package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bEncuestasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bEncuestasPreguntasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bEncuestasPreguntasRespuestasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bEncuestasPreguntasRespuestasCorrelativoBD;
import v50b.v50bModelo.v50bDao.V50bEncuestasDAO;

/**
 * 
 * @author brey
 *
 */
public class V50bEncuestasDAOImpl implements V50bEncuestasDAO{

	private static final int MAGIC_NUMBER998 = 998;
	
	/**
	 * <p>Ttulo: fncBusqEncuestas</p>
	 * <p>Descripcin: busca encuestas</p>
	 * <p>Copyright: Copyright (c) 2008</p>
	 * <p>Empresa: Eurohelp Consulting</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             SQLException
	 */
	public List fncBusqEncuestas(V50bEncuestaBean encuestaBean)
			throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncBusqEncuestas()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TRESCIENTOSCIENCUENTAYDOS);
		final List arrCampos = new ArrayList();

		sql.append("SELECT T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA).append(" AS NUMENCUESTA,");
		sql.append("LPAD(T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA).append(",?,'0') AS NUMENCUESTAORDEN,");
		arrCampos.add(new Integer(V50bClsConstantes.DOS));
		sql.append(" TO_CHAR(T17.").append(V50bEncuestasBD.FECHA_INICIO).append(",?)").append(" AS FECINICIO,");
		arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));
		sql.append(" TO_CHAR(T17.").append(V50bEncuestasBD.FECHA_FINAL).append(",?)").append(" AS FECFIN,");
		arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));
		sql.append("T17.").append(V50bEncuestasBD.TITULOCAS).append(" AS TITULOCAS, T17.");
		sql.append(V50bEncuestasBD.TITULOEUS).append(" AS TITULOEUS,");
		sql.append("T17.").append(V50bEncuestasBD.ESTADO).append(" AS ESTADO,");
		sql.append("T17.").append(V50bEncuestasBD.TIPO).append(" AS TIPO,");
		sql.append("DECODE (T17.").append(V50bEncuestasBD.TIPO);
		sql.append(",'" + V50bClsConstantes.CONSTANTE_GENERAL+ "','"
					+ Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
						"comun.general", encuestaBean.getIdioma()) + "'");
		sql.append(",'" + V50bClsConstantes.CONSTANTE_SATISFACCION
				+ "','" + Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
						"comun.satisfaccion", encuestaBean.getIdioma()) + "'");
		sql.append(") AS TIPOSTR,");
		sql.append("DECODE (T17.").append(V50bEncuestasBD.ESTADO);
		sql.append(",'" + V50bClsConstantes.CONSTANTE_ACTIVA
				+ "','" + Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
						"comun.activa", encuestaBean.getIdioma()) + "'");
		sql.append(",'" + V50bClsConstantes.CONSTANTE_INACTIVA
				+ "','" + Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
						"comun.inactiva", encuestaBean.getIdioma()) + "'");
		sql.append(") AS ESTADOSTR FROM ");
		sql.append(V50bEncuestasBD.TABLA_ENCUESTAS).append(" T17");

		sql.append(" WHERE T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA).append(" > 0");

		// Si ha introducido el N de Encuesta
		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().trim().equals("")) {
			sql.append(" AND T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA).append("=?");
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		}
		
		if (StringUtils.isNotEmpty(encuestaBean.getStrFechaInicio()) && StringUtils.isNotEmpty(encuestaBean.getStrFechaFinal())){		
			sql.append(" AND (T17.").append(V50bEncuestasBD.FECHA_INICIO).append(" BETWEEN TO_DATE(?,?) AND TO_DATE(?,?) ");
			arrCampos.add(encuestaBean.getStrFechaInicio().trim());
			arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));
			arrCampos.add(encuestaBean.getStrFechaFinal().trim());
			arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));
		
			sql.append(" OR T17.").append(V50bEncuestasBD.FECHA_FINAL).append(" BETWEEN TO_DATE(?,?) AND TO_DATE(?,?))");
			arrCampos.add(encuestaBean.getStrFechaInicio().trim());
			arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));
			arrCampos.add(encuestaBean.getStrFechaFinal().trim());
			arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));
		} else {
			// Si ha introducido Fecha de Inicio pero no de fin
			if (StringUtils.isNotEmpty(encuestaBean.getStrFechaInicio()) && StringUtils.isEmpty(encuestaBean.getStrFechaFinal())){
				sql.append(" AND T17.").append(V50bEncuestasBD.FECHA_INICIO).append(" >= TO_DATE(?,?) ");
				arrCampos.add(encuestaBean.getStrFechaInicio().trim());
				arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));
			} else {
				// Si ha introducido Fecha Final pero no de inicio
				if (StringUtils.isEmpty(encuestaBean.getStrFechaInicio()) && StringUtils.isNotEmpty(encuestaBean.getStrFechaFinal())){
					sql.append(" AND T17.").append(V50bEncuestasBD.FECHA_FINAL).append(" <= TO_DATE(?,?)");
					arrCampos.add(encuestaBean.getStrFechaFinal().trim());
					arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));
				}
			}
		}
		

		// Si ha introducido Ttulo
		if (encuestaBean.getStrTituloCas() != null
				&& !encuestaBean.getStrTituloCas().trim().equals("")) {
			sql.append(" AND UPPER(T17.").append(V50bEncuestasBD.TITULOCAS).append(") LIKE ?");
			arrCampos.add("%" + encuestaBean.getStrTituloCas().trim() + "%");
		}

		if (encuestaBean.getStrTituloEus() != null
				&& !encuestaBean.getStrTituloEus().trim().equals("")) {
			sql.append(" AND UPPER(T17.").append(V50bEncuestasBD.TITULOEUS).append(") LIKE ?");
			arrCampos.add("%" + encuestaBean.getStrTituloEus().trim() + "%");

		}

		// Valor de Activa: Siempre tiene un valor asignado, aunque no est
		// seleccionado

		if (encuestaBean.getStrEstado() != null
				&& !encuestaBean.getStrEstado().equals("")) {
			sql.append(" AND T17.").append(V50bEncuestasBD.ESTADO).append("=?");
			if (encuestaBean.getStrEstado().equals(V50bClsConstantes.CONSTANTE_ACTIVA)) {
				arrCampos.add(V50bClsConstantes.CONSTANTE_ACTIVA);
			} else {
				arrCampos.add(V50bClsConstantes.CONSTANTE_INACTIVA);
			}
		}

		if (encuestaBean.getStrTipo() != null
				&& !encuestaBean.getStrTipo().equals("")) {
			sql.append(" AND T17.").append(V50bEncuestasBD.TIPO).append(" = ?");
			arrCampos.add(encuestaBean.getStrTipo().trim());
		}
		sql.append(" ORDER BY 1");

		return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrCampos, new V50bEncuestasMapper());
	}

	/**
	 * <p> Ttulo: fncAgregarNuevaEncuesta </p>
	 * <p> Descripcin: agrega nueva encuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param nuevoNumEncuesta String
	 * @param encuestaBean V50bEncuestaBean
	 * @return long
	 * @throws Exception
	 *             SQLException
	 */
	public long fncAgregarNuevaEncuesta(String nuevoNumEncuesta,
			V50bEncuestaBean encuestaBean) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncAgregarNuevaEncuesta()");
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.SETENTAYUNO);
		final List arrCampos = new ArrayList();

		sbSQL.append("INSERT INTO ");
		sbSQL.append(V50bEncuestasBD.TABLA_ENCUESTAS);
		sbSQL.append(" (");
		sbSQL.append(V50bEncuestasBD.NUMERO_ENCUESTA).append(",");
		sbSQL.append(V50bEncuestasBD.FECHA_INICIO).append(",");
		sbSQL.append(V50bEncuestasBD.FECHA_FINAL).append(",");
		sbSQL.append(V50bEncuestasBD.TITULOCAS).append(",");
		sbSQL.append(V50bEncuestasBD.TITULOEUS).append(",");
		sbSQL.append(V50bEncuestasBD.TIPO).append(",");
		sbSQL.append(V50bEncuestasBD.ESTADO);
		sbSQL.append(") ");
		sbSQL.append("VALUES ( ?, TO_DATE(?,?), TO_DATE(?,?), ?, ?,?,?)");

		arrCampos.add(Long.valueOf(nuevoNumEncuesta));
		if (encuestaBean.getStrFechaInicio() != null
				&& !encuestaBean.getStrFechaInicio().equals("")) {
			arrCampos.add(encuestaBean.getStrFechaInicio().trim());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));

		if (encuestaBean.getStrFechaFinal() != null
				&& !encuestaBean.getStrFechaFinal().equals("")) {
			arrCampos.add(encuestaBean.getStrFechaFinal().trim());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));

		if (encuestaBean.getStrTituloCas() != null
				&& !encuestaBean.getStrTituloCas().equals("")) {
			arrCampos.add(encuestaBean.getStrTituloCas().trim());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrTituloEus() != null
				&& !encuestaBean.getStrTituloEus().equals("")) {
			arrCampos.add(encuestaBean.getStrTituloEus().trim());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		if (encuestaBean.getStrTipo()!= null
				&& !encuestaBean.getStrTipo().equals("")) {
			arrCampos.add(encuestaBean.getStrTipo().trim());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrEstado() != null
				&& !encuestaBean.getStrEstado().equals("")) {
			if (encuestaBean.getStrEstado().equals(
					V50bClsConstantes.CONSTANTE_ACTIVA)) {
				arrCampos.add(V50bClsConstantes.CONSTANTE_ACTIVA);
			} else {
				arrCampos.add(V50bClsConstantes.CONSTANTE_INACTIVA);
			}
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_INACTIVA);
		}

		if (new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos) > 0) {
			return Long.parseLong(nuevoNumEncuesta);
		} else {
			return 0;

		}
	}

	/**
	 * <p> Ttulo: fncModificarEncuesta </p>
	 * <p> Descripcin: modifica una encuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean  V50bEncuestaBean
	 * @return long
	 * @throws Exception
	 *             SQLException
	 */
	public long fncModificarEncuesta(V50bEncuestaBean encuestaBean) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncModificarEncuesta()");

		V50bClsTrazas.depura("Bean: "+encuestaBean);
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.NOVENTAYSIETE);
		final List arrParam = new ArrayList();

		sbSQL.append("UPDATE ").append(V50bEncuestasBD.TABLA_ENCUESTAS).append(" T17 ");
		sbSQL.append("SET T17.").append(V50bEncuestasBD.FECHA_INICIO).append("=TO_DATE(?,?),");
		sbSQL.append("T17.").append(V50bEncuestasBD.FECHA_FINAL).append("=TO_DATE(?,?),");
		sbSQL.append("T17.").append(V50bEncuestasBD.TITULOCAS).append("=?,");
		sbSQL.append("T17.").append(V50bEncuestasBD.TITULOEUS).append("=?,");
		sbSQL.append("T17.").append(V50bEncuestasBD.ESTADO).append("=?, ");
		sbSQL.append("T17.").append(V50bEncuestasBD.TIPO).append("=? ");
		sbSQL.append("WHERE T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA).append("=? ");

		if (encuestaBean.getStrFechaInicio() != null
				&& !encuestaBean.getStrFechaInicio().equals("")) {
			arrParam.add(encuestaBean.getStrFechaInicio().trim());
		} else {
			arrParam.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParam.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));

		if (encuestaBean.getStrFechaFinal() != null
				&& !encuestaBean.getStrFechaFinal().equals("")) {
			arrParam.add(encuestaBean.getStrFechaFinal().trim());
		} else {
			arrParam.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParam.add(V50bClsFunciones.fncMascaraToCharToDate(encuestaBean.getIdioma()));

		if (encuestaBean.getStrTituloCas() != null
				&& !encuestaBean.getStrTituloCas().equals("")) {
			arrParam.add(encuestaBean.getStrTituloCas().trim());
		} else {
			arrParam.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrTituloEus() != null
				&& !encuestaBean.getStrTituloEus().equals("")) {
			arrParam.add(encuestaBean.getStrTituloEus().trim());
		} else {
			arrParam.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrEstado() != null
				&& !encuestaBean.getStrEstado().equals("")) {
			if (encuestaBean.getStrEstado().equals(
					V50bClsConstantes.CONSTANTE_ACTIVA)) {
				arrParam.add(V50bClsConstantes.CONSTANTE_ACTIVA);
			} else {
				arrParam.add(V50bClsConstantes.CONSTANTE_INACTIVA);
			}
		} else {
			arrParam.add(V50bClsConstantes.CONSTANTE_INACTIVA);
		}
		if (encuestaBean.getStrTipo() != null
				&& !encuestaBean.getStrTipo().equals("")) {
			arrParam.add(encuestaBean.getStrTipo().trim());
		} else {
			arrParam.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrParam.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrParam.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrParam);
	}

	/**
	 * <p> Ttulo: fncEliminarEncuesta </p>
	 * <p> Descripcin: elimina una encuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarEncuesta(V50bEncuestaBean encuestaBean)
			throws Exception {
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarEncuesta()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.VEINTE);
		final List arrCampos = new ArrayList();
	
		sql.append("DELETE ").append(V50bEncuestasBD.TABLA_ENCUESTAS);
		sql.append(" WHERE ").append(V50bEncuestasBD.NUMERO_ENCUESTA).append(" = ? ");

		arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrCampos);
	}

	/**
	 * <p> Ttulo: fncGenerarNumeroEncuesta </p>
	 * <p> Descripcin: genera un nmero para una encuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return String
	 * @throws Exception
	 *             SQLException
	 */
	public String fncGenerarNumeroEncuesta() throws Exception {

	/*	final StringBuffer sql = new StringBuffer(V50bClsConstantes.VEINTE);

		sql.append("SELECT MAX(").append(V50bEncuestasBD.NUMERO_ENCUESTA);
		sql.append(")+1 FROM ").append(V50bEncuestasBD.TABLA_ENCUESTAS);
		
		String numEncuesta = new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString());
		if (numEncuesta==null || "".equals(numEncuesta)){
			numEncuesta= "1";
		}
		return numEncuesta;
	*/	
		final StringBuffer sqlSec = new StringBuffer(V50bClsConstantes.VEINTICINCO);

		sqlSec.append("SELECT ");
		sqlSec.append(V50bEncuestasBD.SEQ_ENCUESTAS);
		sqlSec.append(".NEXTVAL FROM DUAL");

		return new V50bClsAccesoBD().fncConsultaEspecifica(sqlSec.toString());
	
	}

	/**
	 * <p> Ttulo: fncComprobarActivaBD </p>
	 * <p> Descripcin: comprueba si una encuesta est activa en la bd </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @param bean V50bEncuestaBean
	 * @author brey
	 * @version 1.0
	 * @return String
	 * @throws Exception
	 *             SQLException
	 */
	public String fncComprobarActivaBD(V50bEncuestaBean bean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncComprobarActivaBD()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CUARENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("SELECT COUNT(1) FROM ");
		sbSQL.append(V50bEncuestasBD.TABLA_ENCUESTAS);
		sbSQL.append(" WHERE ").append(V50bEncuestasBD.ESTADO).append("=?");

		arrCampos.add(V50bClsConstantes.CONSTANTE_ACTIVA);
		sbSQL.append(" AND ").append(V50bEncuestasBD.TIPO).append("=?");
		arrCampos.add(bean.getStrTipo());
		return new V50bClsAccesoBD().fncConsultaEspecifica(sbSQL.toString(), arrCampos);
	}

	/**
	 * <p> Ttulo: fncObtenerActivaBD </p>
	 * <p> Descripcin: obtener la encuesta activa </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param bean V50bEncuestaBean
	 * @return String
	 * @throws Exception
	 *             SQLException
	 */
	public String fncObtenerActivaBD(V50bEncuestaBean bean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncObtenerActivaBD()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.TREINTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("SELECT T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA);
		sbSQL.append(" FROM ").append(V50bEncuestasBD.TABLA_ENCUESTAS);
		sbSQL.append(" T17 WHERE ");
		sbSQL.append(V50bEncuestasBD.ESTADO).append("=?");
		arrCampos.add(V50bClsConstantes.CONSTANTE_ACTIVA);
		sbSQL.append(" AND ").append(V50bEncuestasBD.TIPO).append("=?");
		arrCampos.add(bean.getStrTipo());

		return new V50bClsAccesoBD().fncConsultaEspecifica(sbSQL.toString(), arrCampos);
	}

	/**
	 * <p> Ttulo: fncCopiarCamposEncuesta </p>
	 * <p> Descripcin: copia los campos de una encuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param numEncuestaCopia String
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncCopiarCamposEncuesta(String numEncuestaCopia, V50bEncuestaBean encuestaBean) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncCopiarCamposEncuesta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.NOVENTAYSIETE);
		final List arrCampos = new ArrayList();
		sbSQL.append("INSERT INTO ").append(V50bEncuestasBD.TABLA_ENCUESTAS);
		sbSQL.append(" (").append(V50bEncuestasBD.NUMERO_ENCUESTA).append(", ");
		sbSQL.append(V50bEncuestasBD.FECHA_INICIO).append(", ");
		sbSQL.append(V50bEncuestasBD.FECHA_FINAL).append(", ");
		sbSQL.append(V50bEncuestasBD.TITULOCAS).append(", ");
		sbSQL.append(V50bEncuestasBD.TITULOEUS).append(", ");
		sbSQL.append(V50bEncuestasBD.TIPO).append(", ");
		sbSQL.append(V50bEncuestasBD.ESTADO).append(") ");
		sbSQL.append("SELECT ").append("?, ").append("T17.");
		sbSQL.append(V50bEncuestasBD.FECHA_INICIO).append(", T17.");
		sbSQL.append(V50bEncuestasBD.FECHA_FINAL).append(", T17.");
		sbSQL.append(V50bEncuestasBD.TITULOCAS).append(", T17.");
		sbSQL.append(V50bEncuestasBD.TITULOEUS).append(", T17.");
		sbSQL.append(V50bEncuestasBD.TIPO).append(", ").append("? ");
		sbSQL.append("FROM ").append(V50bEncuestasBD.TABLA_ENCUESTAS).append(" T17 ");
		sbSQL.append("WHERE ").append("T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA).append("=? ");

		arrCampos.add(Long.valueOf(numEncuestaCopia));
		arrCampos.add(encuestaBean.getStrEstado());
		arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}

	/**
	 * <p> Ttulo: fncCopiarCamposPregunta </p>
	 * <p> Descripcin: copia los campos de una pregunta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param numEncuestaCopia String
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncCopiarCamposPregunta(String numEncuestaCopia, V50bEncuestaBean encuestaBean) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncCopiarCamposPregunta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.OCHENTAYUNO);
		final List arrCampos = new ArrayList();

		sbSQL.append("INSERT INTO ").append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS);
		sbSQL.append(" (").append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append(", ");
		sbSQL.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(", ");
		sbSQL.append(V50bEncuestasPreguntasBD.ORDEN).append(", ");
		sbSQL.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_EUS).append(", ");
		sbSQL.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_CAS).append(") ");

		sbSQL.append("SELECT ").append("?, ").append("T18.");
		sbSQL.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(", T18.");
		sbSQL.append(V50bEncuestasPreguntasBD.ORDEN).append(", T18.");
		sbSQL.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_EUS).append(", T18.");
		sbSQL.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_CAS);
		sbSQL.append(" FROM ").append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS).append(" T18 ");
		sbSQL.append("WHERE ").append("T18.");
		sbSQL.append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append("=? ");

		arrCampos.add(Long.valueOf(numEncuestaCopia));
		arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}

	/**
	 * <p> Ttulo: fncCopiarCamposRespuesta </p>
	 * <p> Descripcin: busca individuos para importar asesores </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param numEncuestaCopia String
	 * @param encuestaBean V50bEncuestaBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public int fncCopiarCamposRespuesta(String numEncuestaCopia, V50bEncuestaBean encuestaBean) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncCopiarCamposRespuesta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.NOVENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("INSERT INTO ").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);
		sbSQL.append(" (").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.ORDEN).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_EUS).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_CAS).append(") ");

		sbSQL.append("SELECT ").append("?, ").append("T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(", T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(", T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.ORDEN).append(", T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_EUS).append(", T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_CAS);
		sbSQL.append(" FROM ").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS).append(" T19 ");
		sbSQL.append("WHERE ").append("T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append("=? ");

		arrCampos.add(Long.valueOf(numEncuestaCopia));
		arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}

	/**
	 * Ttulo: fncCopiarCamposRespuestaSeleccionadas
	 * Descripcin: busca individuos para importar asesores
	 * Copyright: Copyright (c) 2008
	 * Empresa: Eurohelp Consulting
	 * @author brey
	 * @version 1.0
	 * @param numEncuestaCopia
	 *            String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public  int fncCopiarCamposRespuestaSeleccionadas(String numEncuestaCopia, V50bEncuestaBean encuestaBean)throws Exception {
		
		StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CIENTOSEIS);
		List arrCampos = new ArrayList();
		
		sbSQL.append("INSERT INTO ").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);
		sbSQL.append(" (").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO).append(", ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO).append(") ");

		sbSQL.append("SELECT ").append("?, ").append("T20.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA).append(", T20.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA).append(", T20.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO).append(",  DECODE ( T20.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO).append(", '1', 0, NULL )");
		sbSQL.append(" FROM ").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);
		sbSQL.append(" T20 WHERE ").append("T20.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA).append("=? ");

		arrCampos.add(Long.valueOf(numEncuestaCopia));
		arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}
	
	/**
	 * <p> Ttulo: fncBusqPreguntas </p>
	 * <p> Descripcin: buscar preguntas </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             SQLException
	 */
	public List fncBusqPreguntas(V50bEncuestaBean encuestaBean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncBusqPreguntas()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CIENTOCINCUENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("SELECT T18.").append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append(" AS NUMENCUESTA, ");
		sbSQL.append("T18.").append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(" AS NUMPREGUNTA, ");
		sbSQL.append("T18.").append(V50bEncuestasPreguntasBD.ORDEN).append(" AS ORDENPREGUNTA, ");
		sbSQL.append("T18.").append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_EUS).append(" AS PREGUNTAEUS, ");
		sbSQL.append("T18.").append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_CAS).append(" AS PREGUNTACAS FROM ");
		sbSQL.append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS).append(" T18");
		sbSQL.append(" WHERE T18.").append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append("=? ");
		sbSQL.append("ORDER BY T18.").append(V50bEncuestasPreguntasBD.ORDEN);

		arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		return new V50bClsAccesoBD().fncLanzaBusqueda(sbSQL.toString(), arrCampos, new V50bPreguntasMapper());
	}

	/**
	 * <p>
	 * Ttulo: fncNumNuevaPregunta
	 * </p>
	 * <p>
	 * Descripcin: genera un nmero para una nueva pregunta
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return String
	 * @throws Exception
	 *             SQLException
	 */
	public String fncNumNuevaPregunta(V50bEncuestaBean encuestaBean)
			throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncNumNuevaPregunta()");
		
		StringBuffer sqlNumPregunta = new StringBuffer(V50bClsConstantes.CINCUENTA);
		final List arrCampos = new ArrayList();

		sqlNumPregunta.append("SELECT ");
		sqlNumPregunta.append("NVL(MAX(T31.");
		sqlNumPregunta.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA);
		sqlNumPregunta.append("),0)+1 ");
		sqlNumPregunta.append("FROM ");
		sqlNumPregunta.append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS);
		sqlNumPregunta.append(" T31 ");
		sqlNumPregunta.append("WHERE ");
		sqlNumPregunta.append("T31.");
		sqlNumPregunta.append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA);
		sqlNumPregunta.append("=? ");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncConsultaEspecifica(sqlNumPregunta
				.toString(), arrCampos);

	}

	/**
	 * <p> Ttulo: fncEliminarTodasPregunta </p>
	 * <p> Descripcin:agrega una nueva pregunta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p>  Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarTodasPregunta(V50bEncuestaBean encuestaBean)
			throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarTodasPregunta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.VEINTICUATRO);
		final List arrCampos = new ArrayList();

		sbSQL.append("DELETE FROM ");
		sbSQL.append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS);
		sbSQL.append(" WHERE ");
		sbSQL.append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA);
		sbSQL.append(" = ? ");
		
		arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}
	
	
	/**
	 * <p>
	 * Ttulo: fncAgregarNuevaPregunta
	 * </p>
	 * <p>
	 * Descripcin:agrega una nueva pregunta
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncAgregarNuevaPregunta(V50bEncuestaBean encuestaBean)
			throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncAgregarNuevaPregunta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CUARENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("INSERT INTO ");
		sbSQL.append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS);
		sbSQL.append(" (");
		sbSQL.append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append(",");
		sbSQL.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(",");
		sbSQL.append(V50bEncuestasPreguntasBD.ORDEN).append(",");
		sbSQL.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_CAS).append(",");
		sbSQL.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_EUS);

		sbSQL.append(") VALUES ( ?,?,?,?,?)");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);

		}

		String strNumPregunta = this.fncNumNuevaPregunta(encuestaBean);
		if (strNumPregunta != null && !strNumPregunta.equals("")) {
			arrCampos.add(Long.valueOf(strNumPregunta));
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrOrdenPregunta() != null
				&& !encuestaBean.getStrOrdenPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrOrdenPreguntaInt());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrPreguntaCas() != null
				&& !encuestaBean.getStrPreguntaCas().equals("")) {
			arrCampos.add(encuestaBean.getStrPreguntaCas());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrPreguntaEus() != null
				&& !encuestaBean.getStrPreguntaEus().equals("")) {
			arrCampos.add(encuestaBean.getStrPreguntaEus());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
		return Integer.parseInt(strNumPregunta);

	}

	/**
	 * <p> Ttulo: fncModificarPregunta </p>
	 * <p> Descripcin: modifica la pregunta de una encuesta dada </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncModificarPregunta(V50bEncuestaBean encuestaBean) throws Exception {
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		final List arrCampos = new ArrayList();

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncModificarPregunta()");
		
		sbSQL.append("UPDATE ").append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS).append(" T18 ");
		sbSQL.append("SET T18.").append(V50bEncuestasPreguntasBD.ORDEN).append("=? ");
		sbSQL.append("WHERE T18.").append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append("=? ");
		sbSQL.append("AND T18.").append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append("=? ");

		if (encuestaBean.getStrOrdenPregunta() != null
				&& !encuestaBean.getStrOrdenPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrOrdenPreguntaInt());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}

	/**
	 * <p>
	 * Ttulo: fncEliminarPregunta
	 * </p>
	 * <p>
	 * Descripcin: eliminar pregunta
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarPregunta(V50bEncuestaBean encuestaBean)
			throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarPregunta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CUARENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("DELETE ");
		sbSQL.append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS);
		sbSQL.append(" T18 ");
		sbSQL.append(" WHERE ");
		sbSQL.append("T18.");
		sbSQL.append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA);
		sbSQL.append("=? ");
		sbSQL.append("AND T18.");
		sbSQL.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA);
		sbSQL.append("=? ");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(),
				arrCampos);
	}

	/**
	 * <p> Ttulo: fncBusqRespuestas </p>
	 * <p> Descripcin: busca la respuestas a una encuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             SQLException
	 */
	public List fncBusqRespuestas(V50bEncuestaBean encuestaBean)
			throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncBusqRespuestas()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CIENTONOVENTAYOCHO);
		final List arrCampos = new ArrayList();

		sbSQL.append("SELECT T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA);
		sbSQL.append(" AS NUMENCUESTA, T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(" AS NUMPREGUNTA, T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(" AS NUMRESPUESTA, T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.ORDEN).append(" AS ORDENRESPUESTA, T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_EUS).append(" AS RESPUESTAEUS, T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_CAS).append(" AS RESPUESTACAS, T19.");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESP_DEFECTO).append(" AS RESPDEFECTO FROM ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS).append(" T19");
		sbSQL.append(" WHERE T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append("=? AND ");
		sbSQL.append("T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append("=? AND ");
		sbSQL.append("T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(" > ? ");
		sbSQL.append("ORDER BY T19.").append(V50bEncuestasPreguntasRespuestasBD.ORDEN);

		arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		arrCampos.add(encuestaBean.getStrNumPreguntaInt());
		arrCampos.add(Integer.valueOf("0"));

		return new V50bClsAccesoBD().fncLanzaBusqueda(sbSQL.toString(), arrCampos, new V50bRespuestasMapper());
	}

	
	/**
	 * Ttulo: fncContarRespuestas
	 * Descripcin: Cuenta el nmero de respuestas de una pregunta
	 * Copyright: Copyright (c) 2008
	 * Empresa: Eurohelp Consulting
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int nmero de respuestas
	 * @throws Exception
	 *             SQLException
	 */
	public int fncContarRespuestas(V50bEncuestaBean encuestaBean)throws Exception {
		
		StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		List arg = new ArrayList();
		
		sql.append("SELECT ")
			.append("COUNT(")
				.append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS).append(".")
				.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA)
			.append(")");
		sql.append(" FROM ")
			.append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);
		sql.append(" WHERE ")
			.append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS).append(".")
			.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append(" = ? ")
			.append(" AND ")
			.append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS).append(".")
			.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(" = ?")
			.append(" AND ")
			.append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS).append(".")
			.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(" > 0");
			
			arg.add(encuestaBean.getStrNumEncuesta());
			arg.add(encuestaBean.getStrNumPregunta());
			
		String num = new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(),arg);
		return Integer.parseInt(num);
	}

	/**
	 * <p> Ttulo: fncAgregarNuevaRespuesta </p>
	 * <p> Descripcin: agrega una nueva respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param numeroRespuesta String
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncAgregarNuevaRespuesta(String numeroRespuesta,
			V50bEncuestaBean encuestaBean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncAgregarNuevaRespuesta()");
		
		// Borramos la respuesta 0 de la pregunta
		// this.fncBorrarRespuestaCero(numeroRespuesta, encuestaBean);

		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("INSERT INTO ").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);
		sbSQL.append(" (").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.ORDEN).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_CAS).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_EUS).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TEXTO_RESP_DEFECTO).append(") ");
		sbSQL.append(" VALUES ( ?, ?, ?, ?, ?, ?, ?)");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (numeroRespuesta != null && !numeroRespuesta.equals("")) {
			arrCampos.add(Integer.valueOf(numeroRespuesta));
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrOrdenRespuesta() != null
				&& !encuestaBean.getStrOrdenRespuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrOrdenRespuesta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrRespuestaCas() != null
				&& !encuestaBean.getStrRespuestaCas().equals("")) {
			arrCampos.add(encuestaBean.getStrRespuestaCas());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrRespuestaEus() != null
				&& !encuestaBean.getStrRespuestaEus().equals("")) {
			arrCampos.add(encuestaBean.getStrRespuestaEus());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if (encuestaBean.getStrRespPorDefecto() != null
				&& encuestaBean.getStrRespPorDefecto().equals(V50bClsConstantes.CONSTANTE_SI)) {
			arrCampos.add(V50bClsConstantes.CONSTANTE_SI);
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NO);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);

	}

	/**
	 * <p>
	 * Ttulo: fncBorrarRespuestaCero
	 * </p>
	 * <p>
	 * Descripcin: borrar respuesta
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param numeroRespuesta
	 *            String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
//	private int fncBorrarRespuestaCero(String numeroRespuesta,
//			V50bEncuestaBean encuestaBean) throws Exception {
//
//		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncBorrarRespuestaCero()");
//		
//		final StringBuffer sbSQL = new StringBuffer();
//		final List arrCampos = new ArrayList();
//
//		sbSQL.append("DELETE ");
//		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TABLA);
//		sbSQL.append(" WHERE ");
//		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA)
//				.append("=? AND ");
//		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA)
//				.append("=? AND ");
//		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA)
//				.append("=? ");
//
//		arrCampos.add(encuestaBean.getStrNumEncuestaLong());
//		arrCampos.add(encuestaBean.getStrNumPreguntaInt());
//		arrCampos.add(Integer.valueOf("0"));
//
//		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(),
//				arrCampos);
//	}

	/**
	 * <p> Ttulo: fncAgregarNuevaRespuestaCorrelativo </p>
	 * <p> Descripcin: agregar nueva respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param numeroRespuesta String
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncAgregarNuevaRespuestaCorrelativo(String numeroRespuesta,
			V50bEncuestaBean encuestaBean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncAgregarNuevaRespuestaCorrelativo()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		final List arrCampos = new ArrayList();

		sbSQL.append("INSERT INTO ").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);
		sbSQL.append(" (").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO).append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO).append(") ");
		sbSQL.append(" VALUES ( ?, ?, ?, ?, ?)");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuesta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (numeroRespuesta != null && !numeroRespuesta.equals("")) {
			arrCampos.add(numeroRespuesta);
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		arrCampos.add(new Integer(1));
		arrCampos.add("0");

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}

	/**
	 * <p>
	 * Ttulo: fncAgregarNuevaRespuestaCorrelativoLibre
	 * </p>
	 * <p>
	 * Descripcin: agregar nueva respuesta
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param numeroRespuesta
	 *            String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
/*	public int fncAgregarNuevaRespuestaCorrelativoLibre(String numeroRespuesta,
			V50bEncuestaBean encuestaBean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncAgregarNuevaRespuestaCorrelativoLibre()");
		
		final StringBuffer sbSQL = new StringBuffer();
		final List arrCampos = new ArrayList();

		sbSQL.append("INSERT INTO ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);
		sbSQL.append(" (");
		sbSQL.append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA)
				.append(",");
		sbSQL.append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA)
				.append(",");
		sbSQL.append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA)
				.append(",");
		sbSQL
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO)
				.append(",");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO);
		sbSQL.append(") ");

		sbSQL.append(" VALUES ( ?, ?, ?, ?, ?)");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuesta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (numeroRespuesta != null && !numeroRespuesta.equals("")) {
			arrCampos.add(numeroRespuesta);
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		arrCampos.add(new Integer(2));
		arrCampos.add("0");

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(),
				arrCampos);
	}
	*/
	/**
	 * <p> Ttulo: fncModificarRespuesta </p>
	 * <p> Descripcin: modificar respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public int fncModificarRespuesta(V50bEncuestaBean encuestaBean)
			throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncModificarRespuesta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTAYNUEVE);
		final List arrCampos = new ArrayList();

		sbSQL.append("UPDATE ").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS).append(" T19 ");
		sbSQL.append("SET T19.").append(V50bEncuestasPreguntasRespuestasBD.ORDEN).append("=? ");
		sbSQL.append("WHERE T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append("=? ");
		sbSQL.append("AND T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append("=? ");
		sbSQL.append("AND T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append("=? ");

		if (encuestaBean.getStrOrdenRespuesta() != null
				&& !encuestaBean.getStrOrdenRespuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrOrdenRespuesta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumRespuesta() != null
				&& !encuestaBean.getStrNumRespuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumRespuesta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}
	
	/**
	 * <p> Ttulo: fncEliminarTodasRespuestas </p>
	 * <p> Descripcin:agrega una nueva pregunta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p>  Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarTodasRespuestas(V50bEncuestaBean encuestaBean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarTodasRespuestas()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.VEINTICUATRO);
		final List arrCampos = new ArrayList();

		sbSQL.append("DELETE FROM ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);
		sbSQL.append(" WHERE ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA);
		sbSQL.append(" = ? ");
		
		arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}
	
	/**
	 * <p> Ttulo: fncEliminarRespuestasPregunta </p>
	 * <p> Descripcin:agrega una nueva pregunta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p>  Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarRespuestasPregunta(V50bEncuestaBean encuestaBean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarRespuestasPregunta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.VEINTICUATRO);
		final List arrCampos = new ArrayList();
		
		this.fncEliminarRespuestasPreguntaCorrelativo(encuestaBean);

		sbSQL.append("DELETE FROM ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);
		sbSQL.append(" WHERE ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append(" = ?");
		sbSQL.append(" AND ").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(" = ?");
		
		arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		arrCampos.add(encuestaBean.getStrNumPreguntaInt());

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}

	/**
	 * <p> Ttulo: fncEliminarRespuesta </p>
	 * <p> Descripcin: elimina respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bAsesoresExternosBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarRespuesta(V50bEncuestaBean encuestaBean) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarRespuesta()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		final List arrCampos = new ArrayList();
		
		this.fncEliminarRespuestaCorrelativo(encuestaBean);
		
		sbSQL.append("DELETE ").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);
		sbSQL.append(" T19  WHERE T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append("=? ");
		sbSQL.append("AND T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append("=? ");
		sbSQL.append("AND T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append("=? ");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumRespuesta() != null
				&& !encuestaBean.getStrNumRespuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumRespuesta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(),arrCampos);
	}
	
	/**
	 * <p> Ttulo: fncEliminarRespuestaTexto </p>
	 * <p> Descripcin: elimina respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bAsesoresExternosBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarRespuestaTexto(V50bEncuestaBean encuestaBean) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarRespuestaTexto()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		final List arrCampos = new ArrayList();
		
		this.fncEliminarRespuestaTextoCorrelativo(encuestaBean);
		
		sbSQL.append("DELETE ").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);
		sbSQL.append(" T19  WHERE T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append("=? ");
		sbSQL.append("AND T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append("=?");
		sbSQL.append("AND T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append("='0'");
		
		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(),arrCampos);
	}
	
	/**
	 * <p> Ttulo: fncEliminarTodasRespuestasCorrelativo </p>
	 * <p> Descripcin:agrega una nueva pregunta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p>  Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarTodasRespuestasCorrelativo(V50bEncuestaBean encuestaBean) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarTodasRespuestasCorrelativo()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.VEINTICUATRO);
		final List arrCampos = new ArrayList();

		sbSQL.append("DELETE FROM ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);
		sbSQL.append(" WHERE ");
		sbSQL.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA);
		sbSQL.append(" = ? ");
		
		arrCampos.add(encuestaBean.getStrNumEncuestaLong());

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrCampos);
	}
	
	/**
	 * <p> Ttulo: fncEliminarRespuestaCorrelativo </p>
	 * <p> Descripcin: elimina respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bAsesoresExternosBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarRespuestaCorrelativo(V50bEncuestaBean encuestaBean) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarRespuestaCorrelativo()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("DELETE ").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);
		sbSQL.append(" T20  WHERE T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA).append("=? ");
		sbSQL.append("AND T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA).append("=? ");
		sbSQL.append("AND T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA).append("=? ");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumRespuesta() != null
				&& !encuestaBean.getStrNumRespuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumRespuesta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(),arrCampos);
	}
	
	/**
	 * <p> Ttulo: fncEliminarRespuestaTextoCorrelativo </p>
	 * <p> Descripcin: elimina respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bAsesoresExternosBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarRespuestaTextoCorrelativo(V50bEncuestaBean encuestaBean) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarRespuestaTextoCorrelativo()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("DELETE ").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);
		sbSQL.append(" T20  WHERE T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA).append("=? ");
		sbSQL.append("AND T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA).append("=? ");
		sbSQL.append("AND T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA).append("='0'");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(),arrCampos);
	}
	
	/**
	 * <p> Ttulo: fncEliminarRespuestasPreguntaCorrelativo </p>
	 * <p> Descripcin: elimina respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bAsesoresExternosBean
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarRespuestasPreguntaCorrelativo(V50bEncuestaBean encuestaBean) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncEliminarRespuestasPreguntaCorrelativo()");
		
		final StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		final List arrCampos = new ArrayList();

		sbSQL.append("DELETE ").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);
		sbSQL.append(" T20  WHERE T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA).append("=? ");
		sbSQL.append("AND T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA).append("=? ");

		if (encuestaBean.getStrNumEncuesta() != null
				&& !encuestaBean.getStrNumEncuesta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumEncuestaLong());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		if (encuestaBean.getStrNumPregunta() != null
				&& !encuestaBean.getStrNumPregunta().equals("")) {
			arrCampos.add(encuestaBean.getStrNumPregunta());
		} else {
			arrCampos.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(),arrCampos);
	}

	/**
	 * <p> Ttulo: fncGenerarNumeroRespuesta </p>
	 * <p> Descripcin: genera un nuevo identificador para la respuesta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param numeroEncuesta String
	 * @param numeroPregunta String
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public String fncGenerarNumeroRespuesta(String numeroEncuesta,
			String numeroPregunta) throws Exception {
		
		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncGenerarNumeroRespuesta()");
		
		final StringBuffer sqlNumRes = new StringBuffer(V50bClsConstantes.SESENTA);
		final List arrCampos = new ArrayList();

		sqlNumRes.append("SELECT NVL(MAX(T19.");
		sqlNumRes.append(V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append("),0)+1 ");
		sqlNumRes.append("FROM ").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);
		sqlNumRes.append(" T19 WHERE ");
		sqlNumRes.append("T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append("=? ");
		sqlNumRes.append("AND T19.").append(V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append("=? ");

		arrCampos.add(Long.valueOf(numeroEncuesta));
		arrCampos.add(Integer.valueOf(numeroPregunta));

		return new V50bClsAccesoBD().fncConsultaEspecifica(sqlNumRes.toString(), arrCampos);
	}

	/**
	 * <p>
	 * Ttulo: fncCargarEncuesta
	 * </p>
	 * <p>
	 * Descripcin: carga una encuesta
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestas
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             SQLException
	 */
	public List fncCargarEncuesta(V50bEncuestaBean encuestas) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncCargarEncuesta()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TRESCIENTOSVENTIUNO);
		final List arrParams = new ArrayList();
		V50bClsTrazas.depura("v50bEncuestaCargadaBeanI",encuestas);
		sql.append("SELECT T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA)
				.append(" AS NUMENCUESTA ");
		sql.append(" ,T17.").append(V50bEncuestasBD.TIPO)
		.append(" AS TIPO ");
		sql.append(" ,T17.").append(V50bEncuestasBD.ESTADO)
		.append(" AS ESTADO ");
		sql.append(" ,T18.").append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA)
				.append(" AS NUMPREGUNTA ");
		sql.append(" ,T18.")
				.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_EUS).append(
						" AS PREGUNTAEUS ");
		sql.append(" ,T18.")
				.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_CAS).append(
						" AS PREGUNTACAS ");

		sql.append(" ,NVL(T19.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(
				",0) AS NUMRESPUESTA ");
		sql.append(" ,T19.").append(
				V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_CAS).append(
				" AS RESPUESTACAS ");
		sql.append(" ,T19.").append(
				V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_EUS).append(
				" AS RESPUESTAEUS ");
		sql.append(" ,T19.").append(
				V50bEncuestasPreguntasRespuestasBD.TEXTO_RESP_DEFECTO).append(
				" AS RESPDEFECTO ");
		sql.append(" ,T19.").append(
				V50bEncuestasPreguntasRespuestasBD.ORDEN).append(
				" AS ORDEN ");
		sql.append(" FROM ").append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS).append(
				" T18 ");
		sql.append(" ,").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS)
				.append(" T19 ");
		sql.append(" ,").append(V50bEncuestasBD.TABLA_ENCUESTAS).append(" T17 ");
		sql.append(" WHERE T18.").append(
				V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append(" = ").append(
				" ? ");
		arrParams.add(encuestas.getStrNumEncuestaLong());

		sql.append(" AND T17.").append(V50bEncuestasBD.NUMERO_ENCUESTA).append(
				" = ").append(" T18.").append(
						V50bEncuestasPreguntasBD.NUMERO_ENCUESTA);
		sql.append(" AND T18.")
				.append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append(" = ")
				.append(" T19.").append(
						V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA)
				.append("(+)");
		sql.append(" AND T18.")
				.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(" = ")
				.append(" T19.").append(
						V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA)
				.append("(+)");

		sql.append(" ORDER BY T18.").append(V50bEncuestasPreguntasBD.ORDEN);
		sql.append(" , T19.").append(V50bEncuestasPreguntasRespuestasBD.ORDEN);

		return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bCargaEncuestasRowMapper());
	}

	/**
	 * <p>
	 * Ttulo: fncInsertRespFijas
	 * </p>
	 * <p>
	 * Descripcin: insertar respuestas
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param valores
	 *            ArrayList
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncInsertRespFijas(List valores) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncInsertRespFijas()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.OCHENTAYDOS);
		final List arrParams = new ArrayList();
		String tot=this.fncExisteRespuestaFija(valores);
		String numRespuestas=this.fncContarRespuestas(valores);
		int total=0;
		V50bEncuestaBean encuestaBean = new V50bEncuestaBean();
		encuestaBean.setStrNumPregunta((String) (valores.get(1)));
		encuestaBean.setStrNumEncuesta((String) (valores.get(0)));
		if (new Integer(numRespuestas).intValue()==0){
			this.fncAgregarNuevaRespuestaCorrelativo((String) (valores.get(2)), encuestaBean);
		}
		sql.append("UPDATE ").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO).append(
				" T20 ");
		sql.append(" SET T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO).append(" = ");

		if ("".equals(tot)){
			total=0;
			sql.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO).append(" + ");
			sql.append(total);
		}
		else{
			sql.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO).append(" + 1");
		}
		
		
		sql.append(" WHERE T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA)
				.append(" = ?");
		arrParams.add(Long.valueOf((String) (valores.get(0))));// n encuesta
		sql.append(" AND T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA)
				.append(" = ?");
		arrParams.add(Integer.valueOf((String) (valores.get(1))));// n
		// pregunta
		sql.append(" AND T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA)
				.append(" = ?");
		arrParams.add(Integer.valueOf((String) (valores.get(2))));// n
		// respuesta
		sql
				.append(" AND T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO)
				.append(" = 1");
	
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(),
				arrParams);
		
	}

	/**
	 * <p>
	 * Ttulo: fncExisteRespuestaFija
	 * </p>
	 * <p>
	 * Descripcin: insertar respuestas
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param valores
	 *            ArrayList
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public String fncExisteRespuestaFija(List valores) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncExisteRespuestaFija()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CINCUENTAYNUEVE);
		final List arrParams = new ArrayList();
		sql.append("SELECT ").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO);
		sql.append(" FROM ").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO).append(" T33 ");
		
		sql.append(" WHERE T33.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA)
				.append(" = ?");
		arrParams.add(Long.valueOf((String) (valores.get(0))));// n encuesta
		sql.append(" AND T33.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA)
				.append(" = ?");
		arrParams.add(Integer.valueOf((String) (valores.get(1))));// n
		// pregunta
		sql.append(" AND T33.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA)
				.append(" = ?");
		arrParams.add(Integer.valueOf((String) (valores.get(2))));// n
		// respuestA

		return new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(),
				arrParams);
	}
	/**
	 * <p> Ttulo: fncContarRespuestas </p>
	 * <p> Descripcin: seleccioneas las respuestas </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param valores ArrayList
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception
	 *             SQLException
	 */
	public String fncContarRespuestas(List valores) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncContarRespuestas()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.SETENTA);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT COUNT(*) FROM ");
		sql.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO).append(" T20 ");
		sql.append(" WHERE T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA).append(" = ?");
		arrParams.add(Long.valueOf((String) (valores.get(0))));
		sql.append(" AND T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA).append(" = ?");
		arrParams.add(Integer.valueOf((String) (valores.get(1))));
		sql.append(" AND T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA).append(" = ?");
		arrParams.add(Integer.valueOf((String) (valores.get(2))));
		
		return new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(),arrParams);
	}
	
	/**
	 * Ttulo: fncSelectRespLibre
	 * Descripcin: seleccioneas las respuestas
	 * Copyright: Copyright (c) 2008
	 * Empresa: Eurohelp Consulting
	 * @author brey
	 * @version 1.0
	 * @param valores     ArrayList
	 * @return persona V50bPersonaGIPBean
	 * @throws Exception SQLException
	 */
	public String fncSelectRespLibre(List valores) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncSelectRespLibre()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.NOVENTAYSIETE);
		final List arrParams = new ArrayList();

		sql
				.append("SELECT NVL(MAX(T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO)
				.append("), 0)+1 AS NUMENCUESTA ");

		sql.append(" FROM ").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO).append(
				" T20 ");

		sql.append(" WHERE T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA)
				.append(" = ?");
		arrParams.add(Long.valueOf((String) (valores.get(0))));
		sql.append(" AND T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA)
				.append(" = ?");
		arrParams.add(Integer.valueOf((String) (valores.get(1))));
		sql.append(" AND T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA)
				.append(" = ").append(V50bClsConstantes.CONSTANTE_RESP_LIBRE);

		return new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(),
				arrParams);
	}

	/**
	 * <p>
	 * Ttulo: fncInsertRespLibre
	 * </p>
	 * <p>
	 * Descripcin: INSERTAR RESPUESTAS
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param valores
	 *            ArrayList
	 * @param correlativo
	 *            String
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncInsertRespLibre(List valores, String correlativo)
			throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncInsertRespLibre()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTA);
		final List arrParams = new ArrayList();

		sql.append("INSERT INTO ").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO);

		sql.append(" (").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA);
		sql.append(" ,").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA);
		sql.append(" ,").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA);
		sql
				.append(" ,")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO);
		sql.append(" ,").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO)
				.append(")");

		sql.append(" VALUES(?,?,");
		sql.append(V50bClsConstantes.CONSTANTE_RESP_LIBRE);
		sql.append(",?,?)");

		arrParams.add(Long.valueOf((String) (valores.get(0))));// n encuesta
		arrParams.add(Integer.valueOf((String) (valores.get(1))));// n
		// pregunta
		arrParams.add(Integer.valueOf(correlativo));
		String texto = (String) valores.get(2);
		if (texto != null && !"".equals(texto)) {
			if (texto.length() > V50bClsConstantes.NOVECIENTOSNOVENTAYNUEVE) {
				texto = texto.substring(0, V50bEncuestasDAOImpl.MAGIC_NUMBER998);
			}
			arrParams.add(texto);// texto introducido
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(),
				arrParams);
	}

	/**
	 * <p>
	 * Ttulo: fncInsertRespVacia
	 * </p>
	 * <p>
	 * Descripcin: insertar respuesta vacia
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param valores
	 *            ArrayList
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncInsertRespVacia(List valores) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncInsertRespVacia()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYSEIS);
		final List arrParams = new ArrayList();

		sql.append("INSERT INTO ").append(
				V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS);

		sql.append(" (").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA);
		sql.append(" ,").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA);
		sql.append(" ,").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA);
		sql.append(" ,").append(V50bEncuestasPreguntasRespuestasBD.ORDEN)
				.append(")");

		sql.append(" VALUES(?,?,");
		sql.append(V50bClsConstantes.CONSTANTE_RESP_LIBRE);
		sql.append(",1)");

		arrParams.add(Long.valueOf((String) (valores.get(0))));// n encuesta
		arrParams.add(Integer.valueOf((String) (valores.get(1))));// n
		// pregunta

		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(),
				arrParams);
	}

	/**
	 * <p>
	 * Ttulo: fncExisteRespuesta
	 * </p>
	 * <p>
	 * Descripcin: buscar la existencia de una respuesta
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param valores
	 *            ArrayList
	 * @return boolean
	 * @throws Exception
	 *             SQLException
	 */
	public boolean fncExisteRespuesta(List valores) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncExisteRespuesta()");
		
		boolean existe = false;
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.SESENTAYSEIS);
		final List arrParams = new ArrayList();

		sql.append("SELECT COUNT(*)");

		sql.append(" FROM ").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS)
				.append(" T32 ");

		sql.append(" WHERE T32.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append(
				" = ?");
		arrParams.add(Long.valueOf((String) (valores.get(0))));// n encuesta
		sql.append(" AND T32.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(
				" = ?");
		arrParams.add(Integer.valueOf((String) (valores.get(1))));// n
		// pregunta
		sql.append(" AND T32.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(
				" = ").append(V50bClsConstantes.CONSTANTE_RESP_LIBRE);

		String a = new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(),
				arrParams);

		if (a != null && a.equals("1")) {// Si es 1 es pq ha encontrao uno
			// luego existe
			existe = true;
		} else {
			existe = false;
		}

		return existe;
	}

	/**
	 * <p>
	 * Ttulo: fncExcelPestania1
	 * </p>
	 * <p>
	 * Descripcin:
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestas
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             SQLException
	 */
	public List fncExcelPestania1(V50bEncuestaBean encuestas) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncExcelPestania1()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.QUINIENTOSCUARENTAYCUATRO);
		final List arrParams = new ArrayList();
		V50bClsTrazas.depura("fncExcelPestania1");
		sql.append("SELECT T18.").append(
				V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(
				" AS NUMPREGUNTA ");
		sql.append(" ,T18.")
				.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_EUS).append(
						" AS PREGUNTAEUS ");
		sql.append(" ,T18.")
				.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_CAS).append(
						" AS PREGUNTACAS ");
		sql.append(" ,T19.").append(
				V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_EUS).append(
				" AS RESPUESTAEUS ");
		sql.append(" ,T19.").append(
				V50bEncuestasPreguntasRespuestasBD.TEXTO_RESPUESTA_CAS).append(
				" AS RESPUESTACAS ");

		sql
				.append(" ,NVL(T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO)
				.append(", 0)").append(" AS RESPUESTAS ");
		sql
				.append(" ,NVL(T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO)
				.append("*100/SUMATORIO, 0)").append(" AS PORCENTAJE ");

		sql.append(" FROM ").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO).append(
				" T20 ");
		sql.append(" ,").append(V50bEncuestasPreguntasRespuestasBD.TABLA_ENC_PREG_RESPUESTAS)
				.append(" T19 ");
		sql.append(" ,").append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS).append(" T18 ");
		sql.append(", (");
		sql.append("SELECT T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA)
				.append(" AS NUENCUSUM ");
		sql.append(" ,T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA)
				.append(" AS NUPREGSUM ");
		sql
				.append(" ,DECODE(SUM(T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO)
				.append("), 0, 1,SUM(T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO)
				.append(")) AS SUMATORIO ");
		sql.append(" FROM ").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO).append(
				" T20 ");
		sql.append(" WHERE T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA)
				.append(" !=0 ");
		sql
				.append(" GROUP BY T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA)
				.append(",T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA);
		sql.append(")");

		sql.append(" WHERE T18.").append(
				V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append(" = ?");
		arrParams.add(Long.valueOf(encuestas.getStrNumEncuesta()));// n
		// encuesta

		sql.append(" AND T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA)
				.append(" !=0 ");
		sql.append(" AND T18.")
				.append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append(" = ")
				.append("T19.").append(
						V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA);
		sql.append(" AND T18.")
				.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(" = ")
				.append("T19.").append(
						V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA);
		sql.append(" AND T19.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append(
				" = ").append("T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA)
				.append("(+)");
		sql.append(" AND T19.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(
				" = ").append("T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA)
				.append("(+)");
		sql.append(" AND T19.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_RESPUESTA).append(
				" = ").append("T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA)
				.append("(+)");
		sql.append(" AND T19.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_ENCUESTA).append(
				" = NUENCUSUM(+)");
		sql.append(" AND T19.").append(
				V50bEncuestasPreguntasRespuestasBD.NUMERO_PREGUNTA).append(
				" = NUPREGSUM(+)");

		sql.append(" ORDER BY T18.").append(V50bEncuestasPreguntasBD.ORDEN)
				.append(" ,T19.").append(
						V50bEncuestasPreguntasRespuestasBD.ORDEN);

		return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bExcelPestania1RowMapper());

	}

	/**
	 * <p>
	 * Ttulo: fncExcelPestania2
	 * </p>
	 * <p>
	 * Descripcin:
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param encuestas
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             SQLException
	 */
	public List fncExcelPestania2(V50bEncuestaBean encuestas) throws Exception {

		V50bClsTrazas.depura("V50bEncuestasDAOImpl.fncExcelPestania2()");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTONOVENTAYOCHO);
		final List arrParams = new ArrayList();
		V50bClsTrazas.depura("fncExcelPestania2");
		sql.append("SELECT T18.").append(
				V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(
				" AS NUMPREGUNTA ");
		sql.append(" ,T18.")
				.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_EUS).append(
						" AS PREGUNTAEUS ");
		sql.append(" ,T18.")
				.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_CAS).append(
						" AS PREGUNTACAS ");
		sql
				.append(" ,T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO)
				.append(" AS RESPUESTA, ");
		sql.append("T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO).append(" AS CORRELATIVO ");

		sql.append(" FROM ").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.TABLA_ENC_CORRELATIVO).append(
				" T20 ");
		sql.append(" ,").append(V50bEncuestasPreguntasBD.TABLA_ENC_PREGUNTAS).append(" T18 ");

		sql.append(" WHERE T18.").append(
				V50bEncuestasPreguntasBD.NUMERO_ENCUESTA).append(" = ?");
		arrParams.add(Long.valueOf(encuestas.getStrNumEncuesta()));// n
		// encuesta

		sql.append(" AND T20.").append(
				V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_RESPUESTA)
				.append(" = 0 ");
		sql
				.append(" AND T18.")
				.append(V50bEncuestasPreguntasBD.NUMERO_ENCUESTA)
				.append(" = ")
				.append("T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_ENCUESTA);
		sql
				.append(" AND T18.")
				.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA)
				.append(" = ")
				.append("T20.")
				.append(
						V50bEncuestasPreguntasRespuestasCorrelativoBD.NUMERO_PREGUNTA);
		sql.append(" AND T20.").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO)
				.append(" IS NOT NULL ");
		sql
				.append(" GROUP BY T18.")
				.append(V50bEncuestasPreguntasBD.NUMERO_PREGUNTA).append(" , ")
				.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_EUS).append(" , ")
				.append(V50bEncuestasPreguntasBD.TEXTO_PREGUNTA_CAS).append(" , ")
				.append("T20.")
				.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CONTENIDO).append(" , ")
				.append("T20.")
				.append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO);
		sql.append(" ORDER BY ").append(V50bEncuestasPreguntasRespuestasCorrelativoBD.CORRELATIVO);
		sql.append(" ASC");
		
		return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bExcelPestania2RowMapper());

	}

	/**
	 * <p> Ttulo: V50bEncuestasMapper </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 */

	class V50bEncuestasMapper implements V50bRowMapper {

		/**
		 * <p> Ttulo: mapRow </p>
		 * <p> Descripcin: mtodo mapRow de bsqueda </p>
		 * <p> Copyright: Copyright (c) 2008 </p>
		 * <p> Empresa: Eurohelp Consulting </p>
		 * 
		 * @author brey
		 * @version 1.0
		 * @param rs
		 *            ResultSet
		 * @return bean Object
		 * @throws SQLException
		 *             excepcion
		 */

		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bEncuestaBean consulta = new V50bEncuestaBean();
			consulta.setStrNumEncuesta(rs.getString("NUMENCUESTA"));
			consulta.setStrNumEncuestaOrden(rs.getString("NUMENCUESTAORDEN"));
			consulta.setStrTituloCas(rs.getString("TITULOCAS"));
			consulta.setStrTituloEus(rs.getString("TITULOEUS"));
			consulta.setStrFechaInicio(rs.getString("FECINICIO"));
			consulta.setStrFechaFinal(rs.getString("FECFIN"));
			consulta.setStrEstado(rs.getString("ESTADO"));
			consulta.setStrEstadoBD(rs.getString("ESTADO"));
			consulta.setStrEstadoStr(rs.getString("ESTADOSTR"));
			consulta.setStrTipo(rs.getString("TIPO"));
			consulta.setStrTipoStr(rs.getString("TIPOSTR"));
			return consulta;
		}
	}

	/**
	 * <p> Ttulo: V50bPreguntasMapper </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p> Empresa: Eurohelp Consulting </p>
	 * 
	 * @author brey
	 * @version 1.0
	 */
	class V50bPreguntasMapper implements V50bRowMapper {

		/**
		 * <p> Ttulo: mapRow </p>
		 * <p> Descripcin: mtodo mapRow de bsqueda </p>
		 * <p> Copyright: Copyright (c) 2008 </p>
		 * <p> Empresa: Eurohelp Consulting </p>
		 * 
		 * @author brey
		 * @version 1.0
		 * @param rs ResultSet
		 * @return bean Object
		 * @throws SQLException
		 *             excepcion
		 */

		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bEncuestaBean consulta = new V50bEncuestaBean();
			consulta.setStrNumEncuesta(rs.getString("NUMENCUESTA"));
			consulta.setStrNumPregunta(rs.getString("NUMPREGUNTA"));
			consulta.setStrOrdenPregunta(rs.getString("ORDENPREGUNTA"));
			consulta.setStrPreguntaCas(rs.getString("PREGUNTACAS"));
			consulta.setStrPreguntaEus(rs.getString("PREGUNTAEUS"));
			// Inicializamos el atributo modo para saber q son preguntas de BD
			consulta.setModo("BD");

			return consulta;
		}
	}

	/**
	 * <p>
	 * Ttulo: V50bRespuestasMapper
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 */
	class V50bRespuestasMapper implements V50bRowMapper {

		/**
		 * <p>
		 * Ttulo: mapRow
		 * </p>
		 * <p>
		 * Descripcin: mtodo mapRow de bsqueda
		 * </p>
		 * <p>
		 * Copyright: Copyright (c) 2008
		 * </p>
		 * <p>
		 * Empresa: Eurohelp Consulting
		 * </p>
		 * 
		 * @author brey
		 * @version 1.0
		 * @param rs
		 *            ResultSet
		 * @return bean Object
		 * @throws SQLException
		 *             excepcion
		 */

		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bEncuestaBean consulta = new V50bEncuestaBean();
			consulta.setStrNumEncuesta(rs.getString("NUMENCUESTA"));
			consulta.setStrNumPregunta(rs.getString("NUMPREGUNTA"));
			consulta.setStrNumRespuesta(rs.getString("NUMRESPUESTA"));
			consulta.setStrOrdenRespuesta(rs.getString("ORDENRESPUESTA"));
			consulta.setStrRespuestaCas(rs.getString("RESPUESTACAS"));
			consulta.setStrRespuestaEus(rs.getString("RESPUESTAEUS"));
			consulta.setStrRespPorDefecto(rs.getString("RESPDEFECTO"));
			consulta.setModo("BD");

			return consulta;
		}
	}

	/**
	 * <p>
	 * Ttulo: V50bCargaEncuestasRowMapper
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 */
	class V50bCargaEncuestasRowMapper implements V50bRowMapper {

		/**
		 * <p>
		 * Ttulo: mapRow
		 * </p>
		 * <p>
		 * Descripcin: mtodo mapRow de bsqueda
		 * </p>
		 * <p>
		 * Copyright: Copyright (c) 2008
		 * </p>
		 * <p>
		 * Empresa: Eurohelp Consulting
		 * </p>
		 * 
		 * @author brey
		 * @version 1.0
		 * @param rs
		 *            ResultSet
		 * @return bean Object
		 * @throws SQLException
		 *             excepcion
		 */

		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bEncuestaBean encuesta = new V50bEncuestaBean();
			encuesta.setStrNumEncuesta(rs.getString("NUMENCUESTA"));
			encuesta.setStrTipo(rs.getString("TIPO"));
			encuesta.setStrEstado(rs.getString("ESTADO"));
			encuesta.setStrNumEncuesta(rs.getString("NUMENCUESTA"));
			encuesta.setStrNumPregunta(rs.getString("NUMPREGUNTA"));
			encuesta.setStrPreguntaCas(rs.getString("PREGUNTACAS"));
			encuesta.setStrPreguntaEus(rs.getString("PREGUNTAEUS"));
			encuesta.setStrNumRespuesta(rs.getString("NUMRESPUESTA"));
			encuesta.setStrRespuestaCas(rs.getString("RESPUESTACAS"));
			encuesta.setStrRespuestaEus(rs.getString("RESPUESTAEUS"));
			encuesta.setStrRespPorDefecto(rs.getString("RESPDEFECTO"));
			encuesta.setStrOrdenRespuesta(rs.getString("ORDEN"));
			return encuesta;
		}
	}

	/**
	 * <p>
	 * Ttulo: V50bExcelPestania1RowMapper
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 */
	class V50bExcelPestania1RowMapper implements V50bRowMapper {

		/**
		 * <p>
		 * Ttulo: mapRow
		 * </p>
		 * <p>
		 * Descripcin: mtodo mapRow de bsqueda
		 * </p>
		 * <p>
		 * Copyright: Copyright (c) 2008
		 * </p>
		 * <p>
		 * Empresa: Eurohelp Consulting
		 * </p>
		 * 
		 * @author brey
		 * @version 1.0
		 * @param rs
		 *            ResultSet
		 * @return bean Object
		 * @throws SQLException
		 *             excepcion
		 */

		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bEncuestaBean encuesta = new V50bEncuestaBean();
			encuesta.setStrNumPregunta(rs.getString("NUMPREGUNTA"));
			encuesta.setStrPreguntaCas(rs.getString("PREGUNTACAS"));
			encuesta.setStrPreguntaEus(rs.getString("PREGUNTAEUS"));
			encuesta.setStrRespuestaCas(rs.getString("RESPUESTACAS"));
			encuesta.setStrRespuestaEus(rs.getString("RESPUESTAEUS"));
			encuesta.setStrRespuestas(rs.getString("RESPUESTAS"));
			encuesta.setStrPorcentaje(rs.getString("PORCENTAJE"));

			return encuesta;
		}
	}

	/**
	 * <p>
	 * Ttulo: V50bExcelPestania2RowMapper
	 * </p>
	 * <p>
	 * Copyright: Copyright (c) 2008
	 * </p>
	 * <p>
	 * Empresa: Eurohelp Consulting
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 */
	class V50bExcelPestania2RowMapper implements V50bRowMapper {
		/**
		 * <p>
		 * Ttulo: mapRow
		 * </p>
		 * <p>
		 * Descripcin: mtodo mapRow de bsqueda
		 * </p>
		 * <p>
		 * Copyright: Copyright (c) 2008
		 * </p>
		 * <p>
		 * Empresa: Eurohelp Consulting
		 * </p>
		 * 
		 * @author Virginia Caldern
		 * @version 1.0
		 * @param rs
		 *            ResultSet
		 * @return bean Object
		 * @throws SQLException
		 *             excepcion
		 */

		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bEncuestaBean encuesta = new V50bEncuestaBean();
			encuesta.setStrNumPregunta(rs.getString("NUMPREGUNTA"));
			encuesta.setStrPreguntaCas(rs.getString("PREGUNTACAS"));
			encuesta.setStrPreguntaEus(rs.getString("PREGUNTAEUS"));
			encuesta.setStrRespuestaCas(rs.getString("RESPUESTA"));
			encuesta.setStrCorrelativo(rs.getString("CORRELATIVO"));
			return encuesta;
		}
	}
	
}
