package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitoBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConsultasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bDificultadBD;
import v50b.v50bModelo.v50bDao.V50bDificultadDAO;


/**
 * 
 * @author iurkidi
 *
 */
public class V50bDificultadDAOImpl implements V50bDificultadDAO{

	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultad(V50bDificultadBean dificultad) throws Exception {
		
		V50bClsTrazas.depura("V50bDificultadDAOImpl.fncBuscarDificultad() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TRESCIENTOSVENTIUNO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T09.").append(V50bDificultadBD.CODDIF).append(" AS CODIGO, ");
		sql.append("LPAD(T09.").append(V50bDificultadBD.CODDIF).append(",?,'0') AS CODIGOORDEN, T09.");
		arrParams.add(new Integer(V50bClsConstantes.DOS));
		sql.append(V50bDificultadBD.DESCC).append(" AS DESCRIPCIONCASTELLANO, T09.");
		sql.append(V50bDificultadBD.DESCE).append(" AS DESCRIPCIONEUSKERA, T09.");
		sql.append(V50bDificultadBD.DIAS).append(" AS DIAS, T09.");
		sql.append(V50bDificultadBD.CAMBIT).append(" AS CODIGOAMBITO, T07.");
		sql.append(V50bAmbitoBD.DESAMC).append(" AS DESCAMBITOCAST, T07.");
		sql.append(V50bAmbitoBD.DESAME).append(" AS DESCAMBITOEUSK, DECODE(T09.");
		sql.append(V50bDificultadBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ALTA).append("', '");
		sql.append(V50bClsConstantes.LITERAL_DESC_ALTA).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_BAJA).append("', '"); 
		sql.append(V50bClsConstantes.LITERAL_DESC_BAJA).append("') AS ESTADO FROM ");
		sql.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09, ");
		sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07 ");
		sql.append("WHERE T09.");
		sql.append(V50bDificultadBD.CODDIF).append(" > 0");
		
		String coddif = dificultad.getCoddif();
		String descc = dificultad.getDescc();
		String desce = dificultad.getDesce();
		String codAmbito = dificultad.getCodambit();
		String estado = dificultad.getEstado();
		
		if(coddif!=null && !"".equals(coddif)){
			int codigo = Integer.parseInt(coddif);
			sql.append(" AND T09.").append(V50bDificultadBD.CODDIF);
			sql.append(" = ").append(codigo);
		}
		
		if(descc!=null && !"".equals(descc)){
			sql.append(" AND UPPER(T09.").append(V50bDificultadBD.DESCC);
			sql.append(") LIKE ?");
			arrParams.add("%"+descc.toUpperCase()+"%");
		}
		
		if(desce!=null && !"".equals(desce)){
			sql.append(" AND UPPER(T09.").append(V50bDificultadBD.DESCE);
			sql.append(") LIKE ?");
			arrParams.add("%"+desce.toUpperCase()+"%");
		}
		
		if(codAmbito!=null && !"".equals(codAmbito)){
			int codigoAmbito = Integer.parseInt(codAmbito);
			sql.append(" AND T09.").append(V50bDificultadBD.CAMBIT);
			sql.append(" = ").append(codigoAmbito);
		}
		
		if (estado!=null){
			sql.append(" AND T09.").append(V50bDificultadBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("'");
		} else {
			sql.append(" AND T09.").append(V50bDificultadBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append("'");
		}
		sql.append(" AND T09.").append(V50bDificultadBD.CAMBIT);
		sql.append(" = ").append("T07.").append(V50bAmbitoBD.CAMBIT);
		sql.append(" ORDER BY 6,1");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bDificultadRowMapper());
		
		return lista;
		
	}
	
	/**
	 * @param codigo : codigo de dificultad 
	 * @return int: el resultado de Delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarDificultad(int codigo) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncEliminarDificultad() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.DIECIOCHO);
		final List arrParams = new ArrayList();
		//int codigo = Integer.parseInt(dificultad.getCoddif());
		
		sql.append("DELETE ");sql.append(V50bDificultadBD.TABLA_DIFICULTAD);
		sql.append(" WHERE ");
		sql.append(V50bDificultadBD.CODDIF);sql.append(" = ").append(codigo);
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarDificultad(V50bDificultadBean dificultad) throws Exception {
		
		V50bClsTrazas.depura("V50bDificultadDAOImpl.fncModificarDificultad() ");
		
		boolean iguales = true;
		int codigo = Integer.parseInt(dificultad.getCoddif());
		String[] ambitos = dificultad.getAmbitos();
		List ambitosOrigen = this.fncAmbitosConsultas(codigo);
		V50bDificultadBean dificultadOrigen = new V50bDificultadBean();
		
		
		if (codigo==1 && dificultad.getEstado()!=null){
			return V50bClsConstantes.DOS_NEGATIVO;
		}
		
		if (codigo!=1 && dificultad.getDias().equals(V50bClsConstantes.CONSTANTE_UNO)){
			return V50bClsConstantes.TRES_NEGATIVO;
		}
		if (dificultad.getEstado()!=null && dificultad.getEstado().equals(V50bClsConstantes.LITERAL_DESC_BAJA)){
			boolean hayAsociados = this.fncComprobarConsultasAsociadas(codigo);
			if (!hayAsociados){
				return V50bClsConstantes.TRES;	
			}
		}
		
		for (int i=0;i<ambitosOrigen.size();i++){
			iguales = false;
			dificultadOrigen = (V50bDificultadBean)ambitosOrigen.get(i);
			String codAmbitoOrigen = dificultadOrigen.getCodambit();
			
			for (int j=0;j<ambitos.length;j++){
				String codAmbito = ambitos[j];	
				if (codAmbito.equals(codAmbitoOrigen)){
					iguales = true;
					break;
				}
			}
			if (!iguales){
				break;
			}
		}
		
		if (!iguales){
			return V50bClsConstantes.DOS;
		}
		else {
			int resultado = this.fncEliminarDificultad(codigo);
			if (resultado<0){
				return resultado;
			}
			
			return this.fncAniadirDificultad(dificultad);
		}
	}
	
	/**
	 * @param codigo : codigo de dificultad 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncAmbitosConsultas(int codigo) throws Exception {
		
		V50bClsTrazas.depura("V50bDificultadDAOImpl.fncAmbitosConsultas() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTA);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT DISTINCT ").append(V50bConsultasBD.CAMBIT).append(" AS CODIGOAMBITO FROM ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS);
		sql.append(" WHERE ").append(V50bConsultasBD.CODDIF).append(" = ").append(codigo);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosDificultadRowMapper());
		
		return lista;
	}
	
	/**
	* @param codDificultad : codigo de resolutor 
	* @return boolean: true si no hay asociados
	* @throws Exception Se eleva la excepcin.
	*/
	public boolean fncComprobarConsultasAsociadas(int codDificultad) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncComprobarConsultasAsociadas() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bConsultasBD.CODDIF).append(" AS CODIGOAMBITO FROM ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS);
		sql.append(" WHERE ").append(V50bConsultasBD.CODDIF).append(" = ").append(codDificultad);
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ").append(V50bClsConstantes.SEIS);
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ").append(V50bClsConstantes.OCHO);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosDificultadRowMapper());
		
		return lista.isEmpty();
	}
		
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirDificultad(V50bDificultadBean dificultad) throws Exception {
		
		V50bClsTrazas.depura("V50bDificultadDAOImpl.fncAniadirDificultad() ");
		final StringBuffer sqlVal = new StringBuffer();	
		
		String codigo = dificultad.getCoddif();
		String id = codigo;
		if (codigo == null || "".equals(codigo)){
			sqlVal.append("SELECT MAX(");sqlVal.append(V50bDificultadBD.CODDIF);
			sqlVal.append(")+1 FROM ").append(V50bDificultadBD.TABLA_DIFICULTAD);
			
			id = new V50bClsAccesoBD().fncConsultaEspecifica(sqlVal.toString());
		}
		
		if (!id.equals(V50bClsConstantes.CONSTANTE_UNO) && dificultad.getDias().equals(V50bClsConstantes.CONSTANTE_UNO)){
			return V50bClsConstantes.DOS_NEGATIVO;
		}
		
		if (id.equals(V50bClsConstantes.CONSTANTE_UNO) && dificultad.getEstado()!=null){
			return V50bClsConstantes.DOS;
		}
		
		int resultado = 0;
		
		String[] lista = dificultad.getAmbitos();
		int codAmbito = 0;
		for (int i=0;i<lista.length;i++){
			codAmbito = Integer.parseInt(lista[i]);
			resultado = this.fncInsertarDificultad(codAmbito,id,dificultad);
			if (resultado!=1){
				return resultado;
			}
		}
		return resultado;
	}
	
	/**
	 * @param codAmbito : codigo de ambito
	 * @param id : codigo de dificultad
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncInsertarDificultad(int codAmbito, String id, V50bDificultadBean dificultad) throws Exception {
		
		V50bClsTrazas.depura("V50bDificultadDAOImpl.fncInsertarDificultad() ");
		final StringBuffer sql = new StringBuffer();
		final List arrParams = new ArrayList();
		String coddif = id;
		if(coddif==null || coddif.equals("")){
			//la tabla esta vaca, no hay expedientes an
			coddif="1";
		}
		
		if("100".equals(coddif)){
			return V50bClsConstantes.TRES_NEGATIVO;
		}else{
			dificultad.setCoddif(coddif);
			int codigo = Integer.parseInt(dificultad.getCoddif());
			int dias = Integer.parseInt(dificultad.getDias());
			
			sql.append("INSERT INTO ").append(V50bDificultadBD.TABLA_DIFICULTAD).append("(");
			sql.append(V50bDificultadBD.CODDIF).append(", ");
			sql.append(V50bDificultadBD.CAMBIT).append(", ");
			sql.append(V50bDificultadBD.DESCC).append(", ");
			sql.append(V50bDificultadBD.DESCE).append(", ");
			sql.append(V50bDificultadBD.ESTADO).append(", ");
			sql.append(V50bDificultadBD.DIAS);
			sql.append(") VALUES(");
			sql.append(codigo).append(",").append(codAmbito).append(",?,?,?,").append(dias).append(") ");
			
			String descc = dificultad.getDescc();
			String desce = dificultad.getDesce();
			String estado = dificultad.getEstado();
			
			if(descc==null || "".equals(descc)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(descc);
			}
			
			if(desce==null || "".equals(desce)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(desce);
			}
			
			if(estado==null || "".equals(estado)){
				arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
			}else{
				arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
			}
					
			return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		}
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosDificultad(V50bDificultadBean dificultad) throws Exception {
		
		V50bClsTrazas.depura("V50bDificultadDAOImpl.fncBuscarAmbitosDificultad() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.SESENTA);
		final List arrParams = new ArrayList();
		
		String coddif = dificultad.getCoddif();
	//	String estado = dificultad.getEstado();
		int codigo = Integer.parseInt(coddif);
		
		sql.append("SELECT T09.").append(V50bDificultadBD.CAMBIT).append(" AS CODIGOAMBITO");
		sql.append(" FROM ");
		sql.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09");
		sql.append(" WHERE T09.");
		sql.append(V50bDificultadBD.CODDIF).append(" = ").append(codigo);
//		sql.append(" AND ").append(V50bDificultadBD.ESTADO).append(" = ?");
		
//		if (estado!=null && estado.equals(V50bClsConstantes.LITERAL_DESC_BAJA)){
//			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
//		}else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
//		}
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosDificultadRowMapper());
		
		return lista;
	}
	
	/**
	 * alata
	 * 
	 * @param listaAmbitos
	 *            :lista con los ambitos de subcategoria
	 * @return boolean
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public boolean fncBuscarDificultadBaja(List listaAmbitos) throws Exception {
		V50bClsTrazas.depura("V50bDificultadDAOImpl.fncBuscarResolBaja() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bAmbitoBD.CAMBIT).append(" AS CODIGOAMBITO");
		sql.append(" FROM ").append(V50bAmbitoBD.TABLA_AMBITO);
		sql.append(" WHERE (").append(V50bAmbitoBD.CAMBIT).append(" = ?");
		sql.append(" AND ").append(V50bAmbitoBD.ESTADO).append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("')");
		V50bDificultadBean dificultad = (V50bDificultadBean)listaAmbitos.get(0);
		arrParams.add(Integer.valueOf(dificultad.getCodambit()));
		for (int i=1;i<listaAmbitos.size();i++) {
			dificultad = (V50bDificultadBean)listaAmbitos.get(i);
			sql.append(" OR (").append(V50bAmbitoBD.CAMBIT).append(" = ?");
			arrParams.add(Integer.valueOf(dificultad.getCodambit()));
			sql.append(" AND ").append(V50bAmbitoBD.ESTADO).append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("')");
		}
		
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bAmbitosDificultadRowMapper());

		return lista.isEmpty();
		
	}
	
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bDificultadRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bDificultadBean dificultad = new V50bDificultadBean();
			
			dificultad.setCoddif(rs.getString("CODIGO"));
			dificultad.setCoddifOrden(rs.getString("CODIGOORDEN"));
			dificultad.setDescc(rs.getString("DESCRIPCIONCASTELLANO"));
			dificultad.setDesce(rs.getString("DESCRIPCIONEUSKERA"));
			dificultad.setCodambit(rs.getString("CODIGOAMBITO"));
			dificultad.setDescAmbitoc(rs.getString("DESCAMBITOCAST"));
			dificultad.setDescAmbitoe(rs.getString("DESCAMBITOEUSK"));
			dificultad.setDias(rs.getString("DIAS"));
			dificultad.setEstado(rs.getString("ESTADO"));
			

			return dificultad;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bAmbitosDificultadRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bDificultadBean dificultad = new V50bDificultadBean();
			
			dificultad.setCodambit(rs.getString("CODIGOAMBITO"));
			
			return dificultad;
		}
	}
	
}

