package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.commons.lang.StringUtils;

import v50b.v50bBeans.V50bAmbitoBean;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bCriteriosConsultaBean;
import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bBeans.V50bNotificacionBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFichero;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitoBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitos_ResolutorBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConsultasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bDificultadBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bEstadosBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bIdiomasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bMotivosConsultaBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bNotificacionesBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bResolutoresBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bSubcategoriasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bSuscriptoresBD;
import v50b.v50bModelo.v50bDao.V50bConsultasDAO;


/**
 * 
 * @author iurkidi
 *
 */
public class V50bConsultasDAOImpl implements V50bConsultasDAO{
	
	/**
	 * <p>Ttulo: fncGenericoNextVal</p>
	 * <p>Descripcin: Mtodo Genrico para la obtencin de valores autonumricos</p>
	 * <p>Copyright: Copyright (c) 2007</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0 Parametros de entrada: String tabla. La tabla donde se
	 *          actualiza la secuencia. Parametros de salida: Integer. El
	 *          resultado devuelto por la secuencia.
	 * @param tabla a
	 * @return Integer
	 * @throws Exception e
	 */
	public Integer fncGenericoNextVal(String tabla) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncGenericoNextVal() ");

		final StringBuffer sqlVal = new StringBuffer(V50bClsConstantes.VEINTICINCO);
		sqlVal.append("SELECT " + tabla + ".NEXTVAL FROM DUAL");

		return new Integer(new V50bClsAccesoBD().fncConsultaEspecifica(sqlVal.toString()));
	}
	
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarConsultasBandejaEntrada</p>
	 * <p>Descripcin: Busca consultas filtrando con el formulario de Bandeja de Entrada</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return lista de consultas que pasan el filtro
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarConsultasBandejaEntrada(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarConsultas() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.OCHOCIENTOSNOVENTAYSEIS);
		final List arrParams = new ArrayList();
		final String strIdioma = form.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		V50bUsuarioBean usuario = form.getUsuarioXlnets();
		
		sql.append("SELECT TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHA, ");
		arrParams.add(masc);
		
		sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHAORDEN, ");
		arrParams.add(V50bClsConstantes.FORMATO_FECHA);
		
		sql.append("T01.").append(V50bConsultasBD.CCONSU).append(" AS CODIGO, ");
		sql.append("T01.").append(V50bConsultasBD.CONTEX).append(" AS CONTEXTO, ");
		sql.append("T01.").append(V50bConsultasBD.CSUSCR).append(" AS SUSCRIPTOR, ");
		
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append("T08.").append(V50bSubcategoriasBD.DESCAS).append(" AS SUBCATEGORIA, ");
		} else {
			sql.append("T08.").append(V50bSubcategoriasBD.DESEUS).append(" AS SUBCATEGORIA, ");
		}
		
		sql.append("T01.").append(V50bConsultasBD.CCATEG).append(" AS CODSUBCATEGORIA, ");
		sql.append("T01.").append(V50bConsultasBD.CRESOL).append(" AS RESOLUTOR, ");
		sql.append("T01.").append(V50bConsultasBD.REMIT).append(" AS REMITENTE, ");
		sql.append("T01.").append(V50bConsultasBD.CAMBIT).append(" AS CODAMBITO, ");
		
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append("T07.").append(V50bAmbitoBD.DESAMC).append(" AS AMBITO, ");
		} else {
			sql.append("T07.").append(V50bAmbitoBD.DESAME).append(" AS AMBITO, ");
		}
		
		sql.append("T01.").append(V50bConsultasBD.CABAND).append(" AS ABANDONADA, ");
		sql.append("T01.").append(V50bConsultasBD.CODEST).append(" AS CODESTADO, ");
		
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append("T21.").append(V50bEstadosBD.DESCC).append(" AS ESTADO, ");
		} else {
			sql.append("T21.").append(V50bEstadosBD.DESCE).append(" AS ESTADO, ");
		}
		
		sql.append("SUBSTR(T01.").append(V50bConsultasBD.TEXTCON).append(",0,?) AS CONSULTA, ");
		arrParams.add(new Integer(V50bClsConstantes.CIEN));
		
		sql.append("T01.").append(V50bConsultasBD.TEXTCON).append(" AS CONSULTAENTERA, ");
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append("T09.").append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD, ");
		} else {
			sql.append("T09.").append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD, ");
		}
		
		sql.append("T01.").append(V50bConsultasBD.CODDIF).append(" AS CODDIFICULTAD, ");		
		sql.append("NVL2(T01.").append(V50bConsultasBD.FILECO_OIDPID).append(",?,?) AS FICHERO, ");
		arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		
		sql.append("(SELECT COUNT(1) FROM ").append(V50bNotificacionesBD.TABLA_NOTIFICACIONES).append(" T12 ");
		sql.append("WHERE T12.").append(V50bNotificacionesBD.CCONSU).append(" = ");
		sql.append(V50bConsultasBD.CCONSU);
		sql.append(" AND T12.").append(V50bNotificacionesBD.CNOTIF).append(">0");
		sql.append(" AND T12.").append(V50bNotificacionesBD.ESTADO).append("=?");
		sql.append(" AND T12.").append(V50bNotificacionesBD.TIPON).append("=?");
		sql.append(" AND T12.").append(V50bNotificacionesBD.CRECEP).append("=");
		sql.append("(SELECT T03.").append(V50bResolutoresBD.COD_RESOL);
		sql.append(" FROM ").append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03 ");
		sql.append(" WHERE T03.").append(V50bResolutoresBD.ID_RESOL).append(" = ? ");
		sql.append(" AND ROWNUM = 1)) AS NOTIFICACION, ");
		arrParams.add(V50bClsConstantes.CONSTANTE_ABIERTA);
		arrParams.add(V50bClsConstantes.CONSTANTE_INTERNA);
		arrParams.add(usuario.getUsuarioXlnets());
		
		sql.append("(SELECT COUNT(1) FROM ").append(V50bNotificacionesBD.TABLA_NOTIFICACIONES).append(" T12 ");
		sql.append("WHERE T12.").append(V50bNotificacionesBD.CCONSU).append(" = ");
		sql.append(V50bConsultasBD.CCONSU);
		sql.append(" AND T12.").append(V50bNotificacionesBD.CNOTIF).append(">0) AS NOTIFICACIONES ");
		
		sql.append("FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01, ");
		sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07, ");
		sql.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09, ");
		sql.append(V50bEstadosBD.TABLA_ESTADOS).append(" T21, ");
		sql.append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append(" T08 ");
		
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(" > 0 ");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T07.").append(V50bAmbitoBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST);
		sql.append(" AND T01.").append(V50bConsultasBD.CCATEG).append(" = T08.").append(V50bSubcategoriasBD.CODSUB).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T08.").append(V50bSubcategoriasBD.CODAMBITO).append("(+)");
		
		if(StringUtils.isNotEmpty(form.getFechaConsultaD())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECCON).append(") >= TO_DATE(?, ?) ");
			arrParams.add(form.getFechaConsultaD());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(form.getFechaConsultaH())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECCON).append(") <= TO_DATE(?, ?) ");
			arrParams.add(form.getFechaConsultaH());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(form.getFechaRespuestaD())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECRES).append(") >= TO_DATE(?, ?) ");
			arrParams.add(form.getFechaRespuestaD());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(form.getFechaRespuestaH())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECRES).append(") <= TO_DATE(?, ?) ");
			arrParams.add(form.getFechaRespuestaH());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(form.getNotificaciones())){
			sql.append(" AND (SELECT COUNT(1) FROM ").append(V50bNotificacionesBD.TABLA_NOTIFICACIONES);
			sql.append(" T12 ").append("WHERE T12.").append(V50bNotificacionesBD.CCONSU).append(" = ");
			sql.append(V50bConsultasBD.CCONSU);
			sql.append(" AND T12.").append(V50bNotificacionesBD.ESTADO).append("=?");
			arrParams.add(V50bClsConstantes.CONSTANTE_ABIERTA);
			
			sql.append(" AND T12.").append(V50bNotificacionesBD.TIPON).append("=?");
			arrParams.add(V50bClsConstantes.CONSTANTE_INTERNA);
			
			if(V50bClsConstantes.CONSTANTE_SI.equals(form.getNotificaciones())){
				sql.append(") > 0 ");
			} else {
				sql.append(") = 0 ");
			}
		}
		
		if(StringUtils.isNotEmpty(form.getAmbito().getCambit())){
			sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = ? ");
			arrParams.add(Integer.valueOf(form.getAmbito().getCambit()));
		}
		
		if(StringUtils.isNotEmpty(form.getCodEstado())){
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = ? ");
			arrParams.add(Integer.valueOf(form.getCodEstado()));
		} else {
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
			
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_DENEGADA));
			
			if(V50bClsConstantes.PERFIL_RESOLUTOR.equals(usuario.getPerfilUsuario())){
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
				arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_ABANDONADA));
			}
		}
		
		sql.append(" AND T01.").append(V50bConsultasBD.ABREV).append(" = ? ");
		if(StringUtils.isNotEmpty(form.getAbreviaturas())){
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		}
		
		if(StringUtils.isNotEmpty(form.getConsulta())){
			sql.append(" AND T01.").append(V50bConsultasBD.TEXTCONF).append(" LIKE ? ");
			String consultaLimpia = V50bClsFunciones.fncNormalizarCadena(form.getConsulta());
			arrParams.add('%'+consultaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase()+'%');
		}
		
		if(V50bClsConstantes.PERFIL_RESOLUTOR.equals(usuario.getPerfilUsuario())){
			sql.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = (");
			sql.append("SELECT T03.").append(V50bResolutoresBD.COD_RESOL);
			sql.append(" FROM ").append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03 ");
			sql.append(" WHERE T03.").append(V50bResolutoresBD.ID_RESOL).append(" = ? ");
			sql.append(" AND ROWNUM = 1) ");
			arrParams.add(usuario.getUsuarioXlnets());
		}
		
		
		sql.append(" ORDER BY T01.").append(V50bConsultasBD.FECCON).append(" DESC");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bBandejaEntradaRowMapper());
		
		return lista; 
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNuevaConsulta</p>
	 * <p>Descripcin: Introduce una nueva consulta en la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param nuevaConsultaForm Formulario con los datos a insertar
	 * @return Lista con el Entero con el resultado de la operacin y String con el cdigo de la consulta
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncNuevaConsulta(V50bConsultaBean nuevaConsultaForm) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncNuevaConsulta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSSEIS);
		final List arrParams = new ArrayList();
		final String strIdioma = nuevaConsultaForm.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		List lResult = new ArrayList();		
		
		sql.append("INSERT INTO ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 (");
		sql.append("T01.").append(V50bConsultasBD.CCONSU).append(", T01.").append(V50bConsultasBD.CAMBIT).append(", ");
		sql.append("T01.").append(V50bConsultasBD.CODDIF).append(", ");
		sql.append("T01.").append(V50bConsultasBD.IDIOMA).append(", T01.").append(V50bConsultasBD.FECCON).append(", ");
		sql.append("T01.").append(V50bConsultasBD.RECIBI).append(", T01.").append(V50bConsultasBD.TEXTCON).append(", ");
		sql.append("T01.").append(V50bConsultasBD.FECRES).append(", T01.").append(V50bConsultasBD.CONTEX).append(", ");
		sql.append("T01.").append(V50bConsultasBD.RESPUESTA).append(", T01.").append(V50bConsultasBD.FILERE_OIDPID).append(", ");
		sql.append("T01.").append(V50bConsultasBD.TAMFILERE).append(", ");
		sql.append("T01.").append(V50bConsultasBD.NOMRE).append(", T01.").append(V50bConsultasBD.CODEST).append(", ");
		sql.append("T01.").append(V50bConsultasBD.TEXTCONF).append(", T01.").append(V50bConsultasBD.RESPUEF).append(", ");
		sql.append("T01.").append(V50bConsultasBD.REMIT).append(", T01.").append(V50bConsultasBD.FRESOL_OIDPID).append(", ");
		sql.append("T01.").append(V50bConsultasBD.NFRESOL);
		sql.append(") VALUES (?, ?, ?, ?, TO_DATE(?,?), ?, ?, TO_DATE(?,?), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		
		Integer codConsulta = this.fncGenericoNextVal(V50bConsultasBD.SEQ_CONSULTAS);
		arrParams.add(codConsulta);
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getAmbito().getCambit())){
			arrParams.add(Integer.valueOf(nuevaConsultaForm.getAmbito().getCambit()));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getDificultad().getCoddif())){
			arrParams.add(Integer.valueOf(nuevaConsultaForm.getDificultad().getCoddif()));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getCodIdioma())){
			arrParams.add(Integer.valueOf(nuevaConsultaForm.getCodIdioma()));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getFechaConsulta())){
			arrParams.add(nuevaConsultaForm.getFechaConsulta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(masc);
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getRecepcion())){
			arrParams.add(nuevaConsultaForm.getRecepcion());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getConsulta())){
			arrParams.add(nuevaConsultaForm.getConsulta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getFechaRespuesta())){
			if(StringUtils.isNotEmpty(nuevaConsultaForm.getRespuesta())){
				arrParams.add(nuevaConsultaForm.getFechaRespuesta());
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(masc);
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getContexto())){
			arrParams.add(nuevaConsultaForm.getContexto());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getRespuesta())){
			arrParams.add(nuevaConsultaForm.getRespuesta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(null != nuevaConsultaForm.getFichRespuesta() && StringUtils.isNotEmpty(nuevaConsultaForm.getFichRespuesta().getOid())){
			arrParams.add(nuevaConsultaForm.getFichRespuesta().getOid());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(null != nuevaConsultaForm.getFichRespuesta() &&nuevaConsultaForm.getFichRespuesta().getTamFich()!=0){
			arrParams.add(nuevaConsultaForm.getFichRespuesta().getTamFich());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_DOUBLE);
		}
		
		if(null != nuevaConsultaForm.getFichRespuesta() && StringUtils.isNotEmpty(nuevaConsultaForm.getFichRespuesta().getNombreReal())){
			arrParams.add(nuevaConsultaForm.getFichRespuesta().getNombreReal());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getRespuesta())){
			String respuestaLimpia = V50bClsFunciones.fncNormalizarCadena(nuevaConsultaForm.getRespuesta()).toUpperCase()
			.replaceAll("<[^<]+?>", "")
			.replaceAll("&NBSP;", "")
			.replaceAll("&LT;", "<")
			.replaceAll("&GT;", ">");
			if(StringUtils.isNotEmpty(respuestaLimpia.trim())){
				arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
			} else {
				arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RECIBIDA));
			}
		} else {
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RECIBIDA));
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getConsulta())){
			String consultaLimpia = V50bClsFunciones.fncNormalizarCadena(nuevaConsultaForm.getConsulta());
			arrParams.add(consultaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(nuevaConsultaForm.getRespuesta())){
			String respuestaLimpia = V50bClsFunciones.fncNormalizarCadena(nuevaConsultaForm.getRespuesta());
			arrParams.add(respuestaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase()
								.replaceAll("<[^<]+?>", "")
								.replaceAll("&NBSP;", " ")
								.replaceAll("&LT;", "<")
								.replaceAll("&GT;", ">"));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
				
		arrParams.add(Integer.valueOf(nuevaConsultaForm.getRemitente()));
		
		if(null != nuevaConsultaForm.getFichResolutor() && StringUtils.isNotEmpty(nuevaConsultaForm.getFichResolutor().getOid())){
			arrParams.add(nuevaConsultaForm.getFichResolutor().getOid());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(null != nuevaConsultaForm.getFichResolutor() && StringUtils.isNotEmpty(nuevaConsultaForm.getFichResolutor().getNombreReal())){
			arrParams.add(nuevaConsultaForm.getFichResolutor().getNombreReal());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		lResult.add(new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams)));
		lResult.add(codConsulta.toString());
		
		return lResult;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncResponderConsulta</p>
	 * <p>Descripcin: Responde a una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param responderForm Formulario con la respuesta
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncResponderConsulta(V50bConsultaBean responderForm) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncResponderConsulta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.NOVENTAYSIETE);
		final List arrParams = new ArrayList();
		
		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.FECRES).append("=SYSDATE, ");
		sql.append("T01.").append(V50bConsultasBD.RESPUESTA).append("=?, ");
		if(StringUtils.isNotEmpty(responderForm.getRespuesta())){
			arrParams.add(responderForm.getRespuesta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.RESPUEF).append("=?, ");
		if(StringUtils.isNotEmpty(responderForm.getRespuesta())){
			String respuestaLimpia = V50bClsFunciones.fncNormalizarCadena(responderForm.getRespuesta());
			arrParams.add(respuestaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase().replaceAll("<[^<]+?>", "").replaceAll("&NBSP;", " "));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.FILERE_OIDPID).append("=?, ");
		if(null != responderForm.getFichRespuesta() && StringUtils.isNotEmpty(responderForm.getFichRespuesta().getOid())){
			arrParams.add(responderForm.getFichRespuesta().getOid());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.TAMFILERE).append("=?, ");
		if(null != responderForm.getFichRespuesta() && responderForm.getFichRespuesta().getTamFich()!=0){
			arrParams.add(responderForm.getFichRespuesta().getTamFich());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_DOUBLE);
		}
		
		sql.append("T01.").append(V50bConsultasBD.NOMRE).append("=?, ");
		if(null != responderForm.getFichRespuesta() && StringUtils.isNotEmpty(responderForm.getFichRespuesta().getNombreReal())){
			arrParams.add(responderForm.getFichRespuesta().getNombreReal());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.FRESOL_OIDPID).append("=?, ");
		if(null != responderForm.getFichResolutor() && StringUtils.isNotEmpty(responderForm.getFichResolutor().getOid())){
			arrParams.add(responderForm.getFichResolutor().getOid());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.NFRESOL).append("=?, ");
		if(null != responderForm.getFichResolutor() && StringUtils.isNotEmpty(responderForm.getFichResolutor().getNombreReal())){
			arrParams.add(responderForm.getFichResolutor().getNombreReal());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.CODEST).append("=? ");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
		
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append("=?");
		arrParams.add(Integer.valueOf(responderForm.getCodigo()));
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	
	/**
	 * 
	 * <p>Ttulo: fncCambiaEstadoConsulta</p>
	 * <p>Descripcin: Cambia el estado de una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codConsulta Cdigo de la consulta
	 * @param codEstado Cdigo del estado
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncCambiaEstadoConsulta(String codConsulta, String codEstado) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncCambiaEstadoConsulta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.CODEST).append("=? ");
		arrParams.add(Integer.valueOf(codEstado));
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append("=?");
		arrParams.add(Integer.valueOf(codConsulta));
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsulta</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncModificarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncModificarConsulta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		final List arrParams = new ArrayList();
//		final String strIdioma = form.getIdioma();
//		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		
		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
//		sql.append("T01.").append(V50bConsultasBD.CAMBIT).append("=?, ");
//		sql.append("T01.").append(V50bConsultasBD.IDIOMA).append("=?, ");
//		sql.append("T01.").append(V50bConsultasBD.FECCON).append("=TO_DATE(?,?), ");
//		sql.append("T01.").append(V50bConsultasBD.RECIBI).append("=?, ");
		sql.append("T01.").append(V50bConsultasBD.TEXTCON).append("=?, ");
//		sql.append("T01.").append(V50bConsultasBD.FECRES).append("=TO_DATE(?,?), ");
//		sql.append("T01.").append(V50bConsultasBD.CONTEX).append("=?, ");
//		sql.append("T01.").append(V50bConsultasBD.RESPUE).append("=?, ");
//		sql.append("T01.").append(V50bConsultasBD.FILERE).append("=?, ");
//		sql.append("T01.").append(V50bConsultasBD.NOMRE).append("=?, ");
		sql.append("T01.").append(V50bConsultasBD.TEXTCONF).append("=? ");
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append("=?");
		
//		if(StringUtils.isNotEmpty(form.getAmbito().getCambit())){
//			arrParams.add(Integer.valueOf(form.getAmbito().getCambit()));
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
//		}
//		
//		if(StringUtils.isNotEmpty(form.getCodIdioma())){
//			arrParams.add(Integer.valueOf(form.getCodIdioma()));
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
//		}
//		
//		if(StringUtils.isNotEmpty(form.getFechaConsulta())){
//			arrParams.add(form.getFechaConsulta());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
//		arrParams.add(masc);
//		
//		if(StringUtils.isNotEmpty(form.getRecepcion())){
//			arrParams.add(form.getRecepcion());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
		
		if(StringUtils.isNotEmpty(form.getConsulta())){
			arrParams.add(form.getConsulta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
//		if(StringUtils.isNotEmpty(form.getFechaRespuesta())){
//			arrParams.add(form.getFechaRespuesta());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
//		arrParams.add(masc);
//		
//		if(StringUtils.isNotEmpty(form.getContexto())){
//			arrParams.add(form.getContexto());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
//		
//		if(StringUtils.isNotEmpty(form.getRespuesta())){
//			arrParams.add(form.getRespuesta());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
//		
//		if(null != form.getFichRespuesta() && 0<form.getFichRespuesta().getBytesFichero().length){
//			arrParams.add(form.getFichRespuesta().getBytesFichero());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_BLOB);
//		}
//		
//		if(null != form.getFichRespuesta() && StringUtils.isNotEmpty(form.getFichRespuesta().getNombreReal())){
//			arrParams.add(form.getFichRespuesta().getNombreReal());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
		
		if(StringUtils.isNotEmpty(form.getConsulta())){
			String consultaLimpia = V50bClsFunciones.fncNormalizarCadena(form.getConsulta());
			arrParams.add(consultaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		arrParams.add(Integer.valueOf(form.getCodigo()));
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	
	/**
	 * <p>Ttulo: fncCatalogarConsulta</p>
	 * <p>Descripcin: Catalogar una consulta</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a cataloogar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncCatalogarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncCatalogarConsulta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTODIEZYNUEVE);
		final List arrParams = new ArrayList();
//		final String strIdioma = form.getIdioma();
//		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		
		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.CODEST).append("=?, ");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
		
		sql.append("T01.").append(V50bConsultasBD.ABREV).append("=?, ");
		if(StringUtils.isNotEmpty(form.getAbreviaturas())){
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		}
		
		sql.append("T01.").append(V50bConsultasBD.INTERN).append("=?, ");
		if(StringUtils.isNotEmpty(form.getPublicado())){
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		}
		
		sql.append("T01.").append(V50bConsultasBD.MULTIT).append("=?, ");
		if(StringUtils.isNotEmpty(form.getMultiterm())){
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		}
		
		
		sql.append("T01.").append(V50bConsultasBD.URLASO).append("=?, ");
		if(StringUtils.isNotEmpty(form.getUrl())){
			String url = form.getUrl();
			if (StringUtils.contains(url, "http://")){
				url = url.substring(V50bClsConstantes.SIETE);
			}
			arrParams.add(url);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.PCLAVE).append("=?, ");
		if(StringUtils.isNotEmpty(form.getPalabrasClave())){
			arrParams.add(form.getPalabrasClave().toUpperCase());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.RESPUESTA).append("=?, ");
		if(StringUtils.isNotEmpty(form.getRespuesta())){
			arrParams.add(form.getRespuesta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.RESPUEF).append("=? ");
		if(StringUtils.isNotEmpty(form.getRespuesta())){
			String respuestaLimpia = V50bClsFunciones.fncNormalizarCadena(form.getRespuesta());
			arrParams.add(respuestaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase().replaceAll("<[^<]+?>", "").replaceAll("&NBSP;", " "));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isEmpty(form.getIndFichero())){
			sql.append(", T01.").append(V50bConsultasBD.FILERE_OIDPID).append("=? ");
			sql.append(", T01.").append(V50bConsultasBD.NOMRE).append("=? ");
			sql.append(", T01.").append(V50bConsultasBD.TAMFILERE).append("=? ");
			if(null != form.getFichRespuesta() && StringUtils.isNotEmpty(form.getFichRespuesta().getNombreReal())){
				arrParams.add(form.getFichRespuesta().getOid());
				arrParams.add(form.getFichRespuesta().getNombreReal());
				arrParams.add(form.getFichRespuesta().getIntTamFichero());
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_DOUBLE);
			}
		}
		
		if(StringUtils.isEmpty(form.getIndFicheroResolutor())){
			sql.append(", T01.").append(V50bConsultasBD.FRESOL_OIDPID).append("=? ");
			sql.append(", T01.").append(V50bConsultasBD.NFRESOL).append("=? ");
			if(null != form.getFichResolutor() && StringUtils.isNotEmpty(form.getFichResolutor().getNombreReal())){
				arrParams.add(form.getFichResolutor().getOid());
				arrParams.add(form.getFichResolutor().getNombreReal());
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}
		}
		
	/*	if(V50bClsConstantes.CONSTANTE_MODIF.equals(form.getModo())){
			sql.append("T01.").append(V50bConsultasBD.FECRES).append("=SYSDATE ");
		} else {
			sql.append("T01.").append(V50bConsultasBD.FECRES).append("=TO_DATE(?,?) ");
			arrParams.add(form.getFechaRespuesta());
			arrParams.add(masc);
		}
		*/
		sql.append(" WHERE T01.").append(V50bConsultasBD.CCONSU).append("=?");
		arrParams.add(Integer.valueOf(form.getCodigo()));
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	
	/**
	 * 
	 * <p>Ttulo: fncAsignarResolutor</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncAsignarResolutor(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncAsignarResolutor() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.NOVENTAYSIETE);
		final List arrParams = new ArrayList();
		
		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.CAMBIT).append("=?, ");
		arrParams.add(Integer.valueOf(form.getAmbito().getCambit()));
		
		sql.append("T01.").append(V50bConsultasBD.CCATEG).append("=?, ");
		arrParams.add(Integer.valueOf(form.getSubcategoria().getCodSub()));
		
		sql.append("T01.").append(V50bConsultasBD.CODDIF).append("=?, ");
		arrParams.add(Integer.valueOf(form.getDificultad().getCoddif()));
		
		sql.append("T01.").append(V50bConsultasBD.TEXADI).append("=?, ");
		if(StringUtils.isNotEmpty(form.getMensaje())){
			arrParams.add(form.getMensaje());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.CRESOL).append("=?, ");
		arrParams.add(Integer.valueOf(form.getResolutor().getCodResol()));
		
		sql.append("T01.").append(V50bConsultasBD.CODEST).append("=?, ");
		arrParams.add(Integer.valueOf(form.getCodEstado()));
		
		if(V50bClsConstantes.CONSTANTE_ALTA.equals(form.getModo())){
			sql.append("T01.").append(V50bConsultasBD.FECASI).append("=SYSDATE, ");
		}
		
		sql.append("T01.").append(V50bConsultasBD.REMIT).append("=? ");
		arrParams.add(Integer.valueOf(form.getRemitente()));
		
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append("=?");
		arrParams.add(Integer.valueOf(form.getCodigo()));
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	/** <p>Ttulo: fncNuevaNotificacion</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a insertar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncNuevaNotificacion(V50bNotificacionBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncNuevaNotificacin() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOVEINTE);
		final List arrParams = new ArrayList();
		
		Integer codNotif = this.fncGenericoNextVal(V50bNotificacionesBD.SEQ_NOTIFICACIONES);
		
		sql.append("INSERT INTO ").append(V50bNotificacionesBD.TABLA_NOTIFICACIONES).append(" T12 (");
		sql.append("T12.").append(V50bNotificacionesBD.CNOTIF).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.CCONSU).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.CRECEP).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.CEMIS).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.PREGUN).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.RESPUE).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.OIDPID).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.NOMFI).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.TIPON).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.ESTADO).append(", ");
		sql.append("T12.").append(V50bNotificacionesBD.FECNOT);
		sql.append(") VALUES (?,?,?,?,?,?,?,?,?,?,SYSDATE)");
		arrParams.add(codNotif);
		arrParams.add(Integer.valueOf(form.getCodConsulta()));
		arrParams.add(Integer.valueOf(form.getCodReceptor()));
		arrParams.add(Integer.valueOf(form.getCodEmisor()));
		
		if(StringUtils.isNotEmpty(form.getPregunta())){
			arrParams.add(form.getPregunta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getRespuesta())){
			arrParams.add(form.getRespuesta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getFichero().getNombreReal())){
			arrParams.add(form.getFichero().getOid());
			arrParams.add(form.getFichero().getNombreReal());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		arrParams.add(form.getTipo());
		
		if(StringUtils.isNotEmpty(form.getEstado())){
			arrParams.add(form.getEstado());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	
	/**
	 * <p>Ttulo: fncVerFicheroConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroConsulta(String v50bCodigoConsulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncVerFicheroConsulta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T01.").append(V50bConsultasBD.NOMCO).append(",T01.").append(V50bConsultasBD.FILECO_OIDPID); 
		sql.append(" FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append(" WHERE T01.").append(V50bConsultasBD.CCONSU).append(" = ?");
		arrParams.add(Integer.valueOf(v50bCodigoConsulta));
				
		return new V50bClsAccesoBD().fncConsultaFichNoTemp(sql.toString(), arrParams);
	}
	
	/**
	 * <p>Ttulo: fncVerFicheroRespuesta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroRespuesta(String v50bCodigoConsulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncVerFicheroRespuesta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T01.").append(V50bConsultasBD.NOMRE).append(",T01.").append(V50bConsultasBD.FILERE_OIDPID); 
		sql.append(" FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append(" WHERE T01.").append(V50bConsultasBD.CCONSU).append(" = ?");
		arrParams.add(Integer.valueOf(v50bCodigoConsulta));
				
		return new V50bClsAccesoBD().fncConsultaFichNoTemp(sql.toString(), arrParams);
	}
	
	/**
	 * <p>Ttulo: fncVerFicheroResolutor</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroResolutor(String v50bCodigoConsulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncVerFicheroResolutor() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T01.").append(V50bConsultasBD.NFRESOL).append(",T01.").append(V50bConsultasBD.FRESOL_OIDPID); 
		sql.append(" FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append(" WHERE T01.").append(V50bConsultasBD.CCONSU).append(" = ?");
		arrParams.add(Integer.valueOf(v50bCodigoConsulta));
				
		return new V50bClsAccesoBD().fncConsultaFichNoTemp(sql.toString(), arrParams);
	}
	
	/**
	 * @author alata
	 * @version 1.0
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasEstadoConsultas(V50bConsultaBean consulta) throws Exception {
		
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarConsultasEstadoConsultas() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.QUINIENTOSCINCUENTAYOCHO);
		final List arrParams = new ArrayList();
		final String strIdioma = consulta.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		
		
		sql.append("SELECT T01.").append(V50bConsultasBD.CCONSU).append(" AS CODIGO, ");
		sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHA, ");
		arrParams.add(masc);
		sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHAORDEN, T01.");
		arrParams.add(V50bClsConstantes.FORMATO_FECHA);
		sql.append(V50bConsultasBD.TEXTCONF).append(" AS CONSULTAFORMATEADA, ");
		sql.append("SUBSTR(T01.").append(V50bConsultasBD.TEXTCON).append(",0,?) AS CONSULTA, T01.");
		arrParams.add(new Integer(V50bClsConstantes.CIEN));
		sql.append(V50bConsultasBD.TEXTCON).append(" AS CONSULTAENTERA, T07.");
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bAmbitoBD.DESAMC).append(" AS AMBITO, T09.");
		} else {
			sql.append(V50bAmbitoBD.DESAME).append(" AS AMBITO, T09.");
		}
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD, T09.");
		} else {
			sql.append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD, T09.");
		}
		sql.append(V50bDificultadBD.DIAS).append(" AS DIASDIFICULTAD, T21.");
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bEstadosBD.DESCC).append(" AS ESTADO, T03.");
		} else {
			sql.append(V50bEstadosBD.DESCE).append(" AS ESTADO, T03.");
		}
		sql.append(V50bResolutoresBD.AP1_RESOL).append(" || ' ' || T03.");
		sql.append(V50bResolutoresBD.AP2_RESOL).append(" || ', ' || T03.");
		sql.append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS RESOLUTOR, ");
		sql.append("DECODE((SELECT COUNT(1) FROM ").append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09 ");
		sql.append("WHERE T09.").append(V50bDificultadBD.CODDIF).append(" = ").append(V50bConsultasBD.CODDIF);
		sql.append(" AND T09.").append(V50bDificultadBD.CAMBIT).append(" = ").append(V50bConsultasBD.CAMBIT);
		sql.append(" AND T09.").append(V50bDificultadBD.DIAS).append(" = 1),0,?,? )AS ES24HORAS, ");
		sql.append("fncatrasadaconsulta(T01.").append(V50bConsultasBD.CCONSU).append(") AS ATRASADA ");
		sql.append(" FROM ");
		arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07, ");
		sql.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09, ");
		sql.append(V50bEstadosBD.TABLA_ESTADOS).append(" T21, ");
		sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 WHERE T01.").append(V50bConsultasBD.CCONSU).append(" > 0");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T07.").append(V50bAmbitoBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST);
		sql.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
		arrParams.add(new Integer(V50bClsConstantes.ESTADO_DENEGADA));
		arrParams.add(new Integer(V50bClsConstantes.ESTADO_CATALOGADA));
		
		String cambit = consulta.getAmbito().getCambit();
		String codest = consulta.getCodEstado();
		String coddif = consulta.getDificultad().getCoddif();
		String dias = consulta.getDificultad().getDias();
		String fueraPlazo =consulta.getIndFinPlazo();
		
		if(cambit!=null && !"".equals(cambit)){
			int codigoAmb = Integer.parseInt(cambit);
			sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT);
			sql.append(" = ").append(codigoAmb);
		}
		
		if(codest!=null && !"".equals(codest)){
			int codigoEst = Integer.parseInt(codest);
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
			sql.append(" = ").append(codigoEst);
		}
		
		if(coddif!=null && !"".equals(coddif)){
			int codigoDif = Integer.parseInt(coddif);
			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
			sql.append(" = ").append(codigoDif);
		}
		
		if(dias!=null && !"".equals(dias)){
			int diasDif = Integer.parseInt(dias);
			sql.append(" AND T09.").append(V50bDificultadBD.DIAS);
			sql.append(" = ").append(diasDif);
		}
		if(StringUtils.isNotEmpty(fueraPlazo)){
			sql.append(" AND fncatrasadaconsulta(T01.").append(V50bConsultasBD.CCONSU).append(") = ? ");
			if(fueraPlazo.equals(V50bClsConstantes.CONSTANTE_SI)){
				arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NO);
			}
		}
		
		sql.append(" ORDER BY 3 ");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bEstadoConsultasRowMapper());
		
		return lista;
	}
	
	
	/**
	 * @author brey
	 * @version 1.0
	 * @param catalogoBean : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasCatalogoConsultas(V50bConsultaBean catalogoBean) throws Exception {
		
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarConsultasCatalogoConsultas() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.SETECIENTOSTREINTA);
		final List arrParams = new ArrayList();
		final String strIdioma = catalogoBean.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		
		
		sql.append("SELECT T01.").append(V50bConsultasBD.CCONSU).append(" AS CODIGO, ");
		sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHA, ");
		arrParams.add(masc);
		sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHAORDEN, T01.");
		arrParams.add(V50bClsConstantes.FORMATO_FECHA);
		sql.append(V50bConsultasBD.TEXTCONF).append(" AS CONSULTAFORMATEADA, ");
		sql.append("SUBSTR(T01.").append(V50bConsultasBD.TEXTCON).append(",0,?) AS CONSULTA, ");
		arrParams.add(new Integer(V50bClsConstantes.CIEN));
		sql.append("T01.").append(V50bConsultasBD.TEXTCON).append(" AS CONSULTAENTERA, T07.");
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bAmbitoBD.DESAMC).append(" AS AMBITO, T09.");
		} else {
			sql.append(V50bAmbitoBD.DESAME).append(" AS AMBITO, T09.");
		}
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD, T09.");
		} else {
			sql.append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD, T09.");
		}
		sql.append(V50bDificultadBD.DIAS).append(" AS DIASDIFICULTAD, T03.");
		sql.append(V50bResolutoresBD.AP1_RESOL).append(" || ' ' || T03.");
		sql.append(V50bResolutoresBD.AP2_RESOL).append(" || ', ' || T03.");
		sql.append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS RESOLUTOR, ");
		sql.append("DECODE((SELECT COUNT(1) FROM ").append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09 ");
		sql.append("WHERE T09.").append(V50bDificultadBD.CODDIF).append(" = ").append(V50bConsultasBD.CODDIF);
		sql.append(" AND T09.").append(V50bDificultadBD.CAMBIT).append(" = ").append(V50bConsultasBD.CAMBIT);
		sql.append(" AND T09.").append(V50bDificultadBD.DIAS).append(" = 1),0,?,? )AS ES24HORAS, ");
		sql.append("fncatrasadaconsulta(T01.").append(V50bConsultasBD.CCONSU).append(") AS ATRASADA ");
		sql.append(" FROM ");
		arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07, ");
		sql.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09, ");
		sql.append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append(" T08, ");
		sql.append(V50bEstadosBD.TABLA_ESTADOS).append(" T21, ");
		sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 WHERE T01.").append(V50bConsultasBD.CCONSU).append(" > 0");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T07.").append(V50bAmbitoBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CCATEG).append(" = T08.").append(V50bSubcategoriasBD.CODSUB).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T08.").append(V50bSubcategoriasBD.CODAMBITO).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST);
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = ?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
		
		String cambit = catalogoBean.getAmbito().getCambit();
		String ccateg = catalogoBean.getSubcategoria().getCodSub();
		String coddif = catalogoBean.getDificultad().getCoddif();
		String dias = catalogoBean.getDificultad().getDias();
		String codresol = catalogoBean.getResolutor().getCodResol();
		String abreviatura = catalogoBean.getAbreviaturas();
		String textoConsulta = catalogoBean.getConsulta();
		String indFinPlazo = catalogoBean.getIndFinPlazo();
		
		if(cambit!=null && !"".equals(cambit)){
			int codigoAmb = Integer.parseInt(cambit);
			if (codigoAmb!=0){
				sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT);
				sql.append(" = ").append(codigoAmb);
			}
		}
		
		if(ccateg!=null && !"".equals(ccateg)){
			int codigoSub = Integer.parseInt(ccateg);
			sql.append(" AND T01.").append(V50bConsultasBD.CCATEG);
			sql.append(" = ").append(codigoSub);
		}
		
		if(coddif!=null && !"".equals(coddif)){
			int codigoDif = Integer.parseInt(coddif);
			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
			sql.append(" = ").append(codigoDif);
		}
		
		if(dias!=null && !"".equals(dias)){
			int diasDif = Integer.parseInt(dias);
			sql.append(" AND T09.").append(V50bDificultadBD.DIAS);
			sql.append(" = ").append(diasDif);
		}
		
		if(codresol!=null && !"".equals(codresol)){
			int codigoResol = Integer.parseInt(codresol);
			sql.append(" AND T03.").append(V50bResolutoresBD.COD_RESOL);
			sql.append(" = ").append(codigoResol);
		}
		
		if(StringUtils.isNotEmpty(abreviatura)){
			sql.append(" AND T01.").append(V50bConsultasBD.ABREV).append(" = ? ");
			if(abreviatura.equals(V50bClsConstantes.CONSTANTE_SI)){
				arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NO);
			}
		}
		
		if(StringUtils.isNotEmpty(catalogoBean.getFechaConsultaD())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECCON).append(") >= TO_DATE(?, ?) ");
			arrParams.add(catalogoBean.getFechaConsultaD());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(catalogoBean.getFechaConsultaH())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECCON).append(") <= TO_DATE(?, ?) ");
			arrParams.add(catalogoBean.getFechaConsultaH());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(catalogoBean.getFechaRespuestaD())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECRES).append(") >= TO_DATE(?, ?) ");
			arrParams.add(catalogoBean.getFechaRespuestaD());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(catalogoBean.getFechaRespuestaH())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECRES).append(") <= TO_DATE(?, ?) ");
			arrParams.add(catalogoBean.getFechaRespuestaH());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(textoConsulta)){
			sql.append(" AND T01.").append(V50bConsultasBD.TEXTCONF).append(" LIKE ? ");
			String consultaLimpia = V50bClsFunciones.fncNormalizarCadena(textoConsulta);
			arrParams.add('%'+consultaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase()+'%');
		}
		
		if(StringUtils.isNotEmpty(indFinPlazo)){
			sql.append(" AND fncatrasadaconsulta(T01.").append(V50bConsultasBD.CCONSU).append(") = ? ");
			if(indFinPlazo.equals(V50bClsConstantes.CONSTANTE_SI)){
				arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NO);
			}
		}
		
		sql.append(" ORDER BY 3 ");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bCatalogoConsultasRowMapper());
		
		return lista;
	
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleConsulta</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return V50bConsultaBean Consulta detallada
	 * @throws Exception Cualquier excepcin
	 */
	public V50bConsultaBean fncDetalleConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncDetalleConsulta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.OCHOCIENTOSCINCUENTAYUNO);
		final List arrParams = new ArrayList();
		final String strIdioma = form.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		
		sql.append("SELECT TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHAC, ");
		arrParams.add(masc);
		
		sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECRES).append(", ?) AS FECHAR, ");
		arrParams.add(masc);
		
		sql.append("T01.").append(V50bConsultasBD.CCONSU).append(" AS CODIGO, ");
		sql.append("T01.").append(V50bConsultasBD.CAMBIT).append(" AS AMBITO, ");
		sql.append("T01.").append(V50bConsultasBD.CCATEG).append(" AS CODSUBCATEGORIA, ");
		sql.append("T01.").append(V50bConsultasBD.CODEST).append(" AS ESTADO, ");
		sql.append("T01.").append(V50bConsultasBD.TEXTCON).append(" AS CONSULTA, ");
		sql.append("T01.").append(V50bConsultasBD.URLASO).append(" AS URL, ");
		sql.append("T01.").append(V50bConsultasBD.MULTIT).append(" AS MULTITERM, ");
		sql.append("T01.").append(V50bConsultasBD.PCLAVE).append(" AS PCLAVE, ");
		
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(form.getIdioma())){
			sql.append("T09.").append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD, ");
		} else {
			sql.append("T09.").append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD, ");
		}
		
		sql.append("T01.").append(V50bConsultasBD.FILECO_OIDPID).append(" AS FILECO_OID, ");
		sql.append("T01.").append(V50bConsultasBD.NOMCO).append(" AS NOMFICHEROC, ");
		sql.append("T01.").append(V50bConsultasBD.FILERE_OIDPID).append(" AS FILERE_OID, ");
		sql.append("T01.").append(V50bConsultasBD.NOMRE).append(" AS NOMFICHEROR, ");
		sql.append("T01.").append(V50bConsultasBD.FRESOL_OIDPID).append(" AS FRESOL_OID, ");
		sql.append("T01.").append(V50bConsultasBD.NFRESOL).append(" AS NOMFICHERORESOL, ");
		
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(form.getIdioma())){
			sql.append("T08.").append(V50bSubcategoriasBD.DESCAS).append(" AS SUBCATEGORIA, ");
		} else {
			sql.append("T08.").append(V50bSubcategoriasBD.DESEUS).append(" AS SUBCATEGORIA, ");
		}
		
		sql.append("T01.").append(V50bConsultasBD.IDIOMA).append(" AS IDIOMA, ");
		sql.append("T03.").append(V50bResolutoresBD.AP1_RESOL).append("||' '||");
		sql.append("T03.").append(V50bResolutoresBD.AP2_RESOL).append("||', '||");
		sql.append("T03.").append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS RESOLUTOR, ");
		sql.append("T01.").append(V50bConsultasBD.ABREV).append(" AS ABREVIATURA, ");
		sql.append("T01.").append(V50bConsultasBD.INTERN).append(" AS PUBLICO, ");
		sql.append("T01.").append(V50bConsultasBD.TEXADI).append(" AS MENSAJE, ");
		sql.append("T01.").append(V50bConsultasBD.CONTEX).append(" AS CONTEXTO, ");
		sql.append("T01.").append(V50bConsultasBD.RECIBI).append(" AS RECEPCION, ");
		sql.append("T01.").append(V50bConsultasBD.RESPUESTA).append(" AS RESPUESTA, ");
		sql.append("T02.").append(V50bSuscriptoresBD.NOMSUS).append(" AS NOMBRE, ");
		sql.append("T02.").append(V50bSuscriptoresBD.AP1SUS).append(" AS APELLIDO1, ");
		sql.append("T02.").append(V50bSuscriptoresBD.AP2SUS).append(" AS APELLIDO2, ");
		sql.append("T02.").append(V50bSuscriptoresBD.DNICIF).append(" AS DNI, ");
		sql.append("fncatrasadaconsulta(T01.").append(V50bConsultasBD.CCONSU).append(") AS ATRASADA, ");
		sql.append("(SELECT COUNT(1) ");
		sql.append("FROM ").append(V50bNotificacionesBD.TABLA_NOTIFICACIONES).append(" T12 ");
		sql.append("WHERE T12.").append(V50bNotificacionesBD.CCONSU).append("=T01.").append(V50bConsultasBD.CCONSU);
		sql.append(" AND T12.").append(V50bNotificacionesBD.CNOTIF).append(">0) AS NUMNOTIF, ");
		sql.append("FNCULTIMOMOTIVO(T01.").append(V50bConsultasBD.CCONSU).append(", ");
		sql.append("T01.").append(V50bConsultasBD.CODEST).append(") AS MOTIVO ");
		
		sql.append("FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01, ");
		sql.append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02, ");
		sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
		sql.append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append(" T08, ");
		sql.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09 ");
		
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(" = ? ");
		arrParams.add(Integer.valueOf(form.getCodigo()));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T08.").append(V50bSubcategoriasBD.CODAMBITO).append("(+)");	
		sql.append(" AND T01.").append(V50bConsultasBD.CCATEG).append(" = T08.").append(V50bSubcategoriasBD.CODSUB).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T08.").append(V50bSubcategoriasBD.CODAMBITO).append("(+)");	
		sql.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL).append("(+)");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bDetalleConsultaRowMapper());
		
		return (V50bConsultaBean)lista.get(0);
	}
	
	/**
	 * @author alata
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasHistoricoConsultas(V50bConsultaBean consulta) throws Exception {
		
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarConsultasHistoricoConsultas() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.SEISCIENTOSSETENTAYTRES);
		final List arrParams = new ArrayList();
		final String strIdioma = consulta.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		
		
		String dni = consulta.getSuscriptor().getNifOtros();
		String nombre = consulta.getSuscriptor().getNombre();
		String apellido1 = consulta.getSuscriptor().getApellido1();
		String apellido2 = consulta.getSuscriptor().getApellido2();
		String codAmbito = consulta.getAmbito().getCambit();
		String codSubcat = consulta.getSubcategoria().getCodSub();
		String codest = consulta.getCodEstado();
		String codResol = consulta.getResolutor().getCodResol();
		String recibido = consulta.getRecepcion();
		String abreviatura = consulta.getAbreviaturas();
		String coddif = consulta.getDificultad().getCoddif();
		String multiterm = consulta.getMultiterm();
		String visible = consulta.getPublicado();
		String idiomaConsulta = consulta.getCodIdioma();
		String denegacion = consulta.getCodMotivDenegar();
		String rechazo = consulta.getCodMotivRechazo();
		String reenvio = consulta.getCodMotivReenvio();
		String textoConsulta = consulta.getConsulta();
		String palabrasClave = consulta.getPalabrasClave();
		String fueraPlazo = consulta.getIndFinPlazo();
		
		sql.append("SELECT T01.").append(V50bConsultasBD.CCONSU).append(" AS CODIGO, ");
		sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHA, ");
		arrParams.add(masc);
		sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHAORDEN, T01.");
		arrParams.add(V50bClsConstantes.FORMATO_FECHA);
		sql.append(V50bConsultasBD.TEXTCONF).append(" AS CONSULTAFORMATEADA, ");
		sql.append("SUBSTR(T01.").append(V50bConsultasBD.TEXTCON).append(",0,?) AS CONSULTA, T01.");
		arrParams.add(new Integer(V50bClsConstantes.CIEN));
		sql.append(V50bConsultasBD.TEXTCON).append(" AS CONSULTAENTERA, T07.");
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bAmbitoBD.DESAMC).append(" AS AMBITO, T14.");
		} else {
			sql.append(V50bAmbitoBD.DESAME).append(" AS AMBITO, T14.");
		}
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bIdiomasBD.DESCC).append(" AS IDIOMA, T09.");
		} else {
			sql.append(V50bIdiomasBD.DESCE).append(" AS IDIOMA, T09.");
		}
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD, T09.");
		} else {
			sql.append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD, T09.");
		}
		sql.append(V50bDificultadBD.DIAS).append(" AS DIASDIFICULTAD, T03.");
		sql.append(V50bResolutoresBD.AP1_RESOL).append(" || ' ' || T03.");
		sql.append(V50bResolutoresBD.AP2_RESOL).append(" || ', ' || T03.");
		sql.append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS RESOLUTOR, T01.");
		sql.append(V50bConsultasBD.INTERN).append(" AS INTERN,");
		sql.append("fncatrasadaconsulta(T01.").append(V50bConsultasBD.CCONSU).append(") AS ATRASADA ");
		sql.append("FROM ");
		sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07, ");
		sql.append(V50bIdiomasBD.TABLA_IDIOMAS).append(" T14, ");
		sql.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09, ");
		sql.append(V50bEstadosBD.TABLA_ESTADOS).append(" T21, ");
		if(denegacion!=null && !"".equals(denegacion)){
			sql.append(V50bMotivosConsultaBD.TABLA_MOTIVOS_CONSULTA).append(" MDENEGACION, ");
		}
		if(rechazo!=null && !"".equals(rechazo)){
			sql.append(V50bMotivosConsultaBD.TABLA_MOTIVOS_CONSULTA).append(" MRECHAZO, ");
		}
		if(reenvio!=null && !"".equals(reenvio)){
			sql.append(V50bMotivosConsultaBD.TABLA_MOTIVOS_CONSULTA).append(" MREENVIO, ");
		}
		sql.append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02, ");
		sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 WHERE T01.").append(V50bConsultasBD.CCONSU).append(" > 0");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T07.").append(V50bAmbitoBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST);
		sql.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.IDIOMA).append(" = T14.").append(V50bIdiomasBD.IDIOMA).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append("(+)");
		
		if(dni!=null && !"".equals(dni)){
			sql.append(" AND UPPER(T02.").append(V50bSuscriptoresBD.DNICIF);
			sql.append(") LIKE ?");
			arrParams.add("%"+dni.toUpperCase()+"%");
		}
		if(nombre!=null && !"".equals(nombre)){
			sql.append(" AND UPPER(T02.").append(V50bSuscriptoresBD.NOMSUS);
			sql.append(") LIKE ?");
			arrParams.add("%"+nombre.toUpperCase()+"%");
		}
		if(apellido1!=null && !"".equals(apellido1)){
			sql.append(" AND UPPER(T02.").append(V50bSuscriptoresBD.AP1SUS);
			sql.append(") LIKE ?");
			arrParams.add("%"+apellido1.toUpperCase()+"%");
		}
		if(apellido2!=null && !"".equals(apellido2)){
			sql.append(" AND UPPER(T02.").append(V50bSuscriptoresBD.AP2SUS);
			sql.append(") LIKE ?");
			arrParams.add("%"+apellido2.toUpperCase()+"%");
		}
		
		if(codAmbito!=null && !"".equals(codAmbito)){
			int codigoAmb = Integer.parseInt(codAmbito);
			if (codigoAmb!=0){
				sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT);
				sql.append(" = ").append(codigoAmb);
			}
		}
		if(codSubcat!=null && !"".equals(codSubcat)){
			int codigoSubCat = Integer.parseInt(codSubcat);
			sql.append(" AND T01.").append(V50bConsultasBD.CCATEG);
			sql.append(" = ").append(codigoSubCat);
		}
		
		if(codResol!=null && !"".equals(codResol)){
			int codigoRes = Integer.parseInt(codResol);
			sql.append(" AND T01.").append(V50bConsultasBD.CRESOL);
			sql.append(" = ").append(codigoRes);
		}
		
		if(codest==null || "".equals(codest)){
			sql.append(" AND (T01.").append(V50bConsultasBD.CODEST).append(" = ?");
			sql.append(" OR T01.").append(V50bConsultasBD.CODEST).append(" = ?)");
			arrParams.add(new Integer(V50bClsConstantes.ESTADO_DENEGADA));
			arrParams.add(new Integer(V50bClsConstantes.ESTADO_CATALOGADA));
		} else {
			if (codest.equals(String.valueOf(V50bClsConstantes.ESTADO_DENEGADA)) || codest.equals(String.valueOf(V50bClsConstantes.ESTADO_CATALOGADA))){
				int codigoEst = Integer.parseInt(codest);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigoEst);
			}
		}
		
		if(StringUtils.isNotEmpty(consulta.getFechaConsultaD())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECCON).append(") >= TO_DATE(?, ?) ");
			arrParams.add(consulta.getFechaConsultaD());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(consulta.getFechaConsultaH())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECCON).append(") <= TO_DATE(?, ?) ");
			arrParams.add(consulta.getFechaConsultaH());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(consulta.getFechaRespuestaD())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECRES).append(") >= TO_DATE(?, ?) ");
			arrParams.add(consulta.getFechaRespuestaD());
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(consulta.getFechaRespuestaH())){
			sql.append(" AND TO_DATE(T01.").append(V50bConsultasBD.FECRES).append(") <= TO_DATE(?, ?) ");
			arrParams.add(consulta.getFechaRespuestaH());
			arrParams.add(masc);
		}
		if(recibido!=null && !"".equals(recibido)){
			sql.append(" AND T01.").append(V50bConsultasBD.RECIBI);
			sql.append(" = ?");
			arrParams.add(recibido);
		}
		if(StringUtils.isNotEmpty(abreviatura)){
			sql.append(" AND T01.").append(V50bConsultasBD.ABREV).append(" = ? ");
			if(abreviatura.equals(V50bClsConstantes.CONSTANTE_SI)){
				arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NO);
			}
		}
		if(coddif!=null && !"".equals(coddif)){
			int codigoDif = Integer.parseInt(coddif);
			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
			sql.append(" = ").append(codigoDif);
		}
		if(StringUtils.isNotEmpty(fueraPlazo)){
			sql.append(" AND fncatrasadaconsulta(T01.").append(V50bConsultasBD.CCONSU).append(") = ? ");
			if(fueraPlazo.equals(V50bClsConstantes.CONSTANTE_SI)){
				arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NO);
			}
		}
		if(StringUtils.isNotEmpty(multiterm)){
			sql.append(" AND T01.").append(V50bConsultasBD.MULTIT).append(" = ? ");
			if(multiterm.equals(V50bClsConstantes.CONSTANTE_SI)){
				arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NO);
			}
		}
		if(StringUtils.isNotEmpty(visible)){
			sql.append(" AND T01.").append(V50bConsultasBD.INTERN).append(" = ? ");
			if(visible.equals(V50bClsConstantes.CONSTANTE_SI)){
				arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NO);
			}
		}
		if(idiomaConsulta!=null && !"".equals(idiomaConsulta)){
			int codigoIdioma = Integer.parseInt(idiomaConsulta);
			sql.append(" AND T01.").append(V50bConsultasBD.IDIOMA);
			sql.append(" = ").append(codigoIdioma);
		}
		if(denegacion!=null && !"".equals(denegacion)){
			int codigoDenegacion = Integer.parseInt(denegacion);
			sql.append(" AND T01.").append(V50bConsultasBD.CCONSU);
			sql.append(" = MDENEGACION.").append(V50bMotivosConsultaBD.CCONSU);
			sql.append(" AND MDENEGACION.").append(V50bMotivosConsultaBD.TIPMOT).append(" = ?");
			arrParams.add(V50bClsConstantes.CONSTANTE_MOTIVO_DENEGACION);
			sql.append(" AND MDENEGACION.").append(V50bMotivosConsultaBD.CMOTIV).append(" = ").append(codigoDenegacion);
			sql.append(" AND MDENEGACION.").append(V50bMotivosConsultaBD.CORREL).append(" > 0");
			sql.append(" AND MDENEGACION.").append(V50bMotivosConsultaBD.CORREL).append(" = (");
			sql.append("SELECT MAX(T05.").append(V50bMotivosConsultaBD.CORREL).append(") ")
				.append("FROM ").append(V50bMotivosConsultaBD.TABLA_MOTIVOS_CONSULTA).append(" T05 ")
				.append("WHERE")
				.append(" T01.").append(V50bConsultasBD.CCONSU)
				.append(" = T05.").append(V50bMotivosConsultaBD.CCONSU)
				.append(" AND T05.").append(V50bMotivosConsultaBD.TIPMOT).append(" = ?")
				.append(" AND T05.").append(V50bMotivosConsultaBD.CMOTIV).append(" = ").append(codigoDenegacion)
				.append(" AND T05.").append(V50bMotivosConsultaBD.CORREL).append(" > 0");
			arrParams.add(V50bClsConstantes.CONSTANTE_MOTIVO_DENEGACION);
			sql.append(")");
		}
		if(rechazo!=null && !"".equals(rechazo)){
			int codigoRechazo = Integer.parseInt(rechazo);
			sql.append(" AND T01.").append(V50bConsultasBD.CCONSU);
			sql.append(" = MRECHAZO.").append(V50bMotivosConsultaBD.CCONSU);
			sql.append(" AND MRECHAZO.").append(V50bMotivosConsultaBD.TIPMOT).append(" = ?");
			arrParams.add(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_RECHAZO);
			sql.append(" AND MRECHAZO.").append(V50bMotivosConsultaBD.CMOTIV).append(" = ").append(codigoRechazo);
			sql.append(" AND MRECHAZO.").append(V50bMotivosConsultaBD.CORREL).append(" > 0");
			sql.append(" AND MRECHAZO.").append(V50bMotivosConsultaBD.CORREL).append(" = (");
			sql.append("SELECT MAX(T05.").append(V50bMotivosConsultaBD.CORREL).append(") ")
				.append("FROM ").append(V50bMotivosConsultaBD.TABLA_MOTIVOS_CONSULTA).append(" T05 ")
				.append("WHERE")
				.append(" T01.").append(V50bConsultasBD.CCONSU)
				.append(" = T05.").append(V50bMotivosConsultaBD.CCONSU)
				.append(" AND T05.").append(V50bMotivosConsultaBD.TIPMOT).append(" = ?")
				.append(" AND T05.").append(V50bMotivosConsultaBD.CMOTIV).append(" = ").append(codigoRechazo)
				.append(" AND T05.").append(V50bMotivosConsultaBD.CORREL).append(" > 0");
			arrParams.add(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_RECHAZO);
			sql.append(")");
		}
		if(reenvio!=null && !"".equals(reenvio)){
			int codigoReenvio = Integer.parseInt(reenvio);
			sql.append(" AND T01.").append(V50bConsultasBD.CCONSU);
			sql.append(" = MREENVIO.").append(V50bMotivosConsultaBD.CCONSU);
			sql.append(" AND MREENVIO.").append(V50bMotivosConsultaBD.TIPMOT).append(" = ?");
			arrParams.add(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_REENVIO);
			sql.append(" AND MREENVIO.").append(V50bMotivosConsultaBD.CMOTIV).append(" = ").append(codigoReenvio);
			sql.append(" AND MREENVIO.").append(V50bMotivosConsultaBD.CORREL).append(" > 0");
			sql.append(" AND MREENVIO.").append(V50bMotivosConsultaBD.CORREL).append(" = (");
			sql.append("SELECT MAX(T05.").append(V50bMotivosConsultaBD.CORREL).append(") ")
				.append("FROM ").append(V50bMotivosConsultaBD.TABLA_MOTIVOS_CONSULTA).append(" T05 ")
				.append("WHERE")
				.append(" T01.").append(V50bConsultasBD.CCONSU)
				.append(" = T05.").append(V50bMotivosConsultaBD.CCONSU)
				.append(" AND T05.").append(V50bMotivosConsultaBD.TIPMOT).append(" = ?")
				.append(" AND T05.").append(V50bMotivosConsultaBD.CMOTIV).append(" = ").append(codigoReenvio)
				.append(" AND T05.").append(V50bMotivosConsultaBD.CORREL).append(" > 0");
			arrParams.add(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_REENVIO);
			sql.append(")");
		}
		
		if(StringUtils.isNotEmpty(textoConsulta)){
			sql.append(" AND T01.").append(V50bConsultasBD.TEXTCONF).append(" LIKE ? ");
			String consultaLimpia = V50bClsFunciones.fncNormalizarCadena(textoConsulta);
			arrParams.add('%'+consultaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase()+'%');
		}
		
		if(StringUtils.isNotEmpty(palabrasClave)){
			StringTokenizer tokenizer =  new StringTokenizer(palabrasClave, ";");
			boolean flag = false;
			sql.append(" AND (");
			while(tokenizer.hasMoreElements()){
				if(flag){
					sql.append(" OR ");
				}
				String token=tokenizer.nextToken().trim();
				sql.append("T01.").append(V50bConsultasBD.PCLAVE).append(" LIKE ?");
				arrParams.add("%"+token+"%");
				flag = true;
			}
			sql.append(")");
		}
		
		
		sql.append(" ORDER BY 3 ");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bHistoricoConsultasRowMapper());
		
		return lista;
	}
	
	
	/**
	 * @author acompes
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultadesAmbito(V50bConsultaBean consulta) throws Exception {
		
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarDificultadesAmbito() para Catlogo Consultas");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.NOVENTA);
		final List arrParams = new ArrayList();
		final String strIdioma = consulta.getIdioma();
		
		int codigo = Integer.parseInt(consulta.getAmbito().getCambit());
		String strEstado = consulta.getDificultad().getEstado();
		
		sql.append("SELECT T09.").append(V50bDificultadBD.CODDIF).append(" AS CODIGODIFICULTAD, T09.");
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD");
		} else {
			sql.append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD");
		}
		sql.append(" FROM ").append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09");
		sql.append(" WHERE T09.").append(V50bDificultadBD.CAMBIT).append(" = ").append(codigo);
		if ("A".equals(strEstado) || "B".equals(strEstado)){
			sql.append(" AND T09.").append(V50bDificultadBD.ESTADO).append(" = '").append(strEstado).append("'");
		}
		sql.append(" ORDER BY 1");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bDificultadesAmbitoRowMapper());
		
		return lista;
	}
	
	/**
	 * @author acompes
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategoriasAmbito(V50bConsultaBean consulta) throws Exception {
		
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarSubcategoriasAmbito() para Catlogo Consultas");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.NOVENTA);
		final List arrParams = new ArrayList();
		final String strIdioma = consulta.getIdioma();
		List lista = new ArrayList();
		if (StringUtils.isNotEmpty(consulta.getAmbito().getCambit())) {
		int codigo = Integer.parseInt(consulta.getAmbito().getCambit());
		
		sql.append("SELECT T08.").append(V50bSubcategoriasBD.CODSUB).append(" AS CODIGOSUBCATEGORIA, T08.");
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
			sql.append(V50bSubcategoriasBD.DESCAS).append(" AS SUBCATEGORIA");
		} else {
			sql.append(V50bSubcategoriasBD.DESEUS).append(" AS SUBCATEGORIA");
		}
		sql.append(" FROM ").append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append(" T08");
		sql.append(" WHERE T08.").append(V50bSubcategoriasBD.CODAMBITO).append(" = ").append(codigo);
		sql.append(" ORDER BY 1");
		
		lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bSubcategoriasAmbitoCatalogoConsultasRowMapper());
		}
		
		return lista;
	}
	
	/**
	 * @author alata
	 * @param consulta : consulta de la busqueda
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncPonerVisibleInternet(V50bConsultaBean consulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncPonerVisibleInternet() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYSEIS);
		final List arrParams = new ArrayList();
		int codigo = Integer.parseInt(consulta.getCodigo());

		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.INTERN).append("=? ");
		arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(" = ").append(codigo);
		
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @author alata
	 * @param consulta : consulta de la busqueda
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncQuitarVisibleInternet(V50bConsultaBean consulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncQuitarVisibleInternet() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYSEIS);
		final List arrParams = new ArrayList();
		int codigo = Integer.parseInt(consulta.getCodigo());

		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.INTERN).append("=? ");
		arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(" = ").append(codigo);
		
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @author alata
	 * @param consulta : consulta de la busqueda
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarRespuesta(V50bConsultaBean consulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncModificarRespuesta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		final List arrParams = new ArrayList();
		int codigo = Integer.parseInt(consulta.getCodigo());

		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.TEXTCON).append("=?, ");
		
		if(StringUtils.isNotEmpty(consulta.getConsulta())){
			arrParams.add(consulta.getConsulta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.PCLAVE).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getPalabrasClave())){
			arrParams.add(consulta.getPalabrasClave());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.RESPUESTA).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getRespuesta())){
			arrParams.add(consulta.getRespuesta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.RESPUEF).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getRespuesta())){
			String respuestaLimpia = V50bClsFunciones.fncNormalizarCadena(consulta.getRespuesta());
			arrParams.add(respuestaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase().replaceAll("<[^<]+?>", "").replaceAll("&NBSP;", " "));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isEmpty(consulta.getIndFichero())){
			sql.append("T01.").append(V50bConsultasBD.FILERE_OIDPID).append("=?, ");
			sql.append("T01.").append(V50bConsultasBD.NOMRE).append("=?, ");
			sql.append("T01.").append(V50bConsultasBD.TAMFILERE).append("=?, ");
			if(null != consulta.getFichRespuesta() && StringUtils.isNotEmpty(consulta.getFichRespuesta().getNombreReal())){
				arrParams.add(consulta.getFichRespuesta().getOid());
				arrParams.add(consulta.getFichRespuesta().getNombreReal());
				arrParams.add(consulta.getFichRespuesta().getTamFich());
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_DOUBLE);
			}
		}
		
		if(StringUtils.isEmpty(consulta.getIndFicheroResolutor())){
			sql.append("T01.").append(V50bConsultasBD.FRESOL_OIDPID).append("=?, ");
			sql.append("T01.").append(V50bConsultasBD.NFRESOL).append("=?, ");
			if(null != consulta.getFichResolutor() && StringUtils.isNotEmpty(consulta.getFichResolutor().getNombreReal())){
				arrParams.add(consulta.getFichResolutor().getOid());
				arrParams.add(consulta.getFichResolutor().getNombreReal());
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}
		}
		
		sql.append("T01.").append(V50bConsultasBD.URLASO).append("=? ");
		if(StringUtils.isNotEmpty(consulta.getUrl())){
			arrParams.add(consulta.getUrl());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
	//	if(V50bClsConstantes.CONSTANTE_MODIF.equals(consulta.getModo())){
	//		sql.append(", T01.").append(V50bConsultasBD.FECRES).append("=SYSDATE ");
	//	} 
		
		sql.append(" WHERE T01.").append(V50bConsultasBD.CCONSU).append(" = ").append(codigo);
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @author alata
	 * @param consulta : consulta de la busqueda
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarRespuestaCatalogo(V50bConsultaBean consulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasDAOImpl.fncModificarRespuestaCatalogo() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		final List arrParams = new ArrayList();
		int codigo = Integer.parseInt(consulta.getCodigo());

		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.CAMBIT).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getAmbito().getCambit())){
			arrParams.add(consulta.getAmbito().getCambit());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.CCATEG).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getSubcategoria().getCodSub())){
			arrParams.add(consulta.getSubcategoria().getCodSub());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.TEXTCON).append("=?, ");
		
		if(StringUtils.isNotEmpty(consulta.getConsulta())){
			arrParams.add(consulta.getConsulta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.PCLAVE).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getPalabrasClave())){
			arrParams.add(consulta.getPalabrasClave());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.RESPUESTA).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getRespuesta())){
			arrParams.add(consulta.getRespuesta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.RESPUEF).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getRespuesta())){
			String respuestaLimpia = V50bClsFunciones.fncNormalizarCadena(consulta.getRespuesta());
			arrParams.add(respuestaLimpia.replaceAll("[^\\p{ASCII}]","").toUpperCase().replaceAll("<[^<]+?>", "").replaceAll("&NBSP;", " "));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isEmpty(consulta.getIndFichero())){
			sql.append("T01.").append(V50bConsultasBD.FILERE_OIDPID).append("=?, ");
			sql.append("T01.").append(V50bConsultasBD.NOMRE).append("=?, ");
			sql.append("T01.").append(V50bConsultasBD.TAMFILERE).append("=?, ");
			if(null != consulta.getFichRespuesta() && StringUtils.isNotEmpty(consulta.getFichRespuesta().getNombreReal())){
				arrParams.add(consulta.getFichRespuesta().getOid());
				arrParams.add(consulta.getFichRespuesta().getNombreReal());
				arrParams.add(consulta.getFichRespuesta().getTamFich());
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_DOUBLE);
			}
		}
		
		if(StringUtils.isEmpty(consulta.getIndFicheroResolutor())){
			sql.append("T01.").append(V50bConsultasBD.FRESOL_OIDPID).append("=?, ");
			sql.append("T01.").append(V50bConsultasBD.NFRESOL).append("=?, ");
			if(null != consulta.getFichResolutor() && StringUtils.isNotEmpty(consulta.getFichResolutor().getNombreReal())){
				arrParams.add(consulta.getFichResolutor().getOid());
				arrParams.add(consulta.getFichResolutor().getNombreReal());
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}
		}
		
		sql.append("T01.").append(V50bConsultasBD.URLASO).append("=?, ");
		if(StringUtils.isNotEmpty(consulta.getUrl())){
			arrParams.add(consulta.getUrl());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T01.").append(V50bConsultasBD.ABREV).append("=? ,");
		if(StringUtils.isNotEmpty(consulta.getAbreviaturas()) && consulta.getAbreviaturas().equals(V50bClsConstantes.CONSTANTE_SI)){
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		}
		
		sql.append("T01.").append(V50bConsultasBD.INTERN).append("=? ,");
		if(StringUtils.isNotEmpty(consulta.getPublicado()) && consulta.getPublicado().equals(V50bClsConstantes.CONSTANTE_SI)){
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		}
		
		sql.append("T01.").append(V50bConsultasBD.MULTIT).append("=? ");
		if(StringUtils.isNotEmpty(consulta.getMultiterm()) && consulta.getMultiterm().equals(V50bClsConstantes.CONSTANTE_SI)){
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NO);
		}
		
	//	if(V50bClsConstantes.CONSTANTE_MODIF.equals(consulta.getModo())){
	//		sql.append(", T01.").append(V50bConsultasBD.FECRES).append("=SYSDATE ");
	//	} 
		
		sql.append(" WHERE T01.").append(V50bConsultasBD.CCONSU).append(" = ").append(codigo);
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}

	/**
	 * @author mmonge
	 * @param criteriosBean parametro de entrada
	 * @return V50ConsultaGraficoPorcentajeBean parametro de salida
	 * @throws Exception excepcion
	 */
		public List fncObtenerDatosGraficos(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			V50bClsTrazas.depura("V50bConsultasDAOImpl.V50bConsultasImpl ");

			/*final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOCINCUENTA);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
			
			sql.append("SELECT T02.").append(V50bSuscriptoresBD.SEXOSUSCR).append(" AS SEXO , ");
			sql.append("TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", ?) AS FECHA, ");
			arrParams.add(masc);
			sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			String codAmbito = criteriosBean.getCodAmbito();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			V50bClsTrazas.depura("codAmbito "+codAmbito);
			V50bClsTrazas.depura("codEstado "+codEstado);
			V50bClsTrazas.depura("codDificultad "+codDificultad);
			V50bClsTrazas.depura("codMunicipio "+codMunicipio);
			V50bClsTrazas.depura("codTh "+th);
			
			if(codAmbito!=null && !"".equals(codAmbito)){
				int codigo = Integer.parseInt(codAmbito);
				sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT);
				sql.append(" = ").append(codigo);
			}
			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}			
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionRowMapper());
			
			return lista;*/
			
			return new ArrayList();
			
		}
		
		/**
		 * <p>Ttulo: fncBuscarNotificaciones</p>
		 * <p>Descripcin: Busca las notificaciones de una consulta</p>
		 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author llaparra
		 * @version 1.0
		 * @param consulta La consulta
		 * @return List Lista con las notificaciones
		 * @throws Exception Cualquier excepcin
		 */
		public List fncBuscarNotificaciones(V50bConsultaBean consulta) throws Exception {
			V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarNotificaciones() ");

			final StringBuffer sql = new StringBuffer(V50bClsConstantes.TRESCIENTOSSESENTAYUNO);
			final List arrParams = new ArrayList();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(consulta.getIdioma());
			
			sql.append("SELECT T12.").append(V50bNotificacionesBD.CEMIS).append(" AS EMISOR, ");
			sql.append("T12.").append(V50bNotificacionesBD.CRECEP).append(" AS RECEPTOR, ");
			sql.append("T12.").append(V50bNotificacionesBD.CNOTIF).append(" AS CODNOTIFICACION, "); 
			sql.append("T12.").append(V50bNotificacionesBD.CCONSU).append(" AS CODCONSULTA, ");
			sql.append("T12.").append(V50bNotificacionesBD.ESTADO).append(" AS ESTADO, ");
			sql.append("T12.").append(V50bNotificacionesBD.TIPON).append(" AS TIPO, ");
			sql.append("TO_CHAR(T12.").append(V50bNotificacionesBD.FECNOT).append(",?) AS FECHA, ");
			arrParams.add(masc);
			
			sql.append("T12.").append(V50bNotificacionesBD.OIDPID).append(" AS OIDPID, ");
			sql.append("T12.").append(V50bNotificacionesBD.NOMFI).append(" AS NOMFICH, ");
			sql.append("T12.").append(V50bNotificacionesBD.PREGUN).append(" AS PREGUNTA, ");
			sql.append("T12.").append(V50bNotificacionesBD.RESPUE).append(" AS RESPUESTA, "); 
			sql.append("T03A.").append(V50bResolutoresBD.AP1_RESOL).append(" ||' '|| ");
			sql.append("T03A.").append(V50bResolutoresBD.AP2_RESOL).append(" ||', '|| ");
			sql.append("T03A.").append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS NOMBRE, ");
			sql.append("T03B.").append(V50bResolutoresBD.ID_RESOL).append(" AS IDRECEPTOR ");
			sql.append("FROM ").append(V50bNotificacionesBD.TABLA_NOTIFICACIONES).append(" T12, ");
			sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03A, ");
			sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03B ");
			sql.append("WHERE T12.").append(V50bNotificacionesBD.CNOTIF).append(">0");
			sql.append(" AND T12.").append(V50bNotificacionesBD.CCONSU).append("=?");
			arrParams.add(Integer.valueOf(consulta.getCodigo()));
			
			sql.append(" AND T03A.").append(V50bResolutoresBD.COD_RESOL).append(" = T12.").append(V50bNotificacionesBD.CEMIS);
			sql.append(" AND T03B.").append(V50bResolutoresBD.COD_RESOL).append(" = T12.").append(V50bNotificacionesBD.CEMIS).append("(+)");
			
			return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50bBuscarNotificacionesRowMapper());
		}
		
		/**
		 * <p>Ttulo: fncRespondeNotificacion</p>
		 * <p>Descripcin: Responde una notificacin</p>
		 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author llaparra
		 * @version 1.0
		 * @param respuesta La respuesta
		 * @return Integer Resultado de la operacin
		 * @throws Exception Cualquier excepcin
		 */
		public Integer fncRespondeNotificacion(V50bNotificacionBean respuesta) throws Exception {
			V50bClsTrazas.depura("V50bConsultasDAOImpl.fncRespondeNotificacion() ");

			final StringBuffer sql = new StringBuffer(V50bClsConstantes.SETENTAYUNO);
			final List arrParams = new ArrayList();
			
			sql.append("UPDATE ").append(V50bNotificacionesBD.TABLA_NOTIFICACIONES).append(" T12 SET ");
			sql.append("T12.").append(V50bNotificacionesBD.FECNOT).append("=SYSDATE, ");
			sql.append("T12.").append(V50bNotificacionesBD.RESPUE).append("=?, ");
			if(StringUtils.isNotEmpty(respuesta.getRespuesta())){
				arrParams.add(respuesta.getRespuesta());
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}
			
			sql.append("T12.").append(V50bNotificacionesBD.ESTADO).append("=? ");
			arrParams.add(V50bClsConstantes.CONSTANTE_CERRADA);
			
			if(StringUtils.isNotEmpty(respuesta.getFichero().getNombreReal())){
				sql.append(", T12.").append(V50bNotificacionesBD.OIDPID).append("=?, ");
				arrParams.add(respuesta.getFichero().getOid());
				
				sql.append("T12.").append(V50bNotificacionesBD.NOMFI).append("=? ");
				arrParams.add(respuesta.getFichero().getNombreReal());
			}
			
			sql.append("WHERE T12.").append(V50bNotificacionesBD.CCONSU).append("=? ");
			arrParams.add(Integer.valueOf(respuesta.getCodConsulta()));
			
			sql.append("AND T12.").append(V50bNotificacionesBD.CNOTIF).append("=?");
			arrParams.add(Integer.valueOf(respuesta.getCodigo()));
			
			return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
		}
		
		/**
		 * <p>Ttulo: fncBuscar24Horas</p>
		 * <p>Descripcin: Busca consultas 24 Horas</p>
		 * <p>Copyright: Copyright (c) Dec 22, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author brey
		 * @version 1.0
		 * @param codResolutor El resolutor
		 * @param codAmbito El mbito
		 * @param idioma El idioma
		 * @return List Lista con las consultas
		 * @throws Exception Cualquier excepcin
		 */
		public List fncBuscar24Horas(String codResolutor, String codAmbito, String idioma)
			throws Exception {
			
			V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscar24Horas()");
			final StringBuffer sql24h = new StringBuffer(530);
			final List arrParams = new ArrayList();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(idioma);
			
			sql24h.append("SELECT DISTINCT(T01.").append(V50bConsultasBD.CCONSU).append(") AS CODCONSULTA, ");
			sql24h.append("T01.").append(V50bConsultasBD.TEXTCON).append(" AS CONSULTA, ");
			sql24h.append("LPAD(T01.").append(V50bConsultasBD.CCONSU).append(",?,'0') AS CODIGOORDEN, T07.");
			arrParams.add(new Integer(V50bClsConstantes.DOS));
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sql24h.append(V50bAmbitoBD.DESAMC).append(" AS AMBITO, T21.");
			} else {
				sql24h.append(V50bAmbitoBD.DESAME).append(" AS AMBITO, T21.");
			}
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sql24h.append(V50bEstadosBD.DESCC).append(" AS ESTADO, T09.");
			} else {
				sql24h.append(V50bEstadosBD.DESCE).append(" AS ESTADO, T09.");
			}
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sql24h.append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD, TO_CHAR(T01.");
			} else {
				sql24h.append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD, TO_CHAR(T01.");
			}
			sql24h.append(V50bConsultasBD.FECCON).append(", ?) AS FECHA, ");
			arrParams.add(masc);
			sql24h.append(V50bResolutoresBD.AP1_RESOL).append(" || ' ' || T03.");
			sql24h.append(V50bResolutoresBD.AP2_RESOL).append(" || ', ' || T03.");
			sql24h.append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS RESOLUTOR, T14.");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sql24h.append(V50bIdiomasBD.DESCC).append(" AS IDIOMA");
			} else {
				sql24h.append(V50bIdiomasBD.DESCE).append(" AS IDIOMA");
			}
			sql24h.append(" FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01, ");
			sql24h.append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR).append(" T06, ");
			sql24h.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07, ");
			sql24h.append(V50bEstadosBD.TABLA_ESTADOS).append(" T21, ");
			sql24h.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09, ");
			sql24h.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
			sql24h.append(V50bIdiomasBD.TABLA_IDIOMAS).append(" T14 WHERE T01.").append(V50bConsultasBD.CCONSU).append(" > 0");
			sql24h.append(" AND T01.").append(V50bConsultasBD.CODDIF).append("=?");
			arrParams.add(Integer.valueOf(V50bClsConstantes.DIFICULTAD_24H));		
//			sql24h.append(" AND SYSDATE BETWEEN T01.").append(V50bConsultasBD.FECCON);
//			sql24h.append(" AND T01.").append(V50bConsultasBD.FECCON).append("+1");
			sql24h.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_DENEGADA));
			sql24h.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
			sql24h.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
			sql24h.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_ABANDONADA));
			sql24h.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = ").append(codResolutor);
			sql24h.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T07.").append(V50bAmbitoBD.CAMBIT).append("(+)");
			sql24h.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST);
			sql24h.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT).append("(+)");
			sql24h.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF).append("(+)");
			sql24h.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL).append("(+)");
			sql24h.append(" AND T01.").append(V50bConsultasBD.IDIOMA).append(" = T14.").append(V50bIdiomasBD.IDIOMA).append("(+)");
			sql24h.append(" ORDER BY CODCONSULTA ASC");
			
			return new V50bClsAccesoBD().fncLanzaBusqueda(sql24h.toString(), arrParams, new V50bVistasRowMapper());
			
			
		
		}
		
		/**
		 * <p>Ttulo: fncBuscarPendientes</p>
		 * <p>Descripcin: Busca consultas Pendientes</p>
		 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author brey
		 * @version 1.0
		 * @param codResolutor El resolutor
		 * @param codAmbito El mbito
		 * @param idioma El idioma
		 * @return List Lista con las consultas
		 * @throws Exception Cualquier excepcin
		 */
		public List fncBuscarPendientes(String codResolutor, String codAmbito, String idioma)
			throws Exception {
			
			V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarPendientes()");
			final StringBuffer sql = new StringBuffer(500);
			final List arrParams = new ArrayList();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(idioma);
			
			sql.append("SELECT T01.").append(V50bConsultasBD.CCONSU).append(" AS CODCONSULTA, ");
			sql.append("T01.").append(V50bConsultasBD.TEXTCON).append(" AS CONSULTA, ");
			sql.append("LPAD(T01.").append(V50bConsultasBD.CCONSU).append(",?,'0') AS CODIGOORDEN, T07.");
			arrParams.add(new Integer(V50bClsConstantes.DOS));
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sql.append(V50bAmbitoBD.DESAMC).append(" AS AMBITO, T21.");
			} else {
				sql.append(V50bAmbitoBD.DESAME).append(" AS AMBITO, T21.");
			}
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sql.append(V50bEstadosBD.DESCC).append(" AS ESTADO, T09.");
			} else {
				sql.append(V50bEstadosBD.DESCE).append(" AS ESTADO, T09.");
			}
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sql.append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD, TO_CHAR(T01.");
			} else {
				sql.append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD, TO_CHAR(T01.");
			}
			sql.append(V50bConsultasBD.FECCON).append(", ?) AS FECHA, ");
			arrParams.add(masc);
			sql.append(V50bResolutoresBD.AP1_RESOL).append(" || ' ' || T03.");
			sql.append(V50bResolutoresBD.AP2_RESOL).append(" || ', ' || T03.");
			sql.append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS RESOLUTOR, T14.");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sql.append(V50bIdiomasBD.DESCC).append(" AS IDIOMA");
			} else {
				sql.append(V50bIdiomasBD.DESCE).append(" AS IDIOMA");
			}
			sql.append(" FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01, ");
			sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07, ");
			sql.append(V50bEstadosBD.TABLA_ESTADOS).append(" T21, ");
			sql.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09, ");
			sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
			sql.append(V50bIdiomasBD.TABLA_IDIOMAS).append(" T14 ");
		    sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(" > 0 ");
		    sql.append("AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RECIBIDA));
		    sql.append("AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_DENEGADA));
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!= ? ");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_ABANDONADA));
			sql.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = ").append(codResolutor);
			sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T07.").append(V50bAmbitoBD.CAMBIT).append("(+)");
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST);
			sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT).append("(+)");
			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF).append("(+)");
			sql.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL).append("(+)");
			sql.append(" AND T01.").append(V50bConsultasBD.IDIOMA).append(" = T14.").append(V50bIdiomasBD.IDIOMA).append("(+)");
			sql.append(" ORDER BY CODCONSULTA ASC");
			
			return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bVistasRowMapper());
		
		}
		
		/**
		 * <p>Ttulo: fncBuscarRetrasadas</p>
		 * <p>Descripcin: Busca consultas Retrasadas</p>
		 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author brey
		 * @version 1.0
		 * @param codResolutor El resolutor
		 * @param codAmbito El mbito
		 * @param idioma El idioma
		 * @return List Lista con las consultas
		 * @throws Exception Cualquier excepcin
		 */
		public List fncBuscarRetrasadas(String codResolutor, String codAmbito, String idioma)
			throws Exception {
			
			V50bClsTrazas.depura("V50bConsultasDAOImpl.fncBuscarRetrasadas()");
			final StringBuffer sqlRetrasadas = new StringBuffer(V50bClsConstantes.QUINIENTOSCINCUENTAYOCHO);
			final List arrParams = new ArrayList();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(idioma);
			
			sqlRetrasadas.append("SELECT T01.").append(V50bConsultasBD.CCONSU).append(" AS CODCONSULTA, ");
			sqlRetrasadas.append("T01.").append(V50bConsultasBD.TEXTCON).append(" AS CONSULTA, ");
			sqlRetrasadas.append("LPAD(T01.").append(V50bConsultasBD.CCONSU).append(",?,'0') AS CODIGOORDEN, T07.");
			arrParams.add(new Integer(V50bClsConstantes.DOS));
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sqlRetrasadas.append(V50bAmbitoBD.DESAMC).append(" AS AMBITO, T21.");
			} else {
				sqlRetrasadas.append(V50bAmbitoBD.DESAME).append(" AS AMBITO, T21.");
			}
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sqlRetrasadas.append(V50bEstadosBD.DESCC).append(" AS ESTADO, T09.");
			} else {
				sqlRetrasadas.append(V50bEstadosBD.DESCE).append(" AS ESTADO, T09.");
			}
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sqlRetrasadas.append(V50bDificultadBD.DESCC).append(" AS DIFICULTAD, TO_CHAR(T01.");
			} else {
				sqlRetrasadas.append(V50bDificultadBD.DESCE).append(" AS DIFICULTAD, TO_CHAR(T01.");
			}
			sqlRetrasadas.append(V50bConsultasBD.FECCON).append(", ?) AS FECHA, ");
			arrParams.add(masc);
			sqlRetrasadas.append(V50bResolutoresBD.AP1_RESOL).append(" || ' ' || T03.");
			sqlRetrasadas.append(V50bResolutoresBD.AP2_RESOL).append(" || ', ' || T03.");
			sqlRetrasadas.append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS RESOLUTOR, T14.");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				sqlRetrasadas.append(V50bIdiomasBD.DESCC).append(" AS IDIOMA");
			} else {
				sqlRetrasadas.append(V50bIdiomasBD.DESCE).append(" AS IDIOMA");
			}
			sqlRetrasadas.append(" FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01, ");
			sqlRetrasadas.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07, ");
			sqlRetrasadas.append(V50bEstadosBD.TABLA_ESTADOS).append(" T21, ");
			sqlRetrasadas.append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09, ");
			sqlRetrasadas.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
			sqlRetrasadas.append(V50bIdiomasBD.TABLA_IDIOMAS).append(" T14 ");
			sqlRetrasadas.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(" > 0 ");
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = ").append(codResolutor);
			sqlRetrasadas.append(" AND FNCRETRASADACONSULTA(T01.").append(V50bConsultasBD.CCONSU).append(") = ? ");
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T07.").append(V50bAmbitoBD.CAMBIT).append("(+)");
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST);
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT).append("(+)");
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF).append("(+)");
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL).append("(+)");
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.IDIOMA).append(" = T14.").append(V50bIdiomasBD.IDIOMA).append("(+)");
			/*sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
			sqlRetrasadas.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" != ?");
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_DENEGADA));
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
			arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_ABANDONADA));*/
			sqlRetrasadas.append(" ORDER BY CODCONSULTA ASC");
		
			return new V50bClsAccesoBD().fncLanzaBusqueda(sqlRetrasadas.toString(), arrParams, new V50bVistasRowMapper());
		
		}
		
		/**
		 * <p>Ttulo: fncVerFicheroNotif</p>
		 * <p>Descripcin: Obtiene el lob de la notificacin</p>
		 * <p>Copyright: Copyright (c) 30/10/2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author llaparra
		 * @version 1.0
		 * @param v50bCodigoNotif Cdigo de la notificacin
		 * @return Devuelve el lob
		 * @throws Exception Cualquier excepcin
		 */
		public V50bClsFichero fncVerFicheroNotif(String v50bCodigoNotif) throws Exception {
			V50bClsTrazas.depura("V50bConsultasDAOImpl.fncVerFicheroNotif() ");
			
			final StringBuffer sql = new StringBuffer(50);
			final List arrParams = new ArrayList();
			
			sql.append("SELECT ");
			sql.append(V50bNotificacionesBD.NOMFI);
			sql.append(", ").append(V50bNotificacionesBD.OIDPID);
			sql.append(" FROM ").append(V50bNotificacionesBD.TABLA_NOTIFICACIONES);
			sql.append(" WHERE ").append(V50bNotificacionesBD.CNOTIF).append(" = ?");
			arrParams.add(Integer.valueOf(v50bCodigoNotif));
					
			return new V50bClsAccesoBD().fncConsultaFichNoTemp(sql.toString(), arrParams);
		}
		
		
	
	//***************
	//* ROW-MAPPERS *
	//***************
		/**
		 * 
		 * @author llaparra
		 *
		 */
		class V50bBuscarNotificacionesRowMapper implements V50bRowMapper{
			
			/**
			 * @param rs :Resultset
			 * @return Object
			 * @throws SQLException Excepcin SQL.
			 */
			public Object mapRow (ResultSet rs) throws SQLException{
				
				final V50bNotificacionBean notif = new V50bNotificacionBean();
				final V50bClsFichero fich = new V50bClsFichero();
				
				notif.setCodConsulta(rs.getString("CODCONSULTA"));
				notif.setCodEmisor(rs.getString("EMISOR"));
				notif.setCodReceptor(rs.getString("RECEPTOR"));
				notif.setCodigo(rs.getString("CODNOTIFICACION"));
				notif.setFecha(rs.getString("FECHA"));
				fich.setOid(rs.getString("OIDPID"));
				fich.setNombreReal(rs.getString("NOMFICH"));
				notif.setFichero(fich);
				notif.setEstado(rs.getString("ESTADO"));
				notif.setTipo(rs.getString("TIPO"));
				notif.setPregunta(rs.getString("PREGUNTA"));
				notif.setRespuesta(rs.getString("RESPUESTA"));
				notif.setNomEmisor(rs.getString("NOMBRE"));
				notif.setIdReceptor(rs.getString("IDRECEPTOR"));
				
				return notif;
			}
		}
		
		
	/**
	 * 
	 * @author llaparra
	 *
	 */
	class V50bDetalleConsultaRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			//final V50bBandejaEntradaTableBean consulta = new V50bBandejaEntradaTableBean();
			final V50bConsultaBean consulta = new V50bConsultaBean();
			final V50bDificultadBean dificultad = new V50bDificultadBean();
			final V50bAmbitoBean ambito = new V50bAmbitoBean();
			final V50bSuscriptorBean suscriptor = new V50bSuscriptorBean();
			final V50bResolutoresBean resolutor = new V50bResolutoresBean();
			final V50bSubcategoriasBean subcategoria = new V50bSubcategoriasBean();
			final V50bClsFichero fichCons = new V50bClsFichero();
			final V50bClsFichero fichRes = new V50bClsFichero();
			final V50bClsFichero fichResol = new V50bClsFichero();
			
			consulta.setFechaConsulta(rs.getString("FECHAC"));
			consulta.setFechaRespuesta(rs.getString("FECHAR"));
			consulta.setCodigo(rs.getString("CODIGO"));
			consulta.setCodEstado(rs.getString("ESTADO"));
			consulta.setConsulta(rs.getString("CONSULTA"));
			consulta.setCodIdioma(rs.getString("IDIOMA"));
			consulta.setAbreviaturas(rs.getString("ABREVIATURA"));
			consulta.setPublicado(rs.getString("PUBLICO"));
			consulta.setContexto(rs.getString("CONTEXTO"));
			consulta.setRecepcion(rs.getString("RECEPCION"));
			consulta.setMultiterm(rs.getString("MULTITERM"));
			consulta.setPalabrasClave(rs.getString("PCLAVE"));
			
			String url = rs.getString("URL");
			if (StringUtils.isNotEmpty(rs.getString("URL")) && 
				!StringUtils.contains(rs.getString("URL").toLowerCase(), "http://")){
					url = "http://".concat(rs.getString("URL"));
			}
			consulta.setUrl(url);
			
			try{  
		    	consulta.setRespuesta(V50bClsFunciones.fncTextoClob(rs.getClob("RESPUESTA")));
		    } catch (Exception e) {
		    	consulta.setRespuesta("");
			}
		    
			consulta.setMensaje(rs.getString("MENSAJE"));
			consulta.setIndFinPlazo(rs.getString("ATRASADA"));
			
			subcategoria.setCodSub(rs.getString("CODSUBCATEGORIA"));
			subcategoria.setDesCas(rs.getString("SUBCATEGORIA"));
			consulta.setSubcategoria(subcategoria);
			
			ambito.setCambit(rs.getString("AMBITO"));
			consulta.setAmbito(ambito);
			
			dificultad.setDescc(rs.getString("DIFICULTAD"));
			consulta.setDificultad(dificultad);
			
			fichCons.setOid(rs.getString("FILECO_OID"));
			fichCons.setNombreReal(rs.getString("NOMFICHEROC"));
			consulta.setFichero(fichCons);
			
			fichRes.setOid(rs.getString("FILERE_OID"));
			fichRes.setNombreReal(rs.getString("NOMFICHEROR"));
			consulta.setFichRespuesta(fichRes);
			
			fichResol.setOid(rs.getString("FRESOL_OID"));
			fichResol.setNombreReal(rs.getString("NOMFICHERORESOL"));
			consulta.setFichResolutor(fichResol);
			
			String resAux=rs.getString("RESOLUTOR");
			if(",".equals(resAux.trim())) {
				resAux="";
			}
			resolutor.setNombreApellidos(resAux);
			consulta.setResolutor(resolutor);
			
			suscriptor.setNombre(rs.getString("NOMBRE"));
			suscriptor.setApellido1(rs.getString("APELLIDO1"));
			suscriptor.setApellido2(rs.getString("APELLIDO2"));
			suscriptor.setNifOtros(rs.getString("DNI"));
			consulta.setSuscriptor(suscriptor);
			
			int numnotif = rs.getInt("NUMNOTIF");
			if(numnotif>0){
				consulta.setIndNotificacion(V50bClsConstantes.CONSTANTE_SI);
			} else {
				consulta.setIndNotificacion(V50bClsConstantes.CONSTANTE_NO);
			}
			
			consulta.setCodMotivDenegar(rs.getString("MOTIVO"));
			
			return consulta;
		}
	}
	
	/**
	 * 
	 * @author llaparra
	 *
	 */
	class V50bBandejaEntradaRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			//final V50bBandejaEntradaTableBean consulta = new V50bBandejaEntradaTableBean();
			final V50bConsultaBean consulta = new V50bConsultaBean();
			final V50bDificultadBean dificultad = new V50bDificultadBean();
			final V50bAmbitoBean ambito = new V50bAmbitoBean();
			final V50bSuscriptorBean suscriptor = new V50bSuscriptorBean();
			final V50bSubcategoriasBean subcategoria = new V50bSubcategoriasBean();
			final V50bResolutoresBean resolutor = new V50bResolutoresBean();
			
			subcategoria.setDesCas(rs.getString("SUBCATEGORIA"));
			subcategoria.setCodSub(rs.getString("CODSUBCATEGORIA"));
			consulta.setSubcategoria(subcategoria);
			consulta.setFechaConsulta(rs.getString("FECHA"));
			consulta.setFechaConsultaOrden(rs.getString("FECHAORDEN"));
			consulta.setCodigo(rs.getString("CODIGO"));
			consulta.setContexto(rs.getString("CONTEXTO"));
			suscriptor.setCodigo(rs.getString("SUSCRIPTOR"));
			consulta.setSuscriptor(suscriptor);
			resolutor.setCodResol(rs.getString("RESOLUTOR"));
			consulta.setResolutor(resolutor);
			ambito.setCambit(rs.getString("CODAMBITO"));
			ambito.setDesamc(rs.getString("AMBITO"));
			consulta.setAmbito(ambito);
			consulta.setIndAbandonada(rs.getString("ABANDONADA"));
			consulta.setCodEstado(rs.getString("CODESTADO"));
			consulta.setNomEstado(rs.getString("ESTADO"));
			consulta.setRemitente(rs.getString("REMITENTE"));
			
			StringBuffer textoCons = new StringBuffer();
			textoCons.append(rs.getString("CONSULTA"));
			if(textoCons.length()>V50bClsConstantes.NOVENTAYNUEVE){
				textoCons.append("...");
			}
			
			consulta.setConsulta(textoCons.toString());
			consulta.setConsultaCompleta(rs.getString("CONSULTAENTERA"));
			dificultad.setDescc(rs.getString("DIFICULTAD"));
			dificultad.setCoddif(rs.getString("CODDIFICULTAD"));
			consulta.setDificultad(dificultad);
			consulta.setIndFichero(rs.getString("FICHERO"));
			
			if(rs.getInt("NOTIFICACION")>0){
				consulta.setIndNotificacion(V50bClsConstantes.CONSTANTE_SI);
			} else {
				consulta.setIndNotificacion(V50bClsConstantes.CONSTANTE_NO);
			}
			
			if(rs.getInt("NOTIFICACIONES")>0){
				consulta.setNotificaciones(V50bClsConstantes.CONSTANTE_SI);
			} else {
				consulta.setNotificaciones(V50bClsConstantes.CONSTANTE_NO);
			}

			return consulta;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bEstadoConsultasRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bConsultaBean consulta = new V50bConsultaBean();
			final V50bDificultadBean dificultad = new V50bDificultadBean();
			final V50bAmbitoBean ambito = new V50bAmbitoBean();
			
			consulta.setCodigo(rs.getString("CODIGO"));
			consulta.setFechaConsulta(rs.getString("FECHA"));
			consulta.setFechaConsultaOrden(rs.getString("FECHAORDEN"));
			
			StringBuffer textoCons = new StringBuffer();
			textoCons.append(rs.getString("CONSULTA"));
			if(textoCons.length()>V50bClsConstantes.NOVENTAYNUEVE){
				textoCons.append("...");
			}
			
			consulta.setConsulta(textoCons.toString());
			consulta.setConsultaCompleta(rs.getString("CONSULTAENTERA"));
			ambito.setDesamc(rs.getString("AMBITO"));
			consulta.setAmbito(ambito);
			dificultad.setDescc(rs.getString("DIFICULTAD"));
			dificultad.setDias(rs.getString("DIASDIFICULTAD"));
			consulta.setDificultad(dificultad);
			consulta.setNomEstado(rs.getString("ESTADO"));
			consulta.setNomResolutor(rs.getString("RESOLUTOR"));
			if (consulta.getNomResolutor().length()==V50bClsConstantes.TRES){
				consulta.setNomResolutor("");
			}
			consulta.setHoras24(rs.getString("ES24HORAS"));
			consulta.setIndFinPlazo(rs.getString("ATRASADA"));
			
			try{  
				consulta.setConsultaFormateada(V50bClsFunciones.replaceGenerales(rs.getString("CONSULTAFORMATEADA")));
		    } catch (Exception e) {
		    	consulta.setConsultaFormateada("");
			}
			return consulta;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bDificultadesAmbitoRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bConsultaBean consulta = new V50bConsultaBean();
			V50bDificultadBean dificultad = new V50bDificultadBean();
			dificultad.setCoddif(rs.getString("CODIGODIFICULTAD"));
			dificultad.setDescc(rs.getString("DIFICULTAD"));
			consulta.setDificultad(dificultad);	
			
			return consulta;
		}
	}
	
	/**
	 * 
	 * @author acompes
	 *
	 */
	class V50bCatalogoConsultasRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bConsultaBean consulta = new V50bConsultaBean();
			final V50bDificultadBean dificultad = new V50bDificultadBean();
			final V50bAmbitoBean ambito = new V50bAmbitoBean();
			
			consulta.setCodigo(rs.getString("CODIGO"));
			consulta.setFechaConsulta(rs.getString("FECHA"));
			consulta.setFechaConsultaOrden(rs.getString("FECHAORDEN"));
			
			StringBuffer textoCons = new StringBuffer();
			textoCons.append(rs.getString("CONSULTA"));
			if(textoCons.length()>V50bClsConstantes.NOVENTAYNUEVE){
				textoCons.append("...");
			}
			
			
			consulta.setConsulta(textoCons.toString());
			consulta.setConsultaCompleta(rs.getString("CONSULTAENTERA"));
			ambito.setDesamc(rs.getString("AMBITO"));
			consulta.setAmbito(ambito);
			consulta.setDescAmbito(rs.getString("AMBITO"));
			dificultad.setDescc(rs.getString("DIFICULTAD"));
			dificultad.setDias(rs.getString("DIASDIFICULTAD"));
			consulta.setDificultad(dificultad);
			consulta.setDescDificultad(rs.getString("DIFICULTAD"));
			consulta.setDias(rs.getString("DIASDIFICULTAD"));
			consulta.setHoras24(rs.getString("ES24HORAS"));
			consulta.setNomResolutor(rs.getString("RESOLUTOR"));
			consulta.setIndFinPlazo(rs.getString("ATRASADA"));
			try{  
				consulta.setConsultaFormateada(V50bClsFunciones.replaceGenerales(rs.getString("CONSULTAFORMATEADA")));
		    } catch (Exception e) {
		    	consulta.setConsultaFormateada("");
			}
			
			return consulta;
		}
	}
	
	/**
	 * 
	 * @author brey
	 *
	 */
	class V50bVistasRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bConsultaBean consulta = new V50bConsultaBean();
			
			consulta.setCodigo(rs.getString("CODCONSULTA"));
			consulta.setConsulta(rs.getString("CONSULTA"));
			consulta.setCodigoOrden(rs.getString("CODIGOORDEN"));
			consulta.setDescAmbito(rs.getString("AMBITO"));
			consulta.setNomEstado(rs.getString("ESTADO"));
			consulta.setDescDificultad(rs.getString("DIFICULTAD"));
			consulta.setFechaConsulta(rs.getString("FECHA"));
			consulta.setNomResolutor(rs.getString("RESOLUTOR"));
			consulta.setDescIdioma(rs.getString("IDIOMA"));
			
			return consulta;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bHistoricoConsultasRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bConsultaBean consulta = new V50bConsultaBean();
			final V50bDificultadBean dificultad = new V50bDificultadBean();
			final V50bAmbitoBean ambito = new V50bAmbitoBean();
			
			consulta.setCodigo(rs.getString("CODIGO"));
			consulta.setFechaConsulta(rs.getString("FECHA"));
			consulta.setFechaConsultaOrden(rs.getString("FECHAORDEN"));
			
			StringBuffer textoCons = new StringBuffer();
			textoCons.append(rs.getString("CONSULTA"));
			if(textoCons.length()>V50bClsConstantes.NOVENTAYNUEVE){
				textoCons.append("...");
			}
			
			consulta.setConsulta(textoCons.toString());
			consulta.setConsultaCompleta(rs.getString("CONSULTAENTERA"));
			ambito.setDesamc(rs.getString("AMBITO"));
			consulta.setAmbito(ambito);
			consulta.setDescIdioma(rs.getString("IDIOMA"));
			dificultad.setDescc(rs.getString("DIFICULTAD"));
			dificultad.setDias(rs.getString("DIASDIFICULTAD"));
			consulta.setDificultad(dificultad);
			consulta.setNomResolutor(rs.getString("RESOLUTOR"));
			if (consulta.getNomResolutor().length()==V50bClsConstantes.TRES){
				consulta.setNomResolutor("");
			}
			consulta.setPublicado(rs.getString("INTERN"));
			consulta.setIndFinPlazo(rs.getString("ATRASADA"));
			try{  
				consulta.setConsultaFormateada(V50bClsFunciones.replaceGenerales(rs.getString("CONSULTAFORMATEADA")));
		    } catch (Exception e) {
		    	consulta.setConsultaFormateada("");
			}
			
			return consulta;
		}
	}
	
	
	/**
	 * 
	 * @author acompes
	 *
	 */
	class V50bSubcategoriasAmbitoCatalogoConsultasRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bConsultaBean consulta = new V50bConsultaBean();
			V50bSubcategoriasBean subcategorias = new V50bSubcategoriasBean();
			subcategorias.setCodSub(rs.getString("CODIGOSUBCATEGORIA"));
			subcategorias.setDesCas(rs.getString("SUBCATEGORIA"));
			consulta.setSubcategoria(subcategorias);	
			
			return consulta;
		}
	}

/**
 * 
 * @author mmonge
 *
 */
	class V50IndicadoresGestionRowMapper implements V50bRowMapper{
/**
 * @param rs parametro de entrada
 * @return Object
 * @throws SQLException excepcion
 */
		public Object mapRow(ResultSet rs) throws SQLException 
		{
			V50bCriteriosConsultaBean miBean= new V50bCriteriosConsultaBean();
			miBean.setSexo(rs.getString("SEXO"));
			miBean.setFechaD(rs.getString("FECHA"));					
			return miBean;
		}		
	}
	
}
