package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bConfiguracionBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConfiguracionBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConfiguracionTextosBD;
import v50b.v50bModelo.v50bDao.V50bConfiguracionDAO;


/**
 * 
 * @author iurkidi
 *
 */
public class V50bConfiguracionDAOImpl implements V50bConfiguracionDAO{

	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfiguracion(V50bConfiguracionBean buzon) throws Exception {

		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncBuscarConfiguracion() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTODIEZYNUEVE);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T13.").append(V50bConfiguracionBD.CODDES).append(" AS CODIGO, T13.");
		sql.append(V50bConfiguracionBD.DESTIN).append(" AS DESTINATARIO, T13.");
		sql.append(V50bConfiguracionBD.EMAIL).append(" AS EMAIL, DECODE(T13.");
		sql.append(V50bConfiguracionBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ACTIVO).append("', '");
		sql.append(V50bClsConstantes.LITERAL_ACTIVO).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_INACTIVO).append("', '"); 
		sql.append(V50bClsConstantes.LITERAL_INACTIVO).append("') AS ESTADO FROM ");
		sql.append(V50bConfiguracionBD.TABLA_BUZON).append(" T13");
		sql.append(" ORDER BY 1");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bConfiguracionRowMapper());
		
		return lista;
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfigTextos(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncBuscarConfigTextos() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOCINCUENTAYSEIS);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T16.").append(V50bConfiguracionTextosBD.CPROPI).append(" AS CODIGO, T16.");
		sql.append(V50bConfiguracionTextosBD.EMAIL).append(" AS EMAIL, DECODE(T16.");
		sql.append(V50bConfiguracionTextosBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ACTIVO).append("', '");
		sql.append(V50bClsConstantes.LITERAL_ACTIVO).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_INACTIVO).append("', '"); 
		sql.append(V50bClsConstantes.LITERAL_INACTIVO).append("') AS ESTADO, T16.");
		sql.append(V50bConfiguracionTextosBD.DPROPC).append(" AS DESCRIPCIONCASTELLANO, T16.");
		sql.append(V50bConfiguracionTextosBD.DPROPE).append(" AS DESCRIPCIONEUSKERA FROM ");
		sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS).append(" T16");
		sql.append(" ORDER BY 1");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bConfiguracionTextoRowMapper());
		
		return lista;
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de Delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarConfiguracion(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncEliminarConfiguracion() ");
		final StringBuffer sql = new StringBuffer();
		final StringBuffer sqlEstado = new StringBuffer();
		final List arrParams = new ArrayList();
		int resultado = 2;
		String coddes =buzon.getCoddes();
		
		if(coddes!=null && !"".equals(coddes)){
			int codigo = Integer.parseInt(coddes);
			sqlEstado.append("SELECT T13.").append(V50bConfiguracionBD.CODDES).append(" AS CODIGO, T13.");
			sqlEstado.append(V50bConfiguracionBD.DESTIN).append(" AS DESTINATARIO, T13.");
			sqlEstado.append(V50bConfiguracionBD.EMAIL).append(" AS EMAIL, DECODE(T13.");
			sqlEstado.append(V50bConfiguracionBD.ESTADO).append(", '");
			sqlEstado.append(V50bClsConstantes.CONSTANTE_ACTIVO).append("', '");
			sqlEstado.append(V50bClsConstantes.LITERAL_ACTIVO).append("', '");
			sqlEstado.append(V50bClsConstantes.CONSTANTE_INACTIVO).append("', '"); 
			sqlEstado.append(V50bClsConstantes.LITERAL_INACTIVO).append("') AS ESTADO FROM ");
			sqlEstado.append(V50bConfiguracionBD.TABLA_BUZON).append(" T13");
			sqlEstado.append(" WHERE ").append(V50bConfiguracionBD.CODDES).append(" = ").append(codigo);
			
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sqlEstado.toString(), arrParams, new V50bConfiguracionRowMapper());
			
			V50bConfiguracionBean destinatario = (V50bConfiguracionBean)lista.get(0);
			if (!destinatario.getEstado().equals(V50bClsConstantes.LITERAL_ACTIVO)){
				sql.append("DELETE ");sql.append(V50bConfiguracionBD.TABLA_BUZON);
				sql.append(" WHERE ");
				sql.append(V50bConfiguracionBD.CODDES);sql.append(" = ").append(codigo);
				resultado = new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
			}
		}
			
		return resultado;
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarContactoIvap(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarContactoIvap() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		String textoContactoIvapes = buzon.getTextoContactoIvapes();
		String textoContactoIvapeu = buzon.getTextoContactoIvapeu();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ");
		
		sql.append(V50bConfiguracionTextosBD.DPROPC).append(" = ? ,");
		
		if(textoContactoIvapes==null || "".equals(textoContactoIvapes)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoContactoIvapes);
		}
		
		sql.append(V50bConfiguracionTextosBD.DPROPE).append(" = ? ");
				
		if(textoContactoIvapeu==null || "".equals(textoContactoIvapeu)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoContactoIvapeu);
		}
		
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_CONTACTO_IVAP).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarOlvidoContrasenia(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarOlvidoContrasenia() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		String textoOlvidoContraseniaes = buzon.getTextoOlvidoContraseniaes();
		String textoOlvidoContraseniaeu = buzon.getTextoOlvidoContraseniaeu();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ");
		
		sql.append(V50bConfiguracionTextosBD.DPROPC).append(" = ?, ");
		
		if(textoOlvidoContraseniaes==null || "".equals(textoOlvidoContraseniaes)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoOlvidoContraseniaes);
		}
		
		sql.append(V50bConfiguracionTextosBD.DPROPE).append(" = ? ");
			
		if(textoOlvidoContraseniaeu==null || "".equals(textoOlvidoContraseniaeu)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoOlvidoContraseniaeu);
		}
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_OLVIDO_CONTRASENYA).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarAltaSuscripcion(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarAltaSuscripcion() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		String textoAltaSuscripciones = buzon.getTextoAltaSuscripciones();
		String textoAltaSuscripcioneu = buzon.getTextoAltaSuscripcioneu();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ");
		
		sql.append(V50bConfiguracionTextosBD.DPROPC).append(" = ?, ");
		
		if(textoAltaSuscripciones==null || "".equals(textoAltaSuscripciones)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoAltaSuscripciones);
		}
		
		sql.append(V50bConfiguracionTextosBD.DPROPE).append(" = ? ");
			
		if(textoAltaSuscripcioneu==null || "".equals(textoAltaSuscripcioneu)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoAltaSuscripcioneu);
		}
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_ALTA_SUSCRIPCION).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarRecibirNotificacion(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarRecibirNotificacion() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		String textoRecibirNotificaciones = buzon.getTextoRecibirNotificaciones();
		String textoRecibirNotificacioneu = buzon.getTextoRecibirNotificacioneu();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ");
		sql.append(V50bConfiguracionTextosBD.DPROPC).append(" = ?, ");
		
		if(textoRecibirNotificaciones==null || "".equals(textoRecibirNotificaciones)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoRecibirNotificaciones);
		}
		
		sql.append(V50bConfiguracionTextosBD.DPROPE).append(" = ? ");
				
		if(textoRecibirNotificacioneu==null || "".equals(textoRecibirNotificacioneu)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoRecibirNotificacioneu);
		}
		
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_RECIBIR_NOTIFICACION).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarProteccionDatos(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarProteccionDatos() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		String textoProteccionDatoses = buzon.getTextoProteccionDatoses();
		String textoProteccionDatoseu = buzon.getTextoProteccionDatoseu();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ");
		sql.append(V50bConfiguracionTextosBD.DPROPC).append(" = ?, ");
		
		if(textoProteccionDatoses==null || "".equals(textoProteccionDatoses)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoProteccionDatoses);
		}
		
		sql.append(V50bConfiguracionTextosBD.DPROPE).append(" = ? ");
				
		if(textoProteccionDatoseu==null || "".equals(textoProteccionDatoseu)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(textoProteccionDatoseu);
		}
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_PROTECCION_DATOS).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarComunicacionClaves(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarComunicacionClaves() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		String textoComunicacionClaveses = buzon.getTextoComunicacionClaveses();
		String textoComunicacionClaveseu = buzon.getTextoComunicacionClaveseu();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ");
			sql.append(V50bConfiguracionTextosBD.DPROPC).append(" = ?, ");
		
			if(textoComunicacionClaveses==null || "".equals(textoComunicacionClaveses)){
					arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(textoComunicacionClaveses);
			}
		
			sql.append(V50bConfiguracionTextosBD.DPROPE).append(" = ? ");
				
			if(textoComunicacionClaveseu==null || "".equals(textoComunicacionClaveseu)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(textoComunicacionClaveseu);
			}
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_COMUNICACION_CLAVES).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarServicioInactivo(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarServicioInactivo() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		String textoServicioInactivoes = buzon.getTextoServicioInactivoes();
		String textoServicioInactivoeu = buzon.getTextoServicioInactivoeu();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ");
			sql.append(V50bConfiguracionTextosBD.DPROPC).append(" = ?, ");
		
			if(textoServicioInactivoes==null || "".equals(textoServicioInactivoes)){
					arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(textoServicioInactivoes);
			}
		
			sql.append(V50bConfiguracionTextosBD.DPROPE).append(" = ? ");
				
			if(textoServicioInactivoeu==null || "".equals(textoServicioInactivoeu)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(textoServicioInactivoeu);
			}
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_SERVICIO_INACTIVO).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarEmailRemitente(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarEmailRemitente() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.VEINTIOCHO);
		final List arrParams = new ArrayList();
		
		String email = buzon.getTextoEmailRemitente();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ").append(V50bConfiguracionTextosBD.EMAIL).append(" = ? ");
		
		if(email==null || "".equals(email)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(email);
		}
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_EMAIL_REMITENTE).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarEmailTecnicos(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncActualizarEmailTecnicos() ");
		StringBuffer sql = new StringBuffer(V50bClsConstantes.VEINTIOCHO);
		final List arrParams = new ArrayList();
		
		String email = buzon.getEmailTecicoIvap();
		
		sql.append("UPDATE ");sql.append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" SET ").append(V50bConfiguracionTextosBD.EMAIL).append(" = ? ");
		
		if(email==null || "".equals(email)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(email);
		}
			
		sql.append("WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append(" = '");
		sql.append(V50bClsConstantes.CONSTANTE_TEXTO_EMAIL_TECNICOS).append("'");
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarBuzon(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncModificarBuzon() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTA);
		final List arrParams = new ArrayList();
		
		String coddes = buzon.getCoddes();
		String destinatario = buzon.getDestin();
		String email = buzon.getEmail();
		String estado = buzon.getEstado();
		
		List lista = this.fncMailsActivos(buzon);
		if (lista.size()>0){
			V50bConfiguracionBean buzonActivo = (V50bConfiguracionBean)lista.get(0);
			if (estado.equals(V50bClsConstantes.LITERAL_ACTIVO) && !buzonActivo.getCoddes().equals(coddes) ){
				return 2;
			}
		} 
		sql.append("UPDATE ");sql.append(V50bConfiguracionBD.TABLA_BUZON);
		sql.append(" SET ");
		sql.append(V50bConfiguracionBD.DESTIN).append(" = ?, ");
			
		if (destinatario==null || "".equals(destinatario)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(destinatario);
		}
			
		sql.append(V50bConfiguracionBD.EMAIL).append(" = ?, ");
			
		if(email==null || "".equals(email)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(email);
		}
			
		sql.append(V50bConfiguracionBD.ESTADO).append(" = ? ");
		
		if(estado.equals(V50bClsConstantes.LITERAL_ACTIVO)){
			arrParams.add(V50bClsConstantes.CONSTANTE_ACTIVO);
		}else if (estado.equals(V50bClsConstantes.LITERAL_INACTIVO)) {
			arrParams.add(V50bClsConstantes.CONSTANTE_INACTIVO);
		}
			
		int codigo = Integer.parseInt(coddes);
			
		sql.append("WHERE ").append(V50bConfiguracionBD.CODDES).append(" = ").append(codigo);
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirBuzon(V50bConfiguracionBean buzon) throws Exception {
		
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncAniadirBuzon() ");
		
		final StringBuffer sql = new StringBuffer();
		final List arrParams = new ArrayList();
		final StringBuffer sqlVal = new StringBuffer(V50bClsConstantes.VEINTICINCO);
		
		//sqlVal.append("SELECT MAX(");sqlVal.append(V50bConfiguracionBD.CODDES);
		//sqlVal.append(")+1 FROM ").append(V50bConfiguracionBD.TABLA_BUZON);
		
		sqlVal.append("SELECT ");
		sqlVal.append(V50bConfiguracionBD.SEQ_BUZON);
		sqlVal.append(".NEXTVAL FROM DUAL");
		
		String id = new V50bClsAccesoBD().fncConsultaEspecifica(sqlVal.toString());
		
	/*	if(id==null || id.equals("")){
			//la tabla esta vaca, no hay expedientes an
			id="1";
		}
	*/	
		if("1000".equals(id)){
			return V50bClsConstantes.TRES_NEGATIVO;
		}else{
			List lista = this.fncMailsActivos(buzon);
			if (lista.size()>0 && buzon.getEstado().equals(V50bClsConstantes.LITERAL_ACTIVO)){
				return 2;
			}
			else{
				buzon.setCoddes(id);
				int codigo = Integer.parseInt(buzon.getCoddes());
				
				sql.append("INSERT INTO ").append(V50bConfiguracionBD.TABLA_BUZON).append("(");
				sql.append(V50bConfiguracionBD.CODDES).append(", ");
				sql.append(V50bConfiguracionBD.DESTIN).append(", ");
				sql.append(V50bConfiguracionBD.EMAIL).append(", ");
				sql.append(V50bConfiguracionBD.ESTADO).append(") VALUES(");
				sql.append(codigo).append(",?,?,?) ");
				
				String destinatario = buzon.getDestin();
				String email = buzon.getEmail();
				String estado = buzon.getEstado();
				
				
				if(destinatario==null || "".equals(destinatario)){
					arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				}else{
					arrParams.add(destinatario);
				}
				
				if(email==null || "".equals(email)){
					arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				}else{
					arrParams.add(email);
				}
				
				if(estado.equals(V50bClsConstantes.LITERAL_ACTIVO)){
					arrParams.add(V50bClsConstantes.CONSTANTE_ACTIVO);
				}else if (estado.equals(V50bClsConstantes.LITERAL_INACTIVO)) {
					arrParams.add(V50bClsConstantes.CONSTANTE_INACTIVO);
				}
						
				return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
			}
		}
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncMailsActivos(V50bConfiguracionBean buzon) throws Exception {

		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncBuscarConfiguracion() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOTREINTA);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T13.").append(V50bConfiguracionBD.CODDES).append(" AS CODIGO, T13.");
		sql.append(V50bConfiguracionBD.DESTIN).append(" AS DESTINATARIO, T13.");
		sql.append(V50bConfiguracionBD.EMAIL).append(" AS EMAIL, DECODE(T13.");
		sql.append(V50bConfiguracionBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ACTIVO).append("', '");
		sql.append(V50bClsConstantes.LITERAL_ACTIVO).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_INACTIVO).append("', '"); 
		sql.append(V50bClsConstantes.LITERAL_INACTIVO).append("') AS ESTADO FROM ");
		sql.append(V50bConfiguracionBD.TABLA_BUZON).append(" T13");
		sql.append(" WHERE ").append(V50bConfiguracionBD.ESTADO).append(" = ?");
		arrParams.add(V50bClsConstantes.CONSTANTE_ACTIVO);
		sql.append(" ORDER BY 1");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bConfiguracionRowMapper());
		
		return lista;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTexto</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @param idioma Idioma de la sesin
	 * @return String El texto
	 * @throws Exception Cualquier excepcin
	 */
	public String fncObtenerTexto(String codigo, String idioma) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionDAOImpl.fncObtenerTexto() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTAYSEIS);
		final List arrParams = new ArrayList();
		String desc ="";
		
		if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			desc = V50bConfiguracionTextosBD.DPROPC;
		} else {
			desc = V50bConfiguracionTextosBD.DPROPE;
		}
		
		sql.append("SELECT T16.").append(desc).append(" AS TEXTO ");
		sql.append("FROM ").append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS).append(" T16 ");
		sql.append("WHERE T16.").append(V50bConfiguracionTextosBD.CPROPI).append(" = ? ");
		arrParams.add(Integer.valueOf(codigo));
		
		return new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(), arrParams);
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bConfiguracionRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bConfiguracionBean buzon = new V50bConfiguracionBean();
			
			buzon.setCoddes(rs.getString("CODIGO"));
			buzon.setDestin(rs.getString("DESTINATARIO"));
			buzon.setEmail(rs.getString("EMAIL"));
			buzon.setEstado(rs.getString("ESTADO"));

			return buzon;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bConfiguracionTextoRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bConfiguracionBean buzon = new V50bConfiguracionBean();
			
			buzon.setCpropi(rs.getString("CODIGO"));
			buzon.setEmail(rs.getString("EMAIL"));
			buzon.setTextoes(rs.getString("DESCRIPCIONCASTELLANO"));
			buzon.setTextoeu(rs.getString("DESCRIPCIONEUSKERA"));
			buzon.setEstadoTexto(rs.getString("ESTADO"));

			return buzon;
		}
	}
	
	
}
