package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bCalendarioBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bCalendarioFestivosBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bCalendarioPerInactivoBD;
import v50b.v50bModelo.v50bDao.V50bCalendarioDAO;



/**
 * 
 * @author iurkidi
 *
 */
public class V50bCalendarioDAOImpl implements V50bCalendarioDAO{


	/**
	 * @author iurkidi
	 * @param bean bean
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncObtenerPeriodoServInactivo(V50bCalendarioBean bean) throws Exception{
		V50bClsTrazas.depura("V50bCalendarioDAOImpl.fncObtenerPeriodoServInactivo() ");
		
		StringBuffer sbSQL=new StringBuffer(V50bClsConstantes.CINCUENTA);
		List arrCampos = new ArrayList();
		
		sbSQL.append("SELECT T15.").append(V50bCalendarioPerInactivoBD.ID_CALENDARIO).append(" AS IDCAL");
		sbSQL.append(", TO_CHAR(T15.").append(V50bCalendarioPerInactivoBD.FECHA_INICIO_INAC).append(",?) AS FECHAINICIO");
		sbSQL.append(", TO_CHAR(T15.").append(V50bCalendarioPerInactivoBD.FECHA_FIN_INAC).append(",?) AS FECHAFIN");
		sbSQL.append(" FROM ").append(V50bCalendarioPerInactivoBD.TABLA_CAL_PERIODO_IANCTIVO).append(" T15");
		sbSQL.append(" WHERE ").append(V50bCalendarioPerInactivoBD.ID_CALENDARIO).append(" > 0");
		
		arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(bean.getIdioma()));
		arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(bean.getIdioma()));
		
		return new V50bClsAccesoBD().fncLanzaBusqueda(sbSQL.toString(),arrCampos, new V50bServInactivoRowMapper());
	}
	
	/**
	 * @author iurkidi
	 * @param bean bean
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncObtenerFestivosCalendario(V50bCalendarioBean bean) throws Exception{
		V50bClsTrazas.depura("V50bCalendarioDAOImpl.fncObtenerFestivosCalendario() ");
		
		StringBuffer sbSQL=new StringBuffer(V50bClsConstantes.CINCUENTA);
		List arrCampos = new ArrayList();
		
		sbSQL.append("SELECT TO_CHAR(T24.").append(V50bCalendarioFestivosBD.FECHA_FESTIVO).append(",?) AS FECHAFESTIVO");
		sbSQL.append(" FROM ").append(V50bCalendarioFestivosBD.TABLA_CALENDARIO_FESTIVOS).append(" T24");
		sbSQL.append(" WHERE T24.").append(V50bCalendarioFestivosBD.ANYO_FESTIVO).append(">0");
		sbSQL.append(" AND T24.").append(V50bCalendarioFestivosBD.ANYO_FESTIVO).append(" =?");
		
		//arrCampos.add(V50bClsFunciones.fncMascaraToCharToDate(bean.getIdioma()));
		arrCampos.add(V50bClsConstantes.FORMATO_FECHA);
		arrCampos.add(new Integer(V50bClsFecha.fncObtenerAnyoSistema()));
		
		return new V50bClsAccesoBD().fncLanzaBusqueda(sbSQL.toString(),arrCampos, new V50bCalendarioFestivosRowMapper());
	}
	
	/**
	 * @author iurkidi
	 * @param bean bean con datos
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public Integer fncModificarPeriodoServInactivo(V50bCalendarioBean bean) throws Exception{
		V50bClsTrazas.depura("V50bCalendarioDAOImpl.fncModificarPeriodoServInactivo() ");
		
		StringBuffer sbSQL=new StringBuffer(V50bClsConstantes.CINCUENTA);
		List arrParams = new ArrayList();
		
		sbSQL.append("UPDATE ").append(V50bCalendarioPerInactivoBD.TABLA_CAL_PERIODO_IANCTIVO).append(" T15");
		sbSQL.append(" SET T15.").append(V50bCalendarioPerInactivoBD.FECHA_INICIO_INAC).append("=TO_DATE(?,?)");
		sbSQL.append(", T15.").append(V50bCalendarioPerInactivoBD.FECHA_FIN_INAC).append("=TO_DATE(?,?)");
		sbSQL.append(" WHERE ").append(V50bCalendarioPerInactivoBD.ID_CALENDARIO).append("=?");
		
		if(bean.getFechaDesdeInactivo()!=null && !"".equals(bean.getFechaDesdeInactivo())){
			arrParams.add(bean.getFechaDesdeInactivo());
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(V50bClsFunciones.fncMascaraToCharToDate(bean.getIdioma()));
		if(bean.getFechaHastaInactivo()!=null && !"".equals(bean.getFechaHastaInactivo())){
			arrParams.add(bean.getFechaHastaInactivo());
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(V50bClsFunciones.fncMascaraToCharToDate(bean.getIdioma()));
		arrParams.add(bean.getIdCalendario());
		
		return new Integer (new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrParams));
		
	}
	
	/**
	 * @author iurkidi
	 * @param bean bean con datos
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public Integer fncAnyadirPeriodoServInactivo(V50bCalendarioBean bean) throws Exception{
		V50bClsTrazas.depura("V50bCalendarioDAOImpl.fncAnyadirPeriodoServInactivo() ");
		
		StringBuffer sbSQL=new StringBuffer(V50bClsConstantes.CINCUENTA);
		List arrParams = new ArrayList();
		
		sbSQL.append("INSERT INTO ").append(V50bCalendarioPerInactivoBD.TABLA_CAL_PERIODO_IANCTIVO).append(" T15");
		sbSQL.append(" (T15.").append(V50bCalendarioPerInactivoBD.ID_CALENDARIO);
		sbSQL.append(", T15.").append(V50bCalendarioPerInactivoBD.FECHA_INICIO_INAC);
		sbSQL.append(", T15.").append(V50bCalendarioPerInactivoBD.FECHA_FIN_INAC);
		sbSQL.append(", T15.").append(V50bCalendarioPerInactivoBD.ESTADO);
		sbSQL.append(" ) VALUES (?,TO_DATE(?,?),TO_DATE(?,?),?) ");
		
		arrParams.add(new Integer("1"));
		arrParams.add(bean.getFechaDesdeInactivo());
		arrParams.add(V50bClsFunciones.fncMascaraToCharToDate(bean.getIdioma()));
		arrParams.add(bean.getFechaHastaInactivo());
		arrParams.add(V50bClsFunciones.fncMascaraToCharToDate(bean.getIdioma()));
		arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		
		return new Integer (new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrParams));
	}
	
	/**
	 * @author alata
	 * @param bean bean con datos
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public Integer fncAnyadirPeriodoServInactivoSinFecha(V50bCalendarioBean bean) throws Exception{
		V50bClsTrazas.depura("V50bCalendarioDAOImpl.fncAnyadirPeriodoServInactivo() ");
		
		StringBuffer sbSQL=new StringBuffer(V50bClsConstantes.CINCUENTA);
		List arrParams = new ArrayList();
		
		sbSQL.append("INSERT INTO ").append(V50bCalendarioPerInactivoBD.TABLA_CAL_PERIODO_IANCTIVO).append(" T15");
		sbSQL.append(" (T15.").append(V50bCalendarioPerInactivoBD.ID_CALENDARIO);
		sbSQL.append(", T15.").append(V50bCalendarioPerInactivoBD.ESTADO);
		sbSQL.append(" ) VALUES (?,?) ");
		
		arrParams.add(new Integer("1"));
		arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		
		return new Integer (new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrParams));
	}
	
	/**
	 * 
	 * <p>Ttulo: fncGuardarFestivo</p>
	 * <p>Descripcin: Guarda un festivo en la tabla de calendarios</p>
	 * <p>Copyright: Copyright (c) Feb 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param anyo Ao
	 * @param fecha Fecha del festivo
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncGuardarFestivo(String anyo, String fecha) throws Exception{
		V50bClsTrazas.depura("V50bCalendarioDAOImpl.fncAnyadirPeriodoServInactivo() ");
		
		StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		List arrParams = new ArrayList();
		
		sbSQL.append("INSERT INTO ").append(V50bCalendarioFestivosBD.TABLA_CALENDARIO_FESTIVOS).append(" T24 (");
		sbSQL.append("T24.").append(V50bCalendarioFestivosBD.ANYO_FESTIVO).append(", ");
		sbSQL.append("T24.").append(V50bCalendarioFestivosBD.FECHA_FESTIVO).append(", ");
		sbSQL.append("T24.").append(V50bCalendarioFestivosBD.ESTADO_FESTIVO).append(") VALUES (?,TO_DATE(?,?),?)");
		arrParams.add(anyo);
		arrParams.add(fecha);
		arrParams.add(V50bClsConstantes.FORMATO_FECHA);
		arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		
		return new Integer (new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrParams));
	}
	
	/**
	 * 
	 * <p>Ttulo: fncEliminarFestivo</p>
	 * <p>Descripcin: Elimina un festivo en la tabla de calendarios</p>
	 * <p>Copyright: Copyright (c) Feb 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param anyo Ao
	 * @param fecha Fecha del festivo
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncEliminarFestivo(String anyo, String fecha) throws Exception{
		V50bClsTrazas.depura("V50bCalendarioDAOImpl.fncEliminarFestivo() ");
		
		StringBuffer sbSQL = new StringBuffer(V50bClsConstantes.CINCUENTA);
		List arrParams = new ArrayList();
		
		sbSQL.append("DELETE FROM ").append(V50bCalendarioFestivosBD.TABLA_CALENDARIO_FESTIVOS).append(" T24 ");
		sbSQL.append("WHERE T24.").append(V50bCalendarioFestivosBD.ANYO_FESTIVO).append("= ? ");
		arrParams.add(anyo);
		
		sbSQL.append("AND T24.").append(V50bCalendarioFestivosBD.FECHA_FESTIVO).append("= TO_DATE(?,?)");
		arrParams.add(fecha);
		arrParams.add(V50bClsConstantes.FORMATO_FECHA);
		
		return new Integer (new V50bClsAccesoBD().fncLanzaMovimiento(sbSQL.toString(), arrParams));
	}
	
	/**
	 * 
	 * @author iurkidi
	 *
	 */
	class V50bServInactivoRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bCalendarioBean festBean = new V50bCalendarioBean();
			
			festBean.setIdCalendario(rs.getString("IDCAL"));
			festBean.setFechaDesdeInactivo(rs.getString("FECHAINICIO"));
			festBean.setFechaHastaInactivo(rs.getString("FECHAFIN"));

			return festBean;
		}
	}
	
	/**
	 * 
	 * @author iurkidi
	 *
	 */
	class V50bCalendarioFestivosRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bCalendarioBean festBean = new V50bCalendarioBean();
			
			festBean.setFecha(rs.getString("FECHAFESTIVO"));

			return festBean;
		}
	}
	
	
}
