package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bAmbitoBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitoBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitos_ResolutorBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConsultasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bDificultadBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bResolutoresBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bSubcategoriasBD;
import v50b.v50bModelo.v50bDao.V50bAmbitosDAO;

/**
 * 
 * @author alata
 *
 */
public class V50bAmbitosDAOImpl implements V50bAmbitosDAO {
	
	/**
	 * @param ambito :ambito con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitos(V50bAmbitoBean ambito) throws Exception {
		
		V50bClsTrazas.depura("V50bAmbitosDAOImpl.fncBuscarAmbitos() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSSEIS);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T07.").append(V50bAmbitoBD.CAMBIT).append(" AS CODIGO, ");
		sql.append("LPAD(T07.").append(V50bAmbitoBD.CAMBIT).append(",?,'0') AS CODIGOORDEN, T07.");
		arrParams.add(new Integer(V50bClsConstantes.UNO));
		sql.append(V50bAmbitoBD.DESAMC).append(" AS DESCRIPCIONCASTELLANO, T07.");
		sql.append(V50bAmbitoBD.DESAME).append(" AS DESCRIPCIONEUSKERA, DECODE(T07.");
		sql.append(V50bAmbitoBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ALTA).append("', '");
		sql.append(V50bClsConstantes.LITERAL_DESC_ALTA).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_BAJA).append("', '"); 
		sql.append(V50bClsConstantes.LITERAL_DESC_BAJA).append("') AS ESTADO FROM ");
		sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07 ");
		sql.append("WHERE T07.");
		sql.append(V50bAmbitoBD.CAMBIT).append(" > 0");
		
		String cambit = ambito.getCambit();
		String desamc = ambito.getDesamc();
		String desame = ambito.getDesame();
		String estado = ambito.getEstado();
		
		if(cambit!=null && !"".equals(cambit)){
			int codigo = Integer.parseInt(cambit);
			sql.append(" AND T07.").append(V50bAmbitoBD.CAMBIT);
			sql.append(" = ").append(codigo);
		}
		
		if(desamc!=null && !"".equals(desamc)){
			sql.append(" AND UPPER(T07.").append(V50bAmbitoBD.DESAMC);
			sql.append(") LIKE ?");
			arrParams.add("%"+desamc.toUpperCase()+"%");
		}
		
		if(desame!=null && !"".equals(desame)){
			sql.append(" AND UPPER(T07.").append(V50bAmbitoBD.DESAME);
			sql.append(") LIKE ?");
			arrParams.add("%"+desame.toUpperCase()+"%");
		}
		if (estado!=null){
			sql.append(" AND T07.").append(V50bAmbitoBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("'");
		}else{
			sql.append(" AND T07.").append(V50bAmbitoBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append("'");
		}
		sql.append(" ORDER BY 1");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosRowMapper());
		
		return lista;
	}
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarAmbito(V50bAmbitoBean ambito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosDAOImpl.fncModificarAmbito() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CINCUENTAYNUEVE);
		final List arrParams = new ArrayList();
		boolean hayAsociados = true;
		String cambit = ambito.getCambit();
		
		if (ambito.getEstado()!=null && ambito.getEstado().equals(V50bClsConstantes.LITERAL_DESC_BAJA)){
			hayAsociados = this.fncComprobarConsultasAsociadas(cambit);
			if (!hayAsociados){
				return 2;
			}
			hayAsociados = this.fncComprobarResolutoresAsociados(cambit);
			if (!hayAsociados){
				return V50bClsConstantes.TRES;
			}
			hayAsociados = this.fncComprobarTieneSubcategorias(cambit);
			if (!hayAsociados){
				return V50bClsConstantes.CUATRO;
			}
			hayAsociados = this.fncComprobarDificultadesAsociadas(cambit);
			if (!hayAsociados){
				return V50bClsConstantes.CINCO;
			}
		}
		
		String desamc = ambito.getDesamc();
		String desame = ambito.getDesame();
		String estado = ambito.getEstado();
		
		sql.append("UPDATE ");sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07");
		sql.append(" SET T07.");
		sql.append(V50bAmbitoBD.DESAMC);sql.append(" = ?, T07.");	
		
		if(desamc==null || "".equals(desamc)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(desamc);
		}
		
		sql.append(V50bAmbitoBD.DESAME);sql.append(" = ?, T07.");
		
		if(desame==null || "".equals(desame)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(desame);
		}
		
		sql.append(V50bAmbitoBD.ESTADO);sql.append(" = ? ");
		
		if(estado==null || "".equals(estado)){
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}
		int codigo = Integer.parseInt(ambito.getCambit());
			
		sql.append("WHERE T07.").append(V50bAmbitoBD.CAMBIT).append(" = ").append(codigo);

		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	* @param codAmbito : codigo de ambito 
	* @return boolean: true si no hay asociados
	* @throws Exception Se eleva la excepcin.
	*/
	public boolean fncComprobarConsultasAsociadas(String codAmbito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosDAOImpl.fncComprobarConsultasAsociadas() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		int codigo = Integer.parseInt(codAmbito);
		
		sql.append("SELECT ").append(V50bConsultasBD.CAMBIT).append(" AS CODIGO FROM ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS);
		sql.append(" WHERE ").append(V50bConsultasBD.CAMBIT).append(" = ").append(codigo);
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ").append(V50bClsConstantes.SEIS);
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ").append(V50bClsConstantes.OCHO);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitoCodigoRowMapper());
		
		return lista.isEmpty();
	}
	
	/**
	* @param codAmbito : codigo de ambito 
	* @return boolean: true si no hay asociados
	* @throws Exception Se eleva la excepcin.
	*/
	public boolean fncComprobarResolutoresAsociados(String codAmbito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosDAOImpl.fncComprobarResolutoresAsociados() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		int codigo = Integer.parseInt(codAmbito);
		
		sql.append("SELECT ").append(V50bAmbitos_ResolutorBD.CRESOL).append(" AS CODIGO FROM ");
		sql.append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR);
		sql.append(" WHERE ").append(V50bAmbitos_ResolutorBD.CAMBIT).append(" = ").append(codigo);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bResolutorCodigoRowMapper());
		boolean noResol = false;
		if (lista.size()==0) {
			noResol = true;
		}
		for (int i=0;i<lista.size();i++) {
			
			V50bResolutoresBean resolutor = (V50bResolutoresBean)lista.get(i);
			
			int codigoResol = Integer.parseInt(resolutor.getCodResol());
			List listaReol = this.fncResolutoresAlta(codigoResol);
			if (listaReol.isEmpty()) {
				noResol = true;
				break;
			}
		}
		return noResol;
	}
	
	/**
	* @param codigo : codigo de los resolutores 
	* @return boolean: true si no tiene subcategorias
	* @throws Exception Se eleva la excepcin.
	*/
	public List fncResolutoresAlta(int codigo) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosDAOImpl.fncResolutoresAlta() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
			
		sql.append("SELECT ").append(V50bResolutoresBD.COD_RESOL).append(" AS CODIGO FROM ");
		sql.append(V50bResolutoresBD.TABLA_RESOLUTORES);
		sql.append(" WHERE ").append(V50bResolutoresBD.COD_RESOL).append(" = ").append(codigo);
		sql.append(" AND ").append(V50bResolutoresBD.ESTADO_RESOL).append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append("'");
			
		return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bResolutorCodigoRowMapper());
	}
	
	/**
	* @param codAmbito : codigo de ambito 
	* @return boolean: true si no tiene subcategorias
	* @throws Exception Se eleva la excepcin.
	*/
	public boolean fncComprobarTieneSubcategorias(String codAmbito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosDAOImpl.fncComprobarTieneSubcategorias() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		int codigo = Integer.parseInt(codAmbito);
		
		sql.append("SELECT ").append(V50bSubcategoriasBD.CODAMBITO).append(" AS CODIGO FROM ");
		sql.append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS);
		sql.append(" WHERE ").append(V50bSubcategoriasBD.CODAMBITO).append(" = ").append(codigo);
		sql.append(" AND ").append(V50bSubcategoriasBD.ESTADO).append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append("'");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitoCodigoRowMapper());
		
		return lista.isEmpty();
	}
	
	/**
	* @param codAmbito : codigo de ambito 
	* @return boolean: true si no hay asociados
	* @throws Exception Se eleva la excepcin.
	*/
	public boolean fncComprobarDificultadesAsociadas(String codAmbito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosDAOImpl.fncComprobarDificultadesAsociadas() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		int codigo = Integer.parseInt(codAmbito);
		
		sql.append("SELECT ").append(V50bDificultadBD.CAMBIT).append(" AS CODIGO FROM ");
		sql.append(V50bDificultadBD.TABLA_DIFICULTAD);
		sql.append(" WHERE ").append(V50bDificultadBD.CAMBIT).append(" = ").append(codigo);
		sql.append(" AND ").append(V50bDificultadBD.ESTADO).append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append("'");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitoCodigoRowMapper());
		
		return lista.isEmpty();
	}
		
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirAmbito(V50bAmbitoBean ambito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosDAOImpl.fncAniadirAmbito() ");
		
		final StringBuffer sql = new StringBuffer();
		final List arrParams = new ArrayList();
		final StringBuffer sqlVal = new StringBuffer(V50bClsConstantes.VEINTE);	
		
		sqlVal.append("SELECT MAX(");sqlVal.append(V50bAmbitoBD.CAMBIT);
		sqlVal.append(")+1 FROM ").append(V50bAmbitoBD.TABLA_AMBITO);
		
		String id = new V50bClsAccesoBD().fncConsultaEspecifica(sqlVal.toString());
		
		if(id==null || id.equals("")){
			//la tabla esta vaca, no hay expedientes an
			id="1";
		}
		
		if("10".equals(id)){
			return V50bClsConstantes.TRES_NEGATIVO;
		}else{
			ambito.setCambit(id);
			int codigo = Integer.parseInt(ambito.getCambit());
			
			sql.append("INSERT INTO ").append(V50bAmbitoBD.TABLA_AMBITO).append("(");
			sql.append(V50bAmbitoBD.CAMBIT).append(", ");
			sql.append(V50bAmbitoBD.DESAMC).append(", ");
			sql.append(V50bAmbitoBD.DESAME).append(", ");
			sql.append(V50bAmbitoBD.ESTADO).append(") VALUES(");
			sql.append(codigo).append(",?,?,?) ");
			
			if(ambito.getDesamc()==null || "".equals(ambito.getDesamc())){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(ambito.getDesamc());
			}
			
			if(ambito.getDesame()==null || "".equals(ambito.getDesame())){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(ambito.getDesame());
			}
			
			if(ambito.getEstado()==null || "".equals(ambito.getEstado())){
				arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
			}else{
				arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
			}
			
			return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		}
	}

	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bAmbitosRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bAmbitoBean ambito = new V50bAmbitoBean();
			
			ambito.setCambit(rs.getString("CODIGO"));
			ambito.setCambitOrden(rs.getString("CODIGOORDEN"));
			ambito.setDesamc(rs.getString("DESCRIPCIONCASTELLANO"));
			ambito.setDesame(rs.getString("DESCRIPCIONEUSKERA"));
			ambito.setEstado(rs.getString("ESTADO"));

			return ambito;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bAmbitoCodigoRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bAmbitoBean ambito = new V50bAmbitoBean();
			
			ambito.setCambit(rs.getString("CODIGO"));

			return ambito;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bResolutorCodigoRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bResolutoresBean resolutor = new V50bResolutoresBean();
			
			resolutor.setCodResol(rs.getString("CODIGO"));

			return resolutor;
		}
	}

}
