package v50b.v50bModelo.v50bDao;

import java.util.List;

import v50b.v50bBeans.V50bSuscriptorBean;



/**
 * 
 * @author iurkidi
 *
 */
public interface V50bUsuariosRegistradosDAO {

	/**
	 * 
	 * <p>Ttulo: fncBuscarUsuariosRegistrados</p>
	 * <p>Descripcin: Busca usuarios registrados en base a un filtro</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Filtro de la bsqueda
	 * @return Lista resultados
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarUsuariosRegistrados(V50bSuscriptorBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleUsuarioRegistrado</p>
	 * <p>Descripcin: Busca los datos de un usuario</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form formulario con el cdigo del usuario
	 * @return Objeto con los datos del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bSuscriptorBean fncDetalleUsuarioRegistrado(V50bSuscriptorBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncNuevoUsuarioRegistrado</p>
	 * <p>Descripcin: Inserta en BDD un nuevo suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Detalle del usuario
	 * @return Lista con el resultado de la operacin y el cdigo del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public List fncNuevoUsuarioRegistrado(V50bSuscriptorBean form) throws Exception;
		
	/**
	 * 
	 * <p>Ttulo: fncModificarUsuarioRegistrado</p>
	 * <p>Descripcin: Modifica un suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncModificarUsuarioRegistrado(V50bSuscriptorBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsultas</p>
	 * <p>Descripcin: Modifica las consultas de un usuario</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codUsuario String con el codigo de usuario
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncModificarConsultas(String codUsuario) throws Exception;
	
	/**
	 * <p>Ttulo: fncEliminarUsuarioRegistrado</p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) 04/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param usuario v50aUsuario
	 * @return int
	 * @throws Exception Cualquier excepcion
	 */
	public int fncEliminarUsuarioRegistrado(V50bSuscriptorBean usuario) throws Exception;
	
	/**
	 * <p>Ttulo: fncExisteSuscriptor</p>
	 * <p>Descripcin: Funcion q comprueba si existe un suscriptor en la base de datos. Si existe envia un true</p>
	 * <p>Copyright: Copyright (c) 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param dni DNI
	 * @param codSus El cdigo del suscriptor
	 * @return boolean
	 * @throws Exception Cualquier excepcion
	 */
	public boolean fncExisteSuscriptor(String dni, String codSus) throws Exception;
	
	/**
	 * <p>Ttulo: fncExisteUsuario</p>
	 * <p>Descripcin: Funcion q comprueba si existe un suscriptor en la base de datos. Si existe envia un true</p>
	 * <p>Copyright: Copyright (c) 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param usuario usuario
	 * @param dni DNI del suscriptor
	 * @return boolean
	 * @throws Exception Cualquier excepcion
	 */
	public boolean fncExisteUsuario(String usuario,String dni) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncCargaEmailRemitente</p>
	 * <p>Descripcin: Obtiene el email del remitente</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @return String email del remitente
	 * @throws Exception Cualquier excepcin
	 */
	public String fncCargaEmailRemitente() throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncComunicacionSuscriptor</p>
	 * <p>Descripcin: Obtiene los datos para comunicacin al suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codSuscr cdigo del suscriptor
	 * @return V50bSuscriptorBean Los datos de comunicacin del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bSuscriptorBean fncComunicacionSuscriptor(String codSuscr) throws Exception;
}
