package v50b.v50bModelo.v50bDao;

import java.util.List;

import v50b.v50bBeans.V50bSubcategoriasBean;

/**
 * 
 * @author acompes
 *
 */
public interface V50bSubcategoriasDAO {

	/**
	 * 
	 * @param subcategorias : Subcategorias con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception;
	
	/**
	 * @param subcategorias :Subcategorias con los datos de busqueda
	 * @return List
	 * @throws Exception Se lanza la excepcin.
	 */
	public List fncBuscarSubcategConsultas(V50bSubcategoriasBean subcategorias) throws Exception;
	
	/**
	* @param subcategorias : Subcategorias con los datos de modificacin 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception;
	
	/**
	* @param subcategorias : subcategorias con los datos a agregar
	* @return int: el resultado del agregado
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception;
	
	/**
	 * @param subcategoria : subcategoria con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosSubcategoria(v50b.v50bBeans.V50bSubcategoriasBean subcategoria) throws Exception;
	
	/**
	 * @param codigo : codigo de subcategoria 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncAmbitosAlmacenados(String codigo) throws Exception;
	
	/**
	 * @param listaAmbitos
	 *            :lista con los ambitos de subcategoria
	 * @return boolean
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public boolean fncBuscarSubcategBaja(List listaAmbitos) throws Exception;
	
}
