package v50b.v50bModelo.v50bDao;

import java.util.List;

import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bResolutoresBean;


/**
 * 
 * @author acompes
 *
 */
public interface V50bResolutoresDAO {

	/**
	 * Ttulo: fncObtenerPerfilUsuario
	 * Empresa: Eurohelp
	 * @author iurkidi
	 * @version 1.0
	 * @param usuarioBean usuario logueado
	 * @return List
	 * @throws Exception SQLException
	 */
	public List fncObtenerPerfilUsuario(V50bUsuarioBean usuarioBean) throws Exception;
		
	/**
	 * 
	 * @param resolutores : Resolutores con los datos de busqueda
	 * @return List
	 * @throws Exception Se lanza la excepcin.
	 */
	public List fncBuscarResolutores(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	* @param resolutores : Resolutores con los datos de modificacin 
	* @return int: el resultado de la update
	* @throws Exception Se lanza la excepcin.
	*/
	public int fncModificarResolutores(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	* @param resolutores : Resolutores con los datos a agregar
	* @return int: el resultado del agregado
	* @throws Exception Se lanza la excepcin.
	*/
	public int fncAniadirResolutores(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	 * @param resolutores : resolutor con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosResolutor(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSituacionResolutoresArea</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 4, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con el mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSituacionResolutoresArea(V50bConsultaBean form) throws Exception;
	
	/**
	 * @param resolutores : resolutor con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarResolutoresAmbito(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSitResolutores</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 10, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito String con el codigo de mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSitResolutores(String codAmbito) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncComunicacionResolutor</p>
	 * <p>Descripcin: Obtiene los datos para comunicacin al resolutor o tcnico</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codResol cdigo del resolutor
	 * @return V50bResolutoresBean Los datos de comunicacin del resolutor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bResolutoresBean fncComunicacionResolutor(String codResol) throws Exception;
	
	/**
	 * alata
	 * 
	 * @param listaAmbitos
	 *            :lista con los ambitos de subcategoria
	 * @return boolean
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public boolean fncBuscarResolBaja(List listaAmbitos) throws Exception;
}
