package v50b.v50bModelo.v50bDao;

import java.util.List;

import v50b.v50bBeans.V50bEncuestaBean;

/**
 * 
 * @author brey
 *
 */
public interface V50bEncuestasDAO {

	/**
	 * fncBusqEncuestas
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public List fncBusqEncuestas(V50bEncuestaBean encuestaBean)throws Exception;
	
	/**
	 * fncAgregarNuevaEncuesta
	 * 
	 * @author brey
	 * @param nuevoNumEncuesta
	 *            String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public long fncAgregarNuevaEncuesta(String nuevoNumEncuesta, V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncModificarEncuesta
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public long fncModificarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncEliminarEncuesta
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncEliminarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncGenerarNumeroEncuesta
	 * 
	 * @author brey
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public String fncGenerarNumeroEncuesta() throws Exception;
	
	/**
	 * fncComprobarActivaBD
	 * 
	 * @author brey
	 * @return String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             Excepcion
	 */
	public String fncComprobarActivaBD(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncCopiarCamposEncuesta
	 * 
	 * @author brey
	 * @param nuevoNumEncuesta
	 *            String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncCopiarCamposEncuesta(String nuevoNumEncuesta, V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncCopiarCamposPregunta
	 * 
	 * @author brey
	 * @param nuevoNumEncuesta
	 *            String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncCopiarCamposPregunta(String nuevoNumEncuesta, V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncCopiarCamposRespuesta
	 * 
	 * @author brey
	 * @param nuevoNumEncuesta
	 *            String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncCopiarCamposRespuesta(String nuevoNumEncuesta, V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncCopiarCamposRespuestaSeleccionadas
	 * 
	 * @author brey
	 * @param numEncuestaCopia
	 *            String
	 * @param encuestaBean
	 *            U94bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             Excepcion
	 */
	public  int fncCopiarCamposRespuestaSeleccionadas(String numEncuestaCopia, V50bEncuestaBean encuestaBean)throws Exception ;
			
	/**
	 * fncBusqPreguntas
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public List fncBusqPreguntas(V50bEncuestaBean encuestaBean)throws Exception;
	
	/**
	 * fncAgregarNuevaPregunta
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncAgregarNuevaPregunta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncModificarPregunta
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncModificarPregunta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncEliminarPregunta
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncEliminarPregunta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncEliminarTodasPregunta
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncEliminarTodasPregunta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncBusqRespuestas
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public List fncBusqRespuestas(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * Ttulo: fncContarRespuestas
	 * Descripcin: Cuenta el nmero de respuestas de una pregunta
	 * Copyright: Copyright (c) 2008
	 * Empresa: Eurohelp Consulting
	 * @author brey
	 * @version 1.0
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return int numero de respuestas
	 * @throws Exception
	 *             SQLException
	 */
	public int fncContarRespuestas(V50bEncuestaBean encuestaBean)throws Exception ;
	
	/**
	 * fncGenerarNumeroRespuesta
	 * 
	 * @author brey
	 * @param numeroEncuesta
	 *            String
	 * @param numeroPregunta
	 *            String
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public String fncGenerarNumeroRespuesta (String numeroEncuesta, String numeroPregunta) throws Exception;
	
	/**
	 * fncAgregarNuevaRespuesta
	 * 
	 * @author brey
	 * @param numeroRespuesta
	 *            String
	 * @param encuestaBean
	 *            U94bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncAgregarNuevaRespuesta(String numeroRespuesta, V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncAgregarNuevaRespuestaCorrelativo
	 * 
	 * @author Virginia Caldern
	 * @param numeroRespuesta
	 *            String
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncAgregarNuevaRespuestaCorrelativo(String numeroRespuesta, V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncModificarRespuesta
	 * 
	 * @author Virginia Caldern
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncModificarRespuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p> Ttulo: fncEliminarTodasRespuestas </p>
	 * <p> Descripcin:agrega una nueva pregunta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p>  Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarTodasRespuestas(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p> Ttulo: fncEliminarRespuestasPregunta </p>
	 * <p> Descripcin:agrega una nueva pregunta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p>  Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarRespuestasPregunta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncEliminarRespuesta
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncEliminarRespuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncEliminarRespuestaTexto
	 * 
	 * @author alata
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncEliminarRespuestaTexto(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p> Ttulo: fncEliminarTodasRespuestasCorrelativo </p>
	 * <p> Descripcin:agrega una nueva pregunta </p>
	 * <p> Copyright: Copyright (c) 2008 </p>
	 * <p>  Empresa: Eurohelp Consulting </p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @return int
	 * @throws Exception
	 *             SQLException
	 */
	public int fncEliminarTodasRespuestasCorrelativo(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncCargarEncuesta
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public List fncCargarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncInsertRespFijas
	 * 
	 * @author brey
	 * @param valores
	 *            ArrayList
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncInsertRespFijas(List valores) throws Exception;
	
	/**
	 * fncInsertRespLibre
	 * 
	 * @author brey
	 * @param valores
	 *            ArrayList
	 * @param correlativo
	 *            String
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncInsertRespLibre(List valores, String correlativo) throws Exception;
	
	/**
	 * fncInsertRespVacia
	 * 
	 * @author brey
	 * @param valores
	 *            ArrayList
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public int fncInsertRespVacia(List valores) throws Exception;
	
	/**
	 * fncSelectRespLibre
	 * 
	 * @author brey
	 * @param valores
	 *            ArrayList
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public String fncSelectRespLibre(List valores) throws Exception;
	
	/**
	 * fncExisteRespuesta
	 * 
	 * @author brey
	 * @param valores
	 *            ArrayList
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public boolean fncExisteRespuesta(List valores) throws Exception;
	
	/**
	 * fncExcelPestania1
	 * 
	 * @author Virginia Caldern
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public List fncExcelPestania1(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncExcelPestania2
	 * 
	 * @author brey
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public List fncExcelPestania2(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * fncObtenerActivaBD
	 * 
	 * @author brey
	 * @param bean
	 *            U94bEncuestaBean
	 * @return List
	 * @throws Exception
	 *             Excepcion
	 */
	public String fncObtenerActivaBD(V50bEncuestaBean bean) throws Exception;
	
}
