package v50b.v50bModelo.v50bDao;

import java.util.List;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bCriteriosConsultaBean;
import v50b.v50bBeans.V50bNotificacionBean;
import v50b.v50bClasesComunes.V50bClsFichero;



/**
 * 
 * @author iurkidi
 *
 */
public interface V50bConsultasDAO {
	
	/**
	 * <p>Ttulo: fncGenericoNextVal</p>
	 * <p>Descripcin: Mtodo Genrico para la obtencin de valores autonumricos</p>
	 * <p>Copyright: Copyright (c) 2007</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0 Parametros de entrada: String tabla. La tabla donde se
	 *          actualiza la secuencia. Parametros de salida: Integer. El
	 *          resultado devuelto por la secuencia.
	 * @param tabla a
	 * @return Integer
	 * @throws Exception e
	 */
	public Integer fncGenericoNextVal(String tabla) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarConsultasBandejaEntrada</p>
	 * <p>Descripcin: Busca consultas filtrando con el formulario de Bandeja de Entrada</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return lista de consultas que pasan el filtro
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarConsultasBandejaEntrada(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncVerFicheroConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroConsulta(String v50bCodigoConsulta) throws Exception;
	
	/**
	 * <p>Ttulo: fncVerFicheroRespuesta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 21/09/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Excepcin
	 */
	public V50bClsFichero fncVerFicheroRespuesta(String v50bCodigoConsulta) throws Exception;
	
	/**
	 * <p>Ttulo: fncVerFicheroResolutor</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 21/09/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Excepcin
	 */
	public V50bClsFichero fncVerFicheroResolutor(String v50bCodigoConsulta) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncNuevaConsulta</p>
	 * <p>Descripcin: Introduce una nueva consulta en la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a insertar
	 * @return Lista con el Entero con el resultado de la operacin y String con el cdigo de la consulta
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncNuevaConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsulta</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncModificarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncCatalogarConsulta</p>
	 * <p>Descripcin: Catalogar una consulta</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a cataloogar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncCatalogarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasEstadoConsultas(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultadesAmbito(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @author brey
	 * @version 1.0
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasCatalogoConsultas(V50bConsultaBean consulta) throws Exception;

	/**
	 * 
	 * <p>Ttulo: fncDetalleConsulta</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return V50bConsultaBean Consulta detallada
	 * @throws Exception Cualquier excepcin
	 */
	public V50bConsultaBean fncDetalleConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * @author acompes
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategoriasAmbito(V50bConsultaBean consulta) throws Exception;
	/**
	 * @author alata
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasHistoricoConsultas(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncAsignarResolutor</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncAsignarResolutor(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncNuevaNotificacion</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a insertar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncNuevaNotificacion(V50bNotificacionBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncResponderConsulta</p>
	 * <p>Descripcin: Responde a una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la respuesta
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncResponderConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncCambiaEstadoConsulta</p>
	 * <p>Descripcin: Cambia el estado de una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codConsulta Cdigo de la consulta
	 * @param codEstado Cdigo del estado
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncCambiaEstadoConsulta(String codConsulta, String codEstado) throws Exception;
	
	/**
	 * @author alata
	 * @param consulta : consulta de la busqueda
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncPonerVisibleInternet(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @author alata
	 * @param consulta : consulta de la busqueda
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncQuitarVisibleInternet(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @author alata
	 * @param consulta : consulta de la busqueda
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarRespuesta(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @author alata
	 * @param consulta : consulta de la busqueda
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarRespuestaCatalogo(V50bConsultaBean consulta) throws Exception;

/**
 * 
 * <p>Ttulo: </p>
 * <p>Descripcin: </p>
 * <p>Copyright: Copyright (c) Dec 11, 2008</p>
 * <p>Empresa: Eurohelp</p>
 * 
 * @author mmonge
 * @version 1.0
 * @param criteriosBean parametro de entrada
 * @return List parametro de salida 
 * @throws Exception excepcion
 */
	public List fncObtenerDatosGraficos(V50bCriteriosConsultaBean criteriosBean) throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscarNotificaciones</p>
	 * <p>Descripcin: Busca las notificaciones de una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param consulta La consulta
	 * @return List Lista con las notificaciones
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarNotificaciones(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * <p>Ttulo: fncRespondeNotificacion</p>
	 * <p>Descripcin: Responde una notificacin</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param respuesta La respuesta
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncRespondeNotificacion(V50bNotificacionBean respuesta) throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscar24Horas</p>
	 * <p>Descripcin: Busca consultas 24 Horas</p>
	 * <p>Copyright: Copyright (c) Dec 22, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscar24Horas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma) throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscarPendientes</p>
	 * <p>Descripcin: Busca consultas Pendientes</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarPendientes(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscarRetrasadas</p>
	 * <p>Descripcin: Busca consultas Retrasadas</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarRetrasadas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws Exception;

	/**
	 * <p>Ttulo: fncVerFicheroNotif</p>
	 * <p>Descripcin: Obtiene el lob de la notificacin</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoNotif Cdigo de la notificacin
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroNotif(String v50bCodigoNotif) throws Exception;

}
