package v50b.v50bModelo.v50bDao;

import java.util.List;

import v50b.v50bBeans.V50bConfiguracionBean;



/**
 * 
 * @author iurkidi
 *
 */
public interface V50bConfiguracionDAO {

	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfiguracion(V50bConfiguracionBean buzon) throws Exception;
	

	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfigTextos(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarConfiguracion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarContactoIvap(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarOlvidoContrasenia(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarAltaSuscripcion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarRecibirNotificacion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarProteccionDatos(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarComunicacionClaves(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarServicioInactivo(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarEmailRemitente(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncActualizarEmailTecnicos(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarBuzon(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirBuzon(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTexto</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @param idioma Idioma de la sesin
	 * @return String El texto
	 * @throws Exception Cualquier excepcin
	 */
	public String fncObtenerTexto(String codigo, String idioma) throws Exception;
}
