package v50b.v50bModelo.v50bDao;

import java.util.List;

import v50b.v50bBeans.V50bCalendarioBean;



/**
 * 
 * @author iurkidi
 *
 */
public interface V50bCalendarioDAO {

	/**
	 * @author iurkidi
	 * @param bean bean
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncObtenerPeriodoServInactivo(V50bCalendarioBean bean) throws Exception;
	
	/**
	 * @author iurkidi
	 * @param bean bean
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncObtenerFestivosCalendario(V50bCalendarioBean bean) throws Exception;
	
	/**
	 * @author iurkidi
	 * @param bean bean con datos
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public Integer fncModificarPeriodoServInactivo(V50bCalendarioBean bean) throws Exception;
	
	/**
	 * @author iurkidi
	 * @param bean bean con datos
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public Integer fncAnyadirPeriodoServInactivo(V50bCalendarioBean bean) throws Exception;
	
	/**
	 * @author alata
	 * @param bean bean con datos
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public Integer fncAnyadirPeriodoServInactivoSinFecha(V50bCalendarioBean bean) throws Exception;
	/**
	 * 
	 * <p>Ttulo: fncGuardarFestivo</p>
	 * <p>Descripcin: Guarda un festivo en la tabla de calendarios</p>
	 * <p>Copyright: Copyright (c) Feb 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param anyo Ao
	 * @param fecha Fecha del festivo
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncGuardarFestivo(String anyo, String fecha) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncEliminarFestivo</p>
	 * <p>Descripcin: Elimina un festivo en la tabla de calendarios</p>
	 * <p>Copyright: Copyright (c) Feb 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param anyo Ao
	 * @param fecha Fecha del festivo
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncEliminarFestivo(String anyo, String fecha) throws Exception;
}
