package v50b.v50bModelo;

import java.util.HashMap;
import java.util.Map;

import v50b.v50bModelo.v50bDao.V50bCalendarioDAO;
import v50b.v50bModelo.v50bDao.V50bAmbitosDAO;
import v50b.v50bModelo.v50bDao.V50bConfiguracionDAO;
import v50b.v50bModelo.v50bDao.V50bConsultasDAO;
import v50b.v50bModelo.v50bDao.V50bDificultadDAO;
import v50b.v50bModelo.v50bDao.V50bEncuestasDAO;
import v50b.v50bModelo.v50bDao.V50bGraficosDAO;
import v50b.v50bModelo.v50bDao.V50bMotivosDAO;
import v50b.v50bModelo.v50bDao.V50bProfesionesDAO;
import v50b.v50bModelo.v50bDao.V50bResolutoresDAO;
import v50b.v50bModelo.v50bDao.V50bSubcategoriasDAO;
import v50b.v50bModelo.v50bDao.V50bTipoTrabajoDAO;
import v50b.v50bModelo.v50bDao.V50bUsuariosRegistradosDAO;

/**
 * Factora para la creacin de Objetos de rellenado.
 * 
 * @author Iaki Cantalapiedra Bernal
 */
public class V50bDAOFactory {

	/**
	 * Instantiates a new v50b dao factory.
	 */
	private V50bDAOFactory() {
	}

	/**
	 * Pool de objetos: Objetos
	 */
	private static Map objectPool = new HashMap();

	/**
	 * Crea una llamada al objeto de rellenado del Array.
	 * 
	 * @param name
	 *            the name
	 * 
	 * @return Object
	 * 
	 * @throws Exception
	 *             Se eleva la Excepcion.
	 */
	private static Object get(String name) throws Exception {

		Object rll = V50bDAOFactory.objectPool.get(name);
		if (rll == null) {
			rll = V50bDAOFactory.getClassForName(name);
			V50bDAOFactory.objectPool.put(name, rll);
		}

		return rll;
	}

	/**
	 * Crea un objeto a partir del nombre de la clase.
	 * 
	 * @param className -
	 *            nombre completo de la clase a crear
	 * 
	 * @return the class for name
	 * 
	 * @throws Exception
	 *             the exception
	 */
	private static Object getClassForName(String className) throws Exception {
		return Class.forName(className).newInstance();
	}

	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bAmbitosDAO getAmbitosDAO() throws Exception {
		return (V50bAmbitosDAO) V50bDAOFactory
				.get("v50b.v50bModelo.v50bJdbc.V50bAmbitosDAOImpl");
	}

	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bResolutoresDAO getResolutoresDAO() throws Exception {
		return (V50bResolutoresDAO) V50bDAOFactory
				.get("v50b.v50bModelo.v50bJdbc.V50bResolutoresDAOImpl");
	}

	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bTipoTrabajoDAO getTipoTrabajoDAO() throws Exception {
		return (V50bTipoTrabajoDAO) V50bDAOFactory
				.get("v50b.v50bModelo.v50bJdbc.V50bTipoTrabajoDAOImpl");
	}

	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bMotivosDAO getMotivoDAO() throws Exception {
		return (V50bMotivosDAO) V50bDAOFactory
				.get("v50b.v50bModelo.v50bJdbc.V50bMotivosDAOImpl");
	}
	
	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bDificultadDAO getDificultadDAO() throws Exception {
		return (V50bDificultadDAO) V50bDAOFactory
				.get("v50b.v50bModelo.v50bJdbc.V50bDificultadDAOImpl");
	}

	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bConfiguracionDAO getConfiguracionDAO() throws Exception {
		return (V50bConfiguracionDAO) V50bDAOFactory
				.get("v50b.v50bModelo.v50bJdbc.V50bConfiguracionDAOImpl");
	}

	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bConsultasDAO getConsultasDAO() throws Exception {
		return (V50bConsultasDAO) V50bDAOFactory
				.get("v50b.v50bModelo.v50bJdbc.V50bConsultasDAOImpl");
	}
	
	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bUsuariosRegistradosDAO getUsuariosRegistradosDAO() throws Exception {
		return (V50bUsuariosRegistradosDAO) V50bDAOFactory
				.get("v50b.v50bModelo.v50bJdbc.V50bUsuariosRegistradosDAOImpl");
	}

	/**
	 * @param subcategorias
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bSubcategoriasDAO getSubcategoriasDAO() throws Exception {
		return (V50bSubcategoriasDAO) V50bDAOFactory.get("v50b.v50bModelo.v50bJdbc.V50bSubcategoriasDAOImpl");
	}

	/**
	 * @param profesiones
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bProfesionesDAO getProfesionesDAO() throws Exception {
		return (V50bProfesionesDAO) V50bDAOFactory.get("v50b.v50bModelo.v50bJdbc.V50bProfesionesDAOImpl");
	}
	
	/**
	 * @param calendario
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bCalendarioDAO getCalendarioDAO() throws Exception {
		return (V50bCalendarioDAO) V50bDAOFactory.get("v50b.v50bModelo.v50bJdbc.V50bCalendarioDAOImpl");
	}
	
	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bGraficosDAO getGraficosDAO() throws Exception {
		return (V50bGraficosDAO) V50bDAOFactory.get("v50b.v50bModelo.v50bJdbc.V50bGraficosDAOImpl");
	}
	
	/**
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public static V50bEncuestasDAO getEncuestasDAO() throws Exception {
		return (V50bEncuestasDAO) V50bDAOFactory.get("v50b.v50bModelo.v50bJdbc.V50bEncuestasDAOImpl");
	}


}
