package v50b.v50bControlador;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;


/**
 * 
 * @author llaparra
 *
 */
public class V50bUsuariosRegistradosImpl implements V50bUsuariosRegistrados {
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarUsuariosRegistrados</p>
	 * <p>Descripcin: Busca usuarios registrados en base a un filtro</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Filtro de la bsqueda
	 * @return Lista resultados
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarUsuariosRegistrados(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosImpl.fncBuscarUsuariosRegistrados() ");
		return V50bDAOFactory.getUsuariosRegistradosDAO().fncBuscarUsuariosRegistrados(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleUsuarioRegistrado</p>
	 * <p>Descripcin: Busca los datos de un usuario</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form formulario con el cdigo del usuario
	 * @return Objeto con los datos del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bSuscriptorBean fncDetalleUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosImpl.fncDetalleUsuarioRegistrado() ");
		return V50bDAOFactory.getUsuariosRegistradosDAO().fncDetalleUsuarioRegistrado(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNuevoUsuarioRegistrado</p>
	 * <p>Descripcin: Inserta en BDD un nuevo suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Detalle del usuario
	 * @return Lista con el resultado de la operacin y el cdigo del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public List fncNuevoUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosImpl.fncNuevoUsuarioRegistrado() ");
		
		final List lResult = new ArrayList();
		final String dni = form.getNifOtros();
		final String usuario = form.getUsuario();
		
		final boolean bSuscriptor = V50bDAOFactory.getUsuariosRegistradosDAO().fncExisteSuscriptor(dni, "");
		if(bSuscriptor){
			lResult.add(new Integer(-1));
		} else {
			final boolean bUsuario = V50bDAOFactory.getUsuariosRegistradosDAO().fncExisteUsuario(usuario, "");
			if(bUsuario) {
				lResult.add(new Integer(-V50bClsConstantes.DOS));
			} else {
				lResult.addAll(V50bDAOFactory.getUsuariosRegistradosDAO().fncNuevoUsuarioRegistrado(form));
			}
		}
		return lResult;
	}
		
	/**
	 * 
	 * <p>Ttulo: fncModificarUsuarioRegistrado</p>
	 * <p>Descripcin: Modifica un suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncModificarUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosImpl.fncModificarUsuarioRegistrado() ");
		
		final Integer iResult;
		final String dni = form.getNifOtros();
		final String codSus = form.getCodigo();
		final String usuario = form.getUsuario();
		
		final boolean bSuscriptor = V50bDAOFactory.getUsuariosRegistradosDAO().fncExisteSuscriptor(dni, codSus);
		if(bSuscriptor){
			iResult = new Integer(-1);
		} else {
			final boolean bUsuario = V50bDAOFactory.getUsuariosRegistradosDAO().fncExisteUsuario(usuario, codSus);
			if(bUsuario) {
				iResult = new Integer(-V50bClsConstantes.DOS);
			} else {
				iResult = V50bDAOFactory.getUsuariosRegistradosDAO().fncModificarUsuarioRegistrado(form);
			}
		}
		return iResult;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncEliminarUsuarioRegistrado</p>
	 * <p>Descripcin: Elimina un suscriptor</p>
	 * <p>Copyright: Copyright (c) Abr 11, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param usuario Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncEliminarUsuarioRegistrado(V50bSuscriptorBean usuario) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosImpl.fncEliminarUsuarioRegistrado() ");
		
		V50bDAOFactory.getUsuariosRegistradosDAO().fncModificarConsultas(usuario.getCodigo());
		return new Integer(V50bDAOFactory.getUsuariosRegistradosDAO().fncEliminarUsuarioRegistrado(usuario));
	}
	
	/**
	 * 
	 * <p>Ttulo: fncCargaEmailRemitente</p>
	 * <p>Descripcin: Obtiene el email del remitente</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @return String email del remitente
	 * @throws Exception Cualquier excepcin
	 */
	public String fncCargaEmailRemitente() throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosImpl.fncCargaEmailRemitente() ");
		return V50bDAOFactory.getUsuariosRegistradosDAO().fncCargaEmailRemitente();
	}
}
