package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bTipoTrabajoBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;


/**
 * 
 * @author alata
 *
 */
public class V50bTipoTrabajoImpl implements V50bTipoTrabajo {
	
	/**
	 * @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		V50bClsTrazas.depura("V50bTipoTrabajoImpl.fncBuscarTiposTrabajo()");
		return V50bDAOFactory.getTipoTrabajoDAO().fncBuscarTiposTrabajo(tipoTrabajo);
	}
	
	/**
	* @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		V50bClsTrazas.depura("V50bTipoTrabajoImpl.fncModificarTiposTrabajo()");
		
		if (tipoTrabajo.getEstado()!=null && tipoTrabajo.getEstado().equals(V50bClsConstantes.LITERAL_DESC_BAJA)) {
			String codTipoTrabajo = tipoTrabajo.getCodtra();
			List lista =V50bDAOFactory.getTipoTrabajoDAO().fncBuscarTipoTrabajoUsuarios(codTipoTrabajo);
			if (lista.size()>0){
				return V50bClsConstantes.DOS_NEGATIVO;
			}
		}
		return V50bDAOFactory.getTipoTrabajoDAO().fncModificarTiposTrabajo(tipoTrabajo);
	}
	
	/**
	* @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		V50bClsTrazas.depura("V50bTipoTrabajoImpl.fncAniadirTiposTrabajo()");
		return V50bDAOFactory.getTipoTrabajoDAO().fncAniadirTiposTrabajo(tipoTrabajo);
	}

}
