package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;

/**
 * 
 * @author acompes
 *
 */
public class V50bSubcategoriasImpl implements V50bSubcategorias {
	
	/**
	 * @param subcategorias : Subcategorias con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasImpl.fncBuscarSubcategorias()");
		return V50bDAOFactory.getSubcategoriasDAO().fncBuscarSubcategorias(subcategorias);
	}
	
	/**
	* @param subcategorias : Subcategorias con los datos de modificacin 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasImpl.fncModificarSubcategorias()");
		
		if (subcategorias.getEstado()!=null && subcategorias.getEstado().equals(V50bClsConstantes.LITERAL_DESC_BAJA)) {
			List lista =V50bDAOFactory.getSubcategoriasDAO().fncBuscarSubcategConsultas(subcategorias);
			if (lista.size()>0){
				return V50bClsConstantes.TRES_NEGATIVO;
			}
		}else {
			if (subcategorias.getAmbitos().length>0) {
				List lista = V50bDAOFactory.getSubcategoriasDAO().fncAmbitosAlmacenados(subcategorias.getCodSub());
				boolean noBaja = V50bDAOFactory.getSubcategoriasDAO().fncBuscarSubcategBaja(lista);
				if (!noBaja){
					return 0;
				}
			}
		}
		return V50bDAOFactory.getSubcategoriasDAO().fncModificarSubcategorias(subcategorias);
	}
	
	/**
	* @param subcategorias : Subcategorias con los datos a agregar 
	* @return int: el resultado de agregar los datos
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasImpl.fncAniadirSubcategorias()");
		return V50bDAOFactory.getSubcategoriasDAO().fncAniadirSubcategorias(subcategorias);
	}
	
	/**
	 * @param subcategoria : subcategoria con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosSubcategoria(v50b.v50bBeans.V50bSubcategoriasBean subcategoria) throws Exception{
		V50bClsTrazas.depura("V50bSubcategoriasImpl.fncBuscarAmbitosSubcategoria()");
		return V50bDAOFactory.getSubcategoriasDAO().fncBuscarAmbitosSubcategoria(subcategoria);
		
	}

}
