package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bModelo.V50bDAOFactory;

/**
 * 
 * @author acompes
 *
 */
public class V50bResolutoresImpl implements V50bResolutores {
	
	
	/**
	 * @param usuarioBean :usuario logueado
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncObtenerPerfilUsuario(V50bUsuarioBean usuarioBean) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresImpl.fncObtenerPerfilUsuario()");
		return V50bDAOFactory.getResolutoresDAO().fncObtenerPerfilUsuario(usuarioBean);
	}
	
	/**
	 * @param resolutores : Resolutores con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarResolutores(V50bResolutoresBean resolutores) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresImpl.fncBuscarResolutores()");
		return V50bDAOFactory.getResolutoresDAO().fncBuscarResolutores(resolutores);
	}
	
	/**
	* @param resolutores : Resolutores con los datos de modificacin 
	* @param usuario : usuario
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarResolutores(V50bResolutoresBean resolutores, String usuario) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresImpl.fncModificarResolutores()");
		
		if (resolutores.getIdResol().equals(usuario) && resolutores.getEstado()!=null && resolutores.getEstado().equals(V50bClsConstantes.CONSTANTE_BAJA)){
			return V50bClsConstantes.TRES_NEGATIVO;
		} else {
			if (resolutores.getEstado()==null || !resolutores.getEstado().equals(V50bClsConstantes.CONSTANTE_BAJA) && resolutores.getAmbitos().length>0) {
				List lista = V50bDAOFactory.getResolutoresDAO().fncBuscarAmbitosResolutor(resolutores);
				boolean noBaja = true;
				if (!lista.isEmpty()) {
					noBaja = V50bDAOFactory.getResolutoresDAO().fncBuscarResolBaja(lista);
				}
				if (!noBaja){
					return 0;
				}
			}
			return V50bDAOFactory.getResolutoresDAO().fncModificarResolutores(resolutores);
		}
	}
	
	/**
	* @param resolutores : Resolutores con los datos a agregar 
	* @return int: el resultado de agregar los datos
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirResolutores(V50bResolutoresBean resolutores) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresImpl.fncAniadirResolutores()");
		return V50bDAOFactory.getResolutoresDAO().fncAniadirResolutores(resolutores);
	}
	
	/**
	 * @param resolutores : resolutores con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosResolutor(V50bResolutoresBean resolutores) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresImpl.fncBuscarAmbitosResolutor()");
		return V50bDAOFactory.getResolutoresDAO().fncBuscarAmbitosResolutor(resolutores);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSituacionResolutoresArea</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 4, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con el mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSituacionResolutoresArea(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresImpl.fncBuscSituacionResolutoresArea() ");
		return V50bDAOFactory.getResolutoresDAO().fncBuscSituacionResolutoresArea(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSitResolutores</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 10, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito String con el codigo de mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSitResolutores(String codAmbito) throws Exception {
		return V50bDAOFactory.getResolutoresDAO().fncBuscSitResolutores(codAmbito);
	}
}
