package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;

/**
 * 
 * @author acompes
 *
 */
public interface V50bResolutores {
	
	/**
	 * fncObtenerPerfilUsuario
	 * @param usuarioBean :usuario logueado
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncObtenerPerfilUsuario(V50bUsuarioBean usuarioBean) throws Exception;
	
	/**
	 * 
	 * @param resolutores :Resolutores con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	
	public List fncBuscarResolutores(V50bResolutoresBean resolutores) throws Exception; 
	
	/**
	* @param resolutores : Resolutores con los datos de la modificacin 
	* @param usuario : usuario
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarResolutores(V50bResolutoresBean resolutores, String usuario) throws Exception;
	
	/**
	* @param resolutores : Resolutores con los datos a agregar 
	* @return int: el resultado de aadir registro
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirResolutores(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	 * @param resolutores : resolutores con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosResolutor(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSituacionResolutoresArea</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 4, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con el mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSituacionResolutoresArea(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSitResolutores</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 10, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito String con el codigo de mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSitResolutores(String codAmbito) throws Exception;
}
