package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bProfesionesBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;

/**
 * 
 * @author acompes
 *
 */
public class V50bProfesionesImpl implements V50bProfesiones {
	
	/**
	 * @param profesiones : Profesiones con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarProfesiones(V50bProfesionesBean profesiones) throws Exception {
		V50bClsTrazas.depura("V50bProfesionesImpl.fncBuscarProfesiones()");
		return V50bDAOFactory.getProfesionesDAO().fncBuscarProfesiones(profesiones);
	}
	
	/**
	* @param profesiones : Profesiones con los datos de modificacin 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarProfesiones(V50bProfesionesBean profesiones) throws Exception {
		V50bClsTrazas.depura("V50bProfesionesImpl.fncModificarProfesiones()");
		
		if (profesiones.getEstado()!=null && profesiones.getEstado().equals(V50bClsConstantes.LITERAL_DESC_BAJA)) {
			String codProfesion = profesiones.getCodProf();
			List lista =V50bDAOFactory.getProfesionesDAO().fncBuscarProfesionesUsuarios(codProfesion);
			if (lista.size()>0){
				return V50bClsConstantes.DOS_NEGATIVO;
			}
		}
		return V50bDAOFactory.getProfesionesDAO().fncModificarProfesiones(profesiones);
	}
	
	/**
	* @param profesiones : Profesiones con los datos a agregar 
	* @return int: el resultado de agregar los datos
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirProfesiones(V50bProfesionesBean profesiones) throws Exception {
		V50bClsTrazas.depura("V50bProfesionesImpl.fncAniadirProfesiones()");
		return V50bDAOFactory.getProfesionesDAO().fncAniadirProfesiones(profesiones);
	}

}
