package v50b.v50bControlador;


import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import v50b.v50bBeans.V50bConsultaEdadPorcentajeBean;
import v50b.v50bBeans.V50bConsultaGraficoBarraPorcentajeBean;
import v50b.v50bBeans.V50bConsultaGraficoPorcentajeBean;
import v50b.v50bBeans.V50bConsultaRespuestasPorTecnicoPorcentajeBean;
import v50b.v50bBeans.V50bCriteriosConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;

/**
 * 
 * @author mmonge
 *
 */
public class V50bGraficosImpl implements V50bGraficos {

	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 30, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criteriosGrafico
	 * @return List list
	 * @throws Exception exception
	 */
	private List fncObtenerDatosgraficosPorSexo(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por sexo suscriptor)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorSexo(criteriosGrafico);
//		String strIdioma = criteriosGrafico.getIdioma();
		
		for(int j=0;j<lista.size();j++)
		{	
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
//			if (prueba.getTituloGraf()==null){
//				prueba.setTituloGraf(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noInformado",strIdioma));
//			}
			totalPorcentaje=totalPorcentaje+Integer.parseInt(prueba.getCountGraf());
			
		}
		for(int i=0;i<lista.size();i++)
		{				
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
			lista.set(i, prueba2);
		}	
				
		return lista;
		
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 30, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criteriosGrafico
	 * @return List list
	 * @throws Exception exception
	 */
	private List fncObtenerDatosgraficosPorEstado(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por estado consulta)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorEstado(criteriosGrafico);
		if ("".equals(criteriosGrafico.getEstadoConsultas()))
		{
			for(int j=0;j<lista.size();j++)
			{
				prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
				totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());
			}
			for(int i=0;i<lista.size();i++)
			{		
				prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
				prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
				lista.set(i, prueba2);
			}	
		}
		else{
			String estado= criteriosGrafico.getEstadoConsultas();
			V50bConsultaGraficoPorcentajeBean criterio= new V50bConsultaGraficoPorcentajeBean();
			V50bConsultaGraficoPorcentajeBean criterioEstado= new V50bConsultaGraficoPorcentajeBean();				
			int contador=0;
			int acumulador=0;
			for(int j=0;j<lista.size();j++)
			{
				prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
				if (estado.equals(prueba.getTituloGraf()))
				{
					criterioEstado.setTituloGraf(prueba.getTituloGraf());
					criterioEstado.setCountGraf(prueba.getCountGraf());								
					acumulador=Integer.parseInt(prueba.getCountGraf());
									}
				else 
				{
					contador = contador+Integer.parseInt(prueba.getCountGraf());						
				}					
			}
			lista.clear();
			criterio.setTituloGraf("OTROS");
			criterio.setCountGraf(Integer.toString(contador));
			lista.add(criterioEstado);
			lista.add(criterio);
			int total= acumulador+contador;
			for(int i=0;i<lista.size();i++)
			{		
				prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
				prueba2.setTotalAcumulado(Integer.toString(total));
			}	
		}
		return lista;
		
	}
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 30, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criteriosGrafico
	 * @return List lista
	 * @throws Exception the exception
	 */
	private List fncObtenerDatosgraficosPorLocalizacion(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{

	V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por localidad)");
	List lista = new ArrayList();
	int totalPorcentaje = 0;
	V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
	V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
	lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorLocalizacion(criteriosGrafico);
	String localidad=criteriosGrafico.getCodTh();
	String localidad2=criteriosGrafico.getLocalizacionTh();
	if((localidad==null) || ("".equals(localidad)))
	{
			for(int j=0;j<lista.size();j++)
			{
				prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
				totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());
			}
			for(int i=0;i<lista.size();i++)
			{		
				prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
				prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
				lista.set(i, prueba2);
			}		
	}
	else if((localidad!=null)&&(!"".equals(localidad)))
		
	{
		V50bConsultaGraficoPorcentajeBean criterio= new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean criterioLocalidad= new V50bConsultaGraficoPorcentajeBean();				
		int contador=0;
		int acumulador=0;
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
			if (localidad2.equals(prueba.getTituloGraf().toUpperCase()))
			{
				criterioLocalidad.setTituloGraf(prueba.getTituloGraf());
				criterioLocalidad.setCountGraf(prueba.getCountGraf());								
				acumulador=Integer.parseInt(prueba.getCountGraf());
			}
			else 
			{
				criterioLocalidad.setTituloGraf(localidad2);
				criterioLocalidad.setCountGraf("0");
				contador = contador+Integer.parseInt(prueba.getCountGraf());						
			}					
		}
		lista.clear();
		criterio.setTituloGraf("OTROS");
		criterio.setCountGraf(Integer.toString(contador));
		lista.add(criterioLocalidad);
		lista.add(criterio);
		int total= acumulador+contador;
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(total));
		}	
	}
	
	return lista;
	
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 30, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criteriosGrafico
	 * @return List lista
	 * @throws Exception the exception
	 */
	private List fncObtenerDatosgraficosPorLocalizacionMunicipio(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{

		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por localidad municipio)");
		String municipio= criteriosGrafico.getLocalizacionMunicipio(); 
		List lista = new ArrayList();
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorLocalizacionMunicipio(criteriosGrafico);
		V50bConsultaGraficoPorcentajeBean criterio= new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean criterioMunicipio= new V50bConsultaGraficoPorcentajeBean();				
		int contador=0;
		int acumulador=0;
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
			if ((municipio.toUpperCase()).equals(prueba.getTituloGraf().toUpperCase()))
			{
				criterioMunicipio.setTituloGraf(prueba.getTituloGraf());
				criterioMunicipio.setCountGraf(prueba.getCountGraf());								
				acumulador=Integer.parseInt(prueba.getCountGraf());
			}
			else 
			{
				contador = contador+Integer.parseInt(prueba.getCountGraf());						
			}					
		}
		lista.clear();
		criterio.setTituloGraf("OTROS");
		criterio.setCountGraf(Integer.toString(contador));
		if (("".equals(criterioMunicipio.getTituloGraf()))||(criterioMunicipio.getTituloGraf()==null)){
			criterioMunicipio.setTituloGraf(municipio);
			criterioMunicipio.setCountGraf("0");
		}
		lista.add(criterioMunicipio);
		lista.add(criterio);
		int total= acumulador+contador;
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(total));
			lista.set(i, prueba2);
		}
		List listaprueba= new ArrayList();
		listaprueba= lista;
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por localidad municipio)"+listaprueba.size());

		return lista;
		
		}
	
	

	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 30, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criteriosGrafico
	 * @return List list
	 * @throws Exception exception
	 */
	private List fncObtenerDatosgraficosPorReenvios(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por Reenvios y causas)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorReenvios(criteriosGrafico);
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
			totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());
		}
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
			lista.set(i, prueba2);
		}		
		
		return lista;
		
	}
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 5, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception excepcion
	 */
	public List fncObtenerDatosgraficosPorRespuestasTecnico(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
	
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por Respuestas Tecnicos)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaRespuestasPorTecnicoPorcentajeBean prueba=new V50bConsultaRespuestasPorTecnicoPorcentajeBean();
		V50bConsultaRespuestasPorTecnicoPorcentajeBean prueba2=new V50bConsultaRespuestasPorTecnicoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorRespuestasTecnico(criteriosGrafico);
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaRespuestasPorTecnicoPorcentajeBean)lista.get(j);			
			totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountRespuestas());
		}
		
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaRespuestasPorTecnicoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
			lista.set(i, prueba2);
		}		
		
		return lista;
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 7, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception exception
	 */
	public List fncObtenerDatosgraficosPorTipoTrabajo(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por tipo trabajo)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorTipoTrabajo(criteriosGrafico);
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);			
			totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());
		}
		
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
			lista.set(i, prueba2);
		}		
		
		return lista;
	}

	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 7, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception exception
	 */
public List fncObtenerDatosgraficosPorProfesion(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por profesion)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorTipoProfesion(criteriosGrafico);
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);			
			totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());
		}
		
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
			lista.set(i, prueba2);
		}		
		
		return lista;
	}
	

	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 9, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param lista lista
	 * @param strIdioma Idioma de la sesion
	 * @return List Lista
	 * @throws Exception Cualquier excepcion
	 */
	public List fncObtenerContadorEdad(List lista, String strIdioma) throws Exception {
		
		V50bClsTrazas.depura("Funcion Obtener el Contador de Edad");
		V50bConsultaEdadPorcentajeBean miBean= new V50bConsultaEdadPorcentajeBean();
		V50bConsultaEdadPorcentajeBean miBean18= new V50bConsultaEdadPorcentajeBean("<18");
		V50bConsultaEdadPorcentajeBean miBean25= new V50bConsultaEdadPorcentajeBean("18-25");
		V50bConsultaEdadPorcentajeBean miBean35= new V50bConsultaEdadPorcentajeBean("26-35");
		V50bConsultaEdadPorcentajeBean miBean45= new V50bConsultaEdadPorcentajeBean("36-45");
		V50bConsultaEdadPorcentajeBean miBean55= new V50bConsultaEdadPorcentajeBean("46-55");
		V50bConsultaEdadPorcentajeBean miBean65= new V50bConsultaEdadPorcentajeBean("56-65");
		V50bConsultaEdadPorcentajeBean miBean66= new V50bConsultaEdadPorcentajeBean(">65");
		V50bConsultaEdadPorcentajeBean miBeanNo= new V50bConsultaEdadPorcentajeBean(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noInformado",strIdioma));
		StringBuffer car= new StringBuffer();
		StringBuffer cc= new StringBuffer();
		String edadFormateada="";
		for(int i=0; i<lista.size();i++){
			miBean=(V50bConsultaEdadPorcentajeBean)lista.get(i);
			String aux= miBean.getEdad();
			String nose="";
			
			for(int j=0; j<aux.length();j++)
			{
				char c = aux.charAt(j);				
				nose= car.append(c).toString();
				if(!".".equals(nose)){
					edadFormateada=cc.append(c).toString();
					car.deleteCharAt(0);
				}
				else
				{
					//edadFormateada=cc.toString();
					car.delete(0, car.capacity()-1);
					cc.delete(0, car.capacity()-1);	
					j=aux.length();
				}				
			}
		
			//edadFormateada=cc.toString();
			int edad=Integer.parseInt(edadFormateada);
			int contador=0;
			if(edad<V50bClsConstantes.DIECIOCHO && edad>=0)
			{
				contador= Integer.parseInt(miBean18.getContEdad());
				contador= contador+1;
				miBean18.setContEdad(Integer.toString(contador));
			}
			else if((edad>=V50bClsConstantes.DIECIOCHO)&&(edad<V50bClsConstantes.VEINTISEIS))
			{
				contador= Integer.parseInt(miBean25.getContEdad());
				contador= contador+1;
				miBean25.setContEdad(Integer.toString(contador));
				
			}
			else if((edad<V50bClsConstantes.TREINTAYSEIS)&&(edad>=V50bClsConstantes.VEINTISEIS))
			{
				contador= Integer.parseInt(miBean35.getContEdad());
				contador= contador+1;
				miBean35.setContEdad(Integer.toString(contador));
			}
			else if((edad<V50bClsConstantes.CUARENTAYSEIS)&&(edad>=V50bClsConstantes.TREINTAYSEIS))
			{
				contador= Integer.parseInt(miBean45.getContEdad());
				contador= contador+1;
				miBean45.setContEdad(Integer.toString(contador));
			}
			else if((edad<V50bClsConstantes.CINCUENTAYSEIS)&&(edad>=V50bClsConstantes.CUARENTAYSEIS))
			{
				contador= Integer.parseInt(miBean55.getContEdad());
				contador= contador+1;
				miBean55.setContEdad(Integer.toString(contador));
			}
			else if((edad<=V50bClsConstantes.SESENTAYCINCO)&&(edad>=V50bClsConstantes.CINCUENTAYSEIS))
			{
				contador= Integer.parseInt(miBean65.getContEdad());
				contador= contador+1;
				miBean65.setContEdad(Integer.toString(contador));
			}
			else if(edad>V50bClsConstantes.SESENTAYCINCO)
			{
				contador= Integer.parseInt(miBean66.getContEdad());
				contador= contador+1;
				miBean66.setContEdad(Integer.toString(contador));
			}
			else if(edad==-1){
				contador= Integer.parseInt(miBeanNo.getContEdad());
				contador= contador+1;
				miBeanNo.setContEdad(Integer.toString(contador));
			}
		}
		lista.clear();
		if(!"0".equals(miBean18.getContEdad())){
			lista.add(miBean18);
		}
		if(!"0".equals(miBean25.getContEdad())){
			lista.add(miBean25);
		}
		if(!"0".equals(miBean35.getContEdad())){
			lista.add(miBean35);
		}
		if(!"0".equals(miBean45.getContEdad())){
			lista.add(miBean45);
		}
		if(!"0".equals(miBean55.getContEdad())){
			lista.add(miBean55);
		}
		if(!"0".equals(miBean65.getContEdad())){
			lista.add(miBean65);
		}
		if(!"0".equals(miBean66.getContEdad())){
			lista.add(miBean66);
		}
		if(!"0".equals(miBeanNo.getContEdad())){
			lista.add(miBeanNo);
		}
		
		return lista;
	}
	/**
 	* 
 	* <p>Ttulo: </p>
 	* <p>Descripcin: </p>
 	* <p>Copyright: Copyright (c) Jan 9, 2009</p>
 	* <p>Empresa: Eurohelp</p>
 	* 
 	* @author mmonge
 	* @version 1.0
 	* @param criteriosGrafico criterios
 	* @return List lista
 	* @throws Exception exception
 	*/
	public List fncObtenerDatosgraficosPorEdad(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
	
	V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por edad)");
	List lista = new ArrayList();
	int totalPorcentaje = 0;
	V50bConsultaEdadPorcentajeBean prueba=new V50bConsultaEdadPorcentajeBean();
	V50bConsultaEdadPorcentajeBean prueba2=new V50bConsultaEdadPorcentajeBean();
	lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorEdades(criteriosGrafico);
	lista= this.fncObtenerContadorEdad(lista, criteriosGrafico.getIdioma());
	for(int j=0;j<lista.size();j++)
	{
		prueba= (V50bConsultaEdadPorcentajeBean)lista.get(j);			
		totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getContEdad());
	}
	
	for(int i=0;i<lista.size();i++)
	{		
		prueba2=(V50bConsultaEdadPorcentajeBean)lista.get(i);
		prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
		lista.set(i, prueba2);
	}		
	
	return lista;
}
	
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 12, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception exception
	 */
	private List fncObtenerDatosgraficosPorMultiterm(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(PorExtraidas Multiterm)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean objeto=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorMultiterm(criteriosGrafico);
		String strIdioma = criteriosGrafico.getIdioma();
		
		int cont=0;
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
			totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());
			
			if(prueba.getTituloGraf()==null){
				cont=Integer.parseInt(prueba.getCountGraf());
				objeto=(V50bConsultaGraficoPorcentajeBean)lista.get(j);				
			}
			
		}
		lista.remove(objeto);
		for(int i=0;i<lista.size();i++){
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(i);
			if(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",strIdioma).equals(prueba.getTituloGraf()))
			{
				int aux=Integer.parseInt(prueba.getCountGraf())+cont;
				prueba.setCountGraf(Integer.toString(aux));
			}
		}
		
	
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
			lista.set(i, prueba2);
		}		
		
		return lista;
		
	}
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 12, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param lista lista
	 * @param strIdioma Idioma de la sesin
	 * @return List lista
	 * @throws Exception Cualquier excepcin
	 */
	public List v50bFncOrdenarLista (List lista, String strIdioma) throws Exception {
		 
		final V50bConsultaGraficoPorcentajeBean catalogada= new V50bConsultaGraficoPorcentajeBean();
		final V50bConsultaGraficoPorcentajeBean total= new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean aux= new V50bConsultaGraficoPorcentajeBean();
		int cont1=0;
		int cont2=0;
		String strCatalogada = "";
		for (int i=0;i<lista.size();i++){
			aux= (V50bConsultaGraficoPorcentajeBean)lista.get(i);
			
			if(!V50bClsConstantes.ESTADO_CATALOGADA.equals(aux.getEstadoConsulta())) {
				cont1= Integer.parseInt(aux.getCountGraf())+cont1;
			}
			else{
				if(StringUtils.isEmpty(strCatalogada)){
					strCatalogada = aux.getTituloGraf();
				}
				cont2=Integer.parseInt(aux.getCountGraf());
			}
		}
		total.setTituloGraf(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.totalConsultas",strIdioma));
		total.setCountGraf(Integer.toString(cont1));
		catalogada.setTituloGraf(strCatalogada);
		catalogada.setCountGraf(Integer.toString(cont2));
		lista.clear();
		lista.add(total);
		lista.add(catalogada);
		return lista;
	}
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 12, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception exception
	 */
	private List fncObtenerDatosgraficosPorCatalogada(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Incorporaciones a catalogo)");
		
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorCatalogadas(criteriosGrafico);
		lista= this.v50bFncOrdenarLista(lista, criteriosGrafico.getIdioma());
		
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
			totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());		
		}
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
			lista.set(i, prueba2);
		}		
		
		return lista;
		
	}
	
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception exception
	 */
	private List fncObtenerDatosgraficosPorDificultad(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Por dificultad consulta)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorDificultad(criteriosGrafico);
		if ("".equals(criteriosGrafico.getCodDificultad())||(criteriosGrafico.getCodDificultad()==null))
		{
			for(int j=0;j<lista.size();j++)
			{
				prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
				totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());
			}
			for(int i=0;i<lista.size();i++)
			{		
				prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
				prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
				lista.set(i, prueba2);
			}	
		}
		else{
			String dificultad= criteriosGrafico.getDificultad();
			V50bConsultaGraficoPorcentajeBean criterio= new V50bConsultaGraficoPorcentajeBean();
			V50bConsultaGraficoPorcentajeBean criterioDificultad= new V50bConsultaGraficoPorcentajeBean();				
			int contador=0;
			int acumulador=0;
			for(int j=0;j<lista.size();j++)
			{
				prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
				criterioDificultad.setTituloGraf(prueba.getTituloGraf());
				if (dificultad.toUpperCase().equals(prueba.getTituloGraf().toUpperCase()))
				{	
					criterioDificultad.setTituloGraf(prueba.getTituloGraf());
					criterioDificultad.setCountGraf(prueba.getCountGraf());								
					acumulador=Integer.parseInt(prueba.getCountGraf());
				}
				else 
				{
					contador = contador+Integer.parseInt(prueba.getCountGraf());						
				}					
			}
			if(criterioDificultad.getCountGraf()==null){
				criterioDificultad.setTituloGraf(dificultad);
				criterioDificultad.setCountGraf("0");
			}
			lista.clear();
			criterio.setTituloGraf("OTROS");
			criterio.setCountGraf(Integer.toString(contador));
			lista.add(criterioDificultad);
			lista.add(criterio);
			int total= acumulador+contador;
			for(int i=0;i<lista.size();i++)
			{		
				prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
				prueba2.setTotalAcumulado(Integer.toString(total));
			}	
		}
		return lista;
		
	}
	
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 19, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param consulta consulta
	 * @return int mes
	 */
	private int fncCalcularMes(V50bConsultaGraficoBarraPorcentajeBean consulta){
		
		String mes=consulta.getFecha().substring(0, 1);
		if ("0".equals(mes)){
			mes = consulta.getFecha().substring(1,2);
		}
		else
		{
			mes = consulta.getFecha().substring(0,2);
		}
		return Integer.parseInt(mes);
		
	}
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 20, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param listaDefinitiva lista			
	 * @return List
	 */
	private List fncOrdenarListaDefinitiva(List listaDefinitiva){
		
		List auxListaMenorMayor= new ArrayList();
		int anyo;
		int anyo2;
		V50bConsultaGraficoBarraPorcentajeBean auxBean= new V50bConsultaGraficoBarraPorcentajeBean();
		V50bConsultaGraficoBarraPorcentajeBean auxBean2= new V50bConsultaGraficoBarraPorcentajeBean();
		for(int i=0; i<=listaDefinitiva.size();i++){
			i=0;
			auxBean= (V50bConsultaGraficoBarraPorcentajeBean)listaDefinitiva.get(i);
			anyo=Integer.parseInt(auxBean.getFecha().substring(V50bClsConstantes.CINCO, V50bClsConstantes.SIETE));
			for (int j=0; j<listaDefinitiva.size();j++){
				auxBean2= (V50bConsultaGraficoBarraPorcentajeBean)listaDefinitiva.get(j);
				anyo2=Integer.parseInt(auxBean2.getFecha().substring(V50bClsConstantes.CINCO, V50bClsConstantes.SIETE));
				if(anyo2<anyo){
					auxBean= auxBean2;
					anyo=anyo2;					
				}
			}
			auxListaMenorMayor.add(auxBean);
			listaDefinitiva.remove(auxBean);
			
			}
		return auxListaMenorMayor;
	}
	
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 20, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param listaDefinitiva lista
	 * @return List lista
	 */
	private List fncOrdenarListaPorMes(List listaDefinitiva){
		
		List auxListaMenorMayor= new ArrayList();
		int mes;
		int mes2;
		V50bConsultaGraficoBarraPorcentajeBean auxBean= new V50bConsultaGraficoBarraPorcentajeBean();
		V50bConsultaGraficoBarraPorcentajeBean auxBean2= new V50bConsultaGraficoBarraPorcentajeBean();
		for(int i=0; i<=listaDefinitiva.size();i++){
			i=0;
			auxBean= (V50bConsultaGraficoBarraPorcentajeBean)listaDefinitiva.get(i);
			mes=this.fncCalcularMes(auxBean);
			for (int j=0; j<listaDefinitiva.size();j++){
				auxBean2= (V50bConsultaGraficoBarraPorcentajeBean)listaDefinitiva.get(j);
				mes2=this.fncCalcularMes(auxBean2);
				if(mes2<mes){
					auxBean= auxBean2;
					mes=mes2;					
				}
			}
			auxListaMenorMayor.add(auxBean);
			listaDefinitiva.remove(auxBean);
			
			}
		return auxListaMenorMayor;
	}
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 14, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception exception
	 */	
	private List fncObtenerDatosgraficosPorEvolucionUsuariosRegistrados(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Evolucion usuarios registrados)");	
		List lista1 = new ArrayList();
		List lista2 = new ArrayList();
		List listaDefinitiva= new ArrayList();
		lista1=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosEvolucionUsuariosAlta(criteriosGrafico);
		lista2=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosEvolucionUsuariosBaja(criteriosGrafico);
		V50bConsultaGraficoBarraPorcentajeBean alta= new V50bConsultaGraficoBarraPorcentajeBean();
		V50bConsultaGraficoBarraPorcentajeBean baja= new V50bConsultaGraficoBarraPorcentajeBean();
		String fecha="";
		String fecha2="";
		if ((lista1.size()!=0)||(lista2.size()!=0)){
			if ((lista1.size()!=0))
			{
				lista1= this.fncOrdenarListaDefinitiva(lista1);					
				for(int i=0; i<lista1.size();i++){
					alta= (V50bConsultaGraficoBarraPorcentajeBean)lista1.get(i);
					listaDefinitiva.add(alta);
				}
			}
			if((lista2.size()!=0)&&(lista1.size()!=0)){
				lista2=this.fncOrdenarListaDefinitiva(lista2);
				for(int i=0;i<lista2.size();i++){
					baja= (V50bConsultaGraficoBarraPorcentajeBean)lista2.get(i);
					fecha=baja.getFecha();
					for(int j=0;j<listaDefinitiva.size();j++){
						alta=(V50bConsultaGraficoBarraPorcentajeBean) listaDefinitiva.get(j);
						fecha2=alta.getFecha();
						if(fecha.equals(fecha2)){
							baja.setCountR(baja.getCountC());
							baja.setCountC(alta.getCountC());
							listaDefinitiva.remove(alta);
							listaDefinitiva.add(baja);
						}
					}
					if(!fecha.equals(fecha2)){
						listaDefinitiva.add(baja);
					}
				}
			}
			if ((lista1.size()==0)&&(lista2.size()!=0)){
				lista2= this.fncOrdenarListaDefinitiva(lista2);					
				for(int i=0; i<lista2.size();i++){
					baja= (V50bConsultaGraficoBarraPorcentajeBean)lista2.get(i);
					listaDefinitiva.add(baja);
				}
			}
			listaDefinitiva=this.fncOrdenarListaPorMes(listaDefinitiva);		
			listaDefinitiva= this.fncOrdenarListaDefinitiva(listaDefinitiva);
		}	
			return listaDefinitiva;
		
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 14, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception exception
	 */	
	private List fncObtenerDatosgraficosPorEvolucionConsultasRespuestas(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Evolucion consultas respuestas)");	
		List lista1 = new ArrayList();
		List lista2 = new ArrayList();
		List listaDefinitiva= new ArrayList();
		lista1=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosEvolucionConsultas(criteriosGrafico);
		lista2=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosEvolucionRespuestas(criteriosGrafico);
		V50bConsultaGraficoBarraPorcentajeBean consulta= new V50bConsultaGraficoBarraPorcentajeBean();
		V50bConsultaGraficoBarraPorcentajeBean respuesta= new V50bConsultaGraficoBarraPorcentajeBean();
		String fecha="";
		String fecha2="";		
		if((lista1.size()!=0)||(lista2.size()!=0))
		{
			if ((lista1.size()!=0))
			{
				lista1= this.fncOrdenarListaDefinitiva(lista1);			
				for(int i=0; i<lista1.size();i++){
					consulta= (V50bConsultaGraficoBarraPorcentajeBean)lista1.get(i);
					listaDefinitiva.add(consulta);
				}
			}
			if((lista2.size()!=0)&&(lista1.size()!=0)){
				lista2=this.fncOrdenarListaDefinitiva(lista2);
				for(int i=0;i<lista2.size();i++){
					respuesta= (V50bConsultaGraficoBarraPorcentajeBean)lista2.get(i);
					fecha=respuesta.getFecha();
					for(int j=0;j<listaDefinitiva.size();j++){
						consulta=(V50bConsultaGraficoBarraPorcentajeBean) listaDefinitiva.get(j);
						fecha2=consulta.getFecha();
							if(fecha.equals(fecha2)){
								respuesta.setCountC(consulta.getCountC());
								listaDefinitiva.remove(consulta);
								listaDefinitiva.add(respuesta);
							}
					}
					if(!fecha.equals(fecha2)){
						listaDefinitiva.add(respuesta);
					}
				}
			}
			if ((lista1.size()==0)&&(lista2.size()!=0)){
				lista2= this.fncOrdenarListaDefinitiva(lista2);					
				for(int i=0; i<lista2.size();i++){
					respuesta= (V50bConsultaGraficoBarraPorcentajeBean)lista2.get(i);
					listaDefinitiva.add(respuesta);
				}
			}
			listaDefinitiva=this.fncOrdenarListaPorMes(listaDefinitiva);		
			listaDefinitiva= this.fncOrdenarListaDefinitiva(listaDefinitiva);
		}
		return listaDefinitiva;
		
	}
//	/**
//	 * 
//	 * <p>Ttulo: </p>
//	 * <p>Descripcin: </p>
//	 * <p>Copyright: Copyright (c) Jan 13, 2009</p>
//	 * <p>Empresa: Eurohelp</p>
//	 * 
//	 * @author mmonge
//	 * @version 1.0
//	 * @param lista lista
//	 * @return List lista
//	 */
//	private List v50bFncTitularLista(List lista){
//		 
//		V50bConsultaGraficoPorcentajeBean aux= new V50bConsultaGraficoPorcentajeBean();
//		 for (int i=0; i<lista.size();i++){
//			 
//			 aux= (V50bConsultaGraficoPorcentajeBean)lista.get(i);
//			 if (V50bClsConstantes.RECEPCION_CORREO.equals(aux.getTituloGraf())){
//				 aux.setTituloGraf("CORREO");
//				 lista.set(i,aux);
//			 }
//			 else if (V50bClsConstantes.RECEPCION_INICIATIVA.equals(aux.getTituloGraf())){
//				 aux.setTituloGraf("INICIATIVA PROPIA");
//				 lista.set(i,aux);
//			 }
//			 else if (V50bClsConstantes.RECEPCION_MIGRACION.equals(aux.getTituloGraf())){
//				 aux.setTituloGraf("MIGRACION");
//				 lista.set(i,aux);
//			 }
//			 else if (V50bClsConstantes.RECEPCION_PROPUESTA.equals(aux.getTituloGraf())){
//				 aux.setTituloGraf("PROPUESTA");
//				 lista.set(i,aux);
//			 }
//			 else if (V50bClsConstantes.RECEPCION_TELEFONO.equals(aux.getTituloGraf())){
//				 aux.setTituloGraf("TELEFONO");
//				 lista.set(i,aux);
//			 }
//			 else {
//				 aux.setTituloGraf("DUDANET");
//				 lista.set(i,aux);
//			 }
//		 }		
//		return lista;
//	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico criterios
	 * @return List lista
	 * @throws Exception exception
	 */
	private List fncObtenerDatosgraficosPorMedios(V50bCriteriosConsultaBean criteriosGrafico)throws Exception{
		
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosGraficos()(Incorporaciones a medios llegada)");
		List lista = new ArrayList();
		int totalPorcentaje = 0;
		V50bConsultaGraficoPorcentajeBean prueba=new V50bConsultaGraficoPorcentajeBean();
		V50bConsultaGraficoPorcentajeBean prueba2=new V50bConsultaGraficoPorcentajeBean();
		lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosPorLlegadaConsulta(criteriosGrafico);
		//lista= this.v50bFncTitularLista(lista);
		
		for(int j=0;j<lista.size();j++)
		{
			prueba= (V50bConsultaGraficoPorcentajeBean)lista.get(j);
			totalPorcentaje= totalPorcentaje +Integer.parseInt(prueba.getCountGraf());		
		}
		for(int i=0;i<lista.size();i++)
		{		
			prueba2=(V50bConsultaGraficoPorcentajeBean)lista.get(i);
			prueba2.setTotalAcumulado(Integer.toString(totalPorcentaje));
			lista.set(i, prueba2);
		}		
		
		return lista;
		
	}
	/**
	 * 
	 * <p>Ttulo: fncObtenerDatosGraficos</p>
	 * <p>Descripcin: obtener los datos necesarios para rellenar el grafico</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 *  
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico parametro de entrada
	 * @return List parametro de salida
	 * @throws Exception excepcion
	 */
	public List fncObtenerDatosGraficos(V50bCriteriosConsultaBean criteriosGrafico) throws Exception 
	{
		
		List lista= new ArrayList();
		String codMunicipio=criteriosGrafico.getCodMunicipio();
		if ((V50bClsConstantes.POR_SEXO).equals(criteriosGrafico.getRadio())){
			lista=this.fncObtenerDatosgraficosPorSexo(criteriosGrafico);
			
		}
		else if ((V50bClsConstantes.ESTADO_CONSULTAS).equals(criteriosGrafico.getRadio()))
		{
			lista=this.fncObtenerDatosgraficosPorEstado(criteriosGrafico);
		}
		else if ((V50bClsConstantes.POR_LOCALIZACION).equals(criteriosGrafico.getRadio())&&(("".equals(codMunicipio))||(codMunicipio==null)))
		{
			lista= this.fncObtenerDatosgraficosPorLocalizacion(criteriosGrafico);
		}
		else if (((V50bClsConstantes.POR_LOCALIZACION).equals(criteriosGrafico.getRadio()))&&((!"".equals(codMunicipio))||(codMunicipio!=null))){
			lista=this.fncObtenerDatosgraficosPorLocalizacionMunicipio(criteriosGrafico);			
		}
		
		else if (((V50bClsConstantes.CAUSAS_REENVIOS).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorReenvios(criteriosGrafico);
		}
		
		else if (((V50bClsConstantes.RESPUESTAS_TECNICOS).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorRespuestasTecnico(criteriosGrafico);
		}
		
		else if (((V50bClsConstantes.TIPO_TRABAJO).equals(criteriosGrafico.getRadio())))
		{
			
				List lista2= new ArrayList();
				List lista3= new ArrayList();
				lista=this.fncObtenerDatosgraficosPorTipoTrabajo(criteriosGrafico);
				lista2=this.fncObtenerDatosgraficosPorProfesion(criteriosGrafico);
				lista3.add(lista);
				lista3.add(lista2);
				return lista3;
			
			
		}
		else if (((V50bClsConstantes.POR_EDADES).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorEdad(criteriosGrafico);
		}
		
		else if (((V50bClsConstantes.EXTRAIDOS_MULTITERM).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorMultiterm(criteriosGrafico);
		}
		else if (((V50bClsConstantes.INCORP_CATALOGO).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorCatalogada(criteriosGrafico);
		}
		else if (((V50bClsConstantes.CAUSAS_DENEGACION).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorReenvios(criteriosGrafico);
		}
		else if (((V50bClsConstantes.CAUSAS_RECHAZOS).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorReenvios(criteriosGrafico);
		}
		else if (((V50bClsConstantes.DIFICULTAD).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorDificultad(criteriosGrafico);
		}
		else if (((V50bClsConstantes.MEDIOS_LLEGADA_CONSULTA).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorMedios(criteriosGrafico);
		}
		else if (((V50bClsConstantes.EVOL_CONSULTAS_RESPUESTAS).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorEvolucionConsultasRespuestas(criteriosGrafico);
		}
		else if (((V50bClsConstantes.EVOL_USUARIOS_REG).equals(criteriosGrafico.getRadio())))
		{
			lista=this.fncObtenerDatosgraficosPorEvolucionUsuariosRegistrados(criteriosGrafico);
		}
		else if (((V50bClsConstantes.TIEMPO_MEDIO_RESPUESTA).equals(criteriosGrafico.getRadio())))
		{
			lista=V50bDAOFactory.getGraficosDAO().fncObtenerDatosGraficosTiempoMedioRespuesta(criteriosGrafico);
		}
		else{
			List result= new ArrayList();
			result.add("0");
			result.add("0");
			return result;	
		}	
		return lista;
		

	}
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerDatosAmbitos</p>
	 * <p>Descripcin: obtener los datos necesarios para rellenar el combo ambito</p>
	 * <p>Copyright: Copyright (c) 26/01/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 *  
	 * @author mmonge
	 * @version 1.0
	 * @param idioma parametro de entrada
	 * @return List parametro de salida
	 * @throws Exception excepcion
	 */
	public List fncObtenerDatosAmbitos(String idioma) throws Exception {
		V50bClsTrazas.depura("V50bGraficosImpl.fncObtenerDatosAmbitos");
		return V50bDAOFactory.getGraficosDAO().fncObtenerDatosAmbitos(idioma);

	}

}
