package v50b.v50bControlador;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bAmbitoBean;
import v50b.v50bBeans.V50bCalendarioBean;
import v50b.v50bBeans.V50bConfiguracionBean;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bCriteriosConsultaBean;
import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bBeans.V50bMotivosBean;
import v50b.v50bBeans.V50bNotificacionBean;
import v50b.v50bBeans.V50bProfesionesBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bBeans.V50bRespuestasBean;
import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bBeans.V50bTipoTrabajoBean;
import v50b.v50bClasesComunes.V50bClsFichero;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;




/**
 * The Class V50bFachadaImpl.
 * 
 * @author iurkidi
 */
public class V50bFachadaImpl implements V50bFachada {

	private static V50bFachada fachada = null;

	/**
	 * Instantiates a new v50b fachada impl.
	 */
	private V50bFachadaImpl() {
	}

	/**
	 * Gets the singleton.
	 * 
	 * @return the singleton
	 */
	public static V50bFachada getSingleton() {
		if (V50bFachadaImpl.fachada == null) {
			V50bFachadaImpl.fachada = new V50bFachadaImpl();
		}
		return V50bFachadaImpl.fachada;
	}
	
	
	/**
	 * @param ambito : ambito con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitos(V50bAmbitoBean ambito) throws Exception {
		return V50bControladorFactory.getAmbitos().fncBuscarAmbitos(ambito);
	}
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarAmbito(V50bAmbitoBean ambito) throws Exception {
		return V50bControladorFactory.getAmbitos().fncModificarAmbito(ambito);
	}
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirAmbito(V50bAmbitoBean ambito) throws Exception {
		return V50bControladorFactory.getAmbitos().fncAniadirAmbito(ambito);
	}
	
	/**
	* @param usuarioBean : usuario logueado
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public List fncObtenerPerfilUsuario(V50bUsuarioBean usuarioBean) throws Exception {
		return V50bControladorFactory.getResolutores().fncObtenerPerfilUsuario(usuarioBean);
	}
	
	/**
	 * @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		return V50bControladorFactory.getTipoTrabajo().fncBuscarTiposTrabajo(tipoTrabajo);
	}
	
	/**
	* @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		return V50bControladorFactory.getTipoTrabajo().fncModificarTiposTrabajo(tipoTrabajo);
	}
	
	/**
	* @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		return V50bControladorFactory.getTipoTrabajo().fncAniadirTiposTrabajo(tipoTrabajo);
	}
	
	/**
	 * @param motivo : motivo con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarMotivos(V50bMotivosBean motivo) throws Exception {
		return V50bControladorFactory.getMotivo().fncBuscarMotivos(motivo);
	}
	/**
	* @param motivo : motivo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarMotivos(V50bMotivosBean motivo) throws Exception {
		return V50bControladorFactory.getMotivo().fncModificarMotivos(motivo);
	}
	
	/**
	* @param motivo : motivo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirMotivos(V50bMotivosBean motivo) throws Exception {
		return V50bControladorFactory.getMotivo().fncAniadirMotivos(motivo);
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultad(V50bDificultadBean dificultad) throws Exception {
		return V50bControladorFactory.getDificultad().fncBuscarDificultad(dificultad);
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarDificultad(V50bDificultadBean dificultad) throws Exception {
		return V50bControladorFactory.getDificultad().fncModificarDificultad(dificultad);
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirDificultad(V50bDificultadBean dificultad) throws Exception {
		return V50bControladorFactory.getDificultad().fncAniadirDificultad(dificultad);
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosDificultad(V50bDificultadBean dificultad) throws Exception {
		return V50bControladorFactory.getDificultad().fncBuscarAmbitosDificultad(dificultad);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfiguracion(V50bConfiguracionBean buzon) throws Exception {
		return V50bControladorFactory.getConfiguracion().fncBuscarConfiguracion(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfigTextos(V50bConfiguracionBean buzon) throws Exception {
		return V50bControladorFactory.getConfiguracion().fncBuscarConfigTextos(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarConfiguracion(V50bConfiguracionBean buzon) throws Exception {
		return V50bControladorFactory.getConfiguracion().fncEliminarConfiguracion(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncGuardarConfiguracion(V50bConfiguracionBean buzon) throws Exception {
		return V50bControladorFactory.getConfiguracion().fncGuardarConfiguracion(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarBuzon(V50bConfiguracionBean buzon) throws Exception {
		return V50bControladorFactory.getConfiguracion().fncModificarBuzon(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirBuzon(V50bConfiguracionBean buzon) throws Exception {
		return V50bControladorFactory.getConfiguracion().fncAniadirBuzon(buzon);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarConsultasBandejaEntrada</p>
	 * <p>Descripcin: Busca consultas filtrando con el formulario de Bandeja de Entrada</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return lista de consultas que pasan el filtro
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarConsultasBandejaEntrada(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscarConsultasBandejaEntrada() ");
		return V50bControladorFactory.getConsultas().fncBuscarConsultasBandejaEntrada(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNuevaConsulta</p>
	 * <p>Descripcin: Introduce una nueva consulta en la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a insertar
	 * @return Lista con el Entero con el resultado de la operacin y String con el cdigo de la consulta
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncNuevaConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncNuevaConsulta() ");
		return V50bControladorFactory.getConsultas().fncNuevaConsulta(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsulta</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncModificarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncModificarConsulta() ");
		return V50bControladorFactory.getConsultas().fncModificarConsulta(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsultaCatalogo</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 02/04/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarConsultaCatalogo(V50bConsultaBean form) throws Exception {
		return V50bControladorFactory.getConsultas().fncModificarConsultaCatalogo(form);
	}
	/**
	 * <p>Ttulo: fncVerFicheroConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroConsulta(String v50bCodigoConsulta) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncVerFicheroConsulta() ");
		return V50bControladorFactory.getConsultas().fncVerFicheroConsulta(v50bCodigoConsulta);
	}
	
	/**
	 * <p>Ttulo: fncVerFicheroDetalleConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 21/09/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @param tipo String
	 * @return Devuelve el lob
	 * @throws Exception Excepcin
	 */
	public V50bClsFichero fncVerFicheroDetalleConsulta(String v50bCodigoConsulta, String tipo) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncVerFicheroDetalleConsulta() ");
		return V50bControladorFactory.getConsultas().fncVerFicheroDetalleConsulta(v50bCodigoConsulta, tipo);
	}
	
	/**
	 * @param subcategorias : Subcategorias con los datos de busqueda 
	 * @return List: el resultado de la bsqueda
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception {
		return V50bControladorFactory.getSubcategorias().fncBuscarSubcategorias(subcategorias);
	}
	
	/**
	* @param subcategorias : Subcategorias con los datos a modificar 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception {
		return V50bControladorFactory.getSubcategorias().fncModificarSubcategorias(subcategorias);
	}
	
	/**
	* @param subcategorias : Subcategorias con los datos a agregar 
	* @return int: el resultado despus de agregar
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception {
		return V50bControladorFactory.getSubcategorias().fncAniadirSubcategorias(subcategorias);
	}
	
	/**
	 * @param subcategoria : subcategoria con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosSubcategoria(v50b.v50bBeans.V50bSubcategoriasBean subcategoria) throws Exception{
		return V50bControladorFactory.getSubcategorias().fncBuscarAmbitosSubcategoria(subcategoria);
	}

	
	/**
	 * @param profesiones : Profesiones con los datos de busqueda 
	 * @return List: el resultado de la bsqueda
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarProfesiones(V50bProfesionesBean profesiones) throws Exception {
		return V50bControladorFactory.getProfesiones().fncBuscarProfesiones(profesiones);
	}
	
	/**
	* @param profesiones : Profesiones con los datos a modificar 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarProfesiones(V50bProfesionesBean profesiones) throws Exception {
		return V50bControladorFactory.getProfesiones().fncModificarProfesiones(profesiones);
	}
	
	/**
	* @param profesiones : Profesiones con los datos a agregar 
	* @return int: el resultado despus de agregar
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirProfesiones(V50bProfesionesBean profesiones) throws Exception {
		return V50bControladorFactory.getProfesiones().fncAniadirProfesiones(profesiones);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarUsuariosRegistrados</p>
	 * <p>Descripcin: Busca usuarios registrados en base a un filtro</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Filtro de la bsqueda
	 * @return Lista resultados
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarUsuariosRegistrados(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscarUsuariosRegistrados() ");
		return V50bControladorFactory.getUsuariosRegistrados().fncBuscarUsuariosRegistrados(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleUsuarioRegistrado</p>
	 * <p>Descripcin: Busca los datos de un usuario</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form formulario con el cdigo del usuario
	 * @return Objeto con los datos del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bSuscriptorBean fncDetalleUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncDetalleUsuarioRegistrado() ");
		return V50bControladorFactory.getUsuariosRegistrados().fncDetalleUsuarioRegistrado(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNuevoUsuarioRegistrado</p>
	 * <p>Descripcin: Inserta en BDD un nuevo suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Detalle del usuario
	 * @return Lista con el resultado de la operacin y el cdigo del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public List fncNuevoUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncNuevoUsuarioRegistrado() ");
		return V50bControladorFactory.getUsuariosRegistrados().fncNuevoUsuarioRegistrado(form);
	}
		
	/**
	 * 
	 * <p>Ttulo: fncModificarUsuarioRegistrado</p>
	 * <p>Descripcin: Modifica un suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncModificarUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncModificarUsuarioRegistrado() ");
		return V50bControladorFactory.getUsuariosRegistrados().fncModificarUsuarioRegistrado(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncEliminarUsuarioRegistrado</p>
	 * <p>Descripcin: Elimina un suscriptor</p>
	 * <p>Copyright: Copyright (c) Abr 11, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param usuario Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncEliminarUsuarioRegistrado(V50bSuscriptorBean usuario) throws Exception {
		return V50bControladorFactory.getUsuariosRegistrados().fncEliminarUsuarioRegistrado(usuario);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncCargaEmailRemitente</p>
	 * <p>Descripcin: Obtiene el email del remitente</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @return String email del remitente
	 * @throws Exception Cualquier excepcin
	 */
	public String fncCargaEmailRemitente() throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncCargaEmailRemitente() ");
		return V50bControladorFactory.getUsuariosRegistrados().fncCargaEmailRemitente();
	}
	
	/**
	 * @param resolutores : Resolutores con los datos de busqueda 
	 * @return List: el resultado de la bsqueda
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarResolutores(V50bResolutoresBean resolutores) throws Exception {
		return V50bControladorFactory.getResolutores().fncBuscarResolutores(resolutores);
	}
	
	/**
	* @param resolutores : Resolutores con los datos a modificar 
	* @param usuario : usuario
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarResolutores(V50bResolutoresBean resolutores, String usuario) throws Exception {
		return V50bControladorFactory.getResolutores().fncModificarResolutores(resolutores, usuario);
	}
	
	/**
	* @param resolutores : Resolutores con los datos a agregar 
	* @return int: el resultado despus de agregar
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirResolutores(V50bResolutoresBean resolutores) throws Exception {
		return V50bControladorFactory.getResolutores().fncAniadirResolutores(resolutores);
	}
	
	/**
	 * @param resolutores : resolutores con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosResolutor(V50bResolutoresBean resolutores) throws Exception {
		return V50bControladorFactory.getResolutores().fncBuscarAmbitosResolutor(resolutores);
	}
	
	/**
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasEstadoConsultas(V50bConsultaBean consulta) throws Exception {
		return V50bControladorFactory.getConsultas().fncBuscarConsultasEstadoConsultas(consulta);
	}
	
	/**
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultadesAmbito(V50bConsultaBean consulta) throws Exception {
		return V50bControladorFactory.getConsultas().fncBuscarDificultadesAmbito(consulta);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTexto</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @param idioma Idioma de la sesin
	 * @return String El texto
	 * @throws Exception Cualquier excepcin
	 */
	public String fncObtenerTexto(String codigo, String idioma) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.enclosing_method() ");
		return V50bControladorFactory.getConfiguracion().fncObtenerTexto(codigo, idioma);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTextos</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo en ambos idiomas</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @return List Lista con los textos
	 * @throws Exception Cualquier excepcin
	 */
	public List fncObtenerTextos(String codigo) throws Exception{
		V50bClsTrazas.depura("V50bFachadaImpl.fncObtenerTextos() ");
		return V50bControladorFactory.getConfiguracion().fncObtenerTextos(codigo);
	}
	
	/**
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasCatalogoConsultas(V50bConsultaBean consulta) throws Exception {
		return V50bControladorFactory.getConsultas().fncBuscarConsultasCatalogoConsultas(consulta);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleConsulta</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return V50bConsultaBean Consulta detallada
	 * @throws Exception Cualquier excepcin
	 */
	public V50bConsultaBean fncDetalleConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncDetalleConsulta() ");
		return V50bControladorFactory.getConsultas().fncDetalleConsulta(form);
	}
	
	/**
	 * <p>Ttulo: fncComboSubcategoriaDificultad</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codAmbito Cdigo del mbito
	 * @param idioma Idioma de la sesin
	 * @return List Lista con las listas de los combos subcategora y dificultades
	 * @throws Exception Cualquier excepcin
	 */
	public List fncComboSubcategoriaDificultad(String codAmbito, String idioma) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncComboSubcategoriaDificultad() ");
		return V50bControladorFactory.getAmbitos().fncComboSubcategoriaDificultad(codAmbito, idioma);
	}
	
	/**
	 * <p>Ttulo: fncComboSubcategoriaResolutorDificultad</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito Cdigo del mbito
	 * @param idioma Idioma de la sesin
	 * @return List Lista con las listas de los combos subcategora y dificultades
	 * @throws Exception Cualquier excepcin
	 */
	public List fncComboSubcategoriaResolutorDificultad(String codAmbito, String idioma) throws Exception {
		return V50bControladorFactory.getAmbitos().fncComboSubcategoriaResolutorDificultad(codAmbito, idioma);
		
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSituacionResolutoresArea</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 4, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con el mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSituacionResolutoresArea(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscSituacionResolutoresArea() ");
		return V50bControladorFactory.getResolutores().fncBuscSituacionResolutoresArea(form);
	}
	
	/**
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategoriasAmbito(V50bConsultaBean consulta) throws Exception {
		return V50bControladorFactory.getConsultas().fncBuscarSubcategoriasAmbito(consulta);
	}
	
	/**
	 * @author alata
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasHistoricoConsultas(V50bConsultaBean consulta) throws Exception {
		return V50bControladorFactory.getConsultas().fncBuscarConsultasHistoricoConsultas(consulta);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncAsignarResolutor</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Lista con los datos de comunicacin al usuario y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncAsignarResolutor(V50bConsultaBean form) throws Exception{
		V50bClsTrazas.depura("V50bFachadaImpl.fncAsignarResolutor() ");
		return V50bControladorFactory.getConsultas().fncAsignarResolutor(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncReenviarConsulta</p>
	 * <p>Descripcin: Reenva una consulta a otro resolutor</p>
	 * <p>Copyright: Copyright (c) 07/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos para el reenvo
	 * @return Lista con los datos de comunicacin al suscriptor y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncReenviarConsulta(V50bConsultaBean form) throws Exception{
		V50bClsTrazas.depura("V50bFachadaImpl.fncReenviarConsulta() ");
		return V50bControladorFactory.getConsultas().fncReenviarConsulta(form);
	}
	
	/**
	 * @author alata
	 * @param consulta : Formulario con los datos de la consulta
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarVisibleInternet(V50bConsultaBean consulta) throws Exception {
		return V50bControladorFactory.getConsultas().fncModificarVisibleInternet(consulta);
	}
	
	/**
	 * @author alata
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception {
		return V50bControladorFactory.getConsultas().fncVisibleInternetHistConsultas(consultas, seleccionadas);
	}
	
	/**
	 * @author alata
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncNoVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception {
		return V50bControladorFactory.getConsultas().fncNoVisibleInternetHistConsultas(consultas, seleccionadas);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncResponderConsulta</p>
	 * <p>Descripcin: Responde a una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la respuesta
	 * @return List Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public List fncResponderConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncResponderConsulta() ");
		return V50bControladorFactory.getConsultas().fncResponderConsulta(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDenegarConsulta</p>
	 * <p>Descripcin: Deniega una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncDenegarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncDenegarConsulta() ");
		return V50bControladorFactory.getConsultas().fncDenegarConsulta(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncRechazarConsulta</p>
	 * <p>Descripcin: Rechaza una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncRechazarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncRechazarConsulta() ");
		return V50bControladorFactory.getConsultas().fncRechazarConsulta(form);
	}
	
	/**
	 * <p>Ttulo: fncCatalogarConsulta</p>
	 * <p>Descripcin: Catalogar una consulta</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a cataloogar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncCatalogarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncCatalogarConsulta() ");
		return V50bControladorFactory.getConsultas().fncCatalogarConsulta(form);
	}
	
	/**
	 * <p>Ttulo: fncObtenerPeriodoServInactivo</p>
	 * <p>Descripcin: Catalogar una consulta</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author iurkidi
	 * @version 1.0
	 * @param bean bean
	 * @return V50bCalendarioBean fechas de periodo inactivo
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncObtenerPeriodoServInactivo(V50bCalendarioBean bean) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncObtenerPeriodoServInactivo() ");
		return V50bControladorFactory.getCalendario().fncObtenerPeriodoServInactivo(bean);
	}
	
	/**
	 * <p>Ttulo: fncSolicitarInformacion</p>
	 * <p>Descripcin: solicitar informacin adicional a un tcnico o a un suscriptor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la info adicional
	 * @param tipoDest String con el tipo de destinatario (T)Tecnico/(S)Suscriptor
	 * @return List lista con los datos de comunicacin y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncSolicitarInformacion(V50bConsultaBean form, String tipoDest) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncSolicitarInformacion() ");
		return V50bControladorFactory.getConsultas().fncSolicitarInformacion(form, tipoDest);
	}
	/**
	 * 
	 * <p>Ttulo: fncObtenerDatosGraficos</p>
	 * <p>Descripcin: obtener los datos necesarios para rellenar el grafico</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 *  
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico parametro de entrada
	 * @return List parametro de salida
	 * @throws Exception excepcion
	 */
	public List fncObtenerDatosGraficos(V50bCriteriosConsultaBean criteriosGrafico) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncObtenerDatosGraficos() ");
		return V50bControladorFactory.getGraficos().fncObtenerDatosGraficos(criteriosGrafico);
	}

	/**
	 * 
	 * <p>Ttulo: fncBuscSitResolutores</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 10, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito String con el codigo de mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSitResolutores(String codAmbito) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscSitResolutores() ");
		return V50bControladorFactory.getResolutores().fncBuscSitResolutores(codAmbito);
	}
	
	/**
	 * <p>Ttulo: fncGuardarCalendario</p>
	 * <p>Descripcin: guardamos cambios del calendario</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author iurkidi
	 * @version 1.0
	 * @param lista lista con datos
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncGuardarCalendario(ArrayList lista) throws Exception{
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscSitResolutores() ");
		return V50bControladorFactory.getCalendario().fncGuardarCalendario(lista);
	}
	
	/**
	 * <p>Ttulo: fncBuscarNotificaciones</p>
	 * <p>Descripcin: Busca las notificaciones de una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param consulta La consulta
	 * @return List Lista con las notificaciones
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarNotificaciones(V50bConsultaBean consulta) throws Exception{
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscarNotificaciones() ");
		return V50bControladorFactory.getConsultas().fncBuscarNotificaciones(consulta);
	}
	
	/**
	 * <p>Ttulo: fncRespondeNotificacion</p>
	 * <p>Descripcin: Responde una notificacin</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param respuesta La respuesta
	 * @return List Datos de la comunicacin y Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public List fncRespondeNotificacion(V50bNotificacionBean respuesta) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncRespondeNotificacion() ");
		return V50bControladorFactory.getConsultas().fncRespondeNotificacion(respuesta);
	}

	/**
	 * <p>Ttulo: fncBuscar24Horas</p>
	 * <p>Descripcin: Busca consultas 24 Horas</p>
	 * <p>Copyright: Copyright (c) Dec 22, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscar24Horas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)
			throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscar24Horas() ");
		return V50bControladorFactory.getConsultas().fncBuscar24Horas(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
	}
	
	/**
	 * <p>Ttulo: fncBuscarPendientes</p>
	 * <p>Descripcin: Busca consultas Pendientes</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarPendientes(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)
			throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscarPendientes() ");
		return V50bControladorFactory.getConsultas().fncBuscarPendientes(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
	
	}
	
	/**
	 * <p>Ttulo: fncBuscarRetrasadas</p>
	 * <p>Descripcin: Busca consultas Retrasadas</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarRetrasadas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)
			throws Exception {
		
		V50bClsTrazas.depura("V50bFachadaImpl.fncBuscarRetrasadas() ");
		return V50bControladorFactory.getConsultas().fncBuscarRetrasadas(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
	
	}

	/**
	 * Realiza una consulta 
	 * @author brey
	 * @param encuestaBean V50bEncuestaBean: Objeto bean donde se contienen los datos
	 * @return List: lista resultado
	 * @throws Exception SE ELEVA LA EXCEPXION
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBusqEncuestas(V50bEncuestaBean encuestaBean)
			throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncBusqEncuestas() ");
		return V50bControladorFactory.getEncuestas().fncBusqEncuestas(encuestaBean);
	}

	/**
	 * Recupera un fichero
	 * @author brey
	 * @param encuestas V50bEncuestaBean: Objeto bean donde se contienen los datos
	 * @return List: lista resultado
	 * @throws Exception SE ELEVA LA EXCEPXION
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncExcelEncuestasResultados(V50bEncuestaBean encuestas)
			throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncExcelEncuestasResultados() ");
		return V50bControladorFactory.getEncuestas().fncExcelEncuestasResultados(encuestas);
	}

	/**
	   * Recupera un fichero
	   * @author brey
	   * @param encuestas String: Sentencia SQL a lanzar
	   * @return String: el resultado de la select (un campo). "" si es vaco.
	   * @throws Exception Se eleva la excepcion
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	public List fncCargarEncuesta(V50bEncuestaBean encuestas) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncCargarEncuesta() ");
		return V50bControladorFactory.getEncuestas().fncCargarEncuesta(encuestas);
	}
	
	/**
	 * <p>Ttulo: fncEliminarEncuesta</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Eliminar encuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return int
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public int fncEliminarEncuesta(V50bEncuestaBean encuestaBean) throws Exception {
		return V50bControladorFactory.getEncuestas().fncEliminarEncuesta(encuestaBean);
	}
	
	/**
	 * <p>Ttulo: fncCopiarEncuesta</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: copia encuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return long
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public long fncCopiarEncuesta(V50bEncuestaBean encuestaBean) throws Exception {
		return V50bControladorFactory.getEncuestas().fncCopiarEncuesta(encuestaBean);
	}
	
	/**
	 * <p>Ttulo: fncBusqPreguntas</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Busca preguntas</p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public List fncBusqPreguntas(V50bEncuestaBean encuestaBean)throws Exception {
		return V50bControladorFactory.getEncuestas().fncBusqPreguntas(encuestaBean);
	}
	
	/**
	 * <p>Ttulo: fncVerFicheroNotif</p>
	 * <p>Descripcin: Obtiene el lob de la notificacin</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoNotif Cdigo de la notificacin
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroNotif(String v50bCodigoNotif) throws Exception {
		V50bClsTrazas.depura("V50bFachadaImpl.fncVerFicheroNotif() ");
		return V50bControladorFactory.getConsultas().fncVerFicheroNotif(v50bCodigoNotif);
	}
	
	/**
	 * <p>Ttulo: fncModificarPreguntas</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: modifica preguntas</p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @param listaPreguntas ArrayList
	 * @throws Exception excepcin
	 */
	public List fncModificarPreguntas(V50bEncuestaBean encuestaBean, ArrayList listaPreguntas) throws Exception {
		return V50bControladorFactory.getEncuestas().fncModificarPreguntas(encuestaBean, listaPreguntas);
	}
	
	/**
	 * <p>Ttulo: fncBusqRespuestas</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Busca respuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public List fncBusqRespuestas(V50bEncuestaBean encuestaBean) throws Exception {
		return V50bControladorFactory.getEncuestas().fncBusqRespuestas(encuestaBean);
	}
	
	/**
	 * <p>Ttulo: fncModificarRespuestas</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Modificar respuesta</p>
	 * @author alata
	 * @version 1.0
	 * @return int
	 * @param listaRespuestas ArrayList
	 * @throws Exception excepcin
	 */
	public int fncModificarRespuestas(ArrayList listaRespuestas) throws Exception {
		return V50bControladorFactory.getEncuestas().fncModificarRespuestas(listaRespuestas);
	}
	
	/**
	 * <p>Ttulo: fncGuardarEncuestaResultados</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Recupera un fichero</p>
	 * @author brey
	 * @version 1.0
	 * @return String: el resultado de la select (un campo). "" si es vaco.
	 * @param respuestas String: Sentencia SQL a lanzar	 
	 * @throws Exception Se eleva la excepcion
	 */
	public int fncGuardarEncuestaResultados(V50bRespuestasBean respuestas) throws Exception{
		return V50bControladorFactory.getEncuestas().fncGuardarEncuestaResultados(respuestas);
	}

	/**
	 * <p>Ttulo: fncObtenerDatosAmbitos</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Obtiene la lista de ambitos </p>
	 * @author mmonge
	 * @version 1.0
	 * @return List lista con los ambitos
	 * @param idioma idioma	 
	 * @throws Exception excepcion
	 */
	public List fncObtenerDatosAmbitos(String idioma) throws Exception {
		return V50bControladorFactory.getGraficos().fncObtenerDatosAmbitos(idioma);

	}
	
}

