package v50b.v50bControlador;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bAmbitoBean;
import v50b.v50bBeans.V50bCalendarioBean;
import v50b.v50bBeans.V50bConfiguracionBean;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bCriteriosConsultaBean;
import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bBeans.V50bMotivosBean;
import v50b.v50bBeans.V50bNotificacionBean;
import v50b.v50bBeans.V50bProfesionesBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bBeans.V50bRespuestasBean;
import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bBeans.V50bTipoTrabajoBean;
import v50b.v50bClasesComunes.V50bClsFichero;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;



/**
 * The Interface V50bFachada.
 * 
 * @author iurkidi
 */
public interface V50bFachada {


	/**
	 * @param ambito : ambito con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitos(V50bAmbitoBean ambito) throws Exception;
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarAmbito(V50bAmbitoBean ambito) throws Exception;
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la insert
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirAmbito(V50bAmbitoBean ambito) throws Exception;
	
	/**
	 * @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception;
	
	/**
	* @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception;
	
	/**
	* @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	* @return int: el resultado de la insert
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception;
	
	/**
	 * fncObtenerPerfilUsuario
	 * @param usuarioBean :usuario logueado
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncObtenerPerfilUsuario(V50bUsuarioBean usuarioBean) throws Exception;
	
	/**
	 * @param motivo : motivo con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarMotivos(V50bMotivosBean motivo) throws Exception;
	
	/**
	* @param motivo : motivo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarMotivos(V50bMotivosBean motivo) throws Exception;
	
	/**
	* @param motivo : motivo con los datos de busqueda 
	* @return int: el resultado de la insert
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirMotivos(V50bMotivosBean motivo) throws Exception;
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultad(V50bDificultadBean dificultad) throws Exception;
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarDificultad(V50bDificultadBean dificultad) throws Exception;
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirDificultad(V50bDificultadBean dificultad) throws Exception;
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosDificultad(V50bDificultadBean dificultad) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfiguracion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfigTextos(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarConfiguracion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncGuardarConfiguracion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarBuzon(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirBuzon(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarConsultasBandejaEntrada</p>
	 * <p>Descripcin: Busca consultas filtrando con el formulario de Bandeja de Entrada</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return lista de consultas que pasan el filtro
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarConsultasBandejaEntrada(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncNuevaConsulta</p>
	 * <p>Descripcin: Introduce una nueva consulta en la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a insertar
	 * @return Lista con el Entero con el resultado de la operacin y String con el cdigo de la consulta
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncNuevaConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsulta</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncModificarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsultaCatalogo</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 02/04/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarConsultaCatalogo(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncVerFicheroConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroConsulta(String v50bCodigoConsulta) throws Exception;
	
	/**
	 * <p>Ttulo: fncVerFicheroDetalleConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 21/09/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @param tipo String
	 * @return Devuelve el lob
	 * @throws Exception Excepcin
	 */
	public V50bClsFichero fncVerFicheroDetalleConsulta(String v50bCodigoConsulta, String tipo) throws Exception;
	
	/**
	 * @param subcategorias : Subcategorias con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception;
	
	/**
	* @param subcategorias : Subcategorias con los datos a modificar
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception;
	
	/**
	* @param subcategorias : Subcategorias con los datos a agregar 
	* @return int: el resultado de agregar los datos
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirSubcategorias(V50bSubcategoriasBean subcategorias) throws Exception;
	
	/**
	 * Lanza una consulta sencilla con statement que devuelve una lista 
	 * 
	 * @param subcategoria : subcategoria con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	  public List fncBuscarAmbitosSubcategoria(v50b.v50bBeans.V50bSubcategoriasBean subcategoria) throws Exception;
	  
	/**
	 * @param profesiones : Profesiones con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarProfesiones(V50bProfesionesBean profesiones) throws Exception;
	
	/**
	* @param profesiones : Profesiones con los datos a modificar
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarProfesiones(V50bProfesionesBean profesiones) throws Exception;
	
	/**
	* @param profesiones : Profesiones con los datos a agregar 
	* @return int: el resultado de agregar los datos
	* @throws Exception Se eleva la excepcin.
	*/

	public int fncAniadirProfesiones(V50bProfesionesBean profesiones) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarUsuariosRegistrados</p>
	 * <p>Descripcin: Busca usuarios registrados en base a un filtro</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Filtro de la bsqueda
	 * @return Lista resultados
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarUsuariosRegistrados(V50bSuscriptorBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleUsuarioRegistrado</p>
	 * <p>Descripcin: Busca los datos de un usuario</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form formulario con el cdigo del usuario
	 * @return Objeto con los datos del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bSuscriptorBean fncDetalleUsuarioRegistrado(V50bSuscriptorBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncNuevoUsuarioRegistrado</p>
	 * <p>Descripcin: Inserta en BDD un nuevo suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Detalle del usuario
	 * @return Lista con el resultado de la operacin y el cdigo del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public List fncNuevoUsuarioRegistrado(V50bSuscriptorBean form) throws Exception;
		
	/**
	 * 
	 * <p>Ttulo: fncModificarUsuarioRegistrado</p>
	 * <p>Descripcin: Modifica un suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncModificarUsuarioRegistrado(V50bSuscriptorBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncEliminarUsuarioRegistrado</p>
	 * <p>Descripcin: Elimina un suscriptor</p>
	 * <p>Copyright: Copyright (c) Abr 11, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param usuario Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncEliminarUsuarioRegistrado(V50bSuscriptorBean usuario) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncCargaEmailRemitente</p>
	 * <p>Descripcin: Obtiene el email del remitente</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @return String email del remitente
	 * @throws Exception Cualquier excepcin
	 */
	public String fncCargaEmailRemitente() throws Exception;
	
	/**
	 * 
	 * @param resolutores :Resolutores con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	
	public List fncBuscarResolutores(V50bResolutoresBean resolutores) throws Exception; 
	
	/**
	* @param resolutores : Resolutores con los datos de la modificacin 
	* @param usuario : usuario
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarResolutores(V50bResolutoresBean resolutores, String usuario) throws Exception;
	
	/**
	* @param resolutores : Resolutores con los datos a agregar 
	* @return int: el resultado de aadir registro
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirResolutores(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	 * @param resolutores : resolutores con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosResolutor(V50bResolutoresBean resolutores) throws Exception;
	
	/**
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasEstadoConsultas(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTexto</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @param idioma Idioma de la sesin
	 * @return String El texto
	 * @throws Exception Cualquier excepcin
	 */
	public String fncObtenerTexto(String codigo, String idioma) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTextos</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo en ambos idiomas</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @return List Lista con los textos
	 * @throws Exception Cualquier excepcin
	 */
	public List fncObtenerTextos(String codigo) throws Exception;
	
	/**
	 * @author acompes
	 * @version 1.0
	 * @param consulta contiene los datos de bsqueda
	 * @return List
	 * @throws Exception se eleva la excepcin
	 */
	
	public List fncBuscarConsultasCatalogoConsultas(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleConsulta</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return V50bConsultaBean Consulta detallada
	 * @throws Exception Cualquier excepcin
	 */
	public V50bConsultaBean fncDetalleConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncComboSubcategoriaDificultad</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codAmbito Cdigo del mbito
	 * @param idioma Idioma de la sesin
	 * @return List Lista con las listas de los combos subcategora y dificultades
	 * @throws Exception Cualquier excepcin
	 */
	public List fncComboSubcategoriaDificultad(String codAmbito, String idioma) throws Exception;
	
	/**
	 * <p>Ttulo: fncComboSubcategoriaResolutorDificultad</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito Cdigo del mbito
	 * @param idioma Idioma de la sesin
	 * @return List Lista con las listas de los combos subcategora y dificultades
	 * @throws Exception Cualquier excepcin
	 */
	public List fncComboSubcategoriaResolutorDificultad(String codAmbito, String idioma) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSituacionResolutoresArea</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 4, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con el mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSituacionResolutoresArea(V50bConsultaBean form) throws Exception;
	
	/**
	 * @author acompes
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultadesAmbito(V50bConsultaBean consulta) throws Exception;
	
	
	/**
	 * @author acompes
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategoriasAmbito(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @author alata
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasHistoricoConsultas(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncAsignarResolutor</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Lista con los datos de comunicacin al usuario y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncAsignarResolutor(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncReenviarConsulta</p>
	 * <p>Descripcin: Reenva una consulta a otro resolutor</p>
	 * <p>Copyright: Copyright (c) 07/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos para el reenvo
	 * @return Lista con los datos de comunicacin al suscriptor y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncReenviarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * @author alata
	 * @param consulta : Formulario con los datos de la consulta
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarVisibleInternet(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @author alata
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception;
	
	/**
	 * @author alata
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncNoVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncResponderConsulta</p>
	 * <p>Descripcin: Responde a una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la respuesta
	 * @return List Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public List fncResponderConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncDenegarConsulta</p>
	 * <p>Descripcin: Deniega una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncDenegarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncRechazarConsulta</p>
	 * <p>Descripcin: Rechaza una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncRechazarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncCatalogarConsulta</p>
	 * <p>Descripcin: Catalogar una consulta</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a cataloogar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncCatalogarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncObtenerPeriodoServInactivo</p>
	 * <p>Descripcin: obtiene fechas de periodo inactivo</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author iurkidi
	 * @version 1.0
	 * @param bean bean
	 * @return V50bCalendarioBean fechas de periodo inactivo
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncObtenerPeriodoServInactivo(V50bCalendarioBean bean) throws Exception;
	
	/**
	 * <p>Ttulo: fncSolicitarInformacion</p>
	 * <p>Descripcin: solicitar informacin adicional a un tcnico o a un suscriptor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la info adicional
	 * @param tipoDest String con el tipo de destinatario (T)Tecnico/(S)Suscriptor
	 * @return List lista con los datos de comunicacin y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncSolicitarInformacion(V50bConsultaBean form, String tipoDest) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerDatosGraficos</p>
	 * <p>Descripcin: obtener los datos necesarios para rellenar el grafico</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 *  
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosGrafico parametro de entrada
	 * @return List parametro de salida
	 * @throws Exception excepcion
	 */
	public List fncObtenerDatosGraficos(V50bCriteriosConsultaBean criteriosGrafico)throws Exception;
	
	

	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 26, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param idioma idioma
	 * @return List lista
	 * @throws Exception exception
	 */
	public List fncObtenerDatosAmbitos(String idioma)throws Exception;

	
	/**
	 * 
	 * <p>Ttulo: fncBuscSitResolutores</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 10, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito String con el codigo de mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSitResolutores(String codAmbito) throws Exception;
	
	/**
	 * <p>Ttulo: fncGuardarCalendario</p>
	 * <p>Descripcin: guardamos cambios del calendario</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author iurkidi
	 * @version 1.0
	 * @param lista lista con datos
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncGuardarCalendario(ArrayList lista) throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscarNotificaciones</p>
	 * <p>Descripcin: Busca las notificaciones de una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param consulta La consulta
	 * @return List Lista con las notificaciones
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarNotificaciones(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * <p>Ttulo: fncRespondeNotificacion</p>
	 * <p>Descripcin: Responde una notificacin</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param respuesta La respuesta
	 * @return List Datos de la comunicacin y Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public List fncRespondeNotificacion(V50bNotificacionBean respuesta) throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscar24Horas</p>
	 * <p>Descripcin: Busca consultas 24 Horas</p>
	 * <p>Copyright: Copyright (c) Dec 22, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscar24Horas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws Exception;

	/**
	 * <p>Ttulo: fncBuscarPendientes</p>
	 * <p>Descripcin: Busca consultas Pendientes</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarPendientes(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscarRetrasadas</p>
	 * <p>Descripcin: Busca consultas Retrasadas</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarRetrasadas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws Exception;
	
	/**
	 * Realiza una consulta 
	 * @author brey
	 * @param encuestaBean V50bEncuestaBean: Objeto bean donde se contienen los datos
	 * @return List: lista resultado
	 * @throws Exception SE ELEVA LA EXCEPXION
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBusqEncuestas(V50bEncuestaBean encuestaBean)throws Exception;
	
	/**
	 * Recupera un fichero
	 * @author brey
	 * @param encuestas String: Sentencia SQL a lanzar
	 * @return String: el resultado de la select (un campo). "" si es vaco.
	 * @throws Exception Se eleva la excepcion
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	 public List fncExcelEncuestasResultados(V50bEncuestaBean encuestas) throws Exception;
	 
	 /**
	   * Recupera un fichero
	   * @author brey
	   * @param encuestas String: Sentencia SQL a lanzar
	   * @return String: el resultado de la select (un campo). "" si es vaco.
	   * @throws Exception Se eleva la excepcion
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncCargarEncuesta(V50bEncuestaBean encuestas) throws Exception;
	  
	  /**
		 * <p>Ttulo: fncEliminarEncuesta</p>
		 * <p>Empresa: Eurohelp </p>
		 * <p>Descripcin: Eliminar encuesta</p>
		 * @author brey
		 * @version 1.0
		 * @return int
		 * @param encuestaBean V50bEncuestaBean
		 * @throws Exception excepcin
		 */
	  public int fncEliminarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
	  
	  /**
		 * <p>Ttulo: fncCopiarEncuesta</p>
		 * <p>Empresa: Eurohelp </p>
		 * <p>Descripcin: copia encuesta</p>
		 * @author brey
		 * @version 1.0
		 * @return long
		 * @param encuestaBean V50bEncuestaBean
		 * @throws Exception excepcin
		 */
		public long fncCopiarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
		
		/**
		 * <p>Ttulo: fncBusqPreguntas</p>
		 * <p>Empresa: Eurohelp </p>
		 * <p>Descripcin: Busca preguntas</p>
		 * @author brey
		 * @version 1.0
		 * @return List
		 * @param encuestaBean V50bEncuestaBean
		 * @throws Exception excepcin
		 */
		public List fncBusqPreguntas(V50bEncuestaBean encuestaBean)throws Exception;
		
		/**
		 * <p>Ttulo: fncVerFicheroNotif</p>
		 * <p>Descripcin: Obtiene el lob de la notificacin</p>
		 * <p>Copyright: Copyright (c) 30/10/2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author llaparra
		 * @version 1.0
		 * @param v50bCodigoNotif Cdigo de la notificacin
		 * @return Devuelve el lob
		 * @throws Exception Cualquier excepcin
		 */
		public V50bClsFichero fncVerFicheroNotif(String v50bCodigoNotif) throws Exception;
		
		/**
		 * <p>Ttulo: fncModificarPreguntas</p>
		 * <p>Empresa: Eurohelp </p>
		 * <p>Descripcin: modifica preguntas</p>
		 * @author brey
		 * @version 1.0
		 * @return List
		 * @param encuestaBean V50bEncuestaBean
		 * @param listaPreguntas ArrayList
		 * @throws Exception excepcin
		 */
		public List fncModificarPreguntas(V50bEncuestaBean encuestaBean, ArrayList listaPreguntas) throws Exception;
		
		/**
		 * <p>Ttulo: fncBusqRespuestas</p>
		 * <p>Empresa: Eurohelp </p>
		 * <p>Descripcin: Busca respuesta</p>
		 * @author brey
		 * @version 1.0
		 * @return List
		 * @param encuestaBean V50bEncuestaBean
		 * @throws Exception excepcin
		 */
		public List fncBusqRespuestas(V50bEncuestaBean encuestaBean) throws Exception;
		
		/**
		 * <p>Ttulo: fncModificarRespuestas</p>
		 * <p>Empresa: Eurohelp </p>
		 * <p>Descripcin: Modificar respuesta</p>
		 * @author alata
		 * @version 1.0
		 * @return int
		 * @param listaRespuestas ArrayList
		 * @throws Exception excepcin
		 */
		public int fncModificarRespuestas(ArrayList listaRespuestas) throws Exception;
		
		/**
		 * Recupera un fichero
		 * @author brey
		 * @param respuestas String: Sentencia SQL a lanzar
		 * @return String: el resultado de la select (un campo). "" si es vaco.
		 * @throws Exception Se eleva la excepcion
		 *
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 *
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public int fncGuardarEncuestaResultados(V50bRespuestasBean respuestas) throws Exception;
		
}
