package v50b.v50bControlador;

import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bBeans.V50bRespuestasBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * 
 * @author brey
 *
 */
public class V50bEncuestasImpl implements V50bEncuestas {
	
	/**
	 * <p>
	 * Ttulo: fncBusqEncuestas
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             excepcin
	 */


	public List fncBusqEncuestas(V50bEncuestaBean encuestaBean) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasImpl.fncBusqEncuestas()");
		return V50bDAOFactory.getEncuestasDAO().fncBusqEncuestas(encuestaBean);
	}
	
	
	/**
	 * <p>
	 * Ttulo: fncGuardarEncuesta
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return long
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             excepcin
	 */
	public long fncGuardarEncuesta(V50bEncuestaBean encuestaBean) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasImpl.fncGuardarEncuesta()");
		long resultado=0;
		boolean activaEnBD = false;
		
		if(encuestaBean.getStrEstado()!=null && !encuestaBean.getStrEstado().equals("")){
			if(encuestaBean.getStrEstado().equals(V50bClsConstantes.CONSTANTE_ACTIVA)){
				/*con fncObtenerActivaBD obtenemos el numero de la encuesta activa. Hay que tener
				 *en cuenta q podriamos estar modificando la unica encuesta activa y deberia 
				 *dejarnos*/  
				if(V50bDAOFactory.getEncuestasDAO().fncObtenerActivaBD(encuestaBean)!=null && !V50bDAOFactory.getEncuestasDAO().fncObtenerActivaBD(encuestaBean).equals("") && !V50bDAOFactory.getEncuestasDAO().fncObtenerActivaBD(encuestaBean).equals(encuestaBean.getStrNumEncuesta())) {
					activaEnBD=true;
					encuestaBean.setStrEstado(V50bClsConstantes.CONSTANTE_INACTIVA);					
				}				
			}						
		} else {
			encuestaBean.setStrEstado(V50bClsConstantes.CONSTANTE_INACTIVA);
		}
		
		if (encuestaBean.getModo().equals(V50bClsConstantes.MODO_ALTA)){
			String nuevoNumEncuesta = V50bDAOFactory.getEncuestasDAO().fncGenerarNumeroEncuesta();
			resultado = V50bDAOFactory.getEncuestasDAO().fncAgregarNuevaEncuesta(nuevoNumEncuesta, encuestaBean);
			if(resultado>=0){
				resultado=Long.parseLong(nuevoNumEncuesta);
			}
		} else if (encuestaBean.getModo().equals(V50bClsConstantes.MODO_MODIFICAR)){
			resultado = V50bDAOFactory.getEncuestasDAO().fncModificarEncuesta(encuestaBean);
			if(resultado>=0){
				resultado=Long.parseLong(encuestaBean.getStrNumEncuesta());
			}
		} else {
			resultado = 0;
		}
		
		if(resultado > 0 && activaEnBD) {
			return (-1)*resultado;				
		}else{
			return resultado;				
		}
	}
	
	/**
	 * <p>
	 * Ttulo: fncEliminarEncuesta
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return int
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             excepcin
	 */
	public int fncEliminarEncuesta(V50bEncuestaBean encuestaBean) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasImpl.fncEliminarEncuesta()");
		V50bDAOFactory.getEncuestasDAO().fncEliminarTodasRespuestasCorrelativo(encuestaBean);
		V50bDAOFactory.getEncuestasDAO().fncEliminarTodasRespuestas(encuestaBean);
		V50bDAOFactory.getEncuestasDAO().fncEliminarTodasPregunta(encuestaBean);
		return V50bDAOFactory.getEncuestasDAO().fncEliminarEncuesta(encuestaBean);		
	}
	
	/**
	 * <p>
	 * Ttulo: fncCopiarEncuesta
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return long
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             excepcin
	 */
	public long fncCopiarEncuesta(V50bEncuestaBean encuestaBean) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasImpl.fncCopiarEncuesta()");
		int resultado = 0;
		boolean activaEnBD = false;
		
		if(encuestaBean.getStrEstado()!=null && !encuestaBean.getStrEstado().equals("")){
			if(encuestaBean.getStrEstado().equals(V50bClsConstantes.CONSTANTE_ACTIVA)){
				if(V50bDAOFactory.getEncuestasDAO().fncComprobarActivaBD(encuestaBean).equals("1")) {
					activaEnBD=true;
					encuestaBean.setStrEstado(V50bClsConstantes.CONSTANTE_INACTIVA);					
				}				
			}						
		}else{
			encuestaBean.setStrEstado(V50bClsConstantes.CONSTANTE_INACTIVA);
		}

		String nuevoNumEncuesta = V50bDAOFactory.getEncuestasDAO().fncGenerarNumeroEncuesta();
		
		resultado = V50bDAOFactory.getEncuestasDAO().fncCopiarCamposEncuesta(nuevoNumEncuesta, encuestaBean);
		resultado += V50bDAOFactory.getEncuestasDAO().fncCopiarCamposPregunta(nuevoNumEncuesta, encuestaBean);
		resultado += V50bDAOFactory.getEncuestasDAO().fncCopiarCamposRespuesta(nuevoNumEncuesta, encuestaBean);
		resultado += V50bDAOFactory.getEncuestasDAO().fncCopiarCamposRespuestaSeleccionadas(nuevoNumEncuesta, encuestaBean);
		
		if(activaEnBD) {
			return (-1)*Long.valueOf(nuevoNumEncuesta).longValue();				
		}else{
			return Long.valueOf(nuevoNumEncuesta).longValue();				
		}
		

	}
	
	/**
	 * <p>
	 * Ttulo: fncBusqPreguntas
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             excepcin
	 */
	public List fncBusqPreguntas(V50bEncuestaBean encuestaBean)throws Exception {
		V50bClsTrazas.depura("V50bEncuestasImpl.fncBusqPreguntas()");
		return V50bDAOFactory.getEncuestasDAO().fncBusqPreguntas(encuestaBean);
	}
	
	/**
	 * <p>
	 * Ttulo: fncModificarPreguntas
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encBean
	 *            V50bEncuestaBean
	 * @param listaPreguntas
	 *            ArrayList
	 * @throws Exception
	 *             excepcin
	 */
	public List fncModificarPreguntas(V50bEncuestaBean encBean, List listaPreguntas) throws Exception {
		
		final List listResultado=new ArrayList();
		int resultado = 0;
		
		//Guardamos los datos de la encuesta
		long resultLong=this.fncGuardarEncuesta(encBean);
		/*
		if (!V50bClsConstantes.MODO_ALTA.equals(encBean.getModo())){
			for(int i=0;i<listaPreguntas.size();i++){
				V50bEncuestaBean encuestaBean = (V50bEncuestaBean)listaPreguntas.get(i);
				if(encBean.getModo().equals(V50bClsConstantes.MODO_ELIMINAR)){
					System.out.println("eliminar: "+encuestaBean);
				}
			}
		//	numEliminadas =V50bDAOFactory.getEncuestasDAO().fncEliminarTodasPregunta(encBean);
		}
		V50bClsTrazas.depura (String.valueOf(numEliminadas));
		*/
		//Altas y bajas de las preguntas
		for(int i=0;i<listaPreguntas.size();i++){
			V50bEncuestaBean encuestaBean = (V50bEncuestaBean)listaPreguntas.get(i);
			
			//si el atributo modo es BD, es una pregunta q viene de BD
			if(encuestaBean.getModo()!=null && ! encuestaBean.getModo().equals("BD")) {
				if(encuestaBean.getModo().equals(V50bClsConstantes.MODO_ALTA)) {
					if(resultLong>0){
						encuestaBean.setStrNumEncuesta(String.valueOf(resultLong));
					}else if (resultLong<0){
						encuestaBean.setStrNumEncuesta(String.valueOf(resultLong*(-1)));
					}
					resultado = V50bDAOFactory.getEncuestasDAO().fncAgregarNuevaPregunta(encuestaBean);
					encuestaBean.setStrNumPregunta(String.valueOf(resultado));
					encuestaBean.setModo("BD");
					listaPreguntas.set(i, encuestaBean);
				}else if(encuestaBean.getModo().equals(V50bClsConstantes.MODO_MODIFICAR)) { 
					if(encuestaBean.getStrNumPregunta()!=null && ! encuestaBean.getStrNumPregunta().equals("")) {
						resultado += V50bDAOFactory.getEncuestasDAO().fncModificarPregunta(encuestaBean);						
					}else {
						resultado = V50bDAOFactory.getEncuestasDAO().fncAgregarNuevaPregunta(encuestaBean);
						encuestaBean.setStrNumPregunta(String.valueOf(resultado));
						listaPreguntas.set(i, encuestaBean);
					}	
				}else if(encuestaBean.getModo().equals(V50bClsConstantes.MODO_ELIMINAR)) {
					V50bDAOFactory.getEncuestasDAO().fncEliminarRespuestasPregunta(encuestaBean);
					resultado += V50bDAOFactory.getEncuestasDAO().fncEliminarPregunta(encuestaBean);
				}	
			}
			else{//puede que el orden de la pregunta haya cambiado
				resultado += V50bDAOFactory.getEncuestasDAO().fncModificarPregunta(encuestaBean);
			}
			
		}
		listResultado.add(new Long(resultLong));
		listResultado.add(listaPreguntas);
		return listResultado;		
	}
	
	/**
	 * <p>
	 * Ttulo: fncBusqRespuestas
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             excepcin
	 */
	public List fncBusqRespuestas(V50bEncuestaBean encuestaBean) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasImpl.fncBusqRespuestas()");
		if (!encuestaBean.getModo().equals(V50bClsConstantes.MODO_ALTA)) {
			return V50bDAOFactory.getEncuestasDAO().fncBusqRespuestas(encuestaBean);
		} else {
			return new ArrayList();
		}
	}

	/**
	 * <p>
	 * Ttulo: fncModificarRespuestas
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return int
	 * @param listaRespuestas
	 *            ArrayList
	 * @throws Exception
	 *             excepcin
	 */
	public int fncModificarRespuestas(List listaRespuestas) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasImpl.fncModificarRespuestas()");
		
		V50bEncuestaBean encuesta = (V50bEncuestaBean)listaRespuestas.get(0);
		
		int resultado = 0;
		//Contamos el nmero de respuestas de la pregunta. Si es 5 no dejamos aadir ms
		int num=V50bDAOFactory.getEncuestasDAO().fncContarRespuestas(encuesta);
		if (num==0) {
			resultado += V50bDAOFactory.getEncuestasDAO().fncEliminarRespuestaTexto(encuesta);
		}
		
		for(int i=0;i<listaRespuestas.size();i++){
			V50bEncuestaBean encuestaBean = (V50bEncuestaBean)listaRespuestas.get(i);
			
			//if(encuestaBean.getModo()!=null && !encuestaBean.getModo().equals("BD")) {
			
				if(encuestaBean.getModo().equals(V50bClsConstantes.MODO_ELIMINAR)) {
					resultado += V50bDAOFactory.getEncuestasDAO().fncEliminarRespuesta(encuestaBean);
					num--;
				}
				else if(encuestaBean.getModo().equals(V50bClsConstantes.MODO_MODIFICAR) || encuestaBean.getModo().equals("BD")) { 
				
					//if(encuestaBean.getNumRespuesta()!=null && ! encuestaBean.getNumRespuesta().equals("")) {
						resultado += V50bDAOFactory.getEncuestasDAO().fncModificarRespuesta(encuestaBean);						
					}/*else {
						String numRespuesta = V50bDAOFactory.getEncuestasDAO().fncGenerarNumeroRespuesta(encuestaBean.getNumEncuesta(),encuestaBean.getNumPregunta());
						resultado += V50bDAOFactory.getEncuestasDAO().fncAgregarNuevaRespuesta(numRespuesta,encuestaBean);
						resultado += V50bDAOFactory.getEncuestasDAO().fncAgregarNuevaRespuestaCorrelativo(numRespuesta,encuestaBean);
						encuestaBean.setNumRespuesta(numRespuesta);
						//encuestaBean.setModo("BD");
					}					
				}*/
				
				
			/*}
			else{
				resultado += V50bDAOFactory.getEncuestasDAO().fncModificarRespuesta(encuestaBean);
			}*/
		
			final int cinco = 5;
			for(int j=0;j<listaRespuestas.size();j++){
				if(encuestaBean.getModo().equals(V50bClsConstantes.MODO_ALTA)) {
					if(num<cinco){
						String numRespuesta = V50bDAOFactory.getEncuestasDAO().fncGenerarNumeroRespuesta(encuestaBean.getStrNumEncuesta(),encuestaBean.getStrNumPregunta());
						resultado += V50bDAOFactory.getEncuestasDAO().fncAgregarNuevaRespuesta(numRespuesta,encuestaBean);
						resultado += V50bDAOFactory.getEncuestasDAO().fncAgregarNuevaRespuestaCorrelativo(numRespuesta,encuestaBean);
						encuestaBean.setModo("BD");
						encuestaBean.setStrNumRespuesta(numRespuesta);
						num++;
					}
				}
			}
		}
		return resultado;		
	}
	
	/**
	 * <p>
	 * Ttulo: fncCargarEncuesta
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestas
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             excepcin
	 */
	public List fncCargarEncuesta(V50bEncuestaBean encuestas) throws Exception{
		V50bClsTrazas.depura("V50bEncuestasImpl.fncCargarEncuesta()");
		return V50bDAOFactory.getEncuestasDAO().fncCargarEncuesta(encuestas);
	}
	
	/**
	 * <p>
	 * Ttulo: fncExisteRespuesta
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return boolean
	 * @param valores
	 *            ArrayList
	 * @throws Exception
	 *             excepcin
	 */
	public boolean fncExisteRespuesta(List valores) throws Exception {
		V50bClsTrazas.depura("V50bEncuestasImpl.fncExisteRespuesta()");
		return V50bDAOFactory.getEncuestasDAO().fncExisteRespuesta(valores);
	}
	
	/**
	 * <p>
	 * Ttulo: fncGuardarEncuestaResultados
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return int
	 * @param respuestas
	 *            V50bRespuestasBean
	 * @throws Exception
	 *             excepcin
	 */
	public int fncGuardarEncuestaResultados(V50bRespuestasBean respuestas) throws Exception{
		V50bClsTrazas.depura("V50bEncuestasImpl.fncGuardarEncuestaResultados()");
		int tot=0;
		int resultado=0;
		String correlativo="";
		
		int pregInt=Integer.parseInt(respuestas.getNumPreguntas());
		//Miramos si todas las respuestas con radio estan respondidas
		for(int i=1;i<=pregInt;i++) {
			String resp = respuestas.getRadios(i);
			if(resp==null) {
				if (respuestas.getRespLibre(i)==null) {
					return V50bClsConstantes.DOS_NEGATIVO;
				}
			}
		}
		
		//Para los valores fijos
		for(int i=0;i<respuestas.getRadios().length;i++)
		{//Separo para los radios el n de encuesta,la preg y la resp
			String resp = respuestas.getRadios(i);
			if(resp!=null)
			{
				List valores = this.generarArrayList();
				StringTokenizer st = this.generarStringTokenizer(resp);
				
				while (st.hasMoreTokens()){
					valores.add(st.nextToken());
				}
				
				resultado = V50bDAOFactory.getEncuestasDAO().fncInsertRespFijas(valores);
				tot=tot+resultado;
				V50bClsTrazas.depura(String.valueOf(resultado));
			}
		}

		//Para los valores de respuesta libre
		for(int i=0;i<respuestas.getRespLibre().length;i++)
		{
			String respLibre = respuestas.getRespLibre(i);
			String respLibreValor = respuestas.getRespLibreValue(i);
			if(respLibre!=null)
			{//Separo para el n de encuesta y la preg
				List valores = this.generarArrayList();
				StringTokenizer st = this.generarStringTokenizer(respLibreValor);
				
				while (st.hasMoreTokens()){
					valores.add(st.nextToken());
				}
				//ahora aadimos al n encuesta y al n pregunta la respuesta introducida
				valores.add(respLibre);
				if(!this.fncExisteRespuesta(valores))
				{//Si no existe la respuesta 0 en la tabla de respuestas se crea
					resultado = V50bDAOFactory.getEncuestasDAO().fncInsertRespVacia(valores);
				}
				correlativo = V50bDAOFactory.getEncuestasDAO().fncSelectRespLibre(valores);
				if(correlativo==null){
					correlativo="2";}
				resultado 	= V50bDAOFactory.getEncuestasDAO().fncInsertRespLibre(valores,correlativo);
				tot=tot+resultado;
				V50bClsTrazas.depura(String.valueOf(resultado));
			}
		}

		
		if(tot!=0)
			{resultado=1;}
		else
			{resultado=0;}
		
		return resultado;
	}
	
	/**
	 * <p>
	 * Ttulo: fncExcelEncuestasResultados
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean
	 *            V50bEncuestaBean
	 * @throws Exception
	 *             excepcin
	 */
	public List fncExcelEncuestasResultados(V50bEncuestaBean encuestaBean) throws Exception{
		V50bClsTrazas.depura("V50bEncuestasImpl.fncExcelEncuestasResultados()");
		List excel1 = V50bDAOFactory.getEncuestasDAO().fncExcelPestania1(encuestaBean);
		List excel2 = V50bDAOFactory.getEncuestasDAO().fncExcelPestania2(encuestaBean);
		
		List listTotal = new ArrayList();
		listTotal.add(excel1);
		listTotal.add(excel2);
		
		return listTotal;
	}
	
	/**
	 * <p>
	 * Ttulo: generarArrayList
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return ArrayList
	 */
	public List generarArrayList(){
		return new ArrayList();
	}
	
	/**
	 * <p>
	 * Ttulo: generarStringTokenizer
	 * </p>
	 * <p>
	 * Empresa: Eurohelp
	 * </p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @return StringTokenizer
	 * @param resp
	 *            String
	 */
	public StringTokenizer generarStringTokenizer(String resp){
		return new StringTokenizer(resp,"/");
	}

}
