package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bBeans.V50bRespuestasBean;

/**
 * 
 * @author brey
 *
 */
public interface V50bEncuestas {

	/**
	 * <p>Ttulo: fncBusqEncuestas</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: buscar encuestas</p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public List fncBusqEncuestas(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p>Ttulo: fncGuardarEncuesta</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: guarda encuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return long
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public long fncGuardarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p>Ttulo: fncEliminarEncuesta</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Eliminar encuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return int
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public int fncEliminarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p>Ttulo: fncCopiarEncuesta</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: copia encuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return long
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public long fncCopiarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p>Ttulo: fncBusqPreguntas</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Busca preguntas</p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public List fncBusqPreguntas(V50bEncuestaBean encuestaBean)throws Exception;
	
	/**
	 * <p>Ttulo: fncModificarPreguntas</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: modifica preguntas</p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @param listaPreguntas ArrayList
	 * @throws Exception excepcin
	 */
	public List fncModificarPreguntas(V50bEncuestaBean encuestaBean, List listaPreguntas) throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscarMotivoEliminacionContenido</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Busca respuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public List fncBusqRespuestas(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p>Ttulo: fncModificarRespuestas</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Modificar respuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return int
	 * @param listaRespuestas ArrayList
	 * @throws Exception excepcin
	 */
	public int fncModificarRespuestas(List listaRespuestas) throws Exception;
	
	/**
	 * <p>Ttulo: fncCargarEncuesta</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: carga encuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public List fncCargarEncuesta(V50bEncuestaBean encuestaBean) throws Exception;
	
	/**
	 * <p>Ttulo: fncGuardarEncuestaResultados</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: guarda el resultado de la encuesta</p>
	 * @author brey
	 * @version 1.0
	 * @return int
	 * @param respuestas V50bRespuestasBean
	 * @throws Exception excepcin
	 */
	public int fncGuardarEncuestaResultados(V50bRespuestasBean respuestas) throws Exception;
	
	/**
	 * <p>Ttulo: fncExcelEncuestasResultados</p>
	 * <p>Empresa: Eurohelp </p>
	 * <p>Descripcin: Excel de resultados/p>
	 * @author brey
	 * @version 1.0
	 * @return List
	 * @param encuestaBean V50bEncuestaBean
	 * @throws Exception excepcin
	 */
	public List fncExcelEncuestasResultados(V50bEncuestaBean encuestaBean) throws Exception;
	
}
