package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;


/**
 * 
 * @author alata
 *
 */
public class V50bDificultadImpl implements V50bDificultad {
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultad(V50bDificultadBean dificultad) throws Exception {
		V50bClsTrazas.depura("V50bDificultadImpl.fncBuscarDificultad()");
		return V50bDAOFactory.getDificultadDAO().fncBuscarDificultad(dificultad);
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarDificultad(V50bDificultadBean dificultad) throws Exception {
		V50bClsTrazas.depura("V50bDificultadImpl.fncModificarDificultad()");
		
		if (dificultad.getEstado()==null || !dificultad.getEstado().equals(V50bClsConstantes.LITERAL_DESC_BAJA) && dificultad.getAmbitos().length>0) {
			List lista = V50bDAOFactory.getDificultadDAO().fncBuscarAmbitosDificultad(dificultad);
			boolean noBaja = V50bDAOFactory.getDificultadDAO().fncBuscarDificultadBaja(lista);
			if (!noBaja){
				return 0;
			}
		}
		
		return V50bDAOFactory.getDificultadDAO().fncModificarDificultad(dificultad);
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirDificultad(V50bDificultadBean dificultad) throws Exception {
		V50bClsTrazas.depura("V50bDificultadImpl.fncAniadirDificultad()");
		return V50bDAOFactory.getDificultadDAO().fncAniadirDificultad(dificultad);
	}
	
	/**
	 * @param dificultad : dificultad con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosDificultad(V50bDificultadBean dificultad) throws Exception {
		V50bClsTrazas.depura("V50bDificultadImpl.fncBuscarAmbitosDificultad()");
		return V50bDAOFactory.getDificultadDAO().fncBuscarAmbitosDificultad(dificultad);
	}
	
}
