package v50b.v50bControlador;

import java.util.HashMap;
import java.util.Map;



/**
 * Factora para la creacin de Objetos de rellenado.
 * 
 * @author iurkidi
 */
public class V50bControladorFactory {
	
	
	/**
	 * Instantiates a new v50b controlador factory.
	 */
	private V50bControladorFactory(){}
	
	/**
	 * Pool de objetos: Objetos
	 */
	private static Map objectPool=new HashMap();
	
	
	/**
	 * Crea una llamada al objeto de rellenado del Array.
	 * 
	 * @param name Nombre
	 * 
	 * @return Object
	 * 
	 * @throws Exception Se eleva la Excepcion.
	 */
	private static Object get(String name) throws Exception {

			Object rll = V50bControladorFactory.objectPool.get(name);
			if(rll==null){
				rll = V50bControladorFactory.getClassForName(name);
				V50bControladorFactory.objectPool.put(name,rll);
			}
			
			return rll;
	}

	/**
	 * Crea un objeto a partir del nombre de la clase.
	 * 
	 * @param className - nombre completo de la clase a crear
	 * 
	 * @return the class for name
	 * 
	 * @throws Exception the exception
	 */
	private static Object getClassForName(String className) throws Exception {
		return Class.forName(className).newInstance();
	}
	
	/**
	 * Gets the fachada.
	 * 
	 * @return the fachada
	 * 
	 * @throws Exception the exception
	 */
	public static V50bFachada getFachada() throws Exception{
		return V50bFachadaImpl.getSingleton();
	}
	
	/**
	 * 
	 * @return V50bAmbitos
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bAmbitos getAmbitos() throws Exception{
		return (V50bAmbitos)V50bControladorFactory.get("v50b.v50bControlador.V50bAmbitosImpl");
	}
	
	/**
	 * 
	 * @return V50bResolutor
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bResolutores getResolutores() throws Exception{
		return (V50bResolutores)V50bControladorFactory.get("v50b.v50bControlador.V50bResolutoresImpl");
	}
	
	/**
	 * 
	 * @return V50bTipoTrabajo
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bTipoTrabajo getTipoTrabajo() throws Exception{
		return (V50bTipoTrabajo)V50bControladorFactory.get("v50b.v50bControlador.V50bTipoTrabajoImpl");
	}
	
	/**
	 * 
	 * @return V50bMotivos
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bMotivos getMotivo() throws Exception{
		return (V50bMotivos)V50bControladorFactory.get("v50b.v50bControlador.V50bMotivosImpl");
	}
	
	/**
	 * 
	 * @return V50bDificultad
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bDificultad getDificultad() throws Exception{
		return (V50bDificultad)V50bControladorFactory.get("v50b.v50bControlador.V50bDificultadImpl");
	}
	
	/**
	 * 
	 * @return V50bConfiguracion
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bConfiguracion getConfiguracion() throws Exception{
		return (V50bConfiguracion)V50bControladorFactory.get("v50b.v50bControlador.V50bConfiguracionImpl");
	}
	
	/**
	 * 
	 * @return V50bConsultas
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bConsultas getConsultas() throws Exception{
		return (V50bConsultas)V50bControladorFactory.get("v50b.v50bControlador.V50bConsultasImpl");
	}
	
	/**
	 * 
	 * @return V50bSubcategorias
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bSubcategorias getSubcategorias() throws Exception{
		return (V50bSubcategorias)V50bControladorFactory.get("v50b.v50bControlador.V50bSubcategoriasImpl");
	}

	/**
	 * 
	 * @return V50bProfesiones
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bProfesiones getProfesiones() throws Exception{
		return (V50bProfesiones)V50bControladorFactory.get("v50b.v50bControlador.V50bProfesionesImpl");
	}
	
	/**
	 * 
	 * @return V50bUsuariosRegistrados
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bUsuariosRegistrados getUsuariosRegistrados() throws Exception{
		return (V50bUsuariosRegistrados)V50bControladorFactory.get("v50b.v50bControlador.V50bUsuariosRegistradosImpl");
	}
	
	/**
	 * 
	 * @return V50bCalendario
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bCalendario getCalendario() throws Exception{
		return (V50bCalendario)V50bControladorFactory.get("v50b.v50bControlador.V50bCalendarioImpl");
	}
	
	/**
	 * 
	 * @return V50bGraficos
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bGraficos getGraficos() throws Exception{
		return (V50bGraficos)V50bControladorFactory.get("v50b.v50bControlador.V50bGraficosImpl");
	}
	
	/**
	 * 
	 * @return V50bEncuestas
	 * @throws Exception Se eleva la excepcin.
	 */
	protected static V50bEncuestas getEncuestas() throws Exception{
		return (V50bEncuestas)V50bControladorFactory.get("v50b.v50bControlador.V50bEncuestasImpl");
	}
	
}

