package v50b.v50bControlador;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bMotivoConsultaBean;
import v50b.v50bBeans.V50bNotificacionBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFichero;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bModelo.V50bDAOFactory;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


/**
 * 
 * @author llaparra
 *
 */
public class V50bConsultasImpl implements V50bConsultas {
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarConsultasBandejaEntrada</p>
	 * <p>Descripcin: Busca consultas filtrando con el formulario de Bandeja de Entrada</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return lista de consultas que pasan el filtro
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarConsultasBandejaEntrada(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncBuscarConsultasBandejaEntrada() ");
		return V50bDAOFactory.getConsultasDAO().fncBuscarConsultasBandejaEntrada(form);
	}
	
	/**
	 * <p>Ttulo: fncVerFicheroConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroConsulta(String v50bCodigoConsulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncVerFicheroConsulta() ");
		return V50bDAOFactory.getConsultasDAO().fncVerFicheroConsulta(v50bCodigoConsulta);
	}
	
	/**
	 * <p>Ttulo: fncVerFicheroDetalleConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 21/09/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @param tipo String
	 * @return Devuelve el lob
	 * @throws Exception Excepcin
	 */
	public V50bClsFichero fncVerFicheroDetalleConsulta(String v50bCodigoConsulta, String tipo) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncVerFicheroDetalleConsulta() ");
		
		if("A".equals(tipo)){
			return V50bDAOFactory.getConsultasDAO().fncVerFicheroConsulta(v50bCodigoConsulta);
		 } else {
			 if ("B".equals(tipo)){
				 return V50bDAOFactory.getConsultasDAO().fncVerFicheroRespuesta(v50bCodigoConsulta);
			 } else {
				 return V50bDAOFactory.getConsultasDAO().fncVerFicheroResolutor(v50bCodigoConsulta);
			 }
		 }
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNuevaConsulta</p>
	 * <p>Descripcin: Introduce una nueva consulta en la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a insertar
	 * @return Lista con el Entero con el resultado de la operacin y String con el cdigo de la consulta
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncNuevaConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncNuevaConsulta() ");
		
		V50bUsuarioBean usuarioXLNETS = form.getUsuarioXlnets();
		V50bResolutoresBean pOperario = new V50bResolutoresBean();
		pOperario.setIdResol(usuarioXLNETS.getUsuarioXlnets());
		pOperario.setIdioma(form.getIdioma());
		V50bResolutoresBean operario = (V50bResolutoresBean)V50bDAOFactory.getResolutoresDAO().fncBuscarResolutores(pOperario).get(0);
		form.setRemitente(operario.getCodResol());
		
		return V50bDAOFactory.getConsultasDAO().fncNuevaConsulta(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsulta</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncModificarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncModificarConsulta() ");
		return V50bDAOFactory.getConsultasDAO().fncModificarConsulta(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsultaCatalogo</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 02/04/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarConsultaCatalogo(V50bConsultaBean form) throws Exception {
		return V50bDAOFactory.getConsultasDAO().fncModificarRespuestaCatalogo(form);
	}
	
	/**
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasEstadoConsultas(V50bConsultaBean consulta) throws Exception {
		return V50bDAOFactory.getConsultasDAO().fncBuscarConsultasEstadoConsultas(consulta);
	}
	
	/**
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultadesAmbito(V50bConsultaBean consulta) throws Exception {
		return V50bDAOFactory.getConsultasDAO().fncBuscarDificultadesAmbito(consulta);
	}
	
	/**
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasCatalogoConsultas(V50bConsultaBean consulta) throws Exception {
		return V50bDAOFactory.getConsultasDAO().fncBuscarConsultasCatalogoConsultas(consulta);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleConsulta</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return V50bConsultaBean Consulta detallada
	 * @throws Exception Cualquier excepcin
	 */
	public V50bConsultaBean fncDetalleConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncDetalleConsulta() ");
		return V50bDAOFactory.getConsultasDAO().fncDetalleConsulta(form);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncAsignarResolutor</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Lista con los datos de comunicacin al usuario y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncAsignarResolutor(V50bConsultaBean form) throws Exception{
		V50bClsTrazas.depura("V50bConsultasImpl.fncAsignarResolutor() ");
		
		List lResult = new ArrayList();
		Integer result = new Integer(-1);
		Integer res1;
		String codDif = form.getDificultad().getCoddif();
		String codSus = form.getSuscriptor().getCodigo();
		
		if(!V50bClsConstantes.DIFICULTAD_24H.equals(codDif) && StringUtils.isNotEmpty(codSus) &&
				!V50bClsConstantes.CONSTANTE_SI.equals(form.getIndAbandonada())){
			form.setCodEstado(V50bClsConstantes.ESTADO_PDTE_CONFIR_USUARIO);
			
			//sacamos los datos de comunicacin del suscriptor
			lResult.add(V50bDAOFactory.getUsuariosRegistradosDAO().fncComunicacionSuscriptor(form.getSuscriptor().getCodigo()));
		} else {
			form.setCodEstado(V50bClsConstantes.ESTADO_EN_PROCESO);
			
			//no hay datos de comunicacin del suscriptor
			lResult.add(null);
		}
		
		//Obtengo el cdigo del tcnico del IVAP
		V50bUsuarioBean usuarioXLNETS = form.getUsuarioXlnets();
		V50bResolutoresBean pOperario = new V50bResolutoresBean();
		pOperario.setIdResol(usuarioXLNETS.getUsuarioXlnets());
		pOperario.setIdioma(form.getIdioma());
		V50bResolutoresBean operario = (V50bResolutoresBean)V50bDAOFactory.getResolutoresDAO().fncBuscarResolutores(pOperario).get(0);
		
		//Asociamos la consulta al tcnico que la asigna
		form.setRemitente(operario.getCodResol());
		
		//Para saber si se viene de asignar
		form.setModo(V50bClsConstantes.CONSTANTE_ALTA);
		
		res1 = V50bDAOFactory.getConsultasDAO().fncAsignarResolutor(form);
		if(res1.intValue()>0){
			if(!V50bClsConstantes.DIFICULTAD_24H.equals(codDif) && StringUtils.isNotEmpty(codSus) &&
					!V50bClsConstantes.CONSTANTE_SI.equals(form.getIndAbandonada())){
				V50bNotificacionBean notificacion = new V50bNotificacionBean();
				notificacion.setCodConsulta(form.getCodigo());
				notificacion.setCodEmisor(operario.getCodResol());
				notificacion.setCodReceptor(form.getSuscriptor().getCodigo());
				notificacion.setEstado(V50bClsConstantes.CONSTANTE_ABIERTA);
				notificacion.setTipo(V50bClsConstantes.CONSTANTE_EXTERNA);
				StringBuffer textoPregunta = new StringBuffer(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","notificacion.asignada",V50bClsConstantes.CONSTANTE_EUSKARA));
				textoPregunta.append("\r\n\r\n");
				textoPregunta.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","notificacion.asignada",V50bClsConstantes.CONSTANTE_CASTELLANO));
				notificacion.setPregunta(textoPregunta.toString());
				result = V50bDAOFactory.getConsultasDAO().fncNuevaNotificacion(notificacion);
			} else {
				result = res1;
			}
		} else {
			result = res1;
		}
		
		lResult.add(result);
		
		return lResult;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncReenviarConsulta</p>
	 * <p>Descripcin: Reenva una consulta a otro resolutor</p>
	 * <p>Copyright: Copyright (c) 07/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos para el reenvo
	 * @return Lista con los datos de comunicacin al suscriptor y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncReenviarConsulta(V50bConsultaBean form) throws Exception{
		V50bClsTrazas.depura("V50bConsultasImpl.fncReenviarConsulta() ");
		
		List lResult = new ArrayList();
		Integer result = new Integer(-1);
		String codDif = form.getDificultad().getCoddif();
		String codSus = form.getSuscriptor().getCodigo();
		
		//Genero el motivo de reenvo
		final V50bMotivoConsultaBean motivo = new V50bMotivoConsultaBean();
		motivo.setCodConsulta(form.getCodigo());
		motivo.setCodMotivo(form.getCodMotivReenvio());
		motivo.setTipoMotivo(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_REENVIO);
		motivo.setMensaje(form.getMensaje());
		motivo.setCodResolutor(form.getResolutor().getCodResol());
		
		if(!V50bClsConstantes.DIFICULTAD_24H.equals(codDif) && StringUtils.isNotEmpty(codSus)){
			form.setCodEstado(V50bClsConstantes.ESTADO_PDTE_CONFIR_USUARIO);
			
			//sacamos los datos de comunicacin del suscriptor
			lResult.add(V50bDAOFactory.getUsuariosRegistradosDAO().fncComunicacionSuscriptor(form.getSuscriptor().getCodigo()));
		} else {
			form.setCodEstado(V50bClsConstantes.ESTADO_EN_PROCESO);
			
			//no hay datos de comunicacin del suscriptor
			lResult.add(null);
		}
		
		//Obtengo el cdigo del tcnico del IVAP
		V50bUsuarioBean usuarioXLNETS = form.getUsuarioXlnets();
		V50bResolutoresBean pOperario = new V50bResolutoresBean();
		pOperario.setIdResol(usuarioXLNETS.getUsuarioXlnets());
		pOperario.setIdioma(form.getIdioma());
		V50bResolutoresBean operario = (V50bResolutoresBean)V50bDAOFactory.getResolutoresDAO().fncBuscarResolutores(pOperario).get(0);
		form.setRemitente(operario.getCodResol());
		
		//Para saber si se viene de reenviar
		form.setModo(V50bClsConstantes.CONSTANTE_BAJA);
		
		result = V50bDAOFactory.getConsultasDAO().fncAsignarResolutor(form);
		
		//Inserto el motivo de denegacin
		if(result.intValue()>0 && StringUtils.isNotEmpty(motivo.getCodMotivo())) {
			result =  V50bDAOFactory.getMotivoDAO().fncNuevoMotivoConsulta(motivo);
		}
		
		//Creo la notificacin
		if(result.intValue()>0){
			//Si es consulta de suscriptor y tardar ms de 24h -> notif externa
			if(!V50bClsConstantes.DIFICULTAD_24H.equals(codDif) && StringUtils.isNotEmpty(codSus)){
				V50bNotificacionBean notificacion = new V50bNotificacionBean();
				notificacion.setCodConsulta(form.getCodigo());
				notificacion.setCodEmisor(operario.getCodResol());
				notificacion.setCodReceptor(form.getSuscriptor().getCodigo());
				notificacion.setEstado(V50bClsConstantes.CONSTANTE_ABIERTA);
				notificacion.setTipo(V50bClsConstantes.CONSTANTE_EXTERNA);
				notificacion.setPregunta(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","notificacion.asignada",form.getIdioma()));
				result = V50bDAOFactory.getConsultasDAO().fncNuevaNotificacion(notificacion);
			}
			
			//Notif. interna al resolutor al q se reenvia con el motivo
			V50bNotificacionBean notificacion = new V50bNotificacionBean();
			notificacion.setCodConsulta(form.getCodigo());
			notificacion.setCodEmisor(operario.getCodResol());
			notificacion.setCodReceptor(form.getResolutor().getCodResol());
			notificacion.setEstado(V50bClsConstantes.CONSTANTE_CERRADA);
			notificacion.setTipo(V50bClsConstantes.CONSTANTE_INTERNA);
			
			StringBuffer mens = new StringBuffer();
			mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","notificacion.reenviada",form.getIdioma()));
			mens.append("\n\n");
			mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.motivo",form.getIdioma())).append(": ");
			mens.append(form.getDescMotivReenvio());
			if(StringUtils.isNotEmpty(form.getMensaje())){
				mens.append("\n\n");
				mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.mensajeAdicional",form.getIdioma())).append(":\n ");
				mens.append(form.getMensaje());
			}
			notificacion.setPregunta(mens.toString());
			
			result = V50bDAOFactory.getConsultasDAO().fncNuevaNotificacion(notificacion);
		}
		
		lResult.add(result);
		
		return lResult;
	}
	
	/**
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategoriasAmbito(V50bConsultaBean consulta) throws Exception {
		return V50bDAOFactory.getConsultasDAO().fncBuscarSubcategoriasAmbito(consulta);
	}
	
	/**
	 * @author alata
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasHistoricoConsultas(V50bConsultaBean consulta) throws Exception {
		return V50bDAOFactory.getConsultasDAO().fncBuscarConsultasHistoricoConsultas(consulta);
	}
	
	/**
	 * @author alata
	 * @param consulta : Formulario con los datos de la consulta
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarVisibleInternet(V50bConsultaBean consulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncModificarVisibleInternet() ");
		
		int result = 1;
		String visible = consulta.getPublicado();
		
		if (V50bClsConstantes.CONSTANTE_SI.equals(visible)){
			result = V50bDAOFactory.getConsultasDAO().fncPonerVisibleInternet(consulta);
		}else {
			consulta.setPublicado(V50bClsConstantes.CONSTANTE_NO);
			result = V50bDAOFactory.getConsultasDAO().fncQuitarVisibleInternet(consulta);
		}
		V50bDAOFactory.getConsultasDAO().fncModificarRespuesta(consulta);
		return result;
	}
	
	/**
	 * @author alata
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception {
		
		V50bClsTrazas.depura("V50bConsultasImpl.fncVisibleInternetHistConsultas() ");

		int result =V50bClsConstantes.DOS;
		for (int i=0; i<seleccionadas.size(); i++){
			String linea = (String)seleccionadas.get(i);
			int lineaSelec = Integer.parseInt(linea);
			V50bConsultaBean consulta = (V50bConsultaBean)consultas.get(lineaSelec-1);
			if (StringUtils.isEmpty(consulta.getPublicado()) || !consulta.getPublicado().equals(V50bClsConstantes.CONSTANTE_SI)){
				result = V50bDAOFactory.getConsultasDAO().fncPonerVisibleInternet(consulta);
			}
		}
		return result;
	}
	
	/**
	 * @author alata
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncNoVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception {
		
		V50bClsTrazas.depura("V50bConsultasImpl.fncNoVisibleInternetHistConsultas() ");

		int result = V50bClsConstantes.TRES;
		for (int i=0; i<seleccionadas.size(); i++){
			String linea = (String)seleccionadas.get(i);
			int lineaSelec = Integer.parseInt(linea);
			V50bConsultaBean consulta = (V50bConsultaBean)consultas.get(lineaSelec-1);
			if (StringUtils.isEmpty(consulta.getPublicado()) || consulta.getPublicado().equals(V50bClsConstantes.CONSTANTE_SI)){
				result = V50bDAOFactory.getConsultasDAO().fncQuitarVisibleInternet(consulta);
			}
		}
		return result;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncResponderConsulta</p>
	 * <p>Descripcin: Responde a una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la respuesta
	 * @return List Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public List fncResponderConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncResponderConsulta() ");
		
		List lResult = new ArrayList();
		Integer result = new Integer(-1);
		
		result = V50bDAOFactory.getConsultasDAO().fncResponderConsulta(form);
		
		if(result.intValue()>0 && form.getSuscriptor().getCodigo()!=null && !"".equals(form.getSuscriptor().getCodigo())) {
			lResult.add(V50bDAOFactory.getUsuariosRegistradosDAO().fncComunicacionSuscriptor(form.getSuscriptor().getCodigo()));
		}
		else {
			lResult.add(new V50bSuscriptorBean());
		}
		
		return lResult;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDenegarConsulta</p>
	 * <p>Descripcin: Deniega una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncDenegarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncDenegarConsulta() ");
		
		Integer result = new Integer(-1);
		
		//Genero el motivo de denegacin
		final V50bMotivoConsultaBean motivo = new V50bMotivoConsultaBean();
		motivo.setCodConsulta(form.getCodigo());
		motivo.setCodMotivo(form.getCodMotivDenegar());
		motivo.setTipoMotivo(V50bClsConstantes.CONSTANTE_MOTIVO_DENEGACION);
		motivo.setMensaje(form.getMensaje());
		//motivo.setCodResolutor(form.getResolutor().getCodResol());
		
		//Cambio el estado de la consulta
		result = V50bDAOFactory.getConsultasDAO().fncCambiaEstadoConsulta(form.getCodigo(), V50bClsConstantes.ESTADO_DENEGADA);
		
		//Inserto el motivo de denegacin
		if(result.intValue()>0 && StringUtils.isNotEmpty(motivo.getCodMotivo())) {
			result =  V50bDAOFactory.getMotivoDAO().fncNuevoMotivoConsulta(motivo);
		}
		
		//Obtengo el cdigo del tcnico del IVAP
		V50bUsuarioBean usuarioXLNETS = form.getUsuarioXlnets();
		V50bResolutoresBean pOperario = new V50bResolutoresBean();
		pOperario.setIdResol(usuarioXLNETS.getUsuarioXlnets());
		pOperario.setIdioma(form.getIdioma());
		V50bResolutoresBean operario = (V50bResolutoresBean)V50bDAOFactory.getResolutoresDAO().fncBuscarResolutores(pOperario).get(0);
		
		//Genero la notificacin para el usuario
		if(result.intValue()>0 && StringUtils.isNotEmpty(form.getSuscriptor().getCodigo())){
			V50bNotificacionBean notificacion = new V50bNotificacionBean();
			notificacion.setCodConsulta(form.getCodigo());
			notificacion.setCodEmisor(operario.getCodResol());
			notificacion.setCodReceptor(form.getSuscriptor().getCodigo());
			notificacion.setEstado(V50bClsConstantes.CONSTANTE_CERRADA);
			notificacion.setTipo(V50bClsConstantes.CONSTANTE_INTERNA);
			
			StringBuffer mens = new StringBuffer();
			mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","notificacion.denegada",form.getIdioma()));
			mens.append("\n\n");
			mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.motivo",form.getIdioma())).append(": ");
			mens.append(form.getDescMotivDenegar());
			if(StringUtils.isNotEmpty(form.getMensaje())){
				mens.append("\n\n");
				mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.mensajeAdicional",form.getIdioma())).append(":\n ");
				mens.append(form.getMensaje());
			}
			notificacion.setPregunta(mens.toString());
			
			result = V50bDAOFactory.getConsultasDAO().fncNuevaNotificacion(notificacion);
		}
		
		return result;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncRechazarConsulta</p>
	 * <p>Descripcin: Rechaza una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncRechazarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncRechazarConsulta() ");
		
		Integer result = new Integer(-1);
		
		//Genero el motivo de rechazo
		final V50bMotivoConsultaBean motivo = new V50bMotivoConsultaBean();
		motivo.setCodConsulta(form.getCodigo());
		motivo.setCodMotivo(form.getCodMotivRechazo());
		motivo.setTipoMotivo(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_RECHAZO);
		motivo.setMensaje(form.getMensaje());
		motivo.setCodResolutor(form.getResolutor().getCodResol());
		
		//Cambio el estado de la consulta
		result = V50bDAOFactory.getConsultasDAO().fncCambiaEstadoConsulta(form.getCodigo(), V50bClsConstantes.ESTADO_RECHAZADA);
		
		//Inserto el motivo de rechazo
		if(result.intValue()>0 && StringUtils.isNotEmpty(motivo.getCodMotivo())) {
			result =  V50bDAOFactory.getMotivoDAO().fncNuevoMotivoConsulta(motivo);
		}
		
		//Genero la notificacin para el usuario
		if(result.intValue()>0 && StringUtils.isNotEmpty(form.getSuscriptor().getCodigo())){
			V50bNotificacionBean notificacion = new V50bNotificacionBean();
			notificacion.setCodConsulta(form.getCodigo());
			notificacion.setCodEmisor(form.getResolutor().getCodResol());
			notificacion.setCodReceptor(form.getRemitente());
			notificacion.setEstado(V50bClsConstantes.CONSTANTE_CERRADA);
			notificacion.setTipo(V50bClsConstantes.CONSTANTE_INTERNA);
			
			StringBuffer mens = new StringBuffer();
			mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","notificacion.rechazada",form.getIdioma()));
			mens.append("\n\n");
			mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.motivo",form.getIdioma())).append(": ");
			mens.append(form.getDescMotivRechazo());
			if(StringUtils.isNotEmpty(form.getMensaje())){
				mens.append("\n\n");
				mens.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.mensajeAdicional",form.getIdioma())).append(":\n ");
				mens.append(form.getMensaje());
			}
			notificacion.setPregunta(mens.toString());
			
			result = V50bDAOFactory.getConsultasDAO().fncNuevaNotificacion(notificacion);
		}
		
		return result;
	}
	
	/**
	 * <p>Ttulo: fncCatalogarConsulta</p>
	 * <p>Descripcin: Catalogar una consulta</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a cataloogar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncCatalogarConsulta(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncCatalogarConsulta() ");
		return V50bDAOFactory.getConsultasDAO().fncCatalogarConsulta(form);
	}
	
	/**
	 * <p>Ttulo: fncSolicitarInformacion</p>
	 * <p>Descripcin: solicitar informacin adicional a un tcnico o a un suscriptor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la info adicional
	 * @param tipoDest String con el tipo de destinatario (T)Tecnico/(S)Suscriptor
	 * @return List lista con los datos de comunicacin y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncSolicitarInformacion(V50bConsultaBean form, String tipoDest) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncSolicitarInformacion() ");
		
		List lResult = new ArrayList();
		
		Integer result = new Integer(-1);
		
		//Cambio el estado de la consulta
		result = V50bDAOFactory.getConsultasDAO().fncCambiaEstadoConsulta(form.getCodigo(), V50bClsConstantes.ESTADO_PDTE_SUBSANACION);
		
		//Obtengo el cdigo del tcnico del IVAP
		V50bUsuarioBean usuarioXLNETS = form.getUsuarioXlnets();
		V50bResolutoresBean pOperario = new V50bResolutoresBean();
		pOperario.setIdResol(usuarioXLNETS.getUsuarioXlnets());
		pOperario.setIdioma(form.getIdioma());
		V50bResolutoresBean operario = (V50bResolutoresBean)V50bDAOFactory.getResolutoresDAO().fncBuscarResolutores(pOperario).get(0);
		
		//Genero la notificacin para el usuario
		V50bNotificacionBean notificacion = new V50bNotificacionBean();
		notificacion.setCodConsulta(form.getCodigo());
		notificacion.setCodEmisor(operario.getCodResol());
		notificacion.setEstado(V50bClsConstantes.CONSTANTE_ABIERTA);
		notificacion.setPregunta(form.getMensaje());
		if(result.intValue()>0 && V50bClsConstantes.CONSTANTE_TECNICO.equals(tipoDest)){
			notificacion.setCodReceptor(form.getRemitente());
			notificacion.setTipo(V50bClsConstantes.CONSTANTE_INTERNA);
			//Obtenemos los datos para la comunicacin con el tcnico
			lResult.add(V50bDAOFactory.getResolutoresDAO().fncComunicacionResolutor(form.getRemitente()));
		} else if(result.intValue()>0 && V50bClsConstantes.CONSTANTE_SUSCRIPTOR.equals(tipoDest)) {
			notificacion.setCodReceptor(form.getSuscriptor().getCodigo());
			notificacion.setTipo(V50bClsConstantes.CONSTANTE_EXTERNA);
			//Obtenemos los datos para la comunicacin con el suscriptor
			lResult.add(V50bDAOFactory.getUsuariosRegistradosDAO().fncComunicacionSuscriptor(form.getSuscriptor().getCodigo()));
		}
		result = V50bDAOFactory.getConsultasDAO().fncNuevaNotificacion(notificacion);
		
		lResult.add(result);
		
		return lResult;
	}
	
	/**
	 * <p>Ttulo: fncBuscarNotificaciones</p>
	 * <p>Descripcin: Busca las notificaciones de una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param consulta La consulta
	 * @return List Lista con las notificaciones
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarNotificaciones(V50bConsultaBean consulta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncBuscarNotificaciones() ");
		return V50bDAOFactory.getConsultasDAO().fncBuscarNotificaciones(consulta);
	}
	
	/**
	 * <p>Ttulo: fncRespondeNotificacion</p>
	 * <p>Descripcin: Responde una notificacin</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param respuesta La respuesta
	 * @return List Datos de la comunicacin y Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public List fncRespondeNotificacion(V50bNotificacionBean respuesta) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncRespondeNotificacion() ");
		Integer result;
		List lResult = new ArrayList();
		
		result = V50bDAOFactory.getConsultasDAO().fncCambiaEstadoConsulta(respuesta.getCodConsulta(), V50bClsConstantes.ESTADO_EN_PROCESO);
		
		if(result.intValue()>0){
			result = V50bDAOFactory.getConsultasDAO().fncRespondeNotificacion(respuesta);
		}
		
		 lResult.add(V50bDAOFactory.getResolutoresDAO().fncComunicacionResolutor(respuesta.getCodEmisor()));
		 lResult.add(result);
		
		return lResult;
	}

	/**
	 * <p>Ttulo: fncBuscar24Horas</p>
	 * <p>Descripcin: Busca consultas 24 Horas</p>
	 * <p>Copyright: Copyright (c) Dec 22, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscar24Horas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)
			throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncBuscar24Horas() ");
		return V50bDAOFactory.getConsultasDAO().fncBuscar24Horas(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
	}
	
	/**
	 * <p>Ttulo: fncBuscarPendientes</p>
	 * <p>Descripcin: Busca consultas Pendientes</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarPendientes(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)
			throws Exception {
		
		V50bClsTrazas.depura("V50bConsultasImpl.fncBuscarPendientes() ");
		return V50bDAOFactory.getConsultasDAO().fncBuscarPendientes(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
		
	}
	
	/**
	 * <p>Ttulo: fncBuscarRetrasadas</p>
	 * <p>Descripcin: Busca consultas Retrasadas</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarRetrasadas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)
			throws Exception {

		V50bClsTrazas.depura("V50bConsultasImpl.fncBuscarRetrasadas() ");
		return V50bDAOFactory.getConsultasDAO().fncBuscarRetrasadas(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
		
	}

	/**
	 * <p>Ttulo: fncVerFicheroNotif</p>
	 * <p>Descripcin: Obtiene el lob de la notificacin</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoNotif Cdigo de la notificacin
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroNotif(String v50bCodigoNotif) throws Exception {
		V50bClsTrazas.depura("V50bConsultasImpl.fncVerFicheroNotif() ");
		return V50bDAOFactory.getConsultasDAO().fncVerFicheroNotif(v50bCodigoNotif);
	}
	
}
