package v50b.v50bControlador;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bNotificacionBean;
import v50b.v50bClasesComunes.V50bClsFichero;


/**
 * 
 * @author llaparra
 *
 */
public interface V50bConsultas {
	
	/**
	 * 
	 * <p>Ttulo: fncBuscarConsultasBandejaEntrada</p>
	 * <p>Descripcin: Busca consultas filtrando con el formulario de Bandeja de Entrada</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return lista de consultas que pasan el filtro
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarConsultasBandejaEntrada(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncVerFicheroConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroConsulta(String v50bCodigoConsulta) throws Exception;
	
	/**
	 * <p>Ttulo: fncVerFicheroDetalleConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 21/09/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @param tipo String
	 * @return Devuelve el lob
	 * @throws Exception Excepcin
	 */
	public V50bClsFichero fncVerFicheroDetalleConsulta(String v50bCodigoConsulta, String tipo) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncNuevaConsulta</p>
	 * <p>Descripcin: Introduce una nueva consulta en la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a insertar
	 * @return Lista con el Entero con el resultado de la operacin y String con el cdigo de la consulta
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncNuevaConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsulta</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncModificarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsultaCatalogo</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 02/04/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarConsultaCatalogo(V50bConsultaBean form) throws Exception;
	
	/**
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasEstadoConsultas(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarDificultadesAmbito(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasCatalogoConsultas(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleConsulta</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return V50bConsultaBean Consulta detallada
	 * @throws Exception Cualquier excepcin
	 */
	public V50bConsultaBean fncDetalleConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * @param consulta : consulta con los datos de busqueda
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarSubcategoriasAmbito(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @author alata
	 * @param consulta : consulta con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConsultasHistoricoConsultas(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncAsignarResolutor</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Lista con los datos de comunicacin al usuario y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncAsignarResolutor(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncReenviarConsulta</p>
	 * <p>Descripcin: Reenva una consulta a otro resolutor</p>
	 * <p>Copyright: Copyright (c) 07/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos para el reenvo
	 * @return Lista con los datos de comunicacin al suscriptor y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncReenviarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * @author alata
	 * @param consulta : Formulario con los datos de la consulta
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncModificarVisibleInternet(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * @author alata
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception;
	
	/**
	 * @author alata
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public int fncNoVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncResponderConsulta</p>
	 * <p>Descripcin: Responde a una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la respuesta
	 * @return List Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public List fncResponderConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncDenegarConsulta</p>
	 * <p>Descripcin: Deniega una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncDenegarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncRechazarConsulta</p>
	 * <p>Descripcin: Rechaza una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncRechazarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncCatalogarConsulta</p>
	 * <p>Descripcin: Catalogar una consulta</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a cataloogar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public Integer fncCatalogarConsulta(V50bConsultaBean form) throws Exception;
	
	/**
	 * <p>Ttulo: fncSolicitarInformacion</p>
	 * <p>Descripcin: solicitar informacin adicional a un tcnico o a un suscriptor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la info adicional
	 * @param tipoDest String con el tipo de destinatario (T)Tecnico/(S)Suscriptor
	 * @return List lista con los datos de comunicacin y un entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 */
	public List fncSolicitarInformacion(V50bConsultaBean form, String tipoDest) throws Exception;

	
	
	/**
	 * <p>Ttulo: fncBuscarNotificaciones</p>
	 * <p>Descripcin: Busca las notificaciones de una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param consulta La consulta
	 * @return List Lista con las notificaciones
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarNotificaciones(V50bConsultaBean consulta) throws Exception;
	
	/**
	 * <p>Ttulo: fncRespondeNotificacion</p>
	 * <p>Descripcin: Responde una notificacin</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param respuesta La respuesta
	 * @return List Datos de la comunicacin y Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public List fncRespondeNotificacion(V50bNotificacionBean respuesta) throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscar24Horas</p>
	 * <p>Descripcin: Busca consultas 24 Horas</p>
	 * <p>Copyright: Copyright (c) Dec 22, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscar24Horas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma) throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscarPendientes</p>
	 * <p>Descripcin: Busca consultas Pendientes</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarPendientes(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws Exception;
	
	/**
	 * <p>Ttulo: fncBuscarRetrasadas</p>
	 * <p>Descripcin: Busca consultas Retrasadas</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws Exception Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarRetrasadas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws Exception;

	/**
	 * <p>Ttulo: fncVerFicheroNotif</p>
	 * <p>Descripcin: Obtiene el lob de la notificacin</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoNotif Cdigo de la notificacin
	 * @return Devuelve el lob
	 * @throws Exception Cualquier excepcin
	 */
	public V50bClsFichero fncVerFicheroNotif(String v50bCodigoNotif) throws Exception;
	
}
