package v50b.v50bControlador;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bConfiguracionBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;


/**
 * 
 * @author alata
 *
 */
public class V50bConfiguracionImpl implements V50bConfiguracion {
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfiguracion(V50bConfiguracionBean buzon) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionImpl.fncBuscarConfiguracion()");
		return V50bDAOFactory.getConfiguracionDAO().fncBuscarConfiguracion(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfigTextos(V50bConfiguracionBean buzon) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionImpl.fncBuscarConfigTextos()");
		return V50bDAOFactory.getConfiguracionDAO().fncBuscarConfigTextos(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarConfiguracion(V50bConfiguracionBean buzon) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionImpl.fncEliminarConfiguracion()");
		return V50bDAOFactory.getConfiguracionDAO().fncEliminarConfiguracion(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncGuardarConfiguracion(V50bConfiguracionBean buzon) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionImpl.fncGuardarConfiguracion()");
		int resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarContactoIvap(buzon);
		resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarOlvidoContrasenia(buzon);
		resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarAltaSuscripcion(buzon);
		resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarRecibirNotificacion(buzon);
		resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarProteccionDatos(buzon);
		resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarComunicacionClaves(buzon);
		resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarEmailRemitente(buzon);
		resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarEmailTecnicos(buzon);
		resultado = V50bDAOFactory.getConfiguracionDAO().fncActualizarServicioInactivo(buzon);
		return resultado;
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarBuzon(V50bConfiguracionBean buzon) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionImpl.fncModificarBuzon()");
		return V50bDAOFactory.getConfiguracionDAO().fncModificarBuzon(buzon);
	}
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirBuzon(V50bConfiguracionBean buzon) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionImpl.fncAniadirBuzon()");
		return V50bDAOFactory.getConfiguracionDAO().fncAniadirBuzon(buzon);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTexto</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @param idioma Idioma de la sesin
	 * @return String El texto
	 * @throws Exception Cualquier excepcin
	 */
	public String fncObtenerTexto(String codigo, String idioma) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionImpl.fncObtenerTexto() ");
		return V50bDAOFactory.getConfiguracionDAO().fncObtenerTexto(codigo, idioma);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTextos</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo en ambos idiomas</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @return List Lista con los textos
	 * @throws Exception Cualquier excepcin
	 */
	public List fncObtenerTextos(String codigo) throws Exception {
		V50bClsTrazas.depura("V50bConfiguracionImpl.fncObtenerTextos() ");
		List lResult = new ArrayList();
		
		lResult.add(V50bDAOFactory.getConfiguracionDAO().fncObtenerTexto(codigo, V50bClsConstantes.CONSTANTE_CASTELLANO));
		lResult.add(V50bDAOFactory.getConfiguracionDAO().fncObtenerTexto(codigo, V50bClsConstantes.CONSTANTE_EUSKARA));
		
		return lResult;
	}
}
