package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bConfiguracionBean;


/**
 * 
 * @author alata
 *
 */
public interface V50bConfiguracion {
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfiguracion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarConfigTextos(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarConfiguracion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncGuardarConfiguracion(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la update
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncModificarBuzon(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * @param buzon : buzon con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncAniadirBuzon(V50bConfiguracionBean buzon) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTexto</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @param idioma Idioma de la sesin
	 * @return String El texto
	 * @throws Exception Cualquier excepcin
	 */
	public String fncObtenerTexto(String codigo, String idioma) throws Exception;
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerTextos</p>
	 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo en ambos idiomas</p>
	 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codigo Cdigo del texto
	 * @return List Lista con los textos
	 * @throws Exception Cualquier excepcin
	 */
	public List fncObtenerTextos(String codigo) throws Exception;
}
