package v50b.v50bControlador;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bCalendarioBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;


/**
 * 
 * @author alata
 *
 */
public class V50bCalendarioImpl implements V50bCalendario {
	
	
	/**
	 * @author iurkidi
	 * @param bean bean
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncObtenerPeriodoServInactivo(V50bCalendarioBean bean) throws Exception{
		
		V50bClsTrazas.depura("V50bCalendarioImpl.fncObtenerPeriodoServInactivo()");
		List listFinal=new ArrayList();
		
		/*List listRetorno=V50bDAOFactory.getCalendarioDAO().fncObtenerPeriodoServInactivo(bean);
		List listFestivos=V50bDAOFactory.getCalendarioDAO().fncObtenerFestivosCalendario(bean);*/
		
		listFinal.add(V50bDAOFactory.getCalendarioDAO().fncObtenerPeriodoServInactivo(bean));
		listFinal.add(V50bDAOFactory.getCalendarioDAO().fncObtenerFestivosCalendario(bean));
		
		return listFinal;
	}
	
	/**
	 * @author iurkidi
	 * @param lista lista de datos
	 * @return V50bCalendarioBean bean con datos
	 * @throws Exception Se eleva la excepcin.
	 */
	public Integer fncGuardarCalendario(List lista) throws Exception{
		V50bClsTrazas.depura("V50bCalendarioImpl.fncGuardarCalendario() ");
		
		Integer result = new Integer(-1);
		
		final V50bCalendarioBean bean=(V50bCalendarioBean)lista.get(0);
		
		if(bean.isHayPeriodoInactivo()){
			//update
			result = V50bDAOFactory.getCalendarioDAO().fncModificarPeriodoServInactivo(bean);
		} else if ("".equals(bean.getFechaDesdeInactivo()) && "".equals(bean.getFechaHastaInactivo())){
			//insert
			result = V50bDAOFactory.getCalendarioDAO().fncAnyadirPeriodoServInactivoSinFecha(bean);
		} else {
			//insert
			result = V50bDAOFactory.getCalendarioDAO().fncAnyadirPeriodoServInactivo(bean);
		}
		
		if(null!=result && result.intValue()>0){
			final List lAdiciones = (ArrayList)lista.get(1);
			final List lSupresiones = (ArrayList)lista.get(2);
			
			for(int i=0; i<lAdiciones.size();i++){
				V50bCalendarioBean cal = (V50bCalendarioBean)lAdiciones.get(i);
				String anyo = cal.getFecha().substring(0,V50bClsConstantes.CUATRO);
				result = V50bDAOFactory.getCalendarioDAO().fncGuardarFestivo(anyo, cal.getFecha());
			}
			
			if(null!=result && result.intValue()>0){
				for(int i=0; i<lSupresiones.size();i++){
					V50bCalendarioBean cal = (V50bCalendarioBean)lSupresiones.get(i);
					String anyo = cal.getFecha().substring(0,V50bClsConstantes.CUATRO);
					result = V50bDAOFactory.getCalendarioDAO().fncEliminarFestivo(anyo, cal.getFecha());
				}
			}
		}
		
		return result;
	}

}
