package v50b.v50bControlador;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bAmbitoBean;
import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bModelo.V50bDAOFactory;

/**
 * 
 * @author alata
 *
 */
public class V50bAmbitosImpl implements V50bAmbitos {
	
	/**
	 * @param ambito :ambito con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitos(V50bAmbitoBean ambito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosImpl.fncBuscarAmbitos()");
		return V50bDAOFactory.getAmbitosDAO().fncBuscarAmbitos(ambito);
	}
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarAmbito(V50bAmbitoBean ambito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosImpl.fncModificarAmbito()");
		return V50bDAOFactory.getAmbitosDAO().fncModificarAmbito(ambito);
	}
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirAmbito(V50bAmbitoBean ambito) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosImpl.fncAniadirAmbito()");
		return V50bDAOFactory.getAmbitosDAO().fncAniadirAmbito(ambito);
	}
	
	/**
	 * <p>Ttulo: fncComboSubcategoriaDificultad</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codAmbito Cdigo del mbito
	 * @param idioma Idioma de la sesin
	 * @return List Lista con las listas de los combos subcategora y dificultades
	 * @throws Exception Cualquier excepcin
	 */
	public List fncComboSubcategoriaDificultad(String codAmbito, String idioma) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosImpl.fncComboSubcategoriaDificultad() ");
		List lResult = new ArrayList();
		
		V50bSubcategoriasBean subcategoria = new V50bSubcategoriasBean();
		subcategoria.setCodAmbito(codAmbito);
		subcategoria.setIdioma(idioma);
		lResult.add(V50bDAOFactory.getSubcategoriasDAO().fncBuscarSubcategorias(subcategoria));
		
		V50bDificultadBean dificultad = new V50bDificultadBean();
		dificultad.setCodambit(codAmbito);
		dificultad.setIdioma(idioma);
		lResult.add(V50bDAOFactory.getDificultadDAO().fncBuscarDificultad(dificultad));
		
		return lResult;
	}
	
	/**
	 * <p>Ttulo: fncComboSubcategoriaResolutorDificultad</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito Cdigo del mbito
	 * @param idioma Idioma de la sesin
	 * @return List Lista con las listas de los combos subcategora y dificultades
	 * @throws Exception Cualquier excepcin
	 */
	public List fncComboSubcategoriaResolutorDificultad(String codAmbito, String idioma) throws Exception {
		V50bClsTrazas.depura("V50bAmbitosImpl.fncComboSubcategoriaResolutorDificultad() ");
		List lResult = new ArrayList();
		
		V50bSubcategoriasBean subcategoria = new V50bSubcategoriasBean();
		subcategoria.setCodAmbito(codAmbito);
		subcategoria.setIdioma(idioma);
		lResult.add(V50bDAOFactory.getSubcategoriasDAO().fncBuscarSubcategorias(subcategoria));
		
		V50bResolutoresBean resolutor = new V50bResolutoresBean();
		resolutor.setCodambito(codAmbito);
		resolutor.setIdioma(idioma);
		lResult.add(V50bDAOFactory.getResolutoresDAO().fncBuscarResolutoresAmbito(resolutor));
		
		V50bDificultadBean dificultad = new V50bDificultadBean();
		dificultad.setCodambit(codAmbito);
		dificultad.setIdioma(idioma);
		lResult.add(V50bDAOFactory.getDificultadDAO().fncBuscarDificultad(dificultad));
		
		return lResult;
	}
}
