package v50b.v50bControlador;

import java.util.List;

import v50b.v50bBeans.V50bAmbitoBean;

/**
 * 
 * @author alata
 *
 */
public interface V50bAmbitos {
	
	/**
	 * 
	 * @param ambito :ambito con los datos de busqueda
	 * @return List
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitos(V50bAmbitoBean ambito) throws Exception; 
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarAmbito(V50bAmbitoBean ambito) throws Exception;
	
	/**
	* @param ambito : ambito con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirAmbito(V50bAmbitoBean ambito) throws Exception;
	
	/**
	 * <p>Ttulo: fncComboSubcategoriaDificultad</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codAmbito Cdigo del mbito
	 * @param idioma Idioma de la sesin
	 * @return List Lista con las listas de los combos subcategora y dificultades
	 * @throws Exception Cualquier excepcin
	 */
	public List fncComboSubcategoriaDificultad(String codAmbito, String idioma) throws Exception;
	
	/**
	 * <p>Ttulo: fncComboSubcategoriaResolutorDificultad</p>
	 * <p>Descripcin: Busca los datos de una consulta</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito Cdigo del mbito
	 * @param idioma Idioma de la sesin
	 * @return List Lista con las listas de los combos subcategora y dificultades
	 * @throws Exception Cualquier excepcin
	 */
	public List fncComboSubcategoriaResolutorDificultad(String codAmbito, String idioma) throws Exception;
}
