package v50b.v50bClasesComunes.v50bBeansComunes;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.util.HSSFColor;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsExcel;


/**
 * The Class V50bCeldaExcelBean.
 * 
 * @author Iaki Cantalapiedra Bernal
 */
public class V50bCeldaExcelBean implements Cloneable{
	
	private short posicionX = 0;
	private short posicionXDerecha = 0;
	private int posicionY = 0;
	private int posicionYAbajo = 0;
	private int numeroHoja = 0;
	private String dato = "";
	private String intDato="";
	private short tipoDato = V50bClsExcel.formatoPorDefecto;
	private int tipoDatoInt= V50bClsExcel.formatoInteger;
	private short alineacionVertical = HSSFCellStyle.ALIGN_GENERAL;
	private short alineacionHorizontal = HSSFCellStyle.ALIGN_GENERAL;
	private short colorFondo = HSSFColor.WHITE.index;
	private short colorFuente = HSSFFont.COLOR_NORMAL;
	private boolean fuenteItalica = false;
	private byte fuenteSubrayado = HSSFFont.U_NONE;
	private short fuenteNegrita = HSSFFont.BOLDWEIGHT_NORMAL;
	private short tamannoFuente = V50bClsConstantes.DIEZ;
	private String tipoFuente = HSSFFont.FONT_ARIAL;
	private short bordeIzquierdo = HSSFCellStyle.BORDER_NONE;
	private short colorBordeIzquierdo = HSSFColor.WHITE.index;
	private short bordeDerecho = HSSFCellStyle.BORDER_NONE;
	private short colorBordeDerecho = HSSFColor.WHITE.index;
	private short bordeArriba = HSSFCellStyle.BORDER_NONE;
	private short colorBordeArriba = HSSFColor.WHITE.index;
	private short bordeAbajo = HSSFCellStyle.BORDER_NONE;
	private short colorBordeAbajo = HSSFColor.WHITE.index;
	private boolean bloqueada = false;
	private short patronFondo =  HSSFCellStyle.NO_FILL;

	/**
	 * Checks if is bloqueada.
	 * 
	 * @return true, if is bloqueada
	 */
	public boolean isBloqueada() {
		return this.bloqueada;
	}

	/**
	 * @return the intDato
	 */
	public int getIntDato() {
		
		int dato= Integer.parseInt(this.intDato);
		
		return dato;
	}

	/**
	 * @param intDato the doubleDato to set
	 */
	public void setIntDato(String intDato) {
		this.intDato = intDato;
	}

	/**
	 * Sets the bloqueada.
	 * 
	 * @param bloqueada the new bloqueada
	 */
	public void setBloqueada(boolean bloqueada) {
		this.bloqueada = bloqueada;
	}

	/**
	 * Gets the patron fondo.
	 * 
	 * @return the patron fondo
	 */
	public short getPatronFondo() {
		return this.patronFondo;
	}

	/**
	 * Sets the patron fondo.
	 * 
	 * @param patronFondo the new patron fondo
	 */
	public void setPatronFondo(short patronFondo) {
		this.patronFondo = patronFondo;
	}

	/**
	 * Gets the alineacion horizontal.
	 * 
	 * @return the alineacion horizontal
	 */
	public short getAlineacionHorizontal() {
		return this.alineacionHorizontal;
	}

	/**
	 * Sets the alineacion horizontal.
	 * 
	 * @param alineacionHorizontal the new alineacion horizontal
	 */
	public void setAlineacionHorizontal(short alineacionHorizontal) {
		this.alineacionHorizontal = alineacionHorizontal;
	}

	/**
	 * Gets the alineacion vertical.
	 * 
	 * @return the alineacion vertical
	 */
	public short getAlineacionVertical() {
		return this.alineacionVertical;
	}

	/**
	 * Sets the alineacion vertical.
	 * 
	 * @param alineacionVertical the new alineacion vertical
	 */
	public void setAlineacionVertical(short alineacionVertical) {
		this.alineacionVertical = alineacionVertical;
	}

	/**
	 * Gets the borde abajo.
	 * 
	 * @return the borde abajo
	 */
	public short getBordeAbajo() {
		return this.bordeAbajo;
	}

	/**
	 * Sets the borde abajo.
	 * 
	 * @param bordeAbajo the new borde abajo
	 */
	public void setBordeAbajo(short bordeAbajo) {
		this.bordeAbajo = bordeAbajo;
	}

	/**
	 * Gets the borde arriba.
	 * 
	 * @return the borde arriba
	 */
	public short getBordeArriba() {
		return this.bordeArriba;
	}

	/**
	 * Sets the borde arriba.
	 * 
	 * @param bordeArriba the new borde arriba
	 */
	public void setBordeArriba(short bordeArriba) {
		this.bordeArriba = bordeArriba;
	}

	/**
	 * Gets the borde derecho.
	 * 
	 * @return the borde derecho
	 */
	public short getBordeDerecho() {
		return this.bordeDerecho;
	}

	/**
	 * Sets the borde derecho.
	 * 
	 * @param bordeDerecho the new borde derecho
	 */
	public void setBordeDerecho(short bordeDerecho) {
		this.bordeDerecho = bordeDerecho;
	}

	/**
	 * Gets the borde izquierdo.
	 * 
	 * @return the borde izquierdo
	 */
	public short getBordeIzquierdo() {
		return this.bordeIzquierdo;
	}

	/**
	 * Sets the borde izquierdo.
	 * 
	 * @param bordeIzquierdo the new borde izquierdo
	 */
	public void setBordeIzquierdo(short bordeIzquierdo) {
		this.bordeIzquierdo = bordeIzquierdo;
	}

	/**
	 * Gets the color borde abajo.
	 * 
	 * @return the color borde abajo
	 */
	public short getColorBordeAbajo() {
		return this.colorBordeAbajo;
	}

	/**
	 * Sets the color borde abajo.
	 * 
	 * @param colorBordeAbajo the new color borde abajo
	 */
	public void setColorBordeAbajo(short colorBordeAbajo) {
		this.colorBordeAbajo = colorBordeAbajo;
	}

	/**
	 * Gets the color borde arriba.
	 * 
	 * @return the color borde arriba
	 */
	public short getColorBordeArriba() {
		return this.colorBordeArriba;
	}

	/**
	 * Sets the color borde arriba.
	 * 
	 * @param colorBordeArriba the new color borde arriba
	 */
	public void setColorBordeArriba(short colorBordeArriba) {
		this.colorBordeArriba = colorBordeArriba;
	}

	/**
	 * Gets the color borde derecho.
	 * 
	 * @return the color borde derecho
	 */
	public short getColorBordeDerecho() {
		return this.colorBordeDerecho;
	}

	/**
	 * Sets the color borde derecho.
	 * 
	 * @param colorBordeDerecho the new color borde derecho
	 */
	public void setColorBordeDerecho(short colorBordeDerecho) {
		this.colorBordeDerecho = colorBordeDerecho;
	}

	/**
	 * Gets the color borde izquierdo.
	 * 
	 * @return the color borde izquierdo
	 */
	public short getColorBordeIzquierdo() {
		return this.colorBordeIzquierdo;
	}

	/**
	 * Sets the color borde izquierdo.
	 * 
	 * @param colorBordeIzquierdo the new color borde izquierdo
	 */
	public void setColorBordeIzquierdo(short colorBordeIzquierdo) {
		this.colorBordeIzquierdo = colorBordeIzquierdo;
	}

	/**
	 * Gets the color fondo.
	 * 
	 * @return the color fondo
	 */
	public short getColorFondo() {
		return this.colorFondo;
	}

	/**
	 * Sets the color fondo.
	 * 
	 * @param colorFondo the new color fondo
	 */
	public void setColorFondo(short colorFondo) {
		if(colorFondo != HSSFColor.WHITE.index){
			this.patronFondo =  HSSFCellStyle.SOLID_FOREGROUND;
			this.colorFondo = colorFondo;
		}else{
			this.colorFondo = colorFondo;
		}
	}

	/**
	 * Gets the color fuente.
	 * 
	 * @return the color fuente
	 */
	public short getColorFuente() {
		return this.colorFuente;
	}

	/**
	 * Sets the color fuente.
	 * 
	 * @param colorFuente the new color fuente
	 */
	public void setColorFuente(short colorFuente) {
		this.colorFuente = colorFuente;
	}

	/**
	 * Gets the tipo dato.
	 * 
	 * @return the tipo dato
	 */
	public short getTipoDato() {
		return this.tipoDato;
	}

	/**
	 * Sets the tipo dato.
	 * 
	 * @param tipoDato the new tipo dato
	 */
	public void setTipoDato(short tipoDato) {
		this.tipoDato = tipoDato;
	}

	/**
	 * Gets the tipo fuente.
	 * 
	 * @return the tipo fuente
	 */
	public String getTipoFuente() {
		return this.tipoFuente;
	}

	/**
	 * Sets the tipo fuente.
	 * 
	 * @param tipoFuente the new tipo fuente
	 */
	public void setTipoFuente(String tipoFuente) {
		this.tipoFuente = tipoFuente;
	}

	/**
	 * Gets the dato.
	 * 
	 * @return the dato
	 */
	public String getDato() {
		return this.dato;
	}

	/**
	 * Sets the dato.
	 * 
	 * @param dato the new dato
	 */
	public void setDato(String dato) {
		this.dato = dato;
	}

	/**
	 * Gets the posicion x.
	 * 
	 * @return the posicion x
	 */
	public short getPosicionX() {
		return this.posicionX;
	}

	/**
	 * Sets the posicion x.
	 * 
	 * @param posicionX the new posicion x
	 */
	public void setPosicionX(int posicionX) {
		this.posicionX = (short)posicionX;
	}

	/**
	 * Gets the numero hoja.
	 * 
	 * @return the numero hoja
	 */
	public int getNumeroHoja() {
		return this.numeroHoja;
	}

	/**
	 * Sets the numero hoja.
	 * 
	 * @param numeroHoja the new numero hoja
	 */
	public void setNumeroHoja(int numeroHoja) {
		this.numeroHoja = numeroHoja;
	}

	/**
	 * Gets the posicion y.
	 * 
	 * @return the posicion y
	 */
	public int getPosicionY() {
		return this.posicionY;
	}

	/**
	 * Sets the posicion y.
	 * 
	 * @param posicionY the new posicion y
	 */
	public void setPosicionY(int posicionY) {
		this.posicionY = posicionY;
	}

	/**
	 * Checks if is fuente italica.
	 * 
	 * @return true, if is fuente italica
	 */
	public boolean isFuenteItalica() {
		return this.fuenteItalica;
	}

	/**
	 * Sets the fuente italica.
	 * 
	 * @param fuenteItalica the new fuente italica
	 */
	public void setFuenteItalica(boolean fuenteItalica) {
		this.fuenteItalica = fuenteItalica;
	}

	/**
	 * Gets the tamanno fuente.
	 * 
	 * @return the tamanno fuente
	 */
	public short getTamannoFuente() {
		return this.tamannoFuente;
	}

	/**
	 * Sets the tamanno fuente.
	 * 
	 * @param tamannoFuente the new tamanno fuente
	 */
	public void setTamannoFuente(short tamannoFuente) {
		this.tamannoFuente = tamannoFuente;
	}

	/**
	 * Gets the fuente negrita.
	 * 
	 * @return the fuente negrita
	 */
	public short getFuenteNegrita() {
		return this.fuenteNegrita;
	}

	/**
	 * Sets the fuente negrita.
	 * 
	 * @param negrita the new fuente negrita
	 */
	public void setFuenteNegrita(boolean negrita) {
		if(negrita){
			this.fuenteNegrita = HSSFFont.BOLDWEIGHT_BOLD;
		}
	}

	/**
	 * Gets the fuente subrayado.
	 * 
	 * @return the fuente subrayado
	 */
	public byte getFuenteSubrayado() {
		return this.fuenteSubrayado;
	}

	/**
	 * Sets the fuente subrayado.
	 * 
	 * @param fuenteSubrayado the new fuente subrayado
	 */
	public void setFuenteSubrayado(byte fuenteSubrayado) {
		this.fuenteSubrayado = fuenteSubrayado;
	}

	/**
	 * @return the posicionXDerecha
	 */
	public short getPosicionXDerecha() {
		return this.posicionXDerecha;
	}

	/**
	 * @param posicionXDerecha the posicionXDerecha to set
	 */
	public void setPosicionXDerecha(int posicionXDerecha) {
		this.posicionXDerecha = (short)posicionXDerecha;
	}

	/**
	 * @return the posicionYAbajo
	 */
	public int getPosicionYAbajo() {
		return this.posicionYAbajo;
	}

	/**
	 * @param posicionYAbajo the posicionYAbajo to set
	 */
	public void setPosicionYAbajo(int posicionYAbajo) {
		this.posicionYAbajo = posicionYAbajo;
	}
	
	
	/**
	 * clone
	 * @return Object Objeto clonado
	 * @throws CloneNotSupportedException Excepcin al clonar
	 */
	public Object clone() throws CloneNotSupportedException{
		Object clone=null;
		try{
			clone=super.clone();
		}catch(CloneNotSupportedException ex){
			throw new CloneNotSupportedException();
		}
		return clone;
	}

	/**
	 * @return the tipoDatoInt
	 */
	public int getTipoDatoInt() {
		return this.tipoDatoInt;
	}

	/**
	 * @param tipoDatoInt the tipoDatoInt to set
	 */
	public void setTipoDatoInt(int tipoDatoInt) {
		this.tipoDatoInt = tipoDatoInt;
	}

	
	
}