package v50b.v50bClasesComunes;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import n38a.exe.N38APISesion;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * Titulo: V50bTokenFactory Empresa: Eurohelp Consulting Copyright: Copyright
 * (c) 2017
 * 
 * @author dlopez
 * @version 1.0
 * 
 */
public abstract class V50bTokenFactory {
	private static final String	CODIGO_APLICACION = Q70ListenerUtils.getApplicationProperty("COD_APLICACION");

	/**
	 * Un constructor para V50bTokenFactory
	 */
	private V50bTokenFactory() {
	}
	
	/**
	 * Devuelve el Document a partir de un String
	 * 
	 * @param string
	 *            El documento W3C DOM a parsear en formato string
	 * @return El document resultante
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	public static Document fncString2DOM(String xmlStr) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
        DocumentBuilder builder;
        Document doc = null;
        try 
        {  
            builder = factory.newDocumentBuilder();  
            doc = builder.parse( new InputSource( new StringReader( xmlStr ) ) );
        } catch (Exception e) {  
            throw e;
        } 
        return doc;
    }

	/**
	 * Devuelve el String a partir de un Document
	 * 
	 * @param document
	 *            El documento W3C DOM a parsear
	 * @return El string resultante
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	public static String fncDOM2String(Document document) throws Exception {
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();
		DOMSource source = new DOMSource(document);
		StringWriter sw = new StringWriter();
		StreamResult result = new StreamResult(sw);
		transformer.transform(source, result);
		String xmlString = sw.toString();

		return xmlString;
	}
	
	/**
	 * 
	 * Este metodo sirve para obtener el token por defecto
	 * 
	 * @author dlopez
	 * @return El token por defecto
	 */
	public static String getDefaultToken() {
		return (V50bTokenFactory.obtenerTokenAplicacion(V50bTokenFactory.CODIGO_APLICACION));
	}

	/**
	 * Devuelve un token de aplicacin vlido
	 * 
	 * @param codAplic
	 *            El codigo de aplicacion
	 * @return token de aplicacin
	 */
	public static String obtenerTokenAplicacion(String codAplic) {
		String tokenAplicacion = null;

		try {
			N38APISesion n38apiSesion = new N38APISesion();
			Document domToken = n38apiSesion.n38APISesionCrearApp(codAplic);
			tokenAplicacion = V50bTokenFactory.fncDOM2String(domToken);
		} catch (Exception e) {
			V50bClsTrazas.error("V50bTokenFactory.ERROR: " + e.toString());
		}

		return tokenAplicacion;
	}

}
