package v50b.v50bClasesComunes;

import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import n38a.exe.N38APISesion;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * @author dlopez2
 * 
 */
public class V50bTokenClientHandler implements SOAPHandler<SOAPMessageContext> {
	
	private static final Logger LOGGER = LoggerFactory
	.getLogger(V50bTokenClientHandler.class);
	
	private TransformerFactory transformerFactory;


	/**
	 * Constructor para V50bTokenClientHandler.
	 */
	public V50bTokenClientHandler() {
		this.transformerFactory = TransformerFactory.newInstance();
	}

	/**
	 * Este es un metodo sobreescrito.
	 * 
	 * @see javax.xml.ws.handler.soap.SOAPHandler#getHeaders()
	 * @return Set<QName>
	 */
	public Set<QName> getHeaders() {
		return new HashSet<QName>();
	}

	/**
	 * Este es un metodo sobreescrito.
	 * 
	 * @see javax.xml.ws.handler.Handler#close(javax.xml.ws.handler.MessageContext)
	 * @param context
	 *            MessageContext
	 */
	public void close(MessageContext context) {
		// Nada que hacer
	}

	/**
	 * Este es un metodo sobreescrito.
	 * 
	 * @see javax.xml.ws.handler.Handler#handleFault(javax.xml.ws.handler.MessageContext)
	 * @param context
	 *            SOAPMessageContext
	 * @return boolean
	 */
	public boolean handleFault(SOAPMessageContext context) {
		this.registerFault(context);
		return true;
	}

	/**
	 * Este es un metodo sobreescrito.
	 * 
	 * @see javax.xml.ws.handler.Handler#handleMessage(javax.xml.ws.handler.MessageContext)
	 * @param context
	 *            SOAPMessageContext
	 * @return boolean
	 */
	public boolean handleMessage(SOAPMessageContext context) {
		boolean valid = true;
		Boolean outbound = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		// solo para los mensajes SALIENTES
		if (outbound != null && outbound.booleanValue()) {
			valid = false;

			try {
				// recuperar codigo de aplicacion de configuracion
				String codigoAplicacion = Q70ListenerUtils.getApplicationProperty("COD_APLICACION");
				// crear token n38 de aplicacion
				N38APISesion n38Sesion = new N38APISesion();

				Document token = n38Sesion
						.n38APISesionCrearApp(codigoAplicacion);
				// recuperar cabecera SOAP
				SOAPHeader soapHeader = context.getMessage().getSOAPHeader();
				// incluir token en la cabecera creada
				Source source = new DOMSource(token);
				Result result = new DOMResult(soapHeader);

				this.transformerFactory.newTransformer().transform(source,
						result);
				// se puede continuar el procesamiento
				valid = true;
				// Registra salientes
				this.registerOutbound(context);
			} catch (Exception e) {
				V50bTokenClientHandler.LOGGER.info("Error recuperando el token de la cabecera", e);
			}
		} else{
			// Registra entrantes
			this.registerInbound(context);
		}

		return valid;
	}
	
	/**
	 * Este metodo sirve para realizar el registro del mensaje saliente
	 * 
	 * @param context
	 *            El contexto del mensaje
	 */
	private void registerOutbound(SOAPMessageContext context) {
		// Obtenemos los valores a registrar
		final String accion = (String) context.get("WL_OP_NAME");
		final String peticion = this.soap2string(context);

		V50bTokenClientHandler.LOGGER.info("REQUEST WL_OP_NAME", accion);
		V50bTokenClientHandler.LOGGER.info(peticion);
	}

	/**
	 * Este metodo sirve para realizar el registro del mensaje entrante
	 * 
	 * @param context
	 *            El contexto del mensaje
	 */
	private void registerInbound(SOAPMessageContext context) {
		// Obtenemos los valores a registrar
		final String accion = (String) context.get("WL_OP_NAME");
		final String respuesta = this.soap2string(context);

		V50bTokenClientHandler.LOGGER.info("RESPONSE WL_OP_NAME", accion);
		V50bTokenClientHandler.LOGGER.info(respuesta);
	}
	
	/**
	 * Este metodo sirve para realizar el registro del fallos
	 * 
	 * @param context
	 *            El contexto del mensaje
	 */
	private void registerFault(SOAPMessageContext context) {
		// Obtenemos los valores a registrar
		final String accion = (String) context.get("WL_OP_NAME");
		final String respuesta = this.soap2string(context);

		// Fijar valores a registrar
		V50bTokenClientHandler.LOGGER.info("FAULT RESPONSE WL_OP_NAME", accion);
		V50bTokenClientHandler.LOGGER.info(respuesta);
	}

	/**
	 * The method soap2string.
	 * @param context SOAPMessageContext
	 * @return String
	 */
	private String soap2string(SOAPMessageContext context) {
		try {
			final SOAPMessage message = context.getMessage();
			final ByteArrayOutputStream out = new ByteArrayOutputStream();

			message.writeTo(out);

			return new String(out.toByteArray());
		} catch (Exception e) {
			V50bTokenClientHandler.LOGGER.info("[ERROR] parseando el mensaje SOAP: ", e);
			return "Error parseando el mensaje SOAP: " + e.toString();
		}
	}
}
