package v50b.v50bClasesComunes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;

import org.w3c.dom.Document;

import v50b.w43df.pid.client.Exception_Exception;
import v50b.w43df.pid.client.W43DfAttribute;
import v50b.w43df.pid.client.W43DfContent;
import v50b.w43df.pid.client.W43DfDocument;
import v50b.w43df.pid.client.W43DfFormat;
import v50b.w43df.pid.client.W43DfGETContent;
import v50b.w43df.pid.client.W43DfGETDocument;
import v50b.w43df.pid.client.W43DfPIDInterface;
import v50b.w43df.pid.client.W43DfPIDService;

import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;



public class V50bPIDUtils {
	
	
	private final static String RUTA_PIF =  Q70ListenerUtils.getApplicationProperty("rutaPif");
	private final static String DOCUMENT_TYPE =  Q70ListenerUtils.getApplicationProperty("documentTypePid");
	private final static String QNAME_NAMESPACE_URI =  Q70ListenerUtils.getApplicationProperty("qname.namespaceURI");
	private final static String QNAME_LOCAL_PART =  Q70ListenerUtils.getApplicationProperty("qname.localpart");	
	private final static String URL_PID =  Q70ListenerUtils.getApplicationProperty("webservice.pid.wsdl");
	private final static String APP_PATH =  Q70ListenerUtils.getApplicationProperty("aplicacion.path");	
	
	public V50bPIDUtils() {}
	

	/**
	 * INVOCAR SERVICIO addDocument DEL PID
	 * @param nombreFichero String
	 * @param bytesFichero byte[]
 	 * @return String oid 
	 * @throws Exception exception
	 */
	public static String addDocument(String nombreFichero, byte[] bytesFichero) throws Exception {
		V50bClsTrazas.depura("V50bPIDUtils.addDocument");
		String oid = "";
		// paso1: SUBIR EL DOCUMENTO AL EXPLORADOR DE PIF
		V50bClsTrazas.depura("V50bPIDUtils.Subir documento al PIF");
		Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();		
		Document sesion=V50bTokenFactory.fncString2DOM(V50bTokenFactory.getDefaultToken());

		String to = V50bPIDUtils.RUTA_PIF + nombreFichero;

		Long expirationSecs=new Long(60*60*24*15); // 15 das
		Y31AttachmentBean resul = service.put(sesion, new ByteArrayInputStream(bytesFichero), to, false, expirationSecs);

		V50bClsTrazas.depura("V50bPIDUtils.Fichero subido al PIF");
		// ESTABLECER CONFIGURACION DEL PID
		V50bClsTrazas.depura("V50bPIDUtils.Configurando PID");
		W43DfPIDService pidService = new W43DfPIDService(new URL(V50bPIDUtils.URL_PID), new QName(V50bPIDUtils.QNAME_NAMESPACE_URI, V50bPIDUtils.QNAME_LOCAL_PART));
		
		V50bTokenClientHandlerResolver resolver = new V50bTokenClientHandlerResolver();
		List<Handler> listaHandlers = new ArrayList<Handler>();
		listaHandlers.add(new V50bTokenClientHandler());
		resolver.setHandlerChain(listaHandlers);
		
		pidService.setHandlerResolver(resolver);
		String urlPid = V50bPIDUtils.URL_PID;
		W43DfPIDInterface documentsManager = pidService.getW43DfPIDPort();
		// Establecimiento del endpoint real. Si no, por defecto se utilizara el que marque el port del WSDL 
		((BindingProvider) documentsManager).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlPid);

		V50bClsTrazas.depura("V50bPIDUtils.W43DfDocument");
		W43DfDocument document = new W43DfDocument();
		// tipo de documento
		document.setType(V50bPIDUtils.DOCUMENT_TYPE);
		// content
		W43DfContent content = new W43DfContent();
		// formato
		V50bClsTrazas.depura("V50bPIDUtils.W43DfContent");
		W43DfFormat format = new W43DfFormat();
		String extension = nombreFichero.substring(nombreFichero.lastIndexOf(".")+1);
		format.setExtension(extension);
		content.setFormat(format);
		content.setPath(resul.getFilePath());
		document.setContent(content);
		W43DfAttribute attribute = new W43DfAttribute();
		attribute.setKey("object_name");
		attribute.getValues().add(nombreFichero);
		document.getAttributes().add(attribute);
		V50bClsTrazas.depura("V50bPIDUtils.Subir documento al PID");
		oid = documentsManager.addDocument(document);
		V50bClsTrazas.depura("V50bPIDUtils.Documento subido al PID");
		V50bClsTrazas.depura("V50bPIDUtils. OID: " + oid);
		return oid;
	}
	
	
	/**
	 * INVOCAR SERVICIO getDocument DEL PID
	 * @param oid String
	 * @param extension String
	 * @throws Exception_Exception exception
	 * @return byte[] bytes del documento
	 */
	
	public static byte[] getDocument(String oid) throws Exception{
		V50bClsTrazas.depura("V50bPIDUtils.getDocument");
		V50bClsTrazas.depura("V50bPIDUtils.Configurando PID");
		W43DfPIDService pidService = new W43DfPIDService(new URL(V50bPIDUtils.URL_PID), new QName(V50bPIDUtils.QNAME_NAMESPACE_URI, V50bPIDUtils.QNAME_LOCAL_PART));
		
		V50bTokenClientHandlerResolver resolver = new V50bTokenClientHandlerResolver();
		List<Handler> listaHandlers = new ArrayList<Handler>();
		listaHandlers.add(new V50bTokenClientHandler());
		resolver.setHandlerChain(listaHandlers);
		
		pidService.setHandlerResolver(resolver);
		String urlPid = V50bPIDUtils.URL_PID;
		W43DfPIDInterface documentsManager = pidService.getW43DfPIDPort();
		// Establecimiento del endpoint real. Si no, por defecto se utilizara el que marque el port del WSDL 
		((BindingProvider) documentsManager).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlPid);
		
		//OBTENER DOCUMENTO
		V50bClsTrazas.depura("V50bPIDUtils.Desacargando documento del PID");
		W43DfGETDocument document = new W43DfGETDocument();
		document.setId(oid);
		W43DfGETContent content = new W43DfGETContent();
		content.setPath(V50bPIDUtils.APP_PATH);
		document.setContent(content);
			
		W43DfDocument w43DfDocument = documentsManager.getDocument(document);

		// paso2: INVOCAR AL SERVICIO GET DEL PIF
		// OBTENER EL NOMBRE DEL FICHERO Y LA EXTENSION
		Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
		Document sesion=V50bTokenFactory.fncString2DOM(V50bTokenFactory.getDefaultToken());
		// INVOCAR SERVICE GET DEL PIF 
		String ruta = w43DfDocument.getContent().getPath();
		InputStream is = service.get(sesion, ruta);
		ByteArrayOutputStream baos = new ByteArrayOutputStream(); 
		int reads = is.read(); 
		while(reads != -1){ 
			baos.write(reads); 
			reads = is.read(); 
		} 
		return baos.toByteArray();
	}
	
	/**
	 * INVOCAR SERVICIO modifyDocument DEL PID
	 * @param fichero V50bClsFichero
	 * @throws Exception exception
	 */
	public static void modifyDocument(String nombreFichero, byte[] bytesFichero, String oid) throws Exception {
		V50bClsTrazas.depura("V50bPIDUtils.modifyDocument");

		Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();		
		Document sesion=V50bTokenFactory.fncString2DOM(V50bTokenFactory.getDefaultToken());

		String to = V50bPIDUtils.RUTA_PIF + nombreFichero;

		Long expirationSecs=new Long(60*60*24*15); // 15 das
		Y31AttachmentBean resul = service.put(sesion, new ByteArrayInputStream(bytesFichero), to, false, expirationSecs);

		V50bClsTrazas.depura("V50bPIDUtils. Fichero subido al PIF");
		// ESTABLECER CONFIGURACION DEL PID
		V50bClsTrazas.depura("V50bPIDUtils. Configurando PID");
		W43DfPIDService pidService = new W43DfPIDService(new URL(V50bPIDUtils.URL_PID), new QName(V50bPIDUtils.QNAME_NAMESPACE_URI, V50bPIDUtils.QNAME_LOCAL_PART));
		
		V50bTokenClientHandlerResolver resolver = new V50bTokenClientHandlerResolver();
		List<Handler> listaHandlers = new ArrayList<Handler>();
		listaHandlers.add(new V50bTokenClientHandler());
		resolver.setHandlerChain(listaHandlers);
		
		pidService.setHandlerResolver(resolver);
		String urlPid = V50bPIDUtils.URL_PID;
		W43DfPIDInterface documentsManager = pidService.getW43DfPIDPort();
		// Establecimiento del endpoint real. Si no, por defecto se utilizara el que marque el port del WSDL 
		((BindingProvider) documentsManager).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlPid);

		V50bClsTrazas.depura("V50bPIDUtils. W43DfDocument");
		
		W43DfDocument document = new W43DfDocument();
		document.setId(oid);
		// tipo de documento
		document.setType(V50bPIDUtils.DOCUMENT_TYPE);
		// content
		V50bClsTrazas.depura("V50bPIDUtils. W43DfContent");
		W43DfContent content = new W43DfContent();
		// formato
		W43DfFormat format = new W43DfFormat();
		String extension = nombreFichero.substring(nombreFichero.lastIndexOf(".")+1);
		format.setExtension(extension);
		content.setFormat(format);
		content.setPath(resul.getFilePath());
		document.setContent(content);
		//atributo
		W43DfAttribute attribute = new W43DfAttribute();
		attribute.setKey("object_name");
		attribute.getValues().add(nombreFichero);
		document.getAttributes().add(attribute);
		documentsManager.modifyDocument(document);
	}
	
	
	public static void deleteDocument(String oid) throws Exception {
		V50bClsTrazas.depura("V50bPIDUtils.deleteDocument");
		W43DfPIDService pidService = new W43DfPIDService(new URL(V50bPIDUtils.URL_PID), new QName(V50bPIDUtils.QNAME_NAMESPACE_URI, V50bPIDUtils.QNAME_LOCAL_PART));
		V50bTokenClientHandlerResolver resolver = new V50bTokenClientHandlerResolver();
		List<Handler> listaHandlers = new ArrayList<Handler>();
		listaHandlers.add(new V50bTokenClientHandler());
		resolver.setHandlerChain(listaHandlers);
		
		pidService.setHandlerResolver(resolver);
		String urlPid = V50bPIDUtils.URL_PID;
		W43DfPIDInterface documentsManager = pidService.getW43DfPIDPort();
		// Establecimiento del endpoint real. Si no, por defecto se utilizara el que marque el port del WSDL 
		((BindingProvider) documentsManager).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, urlPid);
		
		documentsManager.deleteDocument(oid);
		
	}
}
