package v50b.v50bClasesComunes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.StringTokenizer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

/**
 * The Class V50bClsXML.
 * 
 * @author Iaki Cantalapiedra Bernal
 */
public class V50bClsXML {
	
	/**
	 * Instantiates a new v50b cls xml.
	 */
	private V50bClsXML(){}
	
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static String COMPONENTE = "V50ClsXML"; 
	
	/**
	 * Crea un objeto de la clase Document a partir del String XML que recibe
	 * como parametro.
	 * 
	 * @param xml String xml
	 * 
	 * @return Document objeto de la clase Document.
	 * 
	 * @throws Exception the exception
	 */
	
	public static Document fncCrearDoc(String xml) throws Exception {
		//final String metodo ="crearDoc";
		Document doc = null;
		DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
		//try {
			DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
			try{
				doc = documentBuilder.parse((InputStream)new ByteArrayInputStream(xml.getBytes("8859_1")));				
			}
			catch(SAXException sax){
				if (V50bClsXML.tr.isTraceActive()) {
					V50bClsXML.tr.trace(V50bClsXML.COMPONENTE, Q70TraceLevel.ERROR,"XML mal construido: "+xml);                
	            }   				
				throw sax;
			}
		//}catch (Exception e) {
		//	if (tr.isTraceActive()) {
        //        tr.trace(COMPONENTE, Q70TraceLevel.ERROR,"Error en la creacion del
        // Documento XML");
        //    }
		//}
		//finally{
		return doc;
		//}
	}
	
	/**
	 * Recupera el valor de un elemento.
	 * 
	 * @param elemento - el elemento del que se recupera el valor
	 * 
	 * @return String - valor del elemento
	 */
	
	public static String fncRecuperarValorElemento(Element elemento){
		return elemento.getChildNodes().item(0).getNodeValue();
	}
	
	/**
	 * Fnc recuperar valor nodo.
	 * 
	 * @param nodo the nodo
	 * 
	 * @return the string
	 */
	public static String fncRecuperarValorNodo(Node nodo){
		try{
			return nodo.getChildNodes().item(0).getNodeValue();
		}catch(Exception e){
			return "";
		}
	}
	
	/**
	 * Recupera el valor de una etiqueta(nodo) de un documento.
	 * 
	 * @param document - el documento del que se recupera el valor de la etiqueta
	 * @param rutaElemento - la ruta del nodo dentro del documento, separado por '.'
	 * 
	 * @return String - valor de la etiqueta (nodo)
	 * 
	 * @throws Exception the exception
	 */
	
	public static String fncRecuperarValorElemento(Document document,String rutaElemento)throws Exception {
		String resultado = null;
		StringTokenizer tokCadena = null;
		String bloque = null;
		NodeList listaNodos = null;
		Element elemento = null;
		int contador = 0;
		
		//try{
			tokCadena = new StringTokenizer(rutaElemento,".");
			while (tokCadena.hasMoreTokens()){
				bloque = tokCadena.nextToken();
				if (contador == 0){
					listaNodos = document.getElementsByTagName(bloque);
				}
				else{
					listaNodos = elemento.getElementsByTagName(bloque);
				}
				elemento = (Element)listaNodos.item(0);
				contador++;
			}				
			if (listaNodos.item(0).getChildNodes().item(0) != null){
				resultado = (listaNodos.item(0).getChildNodes().item(0)).getNodeValue();
			}
			return resultado;
		/*
         * } catch (Exception e){ } finally{ return resultado; }
         */
	}

	/**
	 * Recupera la lista de nodos de una etiqueta.
	 * 
	 * @param document - el documento del que se recupera la lista de nodos
	 * @param rutaElemento - la ruta de la etiqueta dentro del documento, separado por '.'
	 * 
	 * @return NodeList - lista de nodos
	 * 
	 * @throws Exception the exception
	 */
	
	public static NodeList fncRecuperarListaElementos(Document document,String rutaElemento)throws Exception{
		NodeList listaResultado = null;
		StringTokenizer tokCadena = null;
		String bloque = null;
		NodeList listaNodos = null;
		Element elemento = null;
		int contador = 0;
		
		//try{
			tokCadena = new StringTokenizer(rutaElemento,".");
			while (tokCadena.hasMoreTokens()){
				bloque = tokCadena.nextToken();
				if (contador == 0){
					listaNodos = document.getElementsByTagName(bloque);
				}
				else{
					listaNodos = elemento.getElementsByTagName(bloque);
				}
				elemento = (Element)listaNodos.item(0);
				contador++;
			}
			if (listaNodos != null)
			{
			listaResultado = listaNodos;
			}
			return listaResultado;
		/*
         * } catch (Exception e){
         *  } finally{ return listaResultado; }
         */
	}

	/**
	 * Devuelve un nodo de una lista de nodos.
	 * 
	 * @param listaNodos NodeList: Lista de nodos
	 * @param elemento int:El elemento de la lista de nodos
	 * @param nodo int: El nodo dentro del elemento
	 * 
	 * @return the node
	 * 
	 * @throws Exception the exception
	 */
	public static Node fncRecuperarNodo(NodeList listaNodos,int elemento, int nodo)throws Exception{
		return listaNodos.item(elemento).getChildNodes().item(nodo);
	}

	/**
	 * Devuelve el valor de un atributo.
	 * 
	 * @param nodo Node:Nodo que contiene el atributo
	 * @param strPfAtributo String:Nombre del atributo
	 * 
	 * @return String:Valor del atributo
	 * 
	 * @throws Exception the exception
	 */
	public static String fncValorAtributo(Node nodo,String strPfAtributo)throws Exception{
		if(nodo.hasAttributes()){    
			try{
				return nodo.getAttributes().getNamedItem(strPfAtributo).getNodeValue();
			}catch(Exception e){
				return "";
			}
    	}else{
    		return "";
    	}
	}	
	
	/**
	 * Devuelve el String a partir de un Document.
	 * 
	 * @param doc Document: El xml
	 * 
	 * @return the string
	 * 
	 * @throws Exception the exception
	 */
	public static String fncObtenerStringDoc(Document doc)throws Exception{
	    TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StringWriter sw=new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        return sw.toString();
		
	}
}
