package v50b.v50bClasesComunes;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import v50b.v50bClasesComunes.v50bBeansComunes.V50bWordBean;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * <p>Ttulo: V50bClsWord</p>
 * <p>Descripcin: Utilidades de generacion de Certificados Word</p>
 * <p>Copyright: Copyright (c) 2007</p>
 * <p>Empresa: Eurohelp Consulting</p>.
 * 
 * @author Iaki Cantalapiedra Bernal
 * @version 1.0
 */
public class V50bClsWord {

	/**
	 * Instantiates a new v50b cls word.
	 */
	private V50bClsWord(){}
	
	/**
	 * Envia un SMS.
	 * 
	 * @param request the request
	 * @param response the response
	 * @param contexto the contexto
	 * @param wordBean the word bean
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha	  	10/01/2007
	 */
	public static void fncGenerarWord(HttpServletRequest request, HttpServletResponse response, Q70ContextoEJIE contexto, V50bWordBean wordBean) throws Exception{
	
		String strut = "comunJSP";
		String action =(String)request.getRequestURI().substring(1);
		action = action.substring(action.indexOf("/")+1);//path completo del action dentro de la aplicacion.                
		if(action.indexOf("/")!=-1){
			strut= action.substring(0,action.indexOf("/"));//Ya tenemos el strut y el action
		}
		
		final StringBuffer v50bstrXml = V50bClsFunciones.generarXML(wordBean.getArrDatos());
		
		V50bClsFichero plantilla = new V50bClsFichero();
		plantilla.setNombreReal(wordBean.getNombrePlantilla());
		plantilla.setBytesFichero(wordBean.getBytesPlantilla());
		
		contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_FICHERO, plantilla);
		
		//Preparamos el XML que nos servira de comunicacion.
		final StringBuffer xml = new StringBuffer(V50bClsConstantes.CUATROCIENTOS);
		xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>");
		xml.append("<ajax-response><responseGenerarWord>");
		xml.append("<strActionWord>");
		xml.append(Q70ListenerUtils.getApplicationProperty("WEBROOT_V50B")+"/"+strut+"/"+Q70ListenerUtils.getApplicationProperty("URL_SERVICIO_GENERACION_CERTIFICADOS")+"?idWord="+System.currentTimeMillis());
		xml.append("</strActionWord>");
		xml.append("<strXml>");
		xml.append("<![CDATA["+v50bstrXml.toString()+"]]>");
		xml.append("</strXml>");
		xml.append("<rutaWordTemp>");
		xml.append(Q70ListenerUtils.getApplicationProperty("RUTA_WORD_TEMP"));
		xml.append("</rutaWordTemp>");
		xml.append("<siguientePeticion>");
		if(wordBean.getSiguientePeticion()!=null 
				&& wordBean.getSiguientePeticion().length==V50bClsConstantes.TRES
				&& !wordBean.getSiguientePeticion()[0].equals("")
				&& !wordBean.getSiguientePeticion()[1].equals("")){
			xml.append("'" + wordBean.getSiguientePeticion()[0] + "', '" + wordBean.getSiguientePeticion()[1]);
				if(!wordBean.getSiguientePeticion()[2].equals("null") && !wordBean.getSiguientePeticion()[2].equals("")){
					xml.append("', '" + wordBean.getSiguientePeticion()[2] + "'");
				} else {
					xml.append("', null");
				}
			//xml.append("'colaboradoresJSP/preImprimirEtiquetas.do','v50bListaSelColaboradores',null");
		} else {
			xml.append("null");
		}
		xml.append("</siguientePeticion>");
		xml.append("</responseGenerarWord></ajax-response>");
		
		response.setContentType("text/xml");
		response.addHeader("Expires", "-1");
    	response.addHeader("Cache-control", "no-store, no-cache, must-revalidate");
    	
		PrintWriter pw = response.getWriter();
		pw.write(xml.toString());
		pw.close();
	}
	
}