package v50b.v50bClasesComunes;

import java.util.List;
import java.util.StringTokenizer;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * The Class V50bClsTrazas.
 * 
 * @author iurkidi
 */
public class V50bClsTrazas {
	
	/**
	 * Instantiates a new v50b cls trazas.
	 */
	private V50bClsTrazas(){}
	
	public static final Logger log = new ConsoleLogger(ConsoleLogger.LEVEL_INFO);
	
	private static Q70Traza tr = Q70Traza.getSingleton();
	
	
	/**
	 * Imprime trazas.
	 * 
	 * @param componente the componente
	 */
	public static void depura(String componente) {
		if (V50bClsTrazas.tr.isTraceActive()) {
			 //if(componente!=null){
				 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,componente);
			 /*}else{
				 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,"NULL");
			 }*/
		}
		V50bClsTrazas.fncEscribeEnConsola(componente+"\n");
	}
	
	 /**
 	 * Imprime trazas desde con un Objet
 	 * (Sobrecarga metodo para pasarle un object).
 	 * 
 	 * @param componente String: texto identificativo
 	 * @param obj Object: objeto a imprimir
 	 */
	 public static void depura(String componente, Object obj){
			 if (V50bClsTrazas.tr.isTraceActive()) {
				 //if(obj!=null){
					 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,componente+": "+obj);
				 /*}else{
					 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,componente+": NULL");	
				 }*/
				 			
			 }
			V50bClsTrazas.fncEscribeEnConsola(componente+": " + obj + "\n");
		 
	 }
	 
	 /**
 	 * Imprime trazas desde con un Objet
 	 * (Sobrecarga metodo para pasarle un object).
 	 * 
 	 * @param componente String: texto identificativo
 	 * @param obj Object: objeto a imprimir
 	 */
	 protected static void fatal(String componente, Object obj){
			 if (V50bClsTrazas.tr.isTraceActive()) {
				 //if(obj!=null){
					 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.FATAL,componente+": "+obj);
				 /*}else{
					 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.FATAL,componente+": NULL");
				 }*/
			 }
			V50bClsTrazas.fncEscribeEnConsolaFatal(componente+": " + obj + "\n");
		 
	 }
	 
	 /**
		 * Imprime trazas.
		 * 
		 * @param componente the componente
		 */
		public static void error(String componente) {
			if (V50bClsTrazas.tr.isTraceActive()) {
				 //if(componente!=null){
					 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.ERROR,componente);
				 /*}else{
					 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,"NULL");
				 }*/
			}
			V50bClsTrazas.fncEscribeEnConsolaError(componente+"\n");
		}
	 
	 /**
 	 * Imprime trazas desde con un Objet y la Clase desde donde se invoca
 	 * (Sobrecarga metodo para pasarle un object y clase).
 	 * 
 	 * @param componente String: texto identificativo
 	 * @param cadena Object: objeto a imprimir
 	 * @param clase Class: clase desde la que se invoca
 	 */
	 public static void depura(String componente,Object cadena,Class clase){
		 if (V50bClsTrazas.tr.isTraceActive()) {
			 //if(cadena!=null){
				 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,componente+": "+cadena);
				 V50bClsTrazas.fncEscribeEnConsola(clase.getName() + " -> " + componente+": " + cadena);
			 /*}
			 else {
				 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,componente+": NULL");
				 V50bClsTrazas.fncEscribeEnConsola(clase.getName() + " -> " + componente+": NULL");
			 }*/
		 }
		 V50bClsTrazas.fncEscribeEnConsola("\n");
		 
	 }	 
	 
	 /**
 	 * Depura bd.
 	 * 
 	 * @param componente the componente
 	 * @param obj the obj
 	 */
 	public static void depuraBD(String componente,Object obj){
			 if (V50bClsTrazas.tr.isTraceActive()) {
				 //if(obj!=null){
					 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,componente.toUpperCase()+": "+obj);
				 /*}else{
					 V50bClsTrazas.tr.trace(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"), Q70TraceLevel.DEBUG,componente.toUpperCase()+": NULL");
				 }*/
			 }
			V50bClsTrazas.fncEscribeEnConsola(componente.toUpperCase()+": " + obj + "\n");
	 }
	 
 	
	 /**
 	 * Fnc traza sql.
 	 * 
 	 * @param sqlP the sql p
 	 * @param arrCampos the arr campos
 	 * 
 	 * @return the string
 	 */
 	public static String fncTrazaSQL(String sqlP, List arrCampos) {
			
		 	 String sql = sqlP;
		 
			 if (arrCampos!=null){
				StringBuffer retSql = new StringBuffer();
				
				boolean seguro = false;
				sql = sql.toUpperCase();
				if(sql.charAt(sql.length()-1)=='?') {
					sql = sql.concat("SEGURO");
					seguro = true;
				}
				
				StringTokenizer interrogante = new StringTokenizer(sql,"?");
				
				int i = 0;
				
				while(interrogante.hasMoreTokens()){
					
					retSql.append(interrogante.nextToken());
	
					if(interrogante.hasMoreTokens()){
						
						if(i>arrCampos.size()-1) {
							return "El array de campos tiene menos campos que interrogantes la sentencia SQL";
						}
						
						Object campo = arrCampos.get(i);
						
						if(campo == null || campo.equals("")) {
							return "El array de campos contiene una posicion a Null o String vacio en la posicin " + i;
						}
						
						if (campo instanceof String) {
							if(campo.toString().equals(V50bClsConstantes.CONSTANTE_NULO_STRING)){
								retSql.append("NULL");
							}
							else if(campo.toString().equals(V50bClsConstantes.CONSTANTE_NULO_INTEGER)){
								retSql.append("NULL");
							}
							else if(campo.toString().equals(V50bClsConstantes.CONSTANTE_NULO_DATE)){
								retSql.append("NULL");
							}
							else if(campo.toString().equals(V50bClsConstantes.CONSTANTE_NULO_FLOAT)){
								retSql.append("NULL");
							}
							else if(campo.toString().equals(V50bClsConstantes.CONSTANTE_NULO_DOUBLE)){
								retSql.append("NULL");
							}
							else{
								retSql.append("'");
								retSql.append(campo.toString());
								retSql.append("'");
							}
						}
						else if(campo instanceof Integer || campo instanceof Double){
							retSql.append(campo.toString());
						}
						else{
							//return "El array de campos tiene un objeto no valido en la posicin " + i;
							retSql.append(campo.toString());
						}
						i++;
					}	
				}
				
				if(i!=arrCampos.size()){
					return "La sentencia SQL tiene menos interrogantes que el array de campos posiciones";
				}
				
				if(seguro) {
					retSql.delete(retSql.length()-V50bClsConstantes.SEIS,retSql.length());
				}
				
				return V50bClsTrazas.fncFormateaQuery(retSql.toString());
			 } else {
				return V50bClsTrazas.fncFormateaQuery(sql);
			}
		}
		
	 
		/**
		 * Fnc formatea query.
		 * 
		 * @param sql the sql
		 * 
		 * @return the string
		 */
		private static String fncFormateaQuery(String sql){
			
			int numCaracteres = 0;
			
			StringBuffer retSql = new StringBuffer();
			
			StringTokenizer espacio = new StringTokenizer(sql," ");
			
			boolean primera = true;
			
			retSql.append("\n");
			
			while(espacio.hasMoreTokens()){
				
				String palabra = espacio.nextToken();
				
				if(primera && (!"SELECT".equals(palabra) && !"UPDATE".equals(palabra) 
						&& !"INSERT".equals(palabra) && !"DELETE".equals(palabra))){
					return "La sentencia SQL no parece valida";
				}
				
				primera = false;
				
				if("FROM".equals(palabra) || "AND".equals(palabra) || "ORDER".equals(palabra) 
						|| "GROUP".equals(palabra) || "WHERE".equals(palabra) || "SET".equals(palabra)) {
					retSql.append("\n");
					retSql.append(palabra);
					retSql.append(" ");
					numCaracteres=palabra.length()+1;
				}
				else if("UNION".equals(palabra)){
					retSql.append("\n");
					retSql.append(" ");
					retSql.append(palabra);
					retSql.append("\n");
					numCaracteres=0;
				}
				else{
					if (numCaracteres+palabra.length()+1>V50bClsConstantes.SETENTAYNUEVE){
						retSql.append("\n");
						numCaracteres=0;
					}
					retSql.append(palabra);
					retSql.append(" ");
					numCaracteres+=palabra.length()+1;
				}
				
			}
			retSql.deleteCharAt(retSql.length()-1);
			retSql.append(";");
			
			return retSql.toString();
		}
		
		
		
		/**
		 * Fnc escribe en consola.
		 * 
		 * @param traza the traza
		 */
		private static void fncEscribeEnConsola(Object traza) {
			String strEntornoAplic=Q70ListenerUtils.getApplicationProperty("ENTORNO_V50B");
			if("LOCAL".equals(strEntornoAplic)){
				if(traza!=null){
					V50bClsTrazas.log.info(traza.toString());
				}else{
					V50bClsTrazas.log.info("NULL");
				}
			}
		}
		
		
		/**
		 * Fnc escribe en consola fatal.
		 * 
		 * @param traza the traza
		 */
		private static void fncEscribeEnConsolaFatal(Object traza) {
			String strEntornoAplic=Q70ListenerUtils.getApplicationProperty("ENTORNO_V50B");
			if("LOCAL".equals(strEntornoAplic)){
				if(traza!=null){
					V50bClsTrazas.log.fatalError(traza.toString());
				}else{
					V50bClsTrazas.log.fatalError("NULL");
				}
				
			}
		}
		
		/**
		 * Fnc escribe en consola fatal.
		 * 
		 * @param traza the traza
		 */
		private static void fncEscribeEnConsolaError(Object traza) {
			String strEntornoAplic=Q70ListenerUtils.getApplicationProperty("ENTORNO_V50B");
			if("LOCAL".equals(strEntornoAplic)){
				if(traza!=null){
					V50bClsTrazas.log.error(traza.toString());
				}else{
					V50bClsTrazas.log.error("NULL");
				}
				
			}
		}
		
		
}