package v50b.v50bClasesComunes;

import javax.servlet.http.HttpServletRequest;

import v50b.v50bClasesComunes.v50bBeansComunes.V50bSMSBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.sms.Q70Constantes;
import es.ejie.frmk.infraestructura.sms.Q70SMSException;
import es.ejie.frmk.infraestructura.sms.Q70SMSMessage;
import es.ejie.frmk.infraestructura.sms.Q70SMSPeticion;
import es.ejie.frmk.infraestructura.sms.Q70SMSPeticionException;
import es.ejie.frmk.infraestructura.sms.Q70SMSTelefono;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

import java.util.StringTokenizer;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;

import n38a.exe.N38APISesion;
import n38c.exe.N38API;
import org.apache.commons.lang.StringUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * <p>T�tulo: V50bClsSMS</p>
 * <p>Descripci�n: Utilidades de envio de SMS para Geremua v2.0</p>
 * <p>Copyright: Copyright (c) 2007</p>
 * <p>Empresa: Eurohelp Consulting</p>
 * @author I�aki Cantalapiedra Bernal
 * @version 1.0
 */
public class V50bClsSMS {

	private static NVPair nvPairs[] = new NVPair[2];
	private static String SOAP1="<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:w91d=\"http://w91d\"><soapenv:Header>";
	private static String SOAP2="</soapenv:Header><soapenv:Body><StringInput xmlns=\"http://w91d\"><![CDATA[<?xml version=\"1.0\" encoding=\"UTF-8\"?><PETICION><LATINIA><MENSAJES><MENSAJE_INFO><TEXTO><![CDATA[";
	//MENSAJE +
	private static String SOAP3="]]]]>><![CDATA[</TEXTO><GSM_DEST>";
	//TELEFONO
	private static String SOAP4="</GSM_DEST></MENSAJE_INFO></MENSAJES></LATINIA></PETICION>]]></StringInput></soapenv:Body></soapenv:Envelope>";


	/**
	 * Instantiates a new v50b cls sms.
	 */
	private V50bClsSMS(){}

	/**
	   * Envia un SMS.
	    * @param  	request La request desde el servlet.
	   * @param  	smsBean Objeto con la informacion del SMS a enviar
	   * @return	int
	   *
	   * @author    I�aki Cantalapiedra Bernal
	   * @version 	1.0
	   * @fecha	  	10/01/2007
	   * @throws 	Exception Cualquier excepcion
	   */
	public static int fncEnviarSMS(HttpServletRequest request, V50bSMSBean smsBean) throws Exception{

		V50bClsTrazas.depura("V50bClsSMS.fncEnviarSMS()");
		try{

			N38APISesion apiSesion = new N38APISesion();
			final Document token = apiSesion.n38APISesionCrearApp(Q70ListenerUtils.getApplicationProperty("COD_APLICACION"));
			V50bClsTrazas.depura(V50bClsXML.fncObtenerStringDoc(token));

			final N38API miAPI = new N38API(token);
			final Document seguridadLatinia = miAPI.n38ItemSeguridad(Q70ListenerUtils.getApplicationProperty("N38UID"));
			V50bClsTrazas.depura(V50bClsXML.fncObtenerStringDoc(seguridadLatinia));

			String strCadena="";
			Node nodo = XPathAPI.selectSingleNode(seguridadLatinia, "/n38/elementos/elemento/elemento[@subtipo='n38itemSeguridad']/parametro[@id='n38cadescripcion']/valor/text()");
			if (nodo!=null){
				strCadena=nodo.getNodeValue();
			}

			V50bClsTrazas.depura(strCadena);

			String resultado = V50bClsSMS.enviarMensajeSMS(smsBean, strCadena);
			if (StringUtils.isNotBlank(resultado)){
				int indiceResultado = StringUtils.indexOf(resultado, "<RESULTADO>");
				int indiceResultadoFinal = StringUtils.indexOf(resultado, "</RESULTADO>");
				if (indiceResultado>-1 && indiceResultadoFinal>-1){
					String resultadoMensaje = StringUtils.substring(resultado, indiceResultado+11,indiceResultadoFinal);
					if ("OK".equals(resultadoMensaje)){
						return V50bClsConstantes.ENVIADO_CORRECTO;
					}
				}
			}
			return V50bClsConstantes.ENVIADO_INCORRECTO;
		}catch (Exception e) {
			return V50bClsConstantes.ENVIADO_INCORRECTO;
		}
	}

	/**
	 *
	 * Metodo sobreescrito
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 * @param smsBean V50bSMSBean
	 * @param cadena String
	 * @return String
	 * @throws Exception excepcion
	 */
	public static String enviarMensajeSMS(V50bSMSBean smsBean, String cadena) throws Exception {
		V50bClsTrazas.depura("V50bGestorSMS.enviarMensajeSMS()");

		final String Host = Q70ListenerUtils.getApplicationProperty("URL_ENVIO_SMS");
		final String EndPoint = Q70ListenerUtils.getApplicationProperty("SMS_END_POINT");
        final HTTPConnection httpCon = V50bClsSMS.getConnection("http",Host,V50bClsConstantes.OCHENTA);

		final String n38Sesion = V50bClsSMS.autentificacionLatinia(cadena);
		final String sResultado= V50bClsSMS.enviar(httpCon,EndPoint,n38Sesion,smsBean.getTelefono(),smsBean.getTextoSMS());

		V50bClsTrazas.depura("Host:" + Host);
		V50bClsTrazas.depura("EndPoint:" + EndPoint);
		V50bClsTrazas.depura("Autentificaci�n:" + n38Sesion);
		V50bClsTrazas.depura("Telefono:" + smsBean.getTelefono());
		V50bClsTrazas.depura("Resultado:" + sResultado);
		return sResultado;
	}


	/**
	 * @autor llaparra
	 * @param cadenaSegLatinia String
	 * @return String
	 */
	private static String autentificacionLatinia(String cadenaSegLatinia){

		final StringTokenizer tokens = new StringTokenizer(cadenaSegLatinia, "#");
		final String [] parametros = new String [V50bClsConstantes.CUATRO];

		int i=0;
		while (tokens.hasMoreElements()){
			parametros[i]=tokens.nextToken();
			++i;
		}
		String cadena = "<authenticationLatinia><userLatinia>XXXXXXXXXXXXXXXXXXXXXXXXX</userLatinia>"+
			"<passwordLatinia>XXXXXXXXXXXXXXXXXXXXXXXXX</passwordLatinia>"+
			"<refProduct>"+parametros[0]+"</refProduct><idContract>"+parametros[1]+"</idContract>"+
			"<loginEnterprise>"+parametros[2]+"</loginEnterprise><password>"+parametros[V50bClsConstantes.TRES]+"</password>"+
			"</authenticationLatinia>";
		return cadena;
	}

	/**
	 *
	 * @autor llaparra
	 * @param protocol String
	 * @param hostname String
	 * @param port String
	 * @return HTTPConnection
	 * @throws Exception Exception
	 */
	private static HTTPConnection getConnection(String protocol, String hostname, int port) throws Exception{
		HTTPConnection httpcon=null ;
        try
        {
        	httpcon = new HTTPConnection(protocol, hostname, port);
        	V50bClsSMS.nvPairs[0] = new NVPair("content-type", "text/xml;charset=utf-8");
        }
        catch (ProtocolNotSuppException e)
        {
            e.printStackTrace();
        }
        return httpcon;
    }

	/**
	 *
	 * @autor llaparra
	 * @param httpConnection HTTPConnection
	 * @param EndPoint String
	 * @param soap String
	 * @return String
	 */
    private static String sendSOAP(HTTPConnection httpConnection,String EndPoint,String soap){
        HTTPResponse rsp;
        try{
                httpConnection.setAllowUserInteraction(false);
                rsp = httpConnection.Post(EndPoint, soap.getBytes("UTF8"), V50bClsSMS.nvPairs);
                return  new String(rsp.getData());
        }
        catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }

	/**
	 *
	 * @autor llaparra
	 * @param httpCon HTTPConnection
	 * @param EndPoint String
	 * @param XMLAutenticacion String
	 * @param Telefono String
	 * @param Mensaje String
	 * @return String
	 */
    private static String enviar(HTTPConnection httpCon,String EndPoint,String XMLAutenticacion, String Telefono, String Mensaje){
    	if(null==httpCon){
    		return null;
    	}
		String mensaje=V50bClsSMS.SOAP1+XMLAutenticacion+V50bClsSMS.SOAP2+Mensaje+V50bClsSMS.SOAP3+Telefono+V50bClsSMS.SOAP4;
		try{
			return V50bClsSMS.sendSOAP(httpCon,EndPoint,mensaje);
		}catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}

}
