package v50b.v50bClasesComunes;
 
import java.io.IOException;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import es.ejie.frmk.infraestructura.seguridad.Q70GestorSeguridad;
import es.ejie.frmk.infraestructura.seguridad.Q70InformacionSeguridadAplicacion;
import es.ejie.frmk.infraestructura.seguridad.Q70InformacionSeguridadUsuario;
import es.ejie.frmk.infraestructura.seguridad.Q70LogonException;
import es.ejie.frmk.infraestructura.seguridad.Q70SeguridadException;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * <p>Ttulo: ClsPermisos</p>
 * <p>Descripcin:Analiza los permisos de acceso a funciones </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Empresa: eurohelp</p>.
 * 
 * @author David Belmez
 * @version 1.0
 */

public final class V50bClsPermisos {
	
	/**
	 * Instantiates a new v50b cls permisos.
	 */
	private V50bClsPermisos(){}
	
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static String COMPONENTE="v50bClsPermisos";
	private static String COD_APLICACION="v50b";
	
	private static String PERFIL_TECNICO_IVAP = Q70ListenerUtils.getApplicationProperty(V50bClsPermisos.COMPONENTE, null, "PERFIL_TECNICO_IVAP");
	
 	/**
	  * Recupera el Session String.
	  * 
	  * @return String con el token String
	  * 
	  * @throws Q70SeguridadException the q70 seguridad exception
	  * @throws ParserConfigurationException the parser configuration exception
	  * @throws IOException Signals that an I/O exception has occurred.
	  * @throws SAXException the SAX exception
	  * @throws Exception the exception
	  */    
    public static String fncGetSessionTokenGestorSeguridad() throws Q70SeguridadException, ParserConfigurationException, SAXException, IOException,Exception{
        Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
        Q70InformacionSeguridadAplicacion infSeguridad = gestorSeguridad.createSecurityApplicationInfo(V50bClsPermisos.COD_APLICACION);        
        return V50bClsXML.fncObtenerStringDoc(infSeguridad.getXLNESessionTolkit().n38APISesionCrearApp(V50bClsPermisos.COD_APLICACION));
    }    
    
    /**
     * Recupera el Session Token, si existe en el ocntexto del contexto, y sino del gestor de seguridad.
     * 
     * @param contexto Q70ContextoEJIE: Contexto de la aplicacion
     * 
     * @return String con el token String
     * 
     * @throws Q70SeguridadException the q70 seguridad exception
     * @throws ParserConfigurationException the parser configuration exception
     * @throws IOException Signals that an I/O exception has occurred.
     * @throws SAXException the SAX exception
     * @throws Exception the exception
     */    
    public static String fncGetSessionToken(Q70ContextoEJIE contexto) throws Q70SeguridadException, ParserConfigurationException, SAXException, IOException,Exception{
    	String strSessionToken=(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_SESSION_TOKEN);     
    	if (strSessionToken!=null && !strSessionToken.equals("")){
    		if (V50bClsPermisos.tr.isTraceActive()) {
    			V50bClsPermisos.tr.trace(V50bClsPermisos.COMPONENTE, Q70TraceLevel.DEBUG,"Recuperando Session Token del Contexto...");                
        	}     		
    	}else{
    		//si no recuperarlo del gestor de seguridad, guardarlo en el contexto y enviarlo   
    		if (V50bClsPermisos.tr.isTraceActive()) {
    			V50bClsPermisos.tr.trace(V50bClsPermisos.COMPONENTE, Q70TraceLevel.DEBUG,"Recuperando Session Token...");                
        	} 
    		strSessionToken=V50bClsPermisos.fncGetSessionTokenGestorSeguridad();
    		contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_SESSION_TOKEN,strSessionToken);
    	}
    	return strSessionToken;
    }
    
    /**
     * Recupera un elemento de n38.
     * 
     * @param request the request
     * @param strPfElemento the str pf elemento
     * 
     * @return the list
     * 
     * @throws Q70SeguridadException the q70 seguridad exception
     * @throws Q70LogonException the q70 logon exception
     */
	private static List fncGetElemento(HttpServletRequest request,String strPfElemento) throws Q70SeguridadException, Q70LogonException{
		Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
    	Q70InformacionSeguridadUsuario infUsuario=gestorSeguridad.createSecurityUserInfo(request);
    	return (Vector)infUsuario.getSessionSecurityInf(strPfElemento);  	
	}
	
	/**
	 * Fnc get document item seguridad.
	 * 
	 * @param request the request
	 * @param tipo the tipo
	 * 
	 * @return the document
	 * 
	 * @throws Q70SeguridadException the q70 seguridad exception
	 * @throws Q70LogonException the q70 logon exception
	 * @throws Exception the exception
	 */
	public static Document fncGetDocumentItemSeguridad(HttpServletRequest request,String tipo) throws Q70SeguridadException, Q70LogonException, Exception{
		Q70GestorSeguridad gestorSeguridad = Q70GestorSeguridad.getSingleton();
    	Q70InformacionSeguridadUsuario infUsuario=gestorSeguridad.createSecurityUserInfo(request);
    	return infUsuario.getXLNESessionTolkit().n38ItemSeguridad(tipo);  	
	}
    
    /**
     * Recupera si tiene el perfil especificado.
     * 
     * @param request the request
     * @param strPfPerfil the str pf perfil
     * 
     * @return true, if fnc tiene perfil
     * 
     * @throws Q70SeguridadException the q70 seguridad exception
     * @throws Q70LogonException the q70 logon exception
     */
    private static boolean fncTienePerfil(HttpServletRequest request,String strPfPerfil) throws Q70SeguridadException, Q70LogonException{    	    	
    	List vectorPermisos=V50bClsPermisos.fncGetElemento(request,"n38perfiles");  	
    	int intTam=vectorPermisos.size();
    	for (int i=0;i<intTam;i++){
    		String strPerfil=(String)vectorPermisos.get(i);
    		if (V50bClsPermisos.tr.isTraceActive()) {
    			V50bClsPermisos.tr.trace(V50bClsPermisos.COMPONENTE, Q70TraceLevel.DEBUG,"Perfil de usuario:" + strPerfil);                
        	}
    		if (strPerfil.equalsIgnoreCase(strPfPerfil)){
    			if (V50bClsPermisos.tr.isTraceActive()) {
    				V50bClsPermisos.tr.trace(V50bClsPermisos.COMPONENTE, Q70TraceLevel.DEBUG,"Perfil encontrado:" + strPerfil);                
            	}
    			return true;
    		}
    	}
    	if (V50bClsPermisos.tr.isTraceActive()) {
    		V50bClsPermisos.tr.trace(V50bClsPermisos.COMPONENTE, Q70TraceLevel.DEBUG,"Perfil NO encontrado");                
    	}
    	return false;
    }
    
    /**
     * Retorna si el susario tiene el perfil de TECNICO del IVAP.
     * 
     * @param request the request
     * 
     * @return true, if fnc es tecnico ivap
     * 
     * @throws Q70SeguridadException the q70 seguridad exception
     * @throws Q70LogonException the q70 logon exception
     */
    public static boolean fncEsTecnicoIvap(HttpServletRequest request) throws Q70SeguridadException, Q70LogonException{
    	return V50bClsPermisos.fncTienePerfil(request,V50bClsPermisos.PERFIL_TECNICO_IVAP);
    }  
    
    /**
     * Recupera un parametro de la sesion XLNets.
     * 
     * @param request the request
     * @param parametro the parametro
     * 
     * @return the string[]
     * 
     * @throws Q70SeguridadException the q70 seguridad exception
     * @throws Q70LogonException the q70 logon exception
     */
    public static String[] fncObtenerParametro(HttpServletRequest request, String parametro) throws Q70SeguridadException, Q70LogonException{
    	List vectorPermisos=V50bClsPermisos.fncGetElemento(request,parametro);
    	String[] retorno = new String[vectorPermisos.size()];
    	for(int i=0;i<vectorPermisos.size();i++){
    		retorno[i] = (String)vectorPermisos.get(i);
    	}
    	return retorno;
    }
    
    /**
     * Recupera el idioma de XLNets.
     * 
     * @param request the request
     * 
     * @return the string
     * 
     * @throws Q70SeguridadException the q70 seguridad exception
     * @throws Q70LogonException the q70 logon exception
     */
    public static String fncObtenerIdioma(HttpServletRequest request) throws Q70SeguridadException, Q70LogonException{
    	List vectorPermisos=V50bClsPermisos.fncGetElemento(request,"n38idioma");
    	return (String)vectorPermisos.get(0);
    }
    
    /**
     * Recupera el usuario de XLNets.
     * 
     * @param request the request
     * 
     * @return the string
     * 
     * @throws Q70SeguridadException the q70 seguridad exception
     * @throws Q70LogonException the q70 logon exception
     */
    public static String fncObtenerUsuarioLogin(HttpServletRequest request) throws Q70SeguridadException, Q70LogonException{
    	List vectorPermisos=V50bClsPermisos.fncGetElemento(request,"n38login");
    	return (String)vectorPermisos.get(0);
    }
    
    /**
     * Recupera la IP del usuario conectado de XLNets, si no la encuentra la obtiene de la request.
     * 
     * @param request the request
     * 
     * @return the string
     * 
     * @throws Q70SeguridadException the q70 seguridad exception
     * @throws Q70LogonException the q70 logon exception
     */
    public static String fncObtenerIpPuesto(HttpServletRequest request) throws Q70SeguridadException, Q70LogonException{
    	//Primero lo buscamos en XLNets.
    	final List vectorPermisos = V50bClsPermisos.fncGetElemento(request, "iphostnumber");
    	
    	if(vectorPermisos != null && vectorPermisos.size() == 1){
    		return (String)vectorPermisos.get(0);
    	} else {
    		//Y si no hay nada en XLNets, o vienen datos no esperado, la recuperamos de la request.
    		return request.getRemoteAddr();
    	}
    }
    
    /**
     * Recupera el dni del usuario de XLNets
     * @param request a
     * @return String
     * @throws Q70SeguridadException e
     * @throws Q70LogonException e
     */
    public static String fncObtenerDniUsuarioLogin(HttpServletRequest request) throws Q70SeguridadException, Q70LogonException{
    	List vectorPermisos=V50bClsPermisos.fncGetElemento(request,"dni");
    	return (String)vectorPermisos.get(0);
    }
}
