package v50b.v50bClasesComunes;

import java.sql.SQLException;

/**
 * <p>Ttulo: V50bClsParametroSQL.java</p>
 * <p>Descipcin: Clase que encapsula un parametro de un procedimiento o funcion de SQL</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Empresa: Eurohelp </p>
 * 
 * @author iurkidi
 * @version 1.0 06-jun-2005
 */

public class V50bClsParametroSQL {
	//Constantes de clase
	protected final static int TIPO_SQL_STRING = java.sql.Types.VARCHAR;

	protected final static int TIPO_SQL_INTEGER = java.sql.Types.INTEGER;

	protected final static int TIPO_SQL_DOUBLE = java.sql.Types.DOUBLE;

	protected final static int TIPO_SQL_DATE = java.sql.Types.DATE;

	protected final static int TIPO_PARAMETRO_IN = 0;

	protected final static int TIPO_PARAMETRO_OUT = 1;

	protected final static int TIPO_PARAMETRO_INOUT = 2;

	private final static String msgError = "debe tener los siguientes valores";

	//Propiedades internas
	private int tipoSQL;

	private int tipoParametro;

	private String valor = null;

	/**
	 * Construye un parametro.
	 * 
	 * @param intPfTipoSQL int: Tipo de parametro SQL
	 * @param intPfTipoParametro int: Tipo de valor de parametro
	 * @param strPfValor String Valor del parametro
	 * 
	 * @throws Exception the exception
	 */

	public V50bClsParametroSQL (int intPfTipoSQL, int intPfTipoParametro, String strPfValor) throws Exception {
		if (this.esTipoSQLCorrecto(intPfTipoSQL)) {
			this.tipoSQL = intPfTipoSQL;
		} else {
			throw new SQLException(
					"intPfTipoSQL "
							+ V50bClsParametroSQL.msgError
							+ " [TIPO_SQL_STRING,TIPO_SQL_INTEGER,TIPO_SQL_DOUBLE,TIPO_SQL_DATE]");
		}
		if (this.esTipoCorrecto(intPfTipoParametro)) {
			this.tipoParametro = intPfTipoParametro;
		} else {
			throw new SQLException(
					"intPfTipoParametro "
							+ V50bClsParametroSQL.msgError
							+ " [TIPO_PARAMETRO_IN,TIPO_PARAMETRO_OUT,TIPO_PARAMETRO_INOUT]");
		}
		this.valor = strPfValor;
	}

	/**
	 * Construye un parametro sin valor.
	 * 
	 * @param intPfTipoSQL int: Tipo de parametro SQL
	 * @param intPfTipoParametro int: Tipo de valor de parametro
	 * 
	 * @throws Exception the exception
	 */

	public V50bClsParametroSQL (int intPfTipoSQL, int intPfTipoParametro) throws Exception {
		if (this.esTipoSQLCorrecto(intPfTipoSQL)) {
			this.tipoSQL = intPfTipoSQL;
		} else {
			throw new SQLException(
					"intPfTipoSQL "
							+ V50bClsParametroSQL.msgError
							+ " [TIPO_SQL_STRING,TIPO_SQL_INTEGER,TIPO_SQL_DOUBLE,TIPO_SQL_DATE]");
		}
		if (this.esTipoCorrecto(intPfTipoParametro)) {
			this.tipoParametro = intPfTipoParametro;
		} else {
			throw new SQLException(
					"intPfTipoParametro "
							+ V50bClsParametroSQL.msgError
							+ " [TIPO_PARAMETRO_IN,TIPO_PARAMETRO_OUT,TIPO_PARAMETRO_INOUT]");
		}
	}

	/**
	 * Obtiene el tipo de parametro.
	 * 
	 * @return String
	 */

	public int getTipoParametro() {
		return this.tipoParametro;
	}

	/**
	 * Obtiene el tipo SQL de parametro.
	 * 
	 * @return String
	 */

	public int getTipoSQL() {
		return this.tipoSQL;
	}

	/**
	 * Obtiene el Valor.
	 * 
	 * @return String
	 */

	public String getValor() {
		return this.valor;
	}

	/**
	 * Comprueba que el tipo es correcto.
	 * 
	 * @param intPfTipoSQL int
	 * 
	 * @return boolean: True si correcto
	 */

	private boolean esTipoSQLCorrecto(int intPfTipoSQL) {
		return (intPfTipoSQL == V50bClsParametroSQL.TIPO_SQL_STRING
				|| intPfTipoSQL == V50bClsParametroSQL.TIPO_SQL_INTEGER
				|| intPfTipoSQL == V50bClsParametroSQL.TIPO_SQL_DOUBLE || intPfTipoSQL == V50bClsParametroSQL.TIPO_SQL_DATE);
	}

	/**
	 * Comprueba que el tipo SQL es correcto.
	 * 
	 * @param intPfTipo int
	 * 
	 * @return boolean: True si correcto
	 */

	private boolean esTipoCorrecto(int intPfTipo) {
		return (intPfTipo == V50bClsParametroSQL.TIPO_PARAMETRO_IN
				|| intPfTipo == V50bClsParametroSQL.TIPO_PARAMETRO_OUT || intPfTipo == V50bClsParametroSQL.TIPO_PARAMETRO_INOUT);
	}

	/**
	 * Sets the tipo parametro.
	 * 
	 * @param tipoParametro the new tipo parametro
	 */
	public void setTipoParametro(int tipoParametro) {
		this.tipoParametro = tipoParametro;
	}

	/**
	 * Sets the tipo sql.
	 * 
	 * @param tipoSQL the new tipo sql
	 */
	public void setTipoSQL(int tipoSQL) {
		this.tipoSQL = tipoSQL;
	}

	/**
	 * Sets the valor.
	 * 
	 * @param valor the new valor
	 */
	public void setValor(String valor) {
		this.valor = valor;
	}

}