package v50b.v50bClasesComunes;

import java.util.List;

import javax.mail.SendFailedException;

import v50b.v50bClasesComunes.v50bBeansComunes.V50bMailBean;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.mail.Q70MailEnvelope;
import es.ejie.frmk.infraestructura.mail.Q70MailException;
import es.ejie.frmk.infraestructura.mail.Q70MailFile;
import es.ejie.frmk.infraestructura.mail.Q70MailMessage;
import es.ejie.frmk.infraestructura.mail.Q70MailUser;


/**
 * <p>Ttulo: V50bClsMail</p>
 * <p>Descripcin: Utilidades de envio de Correo Electronico para Geremua v2.0</p>
 * <p>Copyright: Copyright (c) 2007</p>
 * <p>Empresa: Eurohelp Consulting</p>
 * 
 * @author Iigo Rodrguez Zudaire
 * @version 1.0
 */
public class V50bClsMail {

	
	/**
	 * Instantiates a new v50b cls mail.
	 */
	private V50bClsMail(){}
	
	/**
	 * Envia un Correo Electronico con ficheros adjuntos.
	 * 
	 * @param mailBean the mail bean
	 * @param listaFicherosAdjuntos the lista ficheros adjuntos
	 * @param listaFicherosIncrustados the lista ficheros incrustados
	 * 
	 * @return the int
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iigo Rodrguez Zudaire
	 * @version 	1.0
	 * @fecha	  	15/01/2007
	 */
	public static int fncEnviarMailFicheros(V50bMailBean mailBean, List listaFicherosAdjuntos, List listaFicherosIncrustados) throws Exception{
		
		Q70MailMessage mailMessage = V50bClsMail.fncPrepararMailMessage(mailBean,listaFicherosAdjuntos,listaFicherosIncrustados);
		Q70MailEnvelope mailEnvelope = new Q70MailEnvelope();

		mailEnvelope.setHost(mailBean.getHost());
		mailEnvelope.setMessage(mailMessage);
		
		return V50bClsMail.fncEnviar(mailEnvelope);
	}
	
	/**
	 * Envia un Correo Electronico SIN ficheros adjuntos.
	 * 
	 * @param mailBean the mail bean
	 * 
	 * @return the int
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iigo Rodrguez Zudaire
	 * @version 	1.0
	 * @fecha	  	15/01/2007
	 */
	public static int fncEnviarMail(V50bMailBean mailBean) throws Exception{
		
		Q70MailMessage mailMessage = V50bClsMail.fncPrepararMailMessage(mailBean,null,null);
		Q70MailEnvelope mailEnvelope = new Q70MailEnvelope();

		mailEnvelope.setHost(mailBean.getHost());
		mailEnvelope.setMessage(mailMessage);
		return V50bClsMail.fncEnviar(mailEnvelope);
	}
	
	/**
	 * 
	 * @param mailBean bean
	 * @param listaFicherosAdjuntos listaAdjuntos
	 * @param listaFicherosIncrustados listaIncrustados
	 * @return Q70MailMessage message
	 * @throws Exception ex
	 */
	private static Q70MailMessage fncPrepararMailMessage(V50bMailBean mailBean, List listaFicherosAdjuntos, List listaFicherosIncrustados)throws Exception{
		
		Q70MailMessage mailMessage = new Q70MailMessage();
		
		V50bClsTrazas.depura("V50bClsMail ","- fncPrepararMailMessage -");

		//Obtenemos los datos de la cabecera del email
		mailMessage.setAsunto(mailBean.getAsunto());
		mailMessage.setTextoPlano(mailBean.getCuerpoPlano());
		mailMessage.setTextoHTML(mailBean.getCuerpoHTML());
		mailMessage.setRemitente(mailBean.getRemitente());
		
		V50bClsTrazas.depura("fncPrepararMailMessage - REMITENTE: ",mailBean.getRemitente().getDireccionEmail());

		//Obtenemos las direcciones de email, separadas por ;
		String[] lista=((String)mailBean.getEnviarA()).trim().split(";");
		for (int i=0;i<lista.length && lista[i].trim().length()>0;i++){
			mailMessage.addDestinatarios(V50bClsMail.getMailUser(lista[i]));
			V50bClsTrazas.depura("fncPrepararMailMessage - DESTINATARIO "+i+": ",V50bClsMail.getMailUser(lista[i]).getDireccionEmail());
		}
		
		lista=((String)mailBean.getEnviarCC()).trim().split(";");
		for (int i=0;i<lista.length && lista[i].trim().length()>0;i++){
			mailMessage.addDestinatariosCC(V50bClsMail.getMailUser(lista[i]));
			V50bClsTrazas.depura("fncPrepararMailMessage - DESTINATARIO CC "+i+": ",V50bClsMail.getMailUser(lista[i]).getDireccionEmail());
		}

		lista=((String)mailBean.getEnviarCCO()).trim().split(";");
		for (int i=0;i<lista.length  && lista[i].trim().length()>0;i++){
			mailMessage.addDestinatariosCCO(V50bClsMail.getMailUser(lista[i]));
			V50bClsTrazas.depura("fncPrepararMailMessage - DESTINATARIO CCO "+i+": ",V50bClsMail.getMailUser(lista[i]).getDireccionEmail());
		}
		
		//Obtenemos los ficheros adjuntos
		if(listaFicherosAdjuntos!=null && listaFicherosAdjuntos.size()>0){
			V50bClsTrazas.depura("fncPrepararMailMessage"," MAIL CON FICHERO ADJUNTO");
			for (int i=0;i<listaFicherosAdjuntos.size();i++){
				mailMessage.addFicheroAdjunto((Q70MailFile)listaFicherosAdjuntos.get(i));
			}
			listaFicherosAdjuntos.clear();
		}else{
			V50bClsTrazas.depura("fncPrepararMailMessage"," MAIL SIN FICHERO ADJUNTO");
		}
		//Obtenemos los ficheros incrustados
		if(listaFicherosIncrustados!=null && listaFicherosIncrustados.size()>0){
			V50bClsTrazas.depura("fncPrepararMailMessage"," MAIL CON FICHERO INCRUSTADO");
			for (int i=0;i<listaFicherosIncrustados.size();i++){
				mailMessage.addFicheroIncrustado((Q70MailFile)listaFicherosIncrustados.get(i));
			}
			listaFicherosIncrustados.clear();
		}else{
			V50bClsTrazas.depura("fncPrepararMailMessage"," MAIL SIN FICHERO ADJUNTO");
		}
		
		return mailMessage;
	}
	
	/**
	 * 
	 * @param mailEnvelope mailEnvelope
	 * @return int 1-Ok // -1 - No ok
	 * @throws Exception ex
	 */
	private static int fncEnviar(Q70MailEnvelope mailEnvelope)throws Exception{
		
		try
		{
			Q70Factoria.getGestorMail().dispatch(mailEnvelope);
			V50bClsTrazas.depura("V50aClsMail - fncEnviar","ENVIO CORRECTO DE MAIL");
			return (V50bClsConstantes.ENVIADO_CORRECTO);

		//Gestionamos las excepciones.
		}catch (Q70MailException e) {
			Throwable throwable = e.getThrowable();
			if (throwable instanceof SendFailedException)
			{
				SendFailedException s = (SendFailedException)e.getThrowable();
				//Recogemos las direcciones de email erroneas
				if (null!=s.getInvalidAddresses()){
					for (int i=0;i<s.getInvalidAddresses().length;i++){
						//errors.add(ActionErrors.GLOBAL_ERROR,new ActionError ("error.mail.invalidaDireccion",((InternetAddress)s.getInvalidAddresses()[i]).getAddress()));
						V50bClsTrazas.depura("V50bClsMail","error.mail.invalidaDireccion");	
					}
				}
				//Recogemos las direcciones de emails envadas, pero que no han llegados
				if (null!=s.getValidUnsentAddresses()){
					for (int i=0;i<s.getValidUnsentAddresses().length;i++){
						//errors.add(ActionErrors.GLOBAL_ERROR,new ActionError ("error.mail.validaNoEnviada",((InternetAddress)s.getValidUnsentAddresses()[i]).getAddress()));
						V50bClsTrazas.depura("V50bClsMail","error.mail.validaNoEnviada");
					}
				}
				//Recogemos otro tipo de errores al enviar el email
				if ((null==s.getInvalidAddresses()) && (null==s.getValidUnsentAddresses())){
					//errors.add(ActionErrors.GLOBAL_ERROR,new ActionError("error.mail.otros",s.getMessage()));
					V50bClsTrazas.depura("V50bClsMail","error.mail.otros");
				}
			}else{
				V50bClsTrazas.depura("V50bClsMail (ERROR)", throwable.getMessage());
			}
			V50bClsTrazas.depura("V50aClsMail - fncEnviar","ENVIO INCORRECTO DE MAIL");
			return (V50bClsConstantes.ENVIADO_INCORRECTO);
		}
	}
	
	/**
	 * Generamos una direccin de email de tipo Q70MailUser.
	 * 
	 * @param direccion the direccion
	 * 
	 * @return Q70MailUser
	 */
	private static Q70MailUser getMailUser(String direccion)
	{
		return new Q70MailUser (direccion);
	}
	
}