package v50b.v50bClasesComunes;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * <p>Ttulo: V50bClsLibroRegistro</p>
 * <p>Descripcin: Utilidades de libro registro</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Empresa: Eurohelp Consulting</p>.
 * 
 * @author Jonatan Gonzalez
 * @version 1.0
 */
public class V50bClsLibroRegistro {
	
	/**
	 * Instantiates a new v50b cls libro registro.
	 */
	private V50bClsLibroRegistro(){}
	
	/**
	 * Llama a un ASP que realiza el guardado en el libro de registro.
	 * 
	 * @param sUrlReg the s url reg
	 * @param modelo the modelo
	 * @param sentidoLibro the sentido libro
	 * @param entornoLibro the entorno libro
	 * @param nombreEmpresa the nombre empresa
	 * @param poblacionInterlocutor the poblacion interlocutor
	 * @param observaciones the observaciones
	 * @param aplic the aplic
	 * 
	 * @return HashMap con 'NUMREG' (numero de registro) y 'FECREG' (fecha)
	 * 
	 * @throws Exception si ocurre algn error
	 */
	public static Map altaRegistro (String sUrlReg, 
										String modelo, 
										String sentidoLibro,
										String entornoLibro, 
										String nombreEmpresa, 
										String poblacionInterlocutor,
										String observaciones, 
										String aplic) throws Exception {
		
		Map objRegistro=new HashMap();
		
		String poblInt = "";
		
		if (poblacionInterlocutor==null || poblacionInterlocutor.equals("")){
			poblInt = V50bClsConstantes.CONSTANTE_POBLACION_DEFECTO;
		} else {
			poblInt = poblacionInterlocutor;
		}
		
		String strEstado=Q70ListenerUtils.getApplicationProperty("ENTORNO");
		if(strEstado.equals(V50bClsConstantes.ENTORNO_LOCAL)){
			
			V50bClsTrazas.depura("===============================================================================","");
			V50bClsTrazas.depura("LIBRO_DE_REGISTRO","Libro de registro en pruebas");
			V50bClsTrazas.depura("UrlReg",sUrlReg);
			V50bClsTrazas.depura("modelo",modelo);
			V50bClsTrazas.depura("sentidoLibro",sentidoLibro);
			V50bClsTrazas.depura("entornoLibro",entornoLibro);
			V50bClsTrazas.depura("nombreEmpresa",nombreEmpresa);
			V50bClsTrazas.depura("poblacionInterlocutor",poblInt);
			V50bClsTrazas.depura("observaciones",observaciones);
			V50bClsTrazas.depura("aplic",aplic);
			V50bClsTrazas.depura("===============================================================================","");
			
			//Asigno un n aleatorio
			objRegistro.put("NUMREG",Long.valueOf(V50bClsFunciones.fncGenerarClave(V50bClsConstantes.QUINCE)));
			
			String fechaActual = V50bClsFecha.fncPresentarFechaSistemaCorta(V50bClsConstantes.CONSTANTE_CASTELLANO);
			fechaActual = fechaActual.substring(0,fechaActual.length()-V50bClsConstantes.CUATRO)+fechaActual.substring(fechaActual.length()-2,fechaActual.length());
			objRegistro.put("FECREG",fechaActual);
			
			V50bClsTrazas.depura("LIBRO REGISTRO", objRegistro);
			
		}else if(strEstado.equals(V50bClsConstantes.ENTORNO_EJIE)){
			
			objRegistro = null;
			
			String parametros =
				"modelo=" + URLEncoder.encode(modelo,"UTF-16") + 
				"&sentidoLibro=" + URLEncoder.encode(sentidoLibro,"UTF-16") +
				"&entornoLibro=" + URLEncoder.encode(entornoLibro,"UTF-16") + 
				"&nombreEmpresa=" + URLEncoder.encode(nombreEmpresa,"UTF-16") +
				"&poblacionInterlocutor=" + URLEncoder.encode(poblInt,"UTF-16") + 
				"&observaciones=" + URLEncoder.encode(observaciones,"UTF-16") +
				"&aplic=" + URLEncoder.encode(aplic,"UTF-16");
	
			V50bClsTrazas.depura("Parametros_ASP",parametros);
			
			String regLeido = "ERROR@0@";
			TimeZone tz = TimeZone.getTimeZone("MET");
			String hoy="";
	
			try {
				URL urlReg = new URL(sUrlReg + "?" + parametros);
				V50bClsTrazas.depura("URL LibReg",urlReg);
				DataInputStream dis = new DataInputStream(urlReg.openStream());
				byte [] regLeidoBytes = new byte[V50bClsConstantes.MIL_VEINTICUATRO];
				dis.read(regLeidoBytes);
				regLeido = new String(regLeidoBytes);
				V50bClsTrazas.depura("Alta LibReg, n", regLeido);
				
			}
			catch(MalformedURLException e) {
				V50bClsTrazas.depura("MalformedURLException, error",e.getMessage());
			}
			catch(IOException e) {
				V50bClsTrazas.depura("IOException, error",e.getMessage());
			}
			//Devuelvo un objeto con nregistro y fecha registro			
			List arrRegLeido=V50bClsFunciones.fncSplit(regLeido,"@");		
			V50bClsTrazas.depura("arrRegLeido", arrRegLeido);
			
			if(arrRegLeido.get(1).equals("0")){
				DateFormat df = DateFormat.getDateInstance(DateFormat.LONG, new Locale ("es", "ES"));
				df.setTimeZone(tz);
				java.util.Date dhoy = new java.util.Date();
				SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
				sdf.setTimeZone(tz);
				hoy = sdf.format(dhoy);
				objRegistro=new HashMap();
				objRegistro.put("NUMREG",Long.valueOf("999999999999999"));
				objRegistro.put("FECREG",hoy.toString());
				
			}else{
				objRegistro=new HashMap();
				objRegistro.put("NUMREG",Long.valueOf(arrRegLeido.get(0).toString()));			
				objRegistro.put("FECREG",arrRegLeido.get(1).toString());
			}
			V50bClsTrazas.depura("Objeto LibReg", objRegistro);
		}
		return objRegistro;
	}
	  
  	

}