package v50b.v50bClasesComunes;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.fop.apps.Driver;
import org.apache.fop.messaging.MessageHandler;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import v50b.v50bClasesComunes.v50bBeansComunes.V50bGenericoBean;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * <p>Ttulo: V50bClsInformes</p>
 * <p>Descripcin: Utilidades de informes</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Empresa: Eurohelp Consulting</p>.
 * 
 * @author iurkidi
 * @version 1.0
 */
public class V50bClsInformes {

	/**
	 * Instantiates a new v50b cls informes.
	 */
	private V50bClsInformes(){};
	
	
	/**
	 * Fnc rellena fecha pagina literales.
	 * 
	 * @param arrLiterales the arr literales
	 * 
	 * @throws Exception the exception
	 */
	private static void fncRellenaFechaPaginaLiterales(List arrLiterales) throws Exception{
		arrLiterales.add("cabecera.pagina");
		arrLiterales.add("cabecera.fecha");
	}
	
	/**
	 * fncCrearDocument
	 * @return Document Document
	 * @throws Exception ex
	 */
	private static Document fncCrearDocument()throws Exception{
		
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		DOMImplementation implementation = builder.getDOMImplementation();
		Document document = implementation.createDocument(null, "root", null);
		
		return document;
	}
	
	/**
	 * fncParametrosInforme
	 * @param document document
	 * @param arrPfParametros arrPfParametros
	 * @return Element Element
	 * @throws Exception ex
	 */
	private static Element fncParametrosInforme(Document document,List arrPfParametros)throws Exception{
		
		Element raiz = document.createElement("informe");

	    //Parametros
	    if (arrPfParametros != null && arrPfParametros.size() > 0) {
	      Element zonaParametros = document.createElement("parametros");
	      Element[] parametros = new Element[arrPfParametros.size()];
	      Text[] valoresParametros = new Text[arrPfParametros.size()];

	      for (int i = 0; i < arrPfParametros.size(); ++i) {

	        parametros[i] = document.createElement("parametro" + (i + 1));
	        
	        if(arrPfParametros.get(i)!=null){
		    	   valoresParametros[i] = document.createTextNode(arrPfParametros.get(i).toString());
		       } else {
		    	   valoresParametros[i] = document.createTextNode("");
		       }
	        
	        //valoresParametros[i] = document.createTextNode(arrPfParametros.get(i).toString());
	        parametros[i].appendChild(valoresParametros[i]);
	        zonaParametros.appendChild(parametros[i]);
	      } //Fin for parametros
	      
	      raiz.appendChild(zonaParametros);
	    } //Fin if parametros
	    
	    return raiz;
	}
	
	/**
	 * fncLiteralesInforme
	 * @param raiz raiz
	 * @param document document
	 * @param arrPfLiterales arrPfLiterales
	 * @param strPfFicheroProperties strPfFicheroProperties
	 * @param strPfIdioma strPfIdioma
	 * @return Element Element
	 * @throws Exception ex
	 */
	private static Element fncLiteralesInforme(Element raiz, Document document,List arrPfLiterales,String strPfFicheroProperties,String strPfIdioma)throws Exception{
		
		//Literales
	    if (arrPfLiterales != null && arrPfLiterales.size() > 0) {
	      Element literales = document.createElement("literales");
	      Element[] cadenas = new Element[arrPfLiterales.size()];
	      Text[] textosLiterales = new Text[arrPfLiterales.size()];
	      
	      for (int i = 0; i < arrPfLiterales.size(); ++i) {

	        cadenas[i] = document.createElement(arrPfLiterales.get(i).toString());
	        textosLiterales[i] = document.createTextNode(Q70GestorMensajesi18n.getSingleton().getMessage(strPfFicheroProperties,arrPfLiterales.get(i).toString(),strPfIdioma));
	        cadenas[i].appendChild(textosLiterales[i]);
	        literales.appendChild(cadenas[i]);
	      }//Fin for literales
	      raiz.appendChild(literales);
	    }
	    return raiz;
	}
	
  /**
   * Utiliza FOP para sacar un listado en PDF.
   * 
   * @param objPfRequest HttpServletRequest: peticin actual
   * @param objPfResponse HttpServletResponse: respuesta actual
   * @param strPfIdioma String: String con el idioma actual
   * @param strPfRutaXSL String: String con la ruta del fich. de transformacin XSL:FO a utilizar
   * @param arrPfLiterales ArrayList: arraylist con los literales ya traducidos
   * @param arrPfDatosTabla ArrayList: arraylist de arrays de objetos para rellenar una tabla-listado de resultados
   * @param strPfFicheroProperties String: String con el nombre de fichero de los literales
   * @param arrPfParametros the arr pf parametros
   * @param propiedadOrdenar the propiedad ordenar
   * 
   * @throws Exception the exception
   */
  public static void fncSacarListadoFOP(HttpServletRequest objPfRequest,
                                 HttpServletResponse objPfResponse,
                                 String strPfIdioma,
                                 String strPfRutaXSL,
                                 List arrPfParametros,
                                 List arrPfLiterales,
                                 List arrPfDatosTabla, 
                                 String strPfFicheroProperties,
                                 String propiedadOrdenar)
      throws Exception {
    
	V50bClsInformes.fncRellenaFechaPaginaLiterales(arrPfLiterales); 
	  
    Document document = V50bClsInformes.fncCrearDocument();

    //Parametros
    Element raiz = V50bClsInformes.fncParametrosInforme(document,arrPfParametros);
    //Literales
    raiz = V50bClsInformes.fncLiteralesInforme(raiz,document,arrPfLiterales,strPfFicheroProperties,strPfIdioma);
    
    //Datos de la tabla
    List arrPfDatosTablaConv = V50bClsFunciones.fncConvierteArrayListBeans(arrPfDatosTabla, propiedadOrdenar);
    
    Element contenido = document.createElement("contenido");
    if (arrPfDatosTablaConv != null) {
      Element valoresArray = document.createElement("pagina");
      valoresArray.setAttribute("numFilas", arrPfDatosTablaConv.size() + "");
      int intNumFilas = arrPfDatosTablaConv.size();
      for (int i = 0; i < intNumFilas; ++i) {
        Element fila = document.createElement("fila");
        ArrayList arrFila = (ArrayList) arrPfDatosTablaConv.get(i);
        for (int j = 0; j < arrFila.size(); ++j) {

          Element celda = document.createElement("celda");
          String strValorCelda = "";
          if (arrFila.get(j) != null) {
            strValorCelda = arrFila.get(j).toString();
          }
          Text textoCelda = document.createTextNode(strValorCelda);
          celda.appendChild(textoCelda);
          fila.appendChild(celda);
          String strIndice = "" + (i + 1);
          fila.setAttribute("indice", strIndice);
          celda.setAttribute("orden", "" + (j + 1));
        } //Fin for celdas
        
        valoresArray.appendChild(fila);
      } //Fin for filas
      
      contenido.appendChild(valoresArray);
    } //Fin if de datos de la tabla

    raiz.appendChild(contenido);
    document.getDocumentElement().appendChild(raiz);
    
    /*Descomentando estas lineas se obtendra el XML generado*/
	/* Hay que aadir en el CLASSPATH del WebLogic -> usr\j2se\jakarta-ant-1.5.3-1\lib\xercesImpl.jar */
    //String path = "C:\\ListadoFOP_V50b.xml";
    V50bClsInformes.fncGenerarDocumentos(document,raiz);

    V50bClsInformes.fncDevuelvePDF(objPfResponse, document,strPfRutaXSL);
    System.gc();

    
  } //Fin fncSacarListadoFOP
  
  
  /**
   * 
   * <p><b>Ttulo:</b> fncSacarListadoFOPBeanAnidado</p>
   * <p><b>Descripcin:</b> Utiliza FOP para sacar un listado en PDF. la llamada ser fila[x]/celda[y]/atributo[z]</p>
   * <p><b>Copyright:</b> Copyright (c) Dec 1, 2008</p>
   * <p><b>Empresa:</b> Eurohelp</p>
   * 
   * @author llaparra
   * @version 1.0
   * @param objPfRequest HttpServletRequest: peticin actual
   * @param objPfResponse HttpServletResponse: respuesta actual
   * @param strPfIdioma String: String con el idioma actual
   * @param strPfRutaXSL String: String con la ruta del fich. de transformacin XSL:FO a utilizar
   * @param arrPfLiterales ArrayList: arraylist con los literales ya traducidos
   * @param arrPfDatosTabla ArrayList: arraylist de arrays de objetos para rellenar una tabla-listado de resultados que a su vez tienen otro nivel de objetos debajo
   * @param strPfFicheroProperties String: String con el nombre de fichero de los literales
   * @param arrPfParametros the arr pf parametros
   * @param propiedadOrdenar the propiedad ordenar
   * 
   * @throws Exception the exception
   */
  public static void fncSacarListadoFOPBeanAnidado(HttpServletRequest objPfRequest,
                                 HttpServletResponse objPfResponse,
                                 String strPfIdioma,
                                 String strPfRutaXSL,
                                 List arrPfParametros,
                                 List arrPfLiterales,
                                 List arrPfDatosTabla, 
                                 String strPfFicheroProperties,
                                 String propiedadOrdenar)
      throws Exception {
    
	V50bClsInformes.fncRellenaFechaPaginaLiterales(arrPfLiterales); 
	  
	Document document = V50bClsInformes.fncCrearDocument();
	
    Element raiz = V50bClsInformes.fncParametrosInforme(document,arrPfParametros);

    
    //Literales
    raiz = V50bClsInformes.fncLiteralesInforme(raiz,document,arrPfLiterales,strPfFicheroProperties,strPfIdioma);

  
    //Datos de la tabla
    List arrPfDatosTablaConv = V50bClsFunciones.fncConvierteArrayListBeans(arrPfDatosTabla, propiedadOrdenar);
    
    //Lista auxiliar para los atributos
    List lAux = new ArrayList();
    
    Element contenido = document.createElement("contenido");
    if (arrPfDatosTablaConv != null) {
      Element valoresArray = document.createElement("pagina");
      valoresArray.setAttribute("numFilas", arrPfDatosTablaConv.size() + "");
      int intNumFilas = arrPfDatosTablaConv.size();
      for (int i = 0; i < intNumFilas; ++i) {
        Element fila = document.createElement("fila");
        ArrayList arrFila = (ArrayList) arrPfDatosTablaConv.get(i);
        for (int j = 0; j < arrFila.size(); ++j) {

          Element celda = document.createElement("celda");
          
          if(!(arrFila.get(j) instanceof V50bGenericoBean)){
        	  Element atributo = document.createElement("atributo");
        	  String strValorAtributo = "";
              if (arrFila.get(j) != null) {
                  strValorAtributo = arrFila.get(j).toString();
              }
              Text textoAtributo = document.createTextNode(strValorAtributo);
              atributo.appendChild(textoAtributo);
              celda.appendChild(atributo);
              atributo.setAttribute("orden", "1");
    	  } else {
    		  lAux.clear();
    		  lAux.add(arrFila.get(j));
    		  List arrPfDatosCeldaConv = V50bClsFunciones.fncConvierteArrayListBeans(lAux, null);
    		  
    		  if (arrPfDatosCeldaConv != null) {
    			  ArrayList atribsBean = (ArrayList) arrPfDatosCeldaConv.get(0);
    			  for (int k = 0; k < atribsBean.size(); ++k) {
    				  Element atributo = document.createElement("atributo");
    	        	  String strValorAtributo = V50bClsInformes.fncCompruebaNulo(atribsBean.get(k));
    	              Text textoAtributo = document.createTextNode(strValorAtributo);
    	              atributo.appendChild(textoAtributo);
    	              celda.appendChild(atributo);
    	              atributo.setAttribute("orden", "" + (k + 1));
    			  }
    		  }
    	  }
          
//          String strValorCelda = "";
//          if (arrFila.get(j) != null) {
//            strValorCelda = arrFila.get(j).toString();
//          }
//          Text textoCelda = document.createTextNode(strValorCelda);
//          celda.appendChild(textoCelda);
          fila.appendChild(celda);
          String strIndice = "" + (i + 1);
          fila.setAttribute("indice", strIndice);
          celda.setAttribute("orden", "" + (j + 1));
        } //Fin for celdas
        
        valoresArray.appendChild(fila);
      } //Fin for filas
      
      contenido.appendChild(valoresArray);
    } //Fin if de datos de la tabla

    raiz.appendChild(contenido);
    document.getDocumentElement().appendChild(raiz);
    
    /*Descomentando estas lineas se obtendra el XML generado*/
	/* Hay que aadir en el CLASSPATH del WebLogic -> usr\j2se\jakarta-ant-1.5.3-1\lib\xercesImpl.jar */
    //String path = "C:\\ListadoFOP_V50b.xml";
    V50bClsInformes.fncGenerarDocumentos(document,raiz);

    V50bClsInformes.fncDevuelvePDF(objPfResponse, document,strPfRutaXSL);
    System.gc();

    
  } //Fin fncSacarListadoFOPBeanAnidado
  
  /**
   * 
   * <p>Ttulo: fncCompruebaNulo</p>
   * <p>Descripcin: Comprueba si el objeto de la lista es nulo.</p>
   * <p>Copyright: Copyright (c) Dec 1, 2008</p>
   * <p>Empresa: Eurohelp</p>
   * 
   * @author llaparra
   * @version 1.0
   * @param objetoLista Objeto de la lista
   * @return String La cadena elegida para el nuevo valor
   */
  private static String fncCompruebaNulo(Object objetoLista){
	  if (objetoLista != null) {
          return objetoLista.toString();
      } else {
    	  return "";
      }
  }
  
  /**
   * Utiliza FOP para sacar un listado del calendario en PDF.
   * 
   * @param objPfRequest HttpServletRequest: peticin actual
   * @param objPfResponse HttpServletResponse: respuesta actual
   * @param strPfIdioma String: String con el idioma actual
   * @param strPfRutaXSL String: String con la ruta del fich. de transformacin XSL:FO a utilizar
   * @param arrPfLiterales ArrayList: arraylist con los literales ya traducidos
   * @param arrPfDatosTabla ArrayList: arraylist de arrays de objetos para rellenar una tabla-listado de resultados
   * @param strPfFicheroProperties String: String con el nombre de fichero de los literales
   * @param arrPfParametros the arr pf parametros
   * @param v50barrNomMeses the v50barr nom meses
   * 
   * @throws Exception the exception
   */
  public static void fncSacarListadoCalendarioFOP(HttpServletRequest objPfRequest,
                                 HttpServletResponse objPfResponse,
                                 String strPfIdioma,
                                 String strPfRutaXSL,
                                 List arrPfParametros,
                                 List arrPfLiterales,
                                 List v50barrNomMeses,
                                 List arrPfDatosTabla,
                                 String strPfFicheroProperties)
      throws Exception {
    
	  V50bClsInformes.fncRellenaFechaPaginaLiterales(arrPfLiterales); 
	  
	  Document document = V50bClsInformes.fncCrearDocument();
	  
	  Element raiz = V50bClsInformes.fncParametrosInforme(document,arrPfParametros);

	  raiz = V50bClsInformes.fncLiteralesInforme(raiz,document,arrPfLiterales,strPfFicheroProperties,strPfIdioma);

  
    //Datos de la tabla
    Element contenido = document.createElement("contenido");
    if (arrPfDatosTabla != null) {
      Element valoresArray = document.createElement("pagina");
      int contador=0;
      valoresArray.setAttribute("numFilas", arrPfDatosTabla.size() + "");
      int intNumFilas = arrPfDatosTabla.size();
      for (int i = 0; i < intNumFilas; ++i) {
        Element mes = document.createElement("mes");
        for (int nm = 0;nm<V50bClsConstantes.TRES;nm++)
        {
        	Element nomMes = document.createElement("nomMes");
        	Text textoNomMes = document.createTextNode((String)v50barrNomMeses.get(contador));
        	nomMes.appendChild(textoNomMes);
        	mes.appendChild(nomMes);
        	contador++;
        }
        ArrayList arrMes = (ArrayList) arrPfDatosTabla.get(i);
        for (int k = 0; k < arrMes.size(); k++){
        	Element fila = document.createElement("fila");
        	ArrayList arrFila = (ArrayList) arrMes.get(k);
        	for (int j = 0; j < arrFila.size(); ++j) {

                Element celda = document.createElement("celda");
                String strValorCelda = "";
                if (arrFila.get(j) != null) {
                  strValorCelda = arrFila.get(j).toString();
                }
                Text textoCelda = document.createTextNode(strValorCelda);
                celda.appendChild(textoCelda);
                fila.appendChild(celda);
                String strIndice = "" + (i + 1);
                fila.setAttribute("indice", strIndice);
              } //Fin for celdas
              
              mes.appendChild(fila);
            } //Fin for filas
        valoresArray.appendChild(mes);
        } 
        
      
      contenido.appendChild(valoresArray);
    } //Fin if de datos de la tabla

    raiz.appendChild(contenido);
    document.getDocumentElement().appendChild(raiz);
    
    /*Descomentando estas lineas se obtendra el XML generado.*/
	/* Hay que aadir en el CLASSPATH del WebLogic -> usr\j2se\jakarta-ant-1.5.3-1\lib\xercesImpl.jar */
	//String path = "C:\\ListadoFOP.xml";
	//fncGenerarDocumentos(path,document,raiz);

    V50bClsInformes.fncDevuelvePDF(objPfResponse, document,strPfRutaXSL);
    System.gc();

    
  } //Fin fncSacarListadoCalendarioFOP
  
  
  /**
   * Utiliza FOP para sacar un listado en PDF.
   * 
   * @param objPfResponse HttpServletResponse: respuesta actual
   * @param strPfIdioma String: String con el idioma actual
   * @param strPfRutaXSL String: String con la ruta del fich. de transformacin XSL:FO a utilizar
   * @param arrPfLiterales ArrayList: arraylist con los literales ya traducidos
   * @param arrPfDatosTabla ArrayList: arraylist de arrays de objetos para rellenar una tabla-listado de resultados
   * @param strPfFicheroProperties String: String con el nombre de fichero de los literales
   * @param indRegistros int[]: Numero de registros a mostrar en la primera pagina[0] | Numero de registros a mostrar en las siguientes paginas[1]
   * @param arrPfParametros the arr pf parametros
   * @param propiedadOrdenar the propiedad ordenar
   * 
   * @throws Exception the exception
   */
  public static void fncSacarListadoFOPPorPagina (HttpServletResponse objPfResponse, 
		  								   String strPfIdioma,
		  								   String strPfRutaXSL,
		  								   List arrPfParametros, 
		  								   List arrPfLiterales, 
		  								   List arrPfDatosTabla, 
		  								   String strPfFicheroProperties,
		  								   int[] indRegistros,
		  								   String propiedadOrdenar) throws Exception {
	  
	  V50bClsInformes.fncRellenaFechaPaginaLiterales(arrPfLiterales); 
	  
	  final List arrayDatosTabla = V50bClsFunciones.fncConvierteArrayListBeans(arrPfDatosTabla, propiedadOrdenar);
	  
	  Document document = V50bClsInformes.fncCrearDocument();
	  //Parametros
	  Element prueba = V50bClsInformes.fncParametrosInforme(document,arrPfParametros);
	
	   //Literales
	  prueba = V50bClsInformes.fncLiteralesInforme(prueba,document,arrPfLiterales,strPfFicheroProperties,strPfIdioma);
	
	   //Datos tabla
	   Element contenidoPrueba = document.createElement("contenido");
	   //ArrayList arrPrueba=(ArrayList)arrPfDatosTabla.get(0);
	   if (arrPfDatosTabla!=null){
	     int numPaginas = V50bClsInformes.fncCalcularNumeroPaginas(arrPfDatosTabla.size(),indRegistros[0],indRegistros[1]);
	     contenidoPrueba.setAttribute("numPaginas",numPaginas+"");
	     //int intNumFilas=arrPfDatosTabla.size();
	     int contador = 0;
	     for (int k = 0; k < numPaginas; k++){
	       Element paginaPrueba = document.createElement("pagina");
	       paginaPrueba.setAttribute("indicePagina", (k + 1) + "");
	       if (k==0){//Cuando es la primera pagina, meto el numero de filas inicial.
	         boolean bolHayFila = true;
	         while ((contador < indRegistros[0]) && bolHayFila){
	           Element filaPrueba = document.createElement("fila");
	           ArrayList arrFila = (ArrayList) arrayDatosTabla.get(contador);
	           for (int j = 0; j < arrFila.size(); ++j) {
	             Element celdaPrueba = document.createElement("celda");
	             String strValorCelda = "";
	             if (arrFila.get(j) != null) {
					strValorCelda = arrFila.get(j).toString();
				}
	             Text textoCeldaPrueba = document.createTextNode(
	                 strValorCelda);
	             celdaPrueba.setAttribute("orden", "" + (j + 1));
	             celdaPrueba.appendChild(textoCeldaPrueba);
	             filaPrueba.appendChild(celdaPrueba);
	           } //Fin for celdas
	           contador++;
	           String strIndice = "" + (contador);
	           filaPrueba.setAttribute("indice", strIndice);
	           paginaPrueba.appendChild(filaPrueba);
	           if (contador >= arrayDatosTabla.size()) {
				bolHayFila = false;
			}
	         }
	       }else{
	         boolean bolHayFilaResto = true;
	         int contadorResto = 0;
	
	        while ((contadorResto < indRegistros[1]) && bolHayFilaResto){
	           Element filaPrueba = document.createElement("fila");
	           ArrayList arrFila = (ArrayList) arrayDatosTabla.get(contadorResto+contador);
	           for (int j = 0; j < arrFila.size(); ++j) {
	             Element celdaPrueba = document.createElement("celda");
	             String strValorCelda = "";
	             if (arrFila.get(j) != null) {
					strValorCelda = arrFila.get(j).toString();
				}
	             Text textoCeldaPrueba = document.createTextNode(strValorCelda);
	             celdaPrueba.setAttribute("orden", "" + (j + 1));
	             celdaPrueba.appendChild(textoCeldaPrueba);
	             filaPrueba.appendChild(celdaPrueba);
	           } //Fin for celdas
	           contadorResto++;
	           String strIndice = "" + (contadorResto);
	           filaPrueba.setAttribute("indice", strIndice);
	           paginaPrueba.appendChild(filaPrueba);
	           if (contadorResto+contador >=arrayDatosTabla.size()) {
				bolHayFilaResto = false;
			}
	         }//Fin for filas
	         contador = contador + contadorResto;
	       }
	       contenidoPrueba.appendChild(paginaPrueba);
	
	     }//Fin de pagina
	   }//Fin if de datos de la tabla
	
	   prueba.appendChild(contenidoPrueba);
	   //raiz.appendChild(contenido);
	
	   document.getDocumentElement().appendChild(prueba);
	   
	   /*Descomentando estas lineas se obtendra el XML generado.*/
	   /* Hay que aadir en el CLASSPATH del WebLogic -> usr\j2se\jakarta-ant-1.5.3-1\lib\xercesImpl.jar */
	   //String path = "C:\\ListadoFOPPorPagina.xml";
	   V50bClsInformes.fncGenerarDocumentos(document,prueba);
	
	   V50bClsInformes.fncDevuelvePDF(objPfResponse, document,strPfRutaXSL);
	   System.gc();
	   
  }//Fin fncSacarListadoFOPPorPagina
  
  /**
   * Fnc calcular numero paginas.
   * 
   * @param numFilasTotal the num filas total
   * @param numFilasInicial the num filas inicial
   * @param numFilasSig the num filas sig
   * 
   * @return the int
   */
  public static int fncCalcularNumeroPaginas (int numFilasTotal,int numFilasInicial,int numFilasSig){
	   int numPaginas =0;
	   int numPaginasAux = 0;
	   if (numFilasTotal > 0){
	        numPaginasAux = numFilasTotal - numFilasInicial;
	     if (numPaginasAux > 0) {
	       //Hay mas de 1 pagina, seria repartir las filas que quedan entre las distintas paginas
	       numPaginas = (numPaginasAux / numFilasSig) +1;//Se le suma la primera.
	       if ((numPaginasAux % numFilasSig) > 0) {
			numPaginas++;
		}
	     } else {
			numPaginas = 1; //Solo la primera pagina.
		}
	   }

	   return numPaginas;
	}
  
  
  /**
   * Utiliza FOP para sacar un listado en PDF.
   * 
   * @param objPfResponse HttpServletResponse: respuesta actual
   * @param strPfIdioma String: String con el idioma actual
   * @param strPfRutaXSL String: String con la ruta del fich. de transformacin XSL:FO a utilizar
   * @param arrPfLiterales ArrayList: arraylist con los literales ya traducidos
   * @param arrPfDatosTabla ArrayList: arraylist de arrays de objetos para rellenar una tabla-listado de resultados
   * @param strPfFicheroProperties String: String con el nombre de fichero de los literales
   * @param celda int: Celda por la que se hace la ruptura
   * @param arrPfParametros the arr pf parametros
   * @param propiedadOrdenar the propiedad ordenar
   * 
   * @throws Exception the exception
   */
  public static void fncSacarListadoFOPPorRupturaNuevo (HttpServletResponse objPfResponse, 
		  								   String strPfIdioma,
		  								   String strPfRutaXSL,
		  								   List arrPfParametros, 
		  								   List arrPfLiterales, 
		  								   List arrPfDatosTabla, 
		  								   String strPfFicheroProperties,
		  								   int celda, String propiedadOrdenar) throws Exception {

	  V50bClsInformes.fncRellenaFechaPaginaLiterales(arrPfLiterales); 
	  
	  Document document = V50bClsInformes.fncCrearDocument();
	  
	   Element prueba = V50bClsInformes.fncParametrosInforme(document,arrPfParametros);
	
	   //Literales
	   prueba = V50bClsInformes.fncLiteralesInforme(prueba,document,arrPfLiterales,strPfFicheroProperties,strPfIdioma);
	
	   //Datos tabla
	   List arrPfDatosTablaConv = V50bClsFunciones.fncConvierteArrayListBeans(arrPfDatosTabla, propiedadOrdenar);
	   
	   Element contenidoPrueba = document.createElement("contenido");
	   if (arrPfDatosTablaConv!=null && arrPfDatosTablaConv.size()>0){
//	     contenidoPrueba.setAttribute("numPaginas",numPaginas+"");
	     //int intNumFilas=arrPfDatosTabla.size();
	     int contador = 0;
	     int indicePagina=1;
	     String valorCelda = (String) ((ArrayList) arrPfDatosTablaConv.get(0)).get(celda-1);
	     Element paginaPrueba = document.createElement("pagina");
	     paginaPrueba.setAttribute("indicePagina", indicePagina + "");
	     indicePagina++;
	     
	     for (int k = 0; k < arrPfDatosTablaConv.size(); k++){
	       String celdaActual = (String) ((ArrayList) arrPfDatosTablaConv.get(k)).get(celda-1);
	       if (celdaActual==null || valorCelda.equals(celdaActual)){
	    	   //Aadimos el elemento
	    	   Element filaPrueba = document.createElement("fila");
	    	   ArrayList arrFila = (ArrayList) arrPfDatosTablaConv.get(k);
	    	   
	           for (int j = 0; j < arrFila.size(); ++j) {
	        	 Element celdaPrueba = document.createElement("celda");
	             String strValorCelda = "";
	             if (arrFila.get(j) != null) {
					strValorCelda = (String) arrFila.get(j);
				}
	             Text textoCeldaPrueba = document.createTextNode(strValorCelda);
	             celdaPrueba.appendChild(textoCeldaPrueba);
	             filaPrueba.appendChild(celdaPrueba);
	           } //Fin for celdas
	           contador++;
	           String strIndice = "" + (contador);
	           filaPrueba.setAttribute("indice", strIndice);
	           paginaPrueba.appendChild(filaPrueba);
	       }
	       else {
	    	   //Ruptura
	    	   if(celdaActual!=null){
	    		   valorCelda = celdaActual;
	    	   }
	    	   paginaPrueba = document.createElement("pagina");
	    	   paginaPrueba.setAttribute("indicePagina", indicePagina + "");
	  	       indicePagina++;
	    	   Element filaPrueba = document.createElement("fila");
	    	   ArrayList arrFila = (ArrayList) arrPfDatosTablaConv.get(k);

	           for (int j = 0; j < arrFila.size(); ++j) {
	             Element celdaPrueba = document.createElement("celda");
	             String strValorCelda = "";
	             if (arrFila.get(j) != null) {
					strValorCelda = (String) arrFila.get(j);
				}
	             Text textoCeldaPrueba = document.createTextNode(strValorCelda);
	             celdaPrueba.appendChild(textoCeldaPrueba);
	             filaPrueba.appendChild(celdaPrueba);
	           } //Fin for celdas
	           contador=1;
	           String strIndice = "" + (contador);
	           filaPrueba.setAttribute("indice", strIndice);
	           paginaPrueba.appendChild(filaPrueba);
		           
	       }
	       contenidoPrueba.appendChild(paginaPrueba);
	   	
	     }//Fin de pagina
	   }//Fin if de datos de la tabla
	
	   prueba.appendChild(contenidoPrueba);
	   //raiz.appendChild(contenido);
	
	   document.getDocumentElement().appendChild(prueba);
	
	   /*Descomentando estas lineas se obtendra el XML generado.*/
	   /* Hay que aadir en el CLASSPATH del WebLogic -> usr\j2se\jakarta-ant-1.5.3-1\lib\xercesImpl.jar */
	   //String path = "C:\\ListadoFOPPorRuptura.xml";
	   V50bClsInformes.fncGenerarDocumentos(document,prueba);
	   
	   V50bClsInformes.fncDevuelvePDF(objPfResponse, document,strPfRutaXSL);
	   System.gc();
	   
  }//Fin fncSacarListadoFOPPorRupturaNuevo
  
  
  /**
   * Utiliza FOP para sacar un listado en PDF.
   * 
   * @param objPfRequest HttpServletRequest: peticin actual
   * @param objPfResponse HttpServletResponse: respuesta actual
   * @param strPfIdioma String: String con el idioma actual
   * @param strPfRutaXSL String: String con la ruta del fich. de transformacin XSL:FO a utilizar
   * @param arrPfLiterales ArrayList: arraylist con los literales ya traducidos
   * @param arrPfDatosTabla ArrayList: arraylist de arrays de objetos para rellenar una tabla-listado de resultados
   * @param strPfFicheroProperties String: String con el nombre de fichero de los literales
   * @param celda int: Celda por la que se hace la ruptura
   * @param arrPfParametros the arr pf parametros
   * 
   * @throws Exception the exception
   */
  public static void fncSacarListadoFOPPorRuptura (HttpServletRequest objPfRequest, 
		  								   HttpServletResponse objPfResponse, 
		  								   String strPfIdioma,
		  								   String strPfRutaXSL,
		  								   List arrPfParametros, 
		  								   List arrPfLiterales, 
		  								   List arrPfDatosTabla, 
		  								   String strPfFicheroProperties,
		  								   int celda) throws Exception {

	  V50bClsInformes.fncRellenaFechaPaginaLiterales(arrPfLiterales); 
	  
	  Document document = V50bClsInformes.fncCrearDocument();
	  //Parametros
	   Element prueba = V50bClsInformes.fncParametrosInforme(document,arrPfParametros);
	
	   //Literales
	   prueba = V50bClsInformes.fncLiteralesInforme(prueba,document,arrPfLiterales,strPfFicheroProperties,strPfIdioma);
	
	   //Datos tabla
	   Element contenidoPrueba = document.createElement("contenido");
	   if (arrPfDatosTabla!=null && arrPfDatosTabla.size()>0){
//	     contenidoPrueba.setAttribute("numPaginas",numPaginas+"");
	     //int intNumFilas=arrPfDatosTabla.size();
	     int contador = 0;
	     int indicePagina=1;
	     String valorCelda = (String) ((ArrayList) arrPfDatosTabla.get(0)).get(celda-1);
	     Element paginaPrueba = document.createElement("pagina");
	     paginaPrueba.setAttribute("indicePagina", indicePagina + "");
	     indicePagina++;
	     
	     for (int k = 0; k < arrPfDatosTabla.size(); k++){
	       String celdaActual = (String) ((ArrayList) arrPfDatosTabla.get(k)).get(celda-1);
	       if (valorCelda.equals(celdaActual)){
	    	   //Aadimos el elemento
	    	   Element filaPrueba = document.createElement("fila");
	    	   ArrayList arrFila = (ArrayList) arrPfDatosTabla.get(k);
	    	   
	           for (int j = 0; j < arrFila.size(); ++j) {
	        	 Element celdaPrueba = document.createElement("celda");
	             String strValorCelda = "";
	             if (arrFila.get(j) != null) {
	            	 strValorCelda = (String) arrFila.get(j);
	             }
	             Text textoCeldaPrueba = document.createTextNode(strValorCelda);
	             celdaPrueba.appendChild(textoCeldaPrueba);
	             filaPrueba.appendChild(celdaPrueba);
	           } //Fin for celdas
	           contador++;
	           String strIndice = "" + (contador);
	           filaPrueba.setAttribute("indice", strIndice);
	           paginaPrueba.appendChild(filaPrueba);
	       }
	       else {
	    	   //Ruptura
	    	   valorCelda = celdaActual;
	    	   paginaPrueba = document.createElement("pagina");
	    	   paginaPrueba.setAttribute("indicePagina", indicePagina + "");
	  	       indicePagina++;
	    	   Element filaPrueba = document.createElement("fila");
	    	   ArrayList arrFila = (ArrayList) arrPfDatosTabla.get(k);

	           for (int j = 0; j < arrFila.size(); ++j) {
	             Element celdaPrueba = document.createElement("celda");
	             String strValorCelda = "";
	             if (arrFila.get(j) != null) {
					strValorCelda = (String) arrFila.get(j);
				}
	             Text textoCeldaPrueba = document.createTextNode(strValorCelda);
	             celdaPrueba.appendChild(textoCeldaPrueba);
	             filaPrueba.appendChild(celdaPrueba);
	           } //Fin for celdas
	           contador=1;
	           String strIndice = "" + (contador);
	           filaPrueba.setAttribute("indice", strIndice);
	           paginaPrueba.appendChild(filaPrueba);
		           
	       }
	       contenidoPrueba.appendChild(paginaPrueba);
	   	
	     }//Fin de pagina
	   }//Fin if de datos de la tabla
	
	   prueba.appendChild(contenidoPrueba);
	   //raiz.appendChild(contenido);
	
	   document.getDocumentElement().appendChild(prueba);
	
	   /*Descomentando estas lineas se obtendra el XML generado.*/
	   /* Hay que aadir en el CLASSPATH del WebLogic -> usr\j2se\jakarta-ant-1.5.3-1\lib\xercesImpl.jar */
//	   String path = "C:\\ListadoFOPPorRuptura.xml";
//	   fncGenerarDocumentos(path,document,prueba);
	   
	   V50bClsInformes.fncDevuelvePDF(objPfResponse, document,strPfRutaXSL);
	   System.gc();
	   
  }//Fin fncSacarListadoFOPPorPagina
  
  
  //FUNCION QUE GENERA EL XML
  /**
   * Fnc generar documentos.
   * 
   * @param document the document
   * @param elementAux the element aux
   * 
   * @throws Exception the exception
   */
  public static void fncGenerarDocumentos(Document document,Element elementAux)throws Exception{

	   final String entorno = Q70ListenerUtils.getApplicationProperty("ENTORNO_V50B");
	   if("LOCAL".equals(entorno)){
		   String strRutaXml = Q70ListenerUtils.getApplicationProperty("URL_TEMP")+"ListadoFOP_V50b.xml";
		  
		   File fichero=new File(strRutaXml);
		   FileOutputStream outStrFichero=new FileOutputStream(fichero);
		   document.normalize();
		   OutputFormat outFormat=new OutputFormat(document,"ISO-8859-1",true);
		   XMLSerializer serializerFav=new XMLSerializer(outStrFichero,outFormat);
		   DOMSerializer domSer=serializerFav.asDOMSerializer();
		   domSer.serialize(elementAux);
		   outStrFichero.close();
	   }

	}
  
  /**
   * Utiliza FOP para sacar un listado en PDF. En cada fila, el
   * valor de la primera celda ser el nombre de la fila. Si es null,
   * el nombre ser "fila"
   * 
   * @param objPfRequest HttpServletRequest: peticin actual
   * @param objPfResponse HttpServletResponse: respuesta actual
   * @param strPfIdioma String: String con el idioma actual
   * @param strPfRutaXSL String: String con la ruta del fich. de transformacin XSL:FO a utilizar
   * @param arrPfLiterales ArrayList: arraylist con los literales ya traducidos
   * @param arrPfDatosTabla ArrayList: arraylist de arrays de objetos para rellenar una tabla-listado de resultados
   * @param strPfFicheroProperties String: String con el nombre de fichero de los literales
   * @param arrPfParametros the arr pf parametros
   * 
   * @throws Exception the exception
   */
  public static void fncSacarListadoFOPCambiandoNombresFilas(HttpServletRequest objPfRequest,
                                 HttpServletResponse objPfResponse,
                                 String strPfIdioma,
                                 String strPfRutaXSL,
                                 List arrPfParametros,
                                 List arrPfLiterales,
                                 List arrPfDatosTabla, 
                                 String strPfFicheroProperties
                                 )
      throws Exception {
    
	  V50bClsInformes.fncRellenaFechaPaginaLiterales(arrPfLiterales); 
	  
	  Document document = V50bClsInformes.fncCrearDocument();
	  //Parametros
	  Element raiz = V50bClsInformes.fncParametrosInforme(document,arrPfParametros);
    
   
    //Literales
	  raiz = V50bClsInformes.fncLiteralesInforme(raiz,document,arrPfLiterales,strPfFicheroProperties,strPfIdioma);
  
    //Datos de la tabla
    Element contenido = document.createElement("contenido");
    if (arrPfDatosTabla != null) {
      Element valoresArray = document.createElement("pagina");
      valoresArray.setAttribute("numFilas", arrPfDatosTabla.size() + "");
      int intNumFilas = arrPfDatosTabla.size();
      for (int i = 0; i < intNumFilas; ++i) {
    	     	
        ArrayList arrFila = (ArrayList) arrPfDatosTabla.get(i);
        Element fila;
        if (arrFila.get(0)==null) {
			fila = document.createElement("fila");
		} else{
        	V50bClsTrazas
			.depura("Elemento 0: "+(arrFila.get(0)).toString());
        	fila = document.createElement((arrFila.get(0)).toString());
        	
        }
        for (int j = 0; j < arrFila.size(); ++j) {
          Element celda = document.createElement("celda");
          String strValorCelda = "";
          if (arrFila.get(j) != null) {
            strValorCelda = arrFila.get(j).toString();
          }
          Text textoCelda = document.createTextNode(strValorCelda);
          celda.appendChild(textoCelda);
          fila.appendChild(celda);
          String strIndice = "" + (i + 1);
          fila.setAttribute("indice", strIndice);
        } //Fin for celdas
        
        valoresArray.appendChild(fila);
      } //Fin for filas
      
      contenido.appendChild(valoresArray);
    } //Fin if de datos de la tabla

    raiz.appendChild(contenido);
    document.getDocumentElement().appendChild(raiz);
    
    /*Descomentando estas lineas se obtendra el XML generado.*/
	/* Hay que aadir en el CLASSPATH del WebLogic -> usr\j2se\jakarta-ant-1.5.3-1\lib\xercesImpl.jar */
//	String path = "C:\\ListadoFOP.xml";
	//fncGenerarDocumentos(path,document,raiz);
    V50bClsInformes.fncGenerarDocumentos(document,raiz);

    V50bClsInformes.fncDevuelvePDF(objPfResponse, document,strPfRutaXSL);
    System.gc();

    
  } //Fin fncSacarListadoFOP
  
  
  /**
   * Fnc devuelve pdf.
   * 
   * @param objPfResponse the obj pf response
   * @param document document
   * @param strPfRutaXSL ruta
   * 
   * @throws Exception the exception
   */
  private static void fncDevuelvePDF(HttpServletResponse objPfResponse, Document document, String strPfRutaXSL) throws Exception {
	  
	  	Source sourceXML = new DOMSource(document);
	    
	    Driver driverPruebas = new Driver();
	    driverPruebas.setLogger(V50bClsInformes.fncPonerLogger());
	    driverPruebas.setRenderer(Driver.RENDER_PDF);

	    ByteArrayOutputStream salidaTexto = new ByteArrayOutputStream();
	    Result console = new StreamResult(salidaTexto);

	    Transformer transformerlog = TransformerFactory.newInstance().newTransformer();
	    transformerlog.transform(sourceXML, console);

	    V50bClsTrazas.depura("strPfArchivo", strPfRutaXSL, V50bClsInformes.class.getClass());
	    InputStream xsl = V50bClsInformes.class.getResourceAsStream(strPfRutaXSL);
		V50bClsTrazas.depura("xsl", xsl, V50bClsInformes.class.getClass());
	  
	  //Le decimos que el driver deje el resultado en un ByteArrayOutputStream 
	   ByteArrayOutputStream out = new ByteArrayOutputStream();
	   driverPruebas.setOutputStream(out);
	
	   TransformerFactory factorySalida = TransformerFactory.newInstance();
	   //Le decimos al parser que el XSL es el fichero xsl recibido como parmetro
	   Transformer transformer = factorySalida.newTransformer(new StreamSource(xsl));
	   //Le decimos que el resultado del parseo con XSL vaya al driver.
	   Result res = new SAXResult (driverPruebas.getContentHandler());
	   //Se hace el parseo del XML dinmico con el XSL
	   transformer.transform(sourceXML, res);
	
	   byte[] content = out.toByteArray();
	   //Cogemos el resultado (el pdf en memoria) que gener el driver, y lo pasamos a la pantalla.
	   objPfResponse.setContentType("application/pdf");
	   objPfResponse.setContentLength(content.length);
	
	   objPfResponse.getOutputStream().write(content);
	   objPfResponse.getOutputStream().flush();
	   out.close();
	   out = null;
	   content = null;
	   driverPruebas = null;
  }
  
  /**
   * Fnc poner logger.
   * 
   * @return the logger
   * 
   * @throws Exception the exception
   */
  private static Logger fncPonerLogger() throws Exception {
	  
      String strEntornoAplic=Q70ListenerUtils.getApplicationProperty("ENTORNO_V50B");
      Logger logger;

      if("LOCAL".equals(strEntornoAplic)){
    	  logger = new ConsoleLogger(ConsoleLogger.LEVEL_INFO);
      }else{
    	  logger = new NullLogger();
      }
      
      MessageHandler.setScreenLogger(logger);
      
      return logger;
  }
  
  
}
