package v50b.v50bClasesComunes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.Ellipse2D;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.chart.urls.TimeSeriesURLGenerator;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


/**
 * <p>Ttulo: V50bClsGraficos</p>
 * <p>Descripcin: Utilidades de graficos</p>
 * <p>Copyright: Copyright (c) 2007</p>
 * <p>Empresa: Eurohelp Consulting</p>.
 * 
 * @author Iaki Cantalapiedra Bernal
 * @version 0.1 beta
 */
public class V50bClsGraficos {

	/**
	 * Instantiates a new v50b cls graficos.
	 */
	private V50bClsGraficos(){}
	
	/**
	 * Muestra un grafico de Barras en 2D usando los valores pasados como parametro.
	 * 
	 * @param map the map
	 * @param request the request
	 * @param pw the pw
	 * 
	 * @return 	La ruta completa de la imagen con el grafico.
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha	  	10/01/2007
	 */
	public static String generarGraficoBarras(Map map, HttpServletRequest request, PrintWriter pw) throws Exception{
		String filename = null;
		
			//Miramos a ver si hay datos o no
			if (map.size() == 0) {
				V50bClsTrazas.depura("ERROR", "No hay datos en el Array");
			}
			
		 	//Creamos y rellenamos el CategorySet
			Iterator iter = map.keySet().iterator();
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
			while (iter.hasNext()) {
				String key = (String)iter.next();
                dataset.addValue(Long.valueOf((String)map.get(key)), "", key);
			}

			//Create the chart object
			CategoryAxis categoryAxis = new CategoryAxis("");
			ValueAxis valueAxis = new NumberAxis("");
			BarRenderer renderer = new BarRenderer();
			renderer.setItemURLGenerator(new StandardCategoryURLGenerator());
            renderer.setToolTipGenerator(new StandardCategoryToolTipGenerator());

			Plot plot = new CategoryPlot(dataset, categoryAxis, valueAxis, renderer);
			JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, plot, false);
			chart.setBackgroundPaint(java.awt.Color.white);

			//Write the chart image to the temporary directory
			ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
			filename = ServletUtilities.saveChartAsPNG(chart, V50bClsConstantes.QUINIENTOS, V50bClsConstantes.TRESCIENTOS, info, request.getSession());

			//Write the image map to the PrintWriter
			ChartUtilities.writeImageMap(pw, filename, info, false);
			pw.flush();

		return request.getContextPath() + V50bClsConstantes.RUTA_SERVLET_JFREECHART + filename;
	}
	
	/**
	 * Muestra un grafico de Barras en 3D usando los valores pasados como parametro.
	 * 
	 * @param map the map
	 * @param request the request
	 * @param pw the pw
	 * 
	 * @return 	La ruta completa de la imagen con el grafico.
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha	  	10/01/2007
	 */
	public static String generarGraficoBarras3D(Map map, HttpServletRequest request, PrintWriter pw) throws Exception{
		String filename = null;
		
			//Miramos a ver si hay datos o no
			if (map.size() == 0) {
				V50bClsTrazas.depura("ERROR", "No hay datos en el Array");
			}
			
		 	//Creamos y rellenamos el CategorySet
			Iterator iter = map.keySet().iterator();
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
			while (iter.hasNext()) {
				String key = (String)iter.next();
			    dataset.addValue(Long.valueOf((String)map.get(key)), "", key);
			}

			//Create the chart object
			CategoryAxis3D categoryAxis = new CategoryAxis3D("");
			ValueAxis valueAxis = new NumberAxis("");
			BarRenderer3D renderer = new BarRenderer3D();
			renderer.setItemURLGenerator(new StandardCategoryURLGenerator());
            renderer.setToolTipGenerator(new StandardCategoryToolTipGenerator());

			Plot plot = new CategoryPlot(dataset, categoryAxis, valueAxis, renderer);
			JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, plot, false);
			chart.setBackgroundPaint(java.awt.Color.white);

			//Write the chart image to the temporary directory
			ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
			filename = ServletUtilities.saveChartAsPNG(chart, V50bClsConstantes.QUINIENTOS, V50bClsConstantes.TRESCIENTOS, info, request.getSession());

			//Write the image map to the PrintWriter
			ChartUtilities.writeImageMap(pw, filename, info, false);
			pw.flush();

		return request.getContextPath() + V50bClsConstantes.RUTA_SERVLET_JFREECHART + filename;
	}
	
	/**
	 * Muestra un grafico de Tarta en 2D usando los valores pasados como parametro.
	 * 
	 * @param map the map
	 * @param request the request
	 * @param pw the pw
	 * 
	 * @return 	La ruta completa de la imagen con el grafico.
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha	  	10/01/2007
	 */
	public static String generarGraficoTarta(Map map, HttpServletRequest request, PrintWriter pw) throws Exception{
		String filename = null;
		
			//  Throw a custom NoDataException if there is no data
			if (map.size() == 0) {
				V50bClsTrazas.depura("ERROR", "No hay datos en el Array");
			}

			//  Create and populate a PieDataSet
			DefaultPieDataset data = new DefaultPieDataset();
			Iterator iter = map.keySet().iterator();
			while (iter.hasNext()) {
				String key = (String)iter.next();
				data.setValue(key, Long.valueOf((String)map.get(key)));
			}

			//  Create the chart object
			PiePlot plot = new PiePlot(data);
			plot.setInsets(new RectangleInsets(0, V50bClsConstantes.CINCO, V50bClsConstantes.CINCO, V50bClsConstantes.CINCO));
			plot.setURLGenerator(new StandardPieURLGenerator());
            plot.setToolTipGenerator(new StandardPieToolTipGenerator());
			JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
			chart.setBackgroundPaint(java.awt.Color.white);

			//  Write the chart image to the temporary directory
			ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
			filename = ServletUtilities.saveChartAsPNG(chart, V50bClsConstantes.QUINIENTOS, V50bClsConstantes.TRESCIENTOS, info, request.getSession());

			//  Write the image map to the PrintWriter
			ChartUtilities.writeImageMap(pw, filename, info, false);
			pw.flush();

		return request.getContextPath() + V50bClsConstantes.RUTA_SERVLET_JFREECHART + filename;
	}
	
	/**
	 * Muestra un grafico de Tarta en 3D usando los valores pasados como parametro.
	 * 
	 * @param map the map
	 * @param request the request
	 * @param pw the pw
	 * @param titulo the titulo
	 * @param ancho the ancho
	 * 
	 * @return 	La ruta completa de la imagen con el grafico.
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha	  	10/01/2007
	 */
	public static String generarGraficoTarta3D(Map map, HttpServletRequest request, PrintWriter pw, String titulo, int ancho) throws Exception{
			String filename = null;
			int altura = (int)(ancho/V50bClsConstantes.UNO_TREINTAITRES);
			
			//  Throw a custom NoDataException if there is no data
			if (map.size() == 0) {
				V50bClsTrazas.depura("ERROR", "No hay datos en el Array");
			}

			//  Create and populate a PieDataSet
			DefaultPieDataset data = new DefaultPieDataset();
			Iterator iter = map.keySet().iterator();
			while (iter.hasNext()) {
				String key = (String)iter.next();
				data.setValue(key, Double.valueOf((String)map.get(key)));
			}

			//  Create the chart object
			PiePlot3D plot = new PiePlot3D(data);
			plot.setForegroundAlpha(V50bClsConstantes.CERO_SEIS);
			plot.setCircular(true);
//			plot.setInsets(new RectangleInsets(0, V50bClsConstantes.CINCO, V50bClsConstantes.CINCO, V50bClsConstantes.CINCO));
			plot.setURLGenerator(new StandardPieURLGenerator());			
			
            //plot.setToolTipGenerator(new StandardPieItemLabelGenerator());
            plot.setLabelGenerator(new StandardPieSectionLabelGenerator("{1} %"));
			JFreeChart chart = new JFreeChart(titulo, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
			chart.setBackgroundPaint(java.awt.Color.white);
			
			//  Write the chart image to the temporary directory 345*259
			ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
			filename = ServletUtilities.saveChartAsPNG(chart, ancho, altura, info, request.getSession());

			//  Write the image map to the PrintWriter
			ChartUtilities.writeImageMap(pw, filename, info, false);
			pw.flush();

		return request.getContextPath() + V50bClsConstantes.RUTA_SERVLET_JFREECHART + filename;
	}

	/**
	 * Muestra un grafico de XY usando los valores pasados como parametro.
	 * 
	 * @param listaFinal the lista final
	 * @param request the request
	 * @param pw the pw
	 * @param strIdioma the str idioma
	 * @param listLiterales the list literales
	 * @param listLeyenda the list leyenda
	 * 
	 * @return 	La ruta completa de la imagen con el grafico.
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha	  	10/01/2007
	 */
	public static String generarGraficoXY(List listaFinal, HttpServletRequest request, PrintWriter pw,String strIdioma,List listLiterales,List listLeyenda) throws Exception {
		String filename = null;
		XYSeriesCollection xyDataset = new XYSeriesCollection();

		for(int i=0;i<listaFinal.size();i++){
			HashMap map=(HashMap)listaFinal.get(i);
			//Throw a custom NoDataException if there is no data
			if (map.size() == 0) {
				V50bClsTrazas.depura("ERROR", "No hay datos en el Array");
			}
			//Inicializamos la serie con el ttulo q le corresponde en la leyenda 
			XYSeries dataSeries = V50bClsGraficos.fncNewXYSeries(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",listLeyenda.get(i).toString(),strIdioma));
			Iterator iter = map.keySet().iterator();
			while (iter.hasNext()) {
				String key = (String)iter.next();
				dataSeries.add(Integer.valueOf(key),Long.valueOf((String)map.get(key)));
			}
			xyDataset.addSeries(dataSeries);
		}
		
		JFreeChart chart = ChartFactory.createXYLineChart(null,Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",listLiterales.get(0).toString(),strIdioma),Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",listLiterales.get(1).toString(),strIdioma), xyDataset, PlotOrientation.VERTICAL, true, true, false);
		chart.setBackgroundPaint(Color.white);
        XYPlot xyplot = chart.getXYPlot();
        xyplot.setBackgroundPaint(Color.white);
        xyplot.setDomainGridlinePaint(Color.gray);
        xyplot.setRangeGridlinePaint(Color.gray);
        XYLineAndShapeRenderer xylineandshaperenderer = new XYLineAndShapeRenderer();
        xylineandshaperenderer.setShapesVisible(false);
        xylineandshaperenderer.setLinesVisible(true);
        xylineandshaperenderer.setToolTipGenerator(new StandardXYToolTipGenerator());
        xyplot.setRenderer(xylineandshaperenderer);
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        ValueAxis valueAxis=xyplot.getDomainAxis();
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        valueAxis.setLowerMargin(0D);
        valueAxis.setFixedAutoRange(Double.parseDouble("1"));
        
		//  Write the chart image to the temporary directory
		ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());

		filename = ServletUtilities.saveChartAsPNG(chart, V50bClsConstantes.QUINIENTOS, V50bClsConstantes.TRESCIENTOS, request.getSession());
		
		//  Write the image map to the PrintWriter
		ChartUtilities.writeImageMap(pw, filename, info, false);
		pw.flush();

		return request.getContextPath() + V50bClsConstantes.RUTA_SERVLET_JFREECHART + filename;
		
	}
	
	/**
	 * Muestra un grafico de XY usando los valores pasados como parametro.
	 * 
	 * @param listaFinal the lista final
	 * @param request the request
	 * @param pw the pw
	 * 
	 * @return 	La ruta completa de la imagen con el grafico.
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha	  	10/01/2007
	 */
	public static String generarGraficoXYViejo(List listaFinal, HttpServletRequest request, PrintWriter pw) throws Exception {
		String filename = null;
		XYSeriesCollection xyDataset = new XYSeriesCollection();
		XYPlot plot = null;

		for(int i=0;i<listaFinal.size();i++){
			HashMap map=(HashMap)listaFinal.get(i);
			//Throw a custom NoDataException if there is no data
			if (map.size() == 0) {
				V50bClsTrazas.depura("ERROR", "No hay datos en el Array");
			}
			//Inicializamos la serie con el ttulo q le corresponde en la leyenda 
			XYSeries dataSeries = V50bClsGraficos.fncNewXYSeries("");
			Iterator iter = map.keySet().iterator();
			while (iter.hasNext()) {
				String key = (String)iter.next();
				dataSeries.add(Integer.valueOf(key),Long.valueOf((String)map.get(key)));
			}
			xyDataset.addSeries(dataSeries);
		}
		
			//Create tooltip and URL generators
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
			StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator(
					StandardXYToolTipGenerator.DEFAULT_TOOL_TIP_FORMAT,
                    sdf, NumberFormat.getInstance());
			TimeSeriesURLGenerator urlg = new TimeSeriesURLGenerator(
					sdf, "", "series", "");
			//Create the chart object
			NumberAxis timeAxis = new NumberAxis("");
			NumberAxis valueAxis = new NumberAxis("");
			valueAxis.setAutoRangeIncludesZero(false);  // override default
            StandardXYItemRenderer renderer = new StandardXYItemRenderer(
                    StandardXYItemRenderer.LINES + StandardXYItemRenderer.SHAPES,ttg, urlg);
            renderer.setShapesFilled(true);
			plot = new XYPlot(xyDataset, timeAxis, valueAxis, renderer);
			JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, plot, false);
			chart.setBackgroundPaint(java.awt.Color.white);
        
			//  Write the chart image to the temporary directory
			ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());

			filename = ServletUtilities.saveChartAsPNG(chart, V50bClsConstantes.QUINIENTOS, V50bClsConstantes.TRESCIENTOS, request.getSession());
			
			//  Write the image map to the PrintWriter
			ChartUtilities.writeImageMap(pw, filename, info, false);
			pw.flush();

		return request.getContextPath() + V50bClsConstantes.RUTA_SERVLET_JFREECHART + filename;

	}
		

	/**
	 * Muestra un grafico de XY de area usando los valores pasados como parametro.
	 * 
	 * @param lisMaps the lis maps
	 * @param request the request
	 * @param pw the pw
	 * 
	 * @return 	La ruta completa de la imagen con el grafico.
	 * 
	 * @throws  Exception
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha	  	10/01/2007
	 */
    public static String generarGraficoXYArea(List lisMaps, HttpServletRequest request, PrintWriter pw) throws Exception{
        String filename = null;
        
            //  Retrieve list of WebHits for each section and populate a TableXYDataset
            Iterator lisMapsIter = lisMaps.iterator();
            DefaultTableXYDataset dataset = new DefaultTableXYDataset();
            while (lisMapsIter.hasNext()) {
            	Map map = (Map)lisMapsIter.next();
                XYSeries dataSeries = V50bClsGraficos.fncNewXYSeries("", true, false);
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                	String key = (String)iter.next();
    				dataSeries.add(Double.valueOf(key),Long.valueOf((String)map.get(key)));
                }
                dataset.addSeries(dataSeries);
            }

            //  Throw a custom NoDataException if there is no data
            if (dataset.getItemCount() == 0) {
            	V50bClsTrazas.depura("ERROR", "No hay datos en el Array");
            }

            //  Create tooltip and URL generators
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
            StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator(
                    StandardXYToolTipGenerator.DEFAULT_TOOL_TIP_FORMAT,
                    sdf, NumberFormat.getInstance());
            TimeSeriesURLGenerator urlg = new TimeSeriesURLGenerator(
                    sdf, "", "series", "");

            //  Create the X-Axis
            DateAxis xAxis = new DateAxis(null);
            xAxis.setLowerMargin(0.0);
            xAxis.setUpperMargin(0.0);

            //  Create the X-Axis
            NumberAxis yAxis = new NumberAxis(null);
            yAxis.setAutoRangeIncludesZero(true);

            //  Create the renderer
            StackedXYAreaRenderer renderer =
                    new StackedXYAreaRenderer(XYAreaRenderer.AREA_AND_SHAPES, ttg, urlg);
            renderer.setSeriesPaint(0, new Color(V50bClsConstantes.DOSCIENTOSCINCUENTAYCINCO, V50bClsConstantes.DOSCIENTOSCINCUENTAYCINCO, V50bClsConstantes.CIENTOOCHENTA));
            renderer.setSeriesPaint(1, new Color(V50bClsConstantes.DOSCIENTOSSEIS, V50bClsConstantes.DOSCIENTOSTREINTA, V50bClsConstantes.DOSCIENTOSCINCUENTAYCINCO));
            renderer.setSeriesPaint(2, new Color(V50bClsConstantes.DOSCIENTOSCINCUENTAYCINCO, V50bClsConstantes.DOSCIENTOSTREINTA, V50bClsConstantes.DOSCIENTOSTREINTA));
            renderer.setSeriesPaint(V50bClsConstantes.TRES, new Color(V50bClsConstantes.DOSCIENTOSSEIS, V50bClsConstantes.DOSCIENTOSCINCUENTAYCINCO, V50bClsConstantes.DOSCIENTOSSEIS));
            renderer.setShapePaint(Color.gray);
            renderer.setShapeStroke(new BasicStroke(V50bClsConstantes.CERO_CINCO));
            renderer.setShape(new Ellipse2D.Double(V50bClsConstantes.TRES_NEGATIVO, V50bClsConstantes.TRES_NEGATIVO, V50bClsConstantes.SEIS, V50bClsConstantes.SEIS));
            renderer.setOutline(true);

            //  Create the plot
            XYPlot plot = new XYPlot(dataset, xAxis, yAxis, renderer);
            plot.setForegroundAlpha(V50bClsConstantes.CERO_SESENTAYCINCO);

            //  Reconfigure Y-Axis so the auto-range knows that the data is stacked
            yAxis.configure();

            //  Create the chart
            JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
            chart.setBackgroundPaint(java.awt.Color.white);

            //  Write the chart image to the temporary directory
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            filename = ServletUtilities.saveChartAsPNG(chart, V50bClsConstantes.QUINIENTOS, V50bClsConstantes.TRESCIENTOS, info, request.getSession());

            //  Write the image map to the PrintWriter
            ChartUtilities.writeImageMap(pw, filename, info, false);
            pw.flush();

        return request.getContextPath() + V50bClsConstantes.RUTA_SERVLET_JFREECHART + filename;
    }
    
    /**
     * Fnc new xy series.
     * 
     * @param param the param
     * 
     * @return the xY series
     */
    private static XYSeries fncNewXYSeries(String param){
    	return new XYSeries(param);
    }
    
    /**
     * Fnc new xy series.
     * 
     * @param param the param
     * @param param2 the param2
     * @param param3 the param3
     * 
     * @return the xY series
     */
    private static XYSeries fncNewXYSeries(String param, boolean param2, boolean param3){
    	return new XYSeries(param, param2, param3);
    }


}