package v50b.v50bClasesComunes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

import javax.ejb.EJBHome;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Status;
import javax.transaction.UserTransaction;

import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.validator.GenericValidator;

import v50b.v50bClasesComunes.v50bBeansComunes.V50bGenericoBean;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * The Class V50bClsFunciones.
 * 
 * @author Iaki Cantalapiedra Bernal
 */
public class V50bClsFunciones {
	
	/**
	 * Instantiates a new v50b cls funciones.
	 */
	private V50bClsFunciones(){}
		
	/**
	 * Obtiene la columa pulsada en una ordenacin.
	 * 
	 * @param contexto the contexto
	 * @param request the request
	 * 
	 * @throws Q70GestorMensajesException the q70 gestor mensajes exception
	 * 
	 * @author    Jonatan Gonzlez Castilla
	 * @version 	1.0
	 */
	public static void fncImprimirListadoOrdenado(Q70ContextoEJIE contexto, HttpServletRequest request) throws Q70GestorMensajesException{
		String columnaNueva = "";
		String parametro = "";
		
		String columna = (String) contexto.get("v50bstrColumna");
		String sentido = (String) contexto.get("v50bstrSentido");
		
		Enumeration nombreParametros = request.getParameterNames();
		boolean encontrado = false;
		while (nombreParametros.hasMoreElements() && !encontrado){
			parametro = (String) nombreParametros.nextElement();
			if (parametro.endsWith("-s")){
				columnaNueva = (String) request.getParameter(parametro);
				encontrado = true;
			}
		}
		
		if (encontrado){
			if (columnaNueva.equals(columna)){
				//Cambiar sentido
				if ("ASC".equals(sentido)) {
					sentido = "DESC";
				} else {
					sentido = "ASC";
				}
			}
			else{
				sentido = "ASC";
			}
			
			columna = columnaNueva;
			
			contexto.set("v50bstrColumna",columna);
			contexto.set("v50bstrSentido",sentido);
		}
	}
	
	
	
	
	 /**
 	 * Ordena un ArrayList de HashMap usando la clave dada del HashMap de la manera mas eficiente posible.
 	 * Usando el algoritmo de ordenacin MergeSort en su version Iterativa O(n)=n*log n.
 	 * 
 	 * @param arrOrdenar the arr ordenar
 	 * @param claveOrdenacion the clave ordenacion
 	 * @param sentido the sentido
 	 * 
 	 * @return 	El ArrayList ordenado.
 	 * 
 	 * @throws Q70GestorMensajesException the q70 gestor mensajes exception
 	 * 
 	 * @author    Iaki Cantalapiedra Bernal
 	 * @version 	1.0
 	 * @fecha
 	 */
	public static List fncOrdenarArrayListDeHashMapsAscDesc(List arrOrdenar, String claveOrdenacion, String sentido) throws Q70GestorMensajesException{
		return V50bClsFunciones.mergeSortAscDesc(arrOrdenar, claveOrdenacion,sentido);	
	}
	
	/**
	 * Merge sort asc desc.
	 * 
	 * @param theList the the list
	 * @param claveOrdenacion the clave ordenacion
	 * @param sentido the sentido
	 * 
	 * @return the list
	 */
	private static List mergeSortAscDesc(List theList, String claveOrdenacion,String sentido) {
		
		if (theList.size() <= 1) {
		    return theList;
		  } else {
			  if("ASC".equals(sentido))
			  {
			    ArrayList fh = new ArrayList(theList.subList(0, theList.size()/2));
			    ArrayList sh = new ArrayList(theList.subList(theList.size()/2, theList.size()));
			    return V50bClsFunciones.merge(V50bClsFunciones.mergeSortAscDesc(fh, claveOrdenacion,sentido), V50bClsFunciones.mergeSortAscDesc(sh, claveOrdenacion,sentido), claveOrdenacion);
			  }
			  else
			  {
			    ArrayList fh = new ArrayList(theList.subList(0, theList.size()/2));
			    ArrayList sh = new ArrayList(theList.subList(theList.size()/2, theList.size()));
			    return V50bClsFunciones.mergeDesc(V50bClsFunciones.mergeSortAscDesc(fh, claveOrdenacion,sentido), V50bClsFunciones.mergeSortAscDesc(sh, claveOrdenacion,sentido), claveOrdenacion);
			  }
				  
		  }
		}
	
	
	/**
	 * Ordena un ArrayList de HashMap usando la clave dada del HashMap de la manera mas eficiente posible.
	 * Usando el algoritmo de ordenacin MergeSort en su version Iterativa O(n)=n*log n.
	 * 
	 * @param arrOrdenar the arr ordenar
	 * @param claveOrdenacion the clave ordenacion
	 * @param sentido the sentido
	 * 
	 * @return 	El ArrayList ordenado.
	 * 
	 * @throws Q70GestorMensajesException the q70 gestor mensajes exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha
	 */
	public static List fncOrdenarArrayListDeFechasAscDesc(List arrOrdenar, String claveOrdenacion, String sentido) throws Q70GestorMensajesException{
	
		return V50bClsFunciones.mergeSortAscDesc(arrOrdenar, claveOrdenacion,sentido);	
	}
	
	/**
	 * Ordena un ArrayList de HashMap usando la clave dada del HashMap de la manera mas eficiente posible.
	 * Usando el algoritmo de ordenacin MergeSort en su version Iterativa O(n)=n*log n.
	 * 
	 * @param arrOrdenar the arr ordenar
	 * @param claveOrdenacion the clave ordenacion
	 * 
	 * @return 	El ArrayList ordenado.
	 * 
	 * @throws Q70GestorMensajesException the q70 gestor mensajes exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha
	 */
	public static List fncOrdenarArrayListDeHashMaps(List arrOrdenar, String claveOrdenacion) throws Q70GestorMensajesException{
	
		return V50bClsFunciones.mergeSort(arrOrdenar, claveOrdenacion);	
	}
	
	/**
	 * Merge.
	 * 
	 * @param l1 the l1
	 * @param l2 the l2
	 * @param claveOrdenacion the clave ordenacion
	 * 
	 * @return the list
	 */
	private static List merge(List l1, List l2, String claveOrdenacion) {
		  ArrayList out = new ArrayList();
		  int next1 = 0;
		  int next2 = 0;
		  
		  while (next1 < l1.size() || next2 < l2.size()) {
		      if (next1 >= l1.size()) { 
		        out.add(l2.get(next2));
		        next2++;
		      } else if (next2 >= l2.size()) { 
		        out.add(l1.get(next1));
		        next1++;
		      } else {
		        Comparable c1 = (Comparable)(((HashMap)l1.get(next1)).get(claveOrdenacion)==null?"":((HashMap)l1.get(next1)).get(claveOrdenacion));
		        Comparable c2 = (Comparable)(((HashMap)l2.get(next2)).get(claveOrdenacion)==null?"":((HashMap)l2.get(next2)).get(claveOrdenacion));
		        if (c1.compareTo(c2) <= 0) {
		          out.add(l1.get(next1));
		          next1++;
		        } else {
		          out.add(l2.get(next2));
		          next2++;
		        }
		      }
		  }
		  return out;
		}
	
	/**
	 * Merge desc.
	 * 
	 * @param l1 the l1
	 * @param l2 the l2
	 * @param claveOrdenacion the clave ordenacion
	 * 
	 * @return the list
	 */
	private static List mergeDesc(List l1, List l2, String claveOrdenacion) {
		  ArrayList out = new ArrayList();
		  int next1 = 0;
		  int next2 = 0;
		  
		  while (next1 < l1.size() || next2 < l2.size()) {
		      if (next1 >= l1.size()) { 
		        out.add(l2.get(next2));
		        next2++;
		      } else if (next2 >= l2.size()) { 
		        out.add(l1.get(next1));
		        next1++;
		      } else {
		        Comparable c1 = (Comparable)(((HashMap)l1.get(next1)).get(claveOrdenacion)==null?"":((HashMap)l1.get(next1)).get(claveOrdenacion));
		        Comparable c2 = (Comparable)(((HashMap)l2.get(next2)).get(claveOrdenacion)==null?"":((HashMap)l2.get(next2)).get(claveOrdenacion));
		        if (c1.compareTo(c2) >= 0) {
		          out.add(l1.get(next1));
		          next1++;
		        } else {
		          out.add(l2.get(next2));
		          next2++;
		        }
		      }
		  }
		  return out;
		}
	
	/**
	 * Merge sort.
	 * 
	 * @param theList the the list
	 * @param claveOrdenacion the clave ordenacion
	 * 
	 * @return the list
	 */
	private static List mergeSort(List theList, String claveOrdenacion) {
		  if (theList.size() <= 1) {
		    return theList;
		  } else {
			  List fh = new ArrayList(theList.subList(0, theList.size()/2));
			  List sh = new ArrayList(theList.subList(theList.size()/2, theList.size()));
		    return V50bClsFunciones.merge(V50bClsFunciones.mergeSort(fh, claveOrdenacion), V50bClsFunciones.mergeSort(sh, claveOrdenacion), claveOrdenacion);
		  }
		}

	 /**
 	 * Se le pasa un String con el dato a truncar y el HashMap con los datos de la facutura para rellenar.
 	 * Trunca el String si pasa de 40 caracteres en dos lineas para mostrar en la factura.
 	 * 
 	 * @param dato the dato
 	 * @param datosFactura the datos factura
 	 * @param tipo the tipo
 	 * 
 	 * @return 	El HashMap ya actualizado correctamente.
 	 * 
 	 * @throws Q70GestorMensajesException the q70 gestor mensajes exception
 	 * 
 	 * @author    Iaki Cantalapiedra Bernal
 	 * @version 	1.0
 	 * @fecha
 	 */
	public static Map fncTruncaCamposFactura(String dato, Map datosFactura, String tipo) throws Q70GestorMensajesException{

		int tamDato = dato.length();
		StringBuffer linea1 = new StringBuffer();
		StringBuffer linea2 = new StringBuffer();
		if(tamDato>V50bClsConstantes.CUARENTA){
			StringTokenizer blancos = new StringTokenizer(dato," ");
					
			while(linea1.length()<V50bClsConstantes.VEINTICINCO) {
				//linea1 = linea1 + " " + blancos.nextToken();
				
				linea1.append(" ");
				linea1.append(blancos.nextToken());
			}
			while(blancos.hasMoreTokens()) {
				//linea2 = linea2 + " " + blancos.nextToken();	
				
				linea2.append(" ");
				linea2.append(blancos.nextToken());
			}
		}
		else{
			linea1.append(dato);
		}
		datosFactura.put(tipo+"_LINEA1",linea1);
		datosFactura.put(tipo+"_LINEA2",linea2);

		return datosFactura;
	}
	
	 /**
 	 * Se le pasa un String con un importe en formato cifra valida (1.234.567,89) y se devuelve un float para operar con el
 	 * 
 	 * @param cifra the cifra
 	 * 
 	 * @return 	1.234.567,89 --> 1234567.89 en float// 123,00 --> 123 en float
 	 * 
 	 * @throws Q70GestorMensajesException the q70 gestor mensajes exception
 	 * 
 	 * @author    Iaki Cantalapiedra Bernal
 	 * @version 	1.0
 	 * @fecha
 	 */
	public static String fncFormateaImporteValido(String cifra) throws Q70GestorMensajesException{

		if(cifra!=null && !cifra.equals("")){
		
			StringTokenizer puntos = new StringTokenizer(cifra,".");
			StringBuffer cifraTok = new StringBuffer();
			while(puntos.hasMoreTokens()){
				String token = puntos.nextToken();
				cifraTok.append(token);
			}
			//cifraTok = cifraTok.replace(',','.');
	
			return cifraTok.toString().replace(',','.');
		} else {
			return "";
		}
	}
	
	/**
	 * Establece la propiedad del contexto 'v50bstrActiveX' a false para que no se active el componente ActiveX.
	 * 
	 * @param contexto the contexto
	 * 
	 * @throws Exception the exception
	 */
	public static void fncDesactivarWord(Q70ContextoEJIE contexto) throws Exception {
		contexto.set("v50bstrActiveX","false");
	}
	
	
	 /**
 	 * Se le pasa un string con una cifra ya obtenido a partir de base de datos o conversion de String, puede tener cualquier formato
 	 * aplicable a cifra, el pto decimal que contendra ser el '.', se devuelve una cifra en formato 1.234.567,89 siempre, tenga o no tenga
 	 * decimales (se devolver 123,00 p ej).
 	 * 
 	 * @param cifra the cifra
 	 * 
 	 * @return 	1234567.89 --> 1.234.567,89 // 123 --> 123,00
 	 * 
 	 * @throws Q70GestorMensajesException the q70 gestor mensajes exception
 	 * 
 	 * @author    Iaki Cantalapiedra Bernal
 	 * @version 	1.0
 	 * @fecha
 	 */
	public static String fncFormateaCifraValida(String cifra) throws Q70GestorMensajesException{
		
		if(cifra!=null && !cifra.equals("")){
			Locale localidad = new Locale("es", "ES");
			
			 Double cantidad = new Double(cifra);
			 NumberFormat nf;
			 String salida;
	
			 nf = NumberFormat.getNumberInstance(localidad);
			 nf.setMaximumFractionDigits(2);
			 nf.setMinimumFractionDigits(2);
			 salida = nf.format(cantidad);
			
			return salida;
		} else {
			return "";
		}
	}

	/**
	 * Busca la claveBusqueda que pertenece al campoBusqueda en el array de busquedas.
	 * 
	 * @param arrBusquedas the arr busquedas
	 * @param claveBusqueda the clave busqueda
	 * @param campoBusqueda the campo busqueda
	 * 
	 * @return String: Si no se encuentra se devuelve "NO_ENCONTRADO", en caso contrario se devuelve el valor de la claveBusqueda.
	 * 
	 * @pre: El array debe estar ordenado ascendentemente por el campoBusqueda y este debe ser numerico.
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha
	 */
	public static String fncBusquedaDicotomica(List arrBusquedas, String claveBusqueda, String campoBusqueda){
			
        if (arrBusquedas.size()==0){
			return "NO_ENCONTRADO";
        }
        else if(arrBusquedas.size()==1){
        	Map elemMed = (Map)arrBusquedas.get(0); 
            String camMed = (String)elemMed.get(campoBusqueda);
            if(camMed.equals(claveBusqueda)) {
				return camMed;
			} else {
				return "NO_ENCONTRADO";
			}
        }
        else{
        	int med = ((arrBusquedas.size()-1)/2)+1;
            Map elemMed = (Map)arrBusquedas.get(med); 
            String camMed = (String)elemMed.get(campoBusqueda);
            
	        if(camMed.equals(claveBusqueda)){
	        	
	             return camMed;
			}
			else{         
	             if(Integer.parseInt(camMed)>Integer.parseInt(claveBusqueda)) {
	            	 return V50bClsFunciones.fncBusquedaDicotomica(new ArrayList(arrBusquedas.subList(0,med)),claveBusqueda,campoBusqueda);
	             }
	             else {
	            	 return V50bClsFunciones.fncBusquedaDicotomica(new ArrayList(arrBusquedas.subList(med+1,arrBusquedas.size())),claveBusqueda,campoBusqueda);
	             }
			}
        }
	}
	
	
	/**
	 * Recupera una instancia de un EJB.
	 * 
	 * @param jndiName the jndi name
	 * 
	 * @return Object: el objeto del EJB
	 * 
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha
	 */
	public static Object fncLlamadaEJB(String jndiName) throws Exception
	{
		Object ejb = null;
		try{
			Context ctx = new InitialContext();
			Class paramType[] = { };
			
			Object ihome = ctx.lookup(jndiName);
			EJBHome home = (EJBHome)PortableRemoteObject.narrow(ihome,EJBHome.class);
			
			Method metodo = home.getClass().getMethod("create", paramType);
			ejb = metodo.invoke(home, paramType);
		}
		catch(NamingException ne){
			V50bClsTrazas.depura("ERROR EN LLAMADA EJB","Error en lookup de "+jndiName);
			throw ne;
		}
		catch(NoSuchMethodException nsme){
			V50bClsTrazas.depura("ERROR EN LLAMADA EJB","Error en getMethod");
			throw nsme;
		}
		catch(InvocationTargetException ite){
			V50bClsTrazas.depura("ERROR EN LLAMADA EJB","Error en invoke");
			throw ite;
		}
		catch(IllegalAccessException ite){
			V50bClsTrazas.depura("ERROR EN LLAMADA EJB","Error en invoke");
			throw ite;
		}
		
		return ejb;		
	}
	
	/**
	 * Arregla el array de dias de curso para poder ser usado con el tag de Calendario.
	 * 
	 * * @author    Iaki Cantalapiedra Bernal
	 * 
	 * @param arrBusquedas the arr busquedas
	 * @param diasEsp the dias esp
	 * 
	 * @return the map
	 * 
	 * 
	 * @version 	1.0
	 * @fecha
	 */
	public static Map fncConvierteCalendarioDiasCurso(List arrBusquedas, Map diasEsp){
		
		Map diasCurso;
		
		if(diasEsp==null) {
			diasCurso = new HashMap();
		} else {
			diasCurso = diasEsp;
		}
		
		for(int i=0;i<arrBusquedas.size();i++){
			//Para el combo de annos.
			HashMap tupla = (HashMap)arrBusquedas.get(i);
			//Para el tag de calendario.
			String fecha = (String)tupla.get("FECHA");
			fecha=fecha.substring(0,V50bClsConstantes.CUATRO)+fecha.substring(V50bClsConstantes.CINCO,V50bClsConstantes.SIETE)+fecha.substring(V50bClsConstantes.OCHO,V50bClsConstantes.DIEZ);
			diasCurso.put(fecha,"CURSO");
		}
		
		return diasCurso;
	}
	
	/**
	 * Dado un numero de mes, devuelve el literal asociado al mismo.
	 * 
	 * * @author    Iaki Cantalapiedra Bernal
	 * 
	 * @param numMes the num mes
	 * @param idioma the idioma
	 * 
	 * @return the string
	 * 
	 * @throws Exception the exception
	 * 
	 * @version 	1.0
	 * @fecha
	 */
	public static String fncFormateaNombreMes(int numMes,String idioma) throws Exception {
	    	
	    	String nombreMes = "";
	    	
	    	try{
	    		switch(numMes){
	    		case 1:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.enero",idioma);
					break;				
	    		case 2:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.febrero",idioma);
					break;
	    		case V50bClsConstantes.TRES:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.marzo",idioma);
					break;
	    		case V50bClsConstantes.CUATRO:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.abril",idioma);
					break;
	    		case V50bClsConstantes.CINCO:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.mayo",idioma);
					break;
	    		case V50bClsConstantes.SEIS:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.junio",idioma);
					break;
	    		case V50bClsConstantes.SIETE:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.julio",idioma);
					break;
	    		case V50bClsConstantes.OCHO:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.agosto",idioma);
					break;
	    		case V50bClsConstantes.NUEVE:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.septiembre",idioma);
					break;
	    		case V50bClsConstantes.DIEZ:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.octubre",idioma);
					break;
	    		case V50bClsConstantes.ONCE:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noviembre",idioma);
					break;
	    		case V50bClsConstantes.DOCE:
	    			nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.diciembre",idioma);
					break;
				default:
					break;
	    		}
	    	}
	    	catch (Q70GestorMensajesException e) {
				throw e;
			}	
	    	
	    	return nombreMes;
	    }
	
	/**
	 * Convierte un ArrayList de HashMaps en un ArrayList de ArrayList.
	 * 
	 * @param arrHashMaps ArrayList: el array con HashMaps.
	 * 
	 * @return Arraylist: el array actualizado.
	 * 
	 * @throws Exception the exception
	 */
	public static List fncConvierteArrayList (List arrHashMaps) throws Exception {
		
		List arrDatosTabla = new ArrayList();
		
		for (int i=0; i<arrHashMaps.size(); i++)
		{
			Map mapa = (Map) arrHashMaps.get(i);
			
			//Obtenemos claves del HashMap
			Set keys = mapa.keySet();
			//List arrClaves = V50bClsFunciones.fncNewArrayList();
			List arrClaves = (List)V50bClsFunciones.fncNewInstance("java.util.ArrayList");
			for (Iterator j = keys.iterator(); j.hasNext();) {
				arrClaves.add((String) j.next());
			}
			
			//Ordenamos las claves
			Collections.sort(arrClaves);
			
			//Obtenemos valores de las claves
			//List tmp = V50bClsFunciones.fncNewArrayList();
			List tmp = (List)V50bClsFunciones.fncNewInstance("java.util.ArrayList");
			for (int j=0; j<arrClaves.size(); j++) {
				tmp.add(mapa.get(arrClaves.get(j)));
			}
			
			arrDatosTabla.add(tmp);
		}
		return arrDatosTabla;
	}
	
	/**
	 * Convierte un ArrayList de Beans en un ArrayList de ArrayList.
	 * 
	 * @param arrBeans ArrayList: el array con Beans.
	 * @param propiedadOrdenar the propiedad ordenar
	 * 
	 * @return List: el array actualizado.
	 * 
	 * @throws Exception the exception
	 */
	public static List fncConvierteArrayListBeans(List arrBeans, String propiedadOrdenar) throws Exception {
		
		List arrDatosTabla = new ArrayList();
		
		for (int i=0; i<arrBeans.size(); i++)
		{
			final V50bGenericoBean bean = (V50bGenericoBean) arrBeans.get(i);
			
			final Method[] metodos = bean.getClass().getMethods();
						
			//final Map mapInterno = V50bClsFunciones.fncNewHashMap();
			final Map mapInterno = (Map)V50bClsFunciones.fncNewInstance("java.util.HashMap");
			
			for(int j=0;j<metodos.length;j++){
				
				final Method metodo = metodos[j];
				
				final Class paramType[] = { };
				
				if(metodo.getName().startsWith("get")){
					
					//V50bClsTrazas.depura("metodo",metodo.getName());
					
					final Object dato = metodo.invoke(bean, paramType);
					if(dato!=null){
						mapInterno.put(metodo.getName(), dato);
					}
					else{
						mapInterno.put(metodo.getName(), dato);
					}
				}
			}
			arrDatosTabla.add(mapInterno);
			
		}
		if(!GenericValidator.isBlankOrNull(propiedadOrdenar)){
			arrDatosTabla = V50bClsFunciones.fncOrdenarArrayListDeHashMaps((ArrayList)arrDatosTabla, propiedadOrdenar);
		}
		
		return V50bClsFunciones.fncConvierteArrayList(arrDatosTabla);
	}
	
	/**
	 * Fnc devuelve propiedad.
	 * 
	 * @param contexto the contexto
	 * @param propiedadesColumnasOrdenadas the propiedades columnas ordenadas
	 * 
	 * @return the string
	 * 
	 * @throws Exception the exception
	 */
	public static String fncDevuelvePropiedad(Q70ContextoEJIE contexto, String[] propiedadesColumnasOrdenadas) throws Exception{
		if(contexto.get(V50bClsConstantes.INDICE_ORDENADO_TABLA)!=null 
				&& GenericValidator.isInt((String)contexto.get(V50bClsConstantes.INDICE_ORDENADO_TABLA))
				&& propiedadesColumnasOrdenadas!=null 
				&& propiedadesColumnasOrdenadas.length>0){
			final String prop = propiedadesColumnasOrdenadas[Integer.valueOf((String)contexto.get(V50bClsConstantes.INDICE_ORDENADO_TABLA)).intValue()];
			contexto.set(V50bClsConstantes.INDICE_ORDENADO_TABLA, null);
			return "get" + prop.substring(0, 1).toUpperCase() + prop.subSequence(1, prop.length());
		} else {
			return null;
		}
	}
	
	/**
	 * Obtiene el chorro de bytes desde una ruta de un fichero para poder insertarlo en la BD p.ej.
	 * 
	 * @param rutaFichero String: ruta del fichero.
	 * 
	 * @return byte[]: chorro de bytes obtenido.
	 * 
	 * @throws Exception the exception
	 * 
	 * @author    Iaki Cantalapiedra Bernal
	 * @version 	1.0
	 * @fecha
	 */
	public static byte[] fncBytesDesdeFichero(String rutaFichero) throws Exception {
		
		File cvfile = new File(rutaFichero);
		FileInputStream cvfileinput = new FileInputStream(cvfile);    
		int fileLengthblob=(int)cvfile.length();    
		byte[] byteFichero = new byte[fileLengthblob];
//		cvfileinput.read(byteFichero, 0, fileLengthblob);
        
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		byte[] buf = new byte[1024];
		int n = 0;
		while ((n=cvfileinput.read(buf))>=0){
			baos.write(buf, 0, n);
		}
		cvfileinput.close();			
		byteFichero = baos.toByteArray();
        
        return byteFichero;
	}
	
  /**
   * Reemplaza cadenas de un string por otras.
   * 
   * @param strPfCadena String: cadena a modificar
   * @param strPfAntigua String: subcadena a eliminar
   * @param strPfNueva String: subcadena a incluir
   * @param bolReemplazarTodas boolean: reemplazar todas las ocurrencias de strPfAntigua o slo la 1
   * 
   * @return String: cadena con las sustituciones realizadas.
   * 
   * @throws Exception the exception
   */
  public static String fncReemplazarCadenas(String strPfCadena,
                                            String strPfAntigua,
                                            String strPfNueva,
                                            boolean bolReemplazarTodas) throws Exception {

    if ( (strPfCadena == null) || (strPfAntigua == null)) {
      return strPfCadena;
    }

    StringBuffer B = new StringBuffer();
    int intIterador = 0;
    int intLongitud = strPfCadena.length();
    int intTamanyo = strPfAntigua.length();
    if (intTamanyo == 0) {
      return strPfCadena;
    }

    while (intIterador < intLongitud) {
      int q = strPfCadena.indexOf(strPfAntigua, intIterador);

      // La cadena buscada no se encuentra en la original
      if (q < 0) {
        B.append(strPfCadena.substring(intIterador));
        intIterador = intLongitud;
      }
      else {
        // q es la siguiente aparicin de strPfAntigua
        B.append(strPfCadena.substring(intIterador, q));

        // Sustituimos las cadenas
        B.append(strPfNueva);
        intIterador = q + intTamanyo;
        if (!bolReemplazarTodas) { //Slo reemplazamos la primera ocurrencia
          B.append(strPfCadena.substring(intIterador));
          intIterador = intLongitud;
        }
      }

    } //Fin while

    return B.toString();
  } //Fin fncReemplazarCadenas

  /**
   * Realiza un split de javascript sobre un string a ArrayList.
   * 
   * @param cadena String: cadena a trocear
   * @param separador String: separador a utilizar
   * 
   * @return ArrayList: arraylist resultado.
   * 
   * @throws Exception the exception
   */
  public static List fncSplit(String cadena, String separador) throws
      Exception {
    String temp = cadena;
    List objArray = new ArrayList();
    while (temp.length() > 0) {
      int posicion = (temp.indexOf(separador) == -1) ? temp.length() :
          temp.indexOf(separador);
      String campo = temp.substring(0, posicion);
      if (posicion + separador.length() <= temp.length()) {
        temp = temp.substring(posicion + separador.length());
      }
      else {
        temp = temp.substring(temp.length());
      }
      objArray.add(campo);
    }
    return objArray;
  } //Fin fncSplit

  /**
   * Se crea un string con filas y celdas delimitadas por caracteres no imprimibles.
   * 
   * @param arrPfResultado ArrayList: ArrayList del que se parte
   * 
   * @return String: resultado.
   * 
   * @throws Exception the exception
   */
  public static String fncCrearStringTabla(List arrPfResultado) throws
      Exception {
    StringBuffer strResultado = new StringBuffer();
    for (int i = 0; i < arrPfResultado.size(); ++i) {
      if (i > 0) {
        strResultado.append(V50bClsConstantes.DELIMITADOR_FILA);
      }
      List arrFila = (ArrayList) arrPfResultado.get(i);
      for (int j = 0; j < arrFila.size(); ++j) {
        String dato = "";
        if (arrFila.get(j) != null) {
          dato = (String) arrFila.get(j);
        }
        if (j > 0) {
          strResultado.append(V50bClsConstantes.DELIMITADOR_CELDA);

        }
        strResultado.append(dato);
      }
    }

    return strResultado.toString();
  } //Fin fncCrearStringTabla

  
  
  /**
   * Se crea un string con campos de un arrayList separados por un delimitador.
   * 
   * @param arrPfResultado ArrayList: ArrayList del que se parte
   * @param strPfDelimitador String: String que hace las veces de delimitador
   * 
   * @return String: resultado.
   * 
   * @throws Exception the exception
   */
  public static String fncJoin(List arrPfResultado,
                               String strPfDelimitador) throws Exception {
    StringBuffer strResultado = new StringBuffer();
    for (int i = 0; i < arrPfResultado.size(); ++i) {
      if (i > 0) {
        strResultado.append(V50bClsConstantes.DELIMITADOR_COMPONENTE);
        String dato = arrPfResultado.get(i).toString();
        strResultado.append(dato);
      }
      else {
        String dato = arrPfResultado.get(i).toString();
        strResultado.append(dato);
      }
    }

    return strResultado.toString();
  } //Fin fncJoin

  /**
   * Rellena con blancos HTML un string hasta un tamao dado.
   * 
   * @param strPfCadenaInicialP String: String original
   * @param intTamanyoFinal int: Tamao hasta el que meter blancos
   * 
   * @return String: resultado.
   * 
   * @throws Exception the exception
   */
  public static String fncRellenaConBlancos(String strPfCadenaInicialP,
                                            int intTamanyoFinal) throws
      Exception {
	  
	String strPfCadenaInicial = strPfCadenaInicialP;  
	
    int intTamanyoInicial = strPfCadenaInicial.length();
    for (int i = intTamanyoInicial; i <= intTamanyoFinal; ++i) {
      strPfCadenaInicial = strPfCadenaInicial.concat("&nbsp;");
    }

    return strPfCadenaInicial;

  } //Fin fncRellenaConBlancos

  /**
   * Rellena con blancos XSL un string hasta un tamao dado.
   * 
   * @param strPfCadenaInicialP String: String original
   * @param intTamanyoFinal int: Tamao hasta el que meter blancos
   * 
   * @return String: resultado.
   * 
   * @throws Exception the exception
   */
  public static String fncRellenaConBlancosXSL(String strPfCadenaInicialP,
                                               int intTamanyoFinal) throws
      Exception {
	  
	String strPfCadenaInicial = strPfCadenaInicialP;  
	
    int intTamanyoInicial = strPfCadenaInicial.length();
    for (int i = intTamanyoInicial; i <= intTamanyoFinal; ++i) {
    	strPfCadenaInicial = strPfCadenaInicial.concat(" ");
    }

    return strPfCadenaInicial;

  } //Fin fncRellenaConBlancosXSL

  /**
   * Rellena con blancos o acorta un string hasta un tamao dado.
   * 
   * @param strPfCadenaInicialP String: String original
   * @param intTamanyoFinal int: Tamao hasta el que meter blancos
   * 
   * @return String: resultado.
   * 
   * @throws Exception the exception
   */
  public static String fncAjustaTexto(String strPfCadenaInicialP,
                                      int intTamanyoFinal) throws Exception {
	  
	String strPfCadenaInicial = strPfCadenaInicialP;
	  
    int intTamanyoInicial = strPfCadenaInicial.length();
    if (intTamanyoInicial > intTamanyoFinal) {
      strPfCadenaInicial = strPfCadenaInicial.substring(0, intTamanyoFinal);
    }
    else {
      for (int i = intTamanyoInicial; i <= intTamanyoFinal; ++i) {
    	  strPfCadenaInicial = strPfCadenaInicial.concat(" ");
      }
    }

    return strPfCadenaInicial;

  } //Fin fncRellenaConBlancosXSL

  /**
   * Se comprueba si la transaccin est lanzada o no.
   * 
   * @param utPfTransaccion UserTransaction: Transaccin a comprobar.
   * 
   * @return boolean: true si hay transaccin lanzada o false si no.
   * 
   * @throws Exception the exception
   */

  public static boolean fncHayTransaccion(UserTransaction utPfTransaccion) throws
      Exception {
	
	/* PMD
    if (utPfTransaccion.getStatus() == Status.STATUS_NO_TRANSACTION 
    		|| utPfTransaccion.getStatus() == Status.STATUS_UNKNOWN) {
      return false;
    } else {
      return true;
    }
    */
	  
    return !(utPfTransaccion.getStatus() == Status.STATUS_NO_TRANSACTION 
    		|| utPfTransaccion.getStatus() == Status.STATUS_UNKNOWN);
    
  } //Fin fncHayTransaccion

  /**
   * Realiza el setContextType del fichero segun la extension del fichero.
   * 
   * @param strPfExtension String: extensin del fichero.
   * 
   * @return the string
   * 
   * @throws Exception the exception
   */
     public static String fncContextTypeFichero(String strPfExtension) throws Exception
     {
       String strResultado = "";
       String strExtension = strPfExtension.toLowerCase();
      
       Map map = new HashMap();
       
       map = V50bClsFunciones.fncRellenaTipos1(map);
       map = V50bClsFunciones.fncRellenaTipos2(map);
       
       strResultado = (String)map.get(strExtension);
       if (null==strResultado){
    	   strResultado="application/octet-stream";
       }
       V50bClsTrazas.depura("************ Extension FICHERO ************",strExtension);
       V50bClsTrazas.depura("************ Tipo FICHERO ************",strResultado);
       return strResultado;
     }//Fin fncContextTypeFichero
     
     
     /**
      * Fnc rellena tipos1.
      * 
      * @param map the map
      * 
      * @return the map
      * 
      * @throws Exception the exception
      */
     private static Map fncRellenaTipos1(Map map) throws Exception{
    	 
         map.put("dwg", "application/acad");
         map.put("arj", "application/arj");
         map.put("asd", "application/astound");
         map.put("asn", "application/astound");
         map.put("ccad", "application/clariscad");
         map.put("drw", "application/drafting");
         map.put("dxf", "application/dxf");
         map.put("unv", "application/i-deas");
         map.put("iges", "application/iges");
         map.put("igs", "application/iges");
         map.put("jar", "application/java-archive");
         map.put("hqx", "application/mac-binhex40");
         map.put("mdb", "application/msaccess");
         map.put("xla", "application/msexcel");
         map.put("xls", "application/vnd.ms-excel");
         map.put("xlt", "application/msexcel");
         map.put("xlw", "application/msexcel");
         map.put("pot", "application/mspowerpoint");
         map.put("pps", "application/mspowerpoint");
         map.put("ppt", "application/mspowerpoint");
         map.put("mpp", "application/msproject");
         map.put("doc", "application/msword");
         map.put("word", "application/msword");
         map.put("w6w", "application/msword");
         map.put("wri", "application/mswrite");
         map.put("bin", "application/octet-stream");
         map.put("oda", "application/oda");
         map.put("pdf", "application/pdf");
         map.put("ai", "application/postscript");
         map.put("eps", "application/postscript");
         map.put("ps", "application/postscript");
         map.put("part", "application/pro_eng");
         map.put("prt", "application/pro_eng");
         map.put("rtf", "application/rtf");
         map.put("set", "application/set");
         map.put("stl", "application/sla");
         map.put("sol", "application/solids");
         map.put("st", "application/STEP");
         map.put("step", "application/STEP");
         map.put("stp", "application/STEP");
         map.put("vda", "application/vda");
         map.put("bcpio", "application/x-bcpio");
         map.put("cpio", "application/x-cpio");
         map.put("csh", "application/x-csh");
         map.put("dcr", "application/x-director");
         map.put("dir", "application/x-director");
         map.put("dxr", "application/x-director");
         map.put("dvi", "application/x-dvi");
         map.put("dwf", "application/x-dwf");
         map.put("gtar", "application/x-gtar");
         map.put("gz", "application/x-gzip");
         map.put("gzip", "application/x-gzip");
    	 
    	 return map;
     }
     
     /**
      * Fnc rellena tipos2.
      * 
      * @param map the map
      * 
      * @return the map
      * 
      * @throws Exception the exception
      */
     private static Map fncRellenaTipos2(Map map) throws Exception{
    	 
	    map.put("hdf", "application/x-hdf");
	    map.put("js", "application/x-javascript");
	    map.put("latex", "application/x-latex");
	    map.put("mif", "application/x-mif");
	    map.put("cdf", "application/x-netcdf");
	    map.put("nc", "application/x-netcdf");
	    map.put("sh", "application/x-sh");
	    map.put("shar", "application/x-shar");
	    map.put("swf", "application/x-shockwave-flash");
	    map.put("sit", "application/x-stuffit");
	    map.put("sv4cpio", "application/x-sv4cpio");
	    map.put("sv4crc", "application/x-sv4crc");
	    map.put("tar", "application/x-tar");
	    map.put("tcl", "application/x-tcl");
	    map.put("tex", "application/x-tex");
	    map.put("texi", "application/x-texinfo");
	    map.put("texinfo", "application/x-texinfo");
	    map.put("roff", "application/x-troff");
	    map.put("t", "application/x-troff");
	    map.put("tr", "application/x-troff");
	    map.put("man", "application/x-troff-man");
	    map.put("me", "application/x-troff-me");
	    map.put("ms", "application/x-troff-ms");
	    map.put("ustar", "application/x-ustar");
	    map.put("src", "application/x-wais-source");
	    map.put("hlp", "application/x-winhelp");
	    map.put("zip", "application/zip");
	    map.put("au", "audio/basic");
	    map.put("snd", "audio/basic");
	    map.put("mid", "audio/midi");
	    map.put("midi", "audio/midi");
	    map.put("aif", "audio/x-aiff");
	    map.put("aifc", "audio/x-aiff");
	    map.put("aiff", "audio/x-aiff");
	    map.put("mp3", "audio/x-mpeg");
	    map.put("ra", "audio/x-pn-realaudio");
	    map.put("ram", "audio/x-pn-realaudio");
	    map.put("rpm", "audio/x-pn-realaudio-plugin");
	    map.put("voc", "audio/x-voice");
	    map.put("wav", "application/x-wav");
	    map.put("bmp", "image/bmp");
	    map.put("gif", "image/gif");
	    map.put("ief", "image/ief");
	    map.put("jpe", "image/jpeg");
	    map.put("jpeg", "image/jpeg");
	    map.put("jpg", "image/jpeg");
	    map.put("pict", "image/pict");
	    map.put("png", "image/png");
	    map.put("tif", "image/tiff");
	    map.put("tiff", "image/tiff");
	    map.put("ras", "image/x-cmu-raster");
	    map.put("pnm", "image/x-portable-anymap");
	    map.put("pbm", "image/x-portable-bitmap");
	    map.put("pgm", "image/x-portable-graymap");
	    map.put("ppm", "image/x-portable-pixmap");
	    map.put("xbm", "image/x-xbitmap");
	    map.put("xpm", "image/x-xpixmap");
	    map.put("xwd", "image/x-xwindowdump");
	    map.put("gzip", "multipart/x-gzip");
	    map.put("htm", "text/html");
	    map.put("html", "text/html");
	    map.put("C", "text/plain");
	    map.put("cc", "text/plain");
	    map.put("h", "text/plain");
	    map.put("rtx", "text/richtext");
	    map.put("tsv", "text/tab-separated-values");
	    map.put("etx", "text/x-setext");
	    map.put("sgm", "text/x-sgml");
	    map.put("sgml", "text/x-sgml");
	    map.put("mpe", "video/mpeg");
	    map.put("mpeg", "video/mpeg");
	    map.put("mpg", "video/mpeg");
	    map.put("avi", "video/msvideo");
	    map.put("mov", "video/quicktime");
	    map.put("qt", "video/quicktime");
	    map.put("vdo", "video/vdo");
	    map.put("viv", "video/vivo");
	    map.put("vivo", "video/vivo");
	    map.put("movie", "video/x-sgi-movie");
	    map.put("ice", "x-conference/x-cooltalk");
	    map.put("svr", "x-world/x-svr");
	    map.put("wrl", "x-world/x-vrml");
	    map.put("vrt", "x-world/x-vrt");
	    map.put("txt", "text/plain");
	    map.put("", "");
	
    	return map;
     }
     
     
     /**
      * Convierte un numero dado a la precision de numero de decimales puesto como parametro.
      * 
      * @param decimal double: double original
      * @param decimales int: Cantidad de decimales que tiene que devolver el original
      * 
      * @return float: resultado.
      * 
      * @throws Exception the exception
      */
     
 	public static double cambioPrecision(double decimal,int decimales)throws Exception
	{
		double d=Math.pow(V50bClsConstantes.DIEZ_CERO,(double) decimales);
		double aux=Math.round(decimal*d);
		int auxi=(int) aux;
		return auxi/d;
	}
 	
 	/**
	  * Devuelve un 1 o un 0 si la posicion especificada en el decimal es mayor de 4 o menor.
	  * 
	  * @param numero double: double original
	  * @param decimal int: Cantidad de decimales que tiene que devolver el original
	  * 
	  * @return int: resultado.
	  * 
	  * @throws Exception the exception
	  */
 	
 	public static int posicionDecimal(double numero,int decimal)throws Exception
	{
		String aux = new String(String.valueOf(numero));
		try{
			char numeroAux=aux.charAt(aux.indexOf(".")+decimal);		
			int comparar=Integer.parseInt(String.valueOf(numeroAux));		
			if(comparar<V50bClsConstantes.CINCO) {
				return 0;
			} else {
				return 1;
			}
			}
		catch (Exception e) {
			return 0;
		}
	}
 	
 	/**
	  * Devuelve un StringBuffer que contiene el XML para imprimir un Documento de Word.
	  * 
	  * @param arrDatos the arr datos
	  * 
	  * @return StringBuffer: el xml.
	  * 
	  * @throws Exception the exception
	  */
 	
 	public static StringBuffer generarXML(List arrDatos)throws Exception
	{
 		StringBuffer v50bstrXml= new StringBuffer(V50bClsConstantes.TREINTA);
 		v50bstrXml.append("<inicio>");
		
		for (int i=0;i<arrDatos.size();i++) {
			if(arrDatos.size()>0)
			{
				v50bstrXml.append("<persona>");
				
				HashMap hm = (HashMap) arrDatos.get(i);
				
				Set keys = hm.keySet();
				//ArrayList arrClaves = V50bClsFunciones.fncNewArrayList();
				ArrayList arrClaves = (ArrayList)V50bClsFunciones.fncNewInstance("java.util.ArrayList");
				for (Iterator j = keys.iterator(); j.hasNext();) {
					arrClaves.add((String) j.next());
				}

				String clave = "";	
				//ArrayList lista = V50bClsFunciones.fncNewArrayList();
				ArrayList lista = (ArrayList)V50bClsFunciones.fncNewInstance("java.util.ArrayList");
				//ArrayList subLista = V50bClsFunciones.fncNewArrayList();
				ArrayList subLista = (ArrayList)V50bClsFunciones.fncNewInstance("java.util.ArrayList");
				//HashMap hmTemp = V50bClsFunciones.fncNewHashMap();
				HashMap hmTemp = (HashMap)V50bClsFunciones.fncNewInstance("java.util.HashMap");
				//HashMap hmTemp2 = V50bClsFunciones.fncNewHashMap();
				HashMap hmTemp2 = (HashMap)V50bClsFunciones.fncNewInstance("java.util.HashMap");
				String nodo="";
				String nodo2="";
				String nodoPpal="";
				String nodoPpal2="";
				
				for (int j=0;j<arrClaves.size();j++){
					clave = arrClaves.get(j).toString();
					//Vemos si el nodo sgte es una Lista
					if (clave.indexOf("LISTA")==-1){
						//Si no es una lista se trata como un campo normal con la calve que viene del hashmap
						v50bstrXml.append("<propiedad><clave>"+arrClaves.get(j).toString()+"</clave><valor>"+hm.get(arrClaves.get(j).toString())+"</valor></propiedad>");
					}else{
						//Tratamiento de lista
						lista = (ArrayList)hm.get(arrClaves.get(j));
							for (int k = 0;k<lista.size();k++){
								hmTemp = (HashMap) lista.get(k);
								Set keysTemp = hmTemp.keySet();
								//ArrayList arrClavesTemp = V50bClsFunciones.fncNewArrayList();
								ArrayList arrClavesTemp = (ArrayList)V50bClsFunciones.fncNewInstance("java.util.ArrayList");
								//Se recupera todo el conjunto de claves
								for (Iterator ite = keysTemp.iterator(); ite.hasNext();) {
									arrClavesTemp.add((String) ite.next());
								}
								//Si es el primer elemento aadimos al XML <LISTAx>
								if (k==0){								
									int num = arrClavesTemp.get(0).toString().indexOf("_");
									nodoPpal= arrClavesTemp.get(0).toString().substring(0,num);
									v50bstrXml.append("<"+nodoPpal+">");
								}
								v50bstrXml.append("<fila>");
								//Pasamos por todas las claves de la lista
								for (int l=0;l<arrClavesTemp.size();l++){	
									nodo = arrClavesTemp.get(l).toString();
									nodo = nodo.replaceAll(nodoPpal+"_", "");
									if (nodo.indexOf("SUBLISTA")==-1){
										v50bstrXml.append("<"+nodo+">"+hmTemp.get(arrClavesTemp.get(l).toString())+"</"+nodo+">");
									}else{
										subLista = (ArrayList)hmTemp.get(arrClavesTemp.get(l));
										for (int m = 0;m<subLista.size();m++){
											hmTemp2 = (HashMap) subLista.get(m);
											Set keysTemp2 = hmTemp2.keySet();
											//ArrayList arrClavesTemp2 = V50bClsFunciones.fncNewArrayList();
											ArrayList arrClavesTemp2 = (ArrayList)V50bClsFunciones.fncNewInstance("java.util.ArrayList");
											for (Iterator ite2 = keysTemp2.iterator(); ite2.hasNext();) {
												arrClavesTemp2.add((String) ite2.next());
											}
											if (m==0){								
												int num2 = arrClavesTemp2.get(0).toString().indexOf("_");
												nodoPpal2= arrClavesTemp2.get(0).toString().substring(0,num2);
												v50bstrXml.append("<"+nodoPpal2+">");
											}
											for (int n=0;n<arrClavesTemp2.size();n++){	
												nodo2 = arrClavesTemp2.get(n).toString();
												nodo2 = nodo2.replaceAll(nodoPpal2+"_", "");
												v50bstrXml.append("<"+nodo2+">"+hmTemp2.get(arrClavesTemp2.get(n).toString())+"</"+nodo2+">");
											}
										}
										v50bstrXml.append("</"+nodoPpal2+">");
									}
								}
								v50bstrXml.append("</fila>");
							}
						
							v50bstrXml.append("</"+nodoPpal+">");					
					}
				}
				
				v50bstrXml.append("</persona>");
			}
		}
		
		
		v50bstrXml.append("</inicio>");
		
		V50bClsTrazas.depura("",v50bstrXml);
		
		return v50bstrXml;
	}
 	
 	/**
	  * Salva los parametros de busqueda en un hashmap.
	  * 
	  * @param contexto Q70ContextoEJIE contexto de la aplicacion
	  * 
	  * @throws Exception the exception
	  */
 	
 	public static void salvarParBusqueda(Q70ContextoEJIE contexto)throws Exception
	{
 		HashMap salvado=new HashMap();
		DynaProperty props[]=contexto.getDynaClass().getDynaProperties();
		
		for(int i=0;i<props.length;i++)
		{
			if (props[i].getName().endsWith(V50bClsConstantes.SUFIJO_BUSQUEDA))
			{
				salvado.put(props[i].getName(),contexto.get(props[i].getName()));
			}
		}
		contexto.set(V50bClsConstantes.HASHMAP_PARAMETROS,salvado);
	}
 	
 	/**
	  * Restaura los parametros de busqueda desde un hashmap.
	  * 
	  * @param contexto Q70ContextoEJIE contexto de la aplicacion
	  * 
	  * @throws Exception the exception
	  */
 	
 	public static void setParBusqueda(Q70ContextoEJIE contexto)throws Exception
	{
 		HashMap salvado=(HashMap) contexto.get(V50bClsConstantes.HASHMAP_PARAMETROS);
		DynaProperty props[]=contexto.getDynaClass().getDynaProperties();
		
		for(int i=0;i<props.length;i++)
		{
			if (salvado.containsKey(props[i].getName()))
			{
				contexto.set(props[i].getName(),salvado.get(props[i].getName()));
			}
		}
	}
 	
 	/**
	  *
	  * <p><b>Descripcin: </b>Rellena el Idioma, 'subOpFlag' y el usuario a los Beans recorriendo el contexto de la OP.</p>
	  * 
	  * @param contexto the contexto
	  * 
	  * @throws Exception the exception
	  * 
	  * @author Iaki Cantalapiedra Bernal
	  * @version 1.0
	  */
 	public static void fncRellenarGenericoBean(Q70ContextoEJIE contexto) throws Exception{
 		
 		final DynaProperty[] prop = contexto.getDynaClass().getDynaProperties();
 		final V50bUsuarioBean usuarioXlnets = (V50bUsuarioBean)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_USUARIO_BEAN);
 		
 		//Miramos si la OP tiene subOpFlag o no.
 		boolean existeSubOpFlag = false;
 		for(int s=0;s<prop.length;s++){
			if("subOpFlag".equals(prop[s].getName())){
				existeSubOpFlag = true;
				break;
			}
		}
 		
 		//Introducidos el Idioma, y el subOpFlag si procede.
		for(int i=0;i<prop.length;i++){
			final Object obj = contexto.get(prop[i].getName());
			if(obj instanceof V50bGenericoBean){
				final V50bGenericoBean gen = (V50bGenericoBean) obj;
				gen.setIdioma((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
				if(existeSubOpFlag){
					gen.setSubOpFlag((String)contexto.get("subOpFlag"));
				}
				gen.setUsuarioXlnets(usuarioXlnets);
				contexto.set(prop[i].getName(), gen);
			}
		}

 	}
 	
 	/**
	  * Rellena el subOpFlag a los Beans cuando este no sigue la norma establecida.
	  * 
	  * @param contexto the contexto
	  * @param nombreBean the nombre bean
	  * @param nombreSubOpFlag the nombre sub op flag
	  * 
	  * @throws Exception the exception
	  * 
	  * @author Iaki Cantalapiedra Bernal
	  * @version 1.0
	  */
 	public static void fncRellenarSubOpFlagAnormal(Q70ContextoEJIE contexto, String nombreBean, String nombreSubOpFlag) throws Exception{
 		
 		if(contexto.get(nombreBean)!=null){
		 	V50bGenericoBean bean = (V50bGenericoBean)contexto.get(nombreBean);
		 	bean.setSubOpFlag((String)contexto.get(nombreSubOpFlag));
		 	contexto.set(nombreBean, bean);
 		}
 		 
 	}
 	
 	/**
	  * Devuelve la mascara para el TO_DATE o TO_CHAR adecuada segn el idioma.
	  * 
	  * @param idioma the idioma
	  * 
	  * @return the string
	  * 
	  * @throws Q70GestorMensajesException the q70 gestor mensajes exception
	  * 
	  * @author Iaki Cantalapiedra Bernal
	  * @version 1.0
	  */
 	public static String fncMascaraToCharToDate(String idioma) throws Q70GestorMensajesException{

	 	if(idioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)){
	 		return V50bClsConstantes.FORMATO_FECHA_CASTELLANO;
	 	}
	 	else{
	 		return V50bClsConstantes.FORMATO_FECHA_EUSKARA;
	 	}
 	}
 	
 	/**
	  * Rellena CP con ceros a la izquierda hasta q tenga tamanyo de 5 digitos.
	  * 
	  * @param strPfCadenaInicialP String String original
	  * 
	  * @return String: resultado.
	  * 
	  * @throws Exception the exception
	  */
 	  public static String fncFormateaCP(String strPfCadenaInicialP) throws Exception {
 		  
 		StringBuffer strPfCadenaInicial = new StringBuffer(strPfCadenaInicialP);
 		  
 	    int intTamanyo = strPfCadenaInicial.length();
 	    
 	    if (!"".equals(strPfCadenaInicial.toString()) && intTamanyo<V50bClsConstantes.CINCO){
 	    	int intResto=V50bClsConstantes.CINCO-intTamanyo;
 	    	for(int i=0;i<intResto;i++){
 	    		//strPfCadenaInicial="0"+strPfCadenaInicial;
 	    		strPfCadenaInicial.insert(0, "0");
 	    	}
 	    }
 	    
 	    return strPfCadenaInicial.toString();

 	  } //Fin fncFormateaCP
     
 	  
 	  /**
  	  * Fnc rellena bytes desde blob.
  	  * 
  	  * @param blob the blob
  	  * 
  	  * @return the byte[]
  	  * 
  	  * @throws SQLException the SQL exception
  	  */
 	 public static byte[] fncRellenaBytesDesdeBlob(Blob blob) throws SQLException {
 		 if(blob!=null){
 			try{
 				byte[] fichero = new byte[(int)blob.length()];
// 				final byte[] fichero = new byte[(int)blob.length()];
// 				final InputStream input = blob.getBinaryStream();
// 				input.read(fichero);
// 				input.close(); 				

 				/**/
 				ByteArrayOutputStream baos = new ByteArrayOutputStream();
 				byte[] buf = new byte[1024];
 				InputStream in = blob.getBinaryStream();
 				int n = 0;
 				while ((n=in.read(buf))>=0){
 					baos.write(buf, 0, n);
 				}
 				in.close();			
 				fichero = baos.toByteArray();
 				/**/			
 				
 				return fichero; 				
 			}catch(IOException e){
 				throw new SQLException(e.getMessage());
 			}
 		} else{
 			 return null;
 		 }
 	  }
 	  
 	 /**
 	  * Parsea el los n de cuenta de 4 digitos, 2 y 10 digitos
 	  * Iigo Rodriguez.
 	  * 
 	  * @param numCuenta the num cuenta
 	  * @param digito the digito
 	  * 
 	  * @return String: resultado.
 	  * 
 	  */
 	 public static String fncParseaNumCuenta(String numCuenta,int digito) {
 		int valorNumCuenta = numCuenta.length();
 		StringBuffer resultado = new StringBuffer();
 		
 		if (valorNumCuenta > 0){
 			int bucle = digito - valorNumCuenta;
 			
 			for(int i=0; i<bucle; i++){
 				resultado.append("0");
 			}	
 			resultado.append(numCuenta);
 		}
 		
 		return resultado.toString();

 	}
 	 
 	/**
	  * Fnc validar ccc.
	  * 
	  * @param strNumeroTotal the str numero total
	  * 
	  * @return true, if successful
	  */
	 public static boolean fncValidarCCC(String strNumeroTotal){
		  
		  if (strNumeroTotal.length()==0) {
			return true;
		}
	    	if (strNumeroTotal.length()!=V50bClsConstantes.VEINTE)
	    	{       		
	    		return false;
	    	}
	    	//todos los campos tienen que ser numericos
	    	if(!V50bClsFunciones.fncValidarNumeros(strNumeroTotal))
	    	{
	    		return false;
	    	}
	    	//b banco, s sucursal, d digito de control, n numero de cuenta    	
	    	//el numero de 20 digitos se descompone en (bbbbssssddnnnnnnnnnn)    	
			String strNumDC=strNumeroTotal.substring(V50bClsConstantes.OCHO,V50bClsConstantes.DIEZ);
			String strNumCuenta=strNumeroTotal.substring(V50bClsConstantes.DIEZ,V50bClsConstantes.VEINTE);
			String strNumBanco=strNumeroTotal.substring(0,V50bClsConstantes.CUATRO);
			String strNumOficina=strNumeroTotal.substring(V50bClsConstantes.CUATRO,V50bClsConstantes.OCHO);
			
			//el numero pasado a la funcion ObtenerDigitoControl tiene que tener 10 cifras
			String strPrimeroCuenta=String.valueOf(V50bClsFunciones.fncObtenerDigitoControl("00" + strNumBanco + strNumOficina));
			String strSegundoCuenta=String.valueOf(V50bClsFunciones.fncObtenerDigitoControl(strNumCuenta));
					
			String strPrimeroDigito=String.valueOf(strNumDC.toString().charAt(0));
			String strSengundoDigito=String.valueOf(strNumDC.toString().charAt(1));

			//el primer digito se corresponde al numero que devuelva banco y sucursal
			//el segundo digito se corresponde al numero que devuelva el numero de cuenta
			
			/* PMD
			if(strPrimeroCuenta.equals(strPrimeroDigito) && strSegundoCuenta.equals(strSengundoDigito))
			{
				return true;			
			}
			else
			{
				return false;
			}
			*/
			return (strPrimeroCuenta.equals(strPrimeroDigito) && strSegundoCuenta.equals(strSengundoDigito));
	  }
 	
 	  /**
  	  * Valida que todos los caracteres de un string sean numeros.
  	  * 
  	  * @param s *            String: valor del String
  	  * 
  	  * @return boolean: true si son todos, false algn carcter no es nmero
  	  */
    private static boolean fncValidarNumeros(String s)
    {
    	for (int i=0;i<s.length();i++)
    	{
    		if ( !Character.isDigit(s.charAt(i)) )
    		{
    			return false;
    		}
    	}
    	return true;
    }
 	
 	 /**
 	  * Devuelve el digito de control al numero pasado.
 	  * 
 	  * @param valor String que tiene una cadena de 10 digitos
 	  * 
 	  * @return int: digito asociado a ese numero
 	  */
     private static int  fncObtenerDigitoControl(String valor)
 	{	
     	//valores que tiene que tener al coger la posicion
     	String valores[]= new String[] {"1","2","4","8","5","10","9","7","3","6"};		
 		//logica de calculo del digito de control
 		int intControl = 0;	
 		for (int i=0; i<=V50bClsConstantes.NUEVE; i++)
 		{			
 			intControl +=Integer.parseInt(String.valueOf(valor.charAt(i)))
 	    	* Integer.parseInt(String.valueOf(valores[i]));
 		}
 		intControl = V50bClsConstantes.ONCE - (intControl % V50bClsConstantes.ONCE);
 		
 		if (intControl == V50bClsConstantes.ONCE) {
			intControl = 0;
		} else if (intControl == V50bClsConstantes.DIEZ) {
			intControl = 1;
		}
 	  	//solamente retorno el valor, no la posicion
 		return intControl;
 	}
	  
     /**
      * Fnc validar iban.
      * 
      * @param strP the str p
      * 
      * @return true, if successful
      * 
      * @throws Exception the exception
      */
     public static boolean fncValidarIBAN(String strP) throws Exception
     {
    	String str = strP;
    	 
    	if(GenericValidator.isBlankOrNull(str)) {
			return true;
		}
    	
    	str = str.substring(V50bClsConstantes.CUATRO, str.length()) + str.substring(0, V50bClsConstantes.CUATRO);
    	
    	str = str.replaceAll("A", "10");
    	str = str.replaceAll("B", "11");
    	str = str.replaceAll("C", "12");
    	str = str.replaceAll("D", "13");
    	str = str.replaceAll("E", "14");
    	str = str.replaceAll("F", "15");
    	str = str.replaceAll("G", "16");
    	str = str.replaceAll("H", "17");
    	str = str.replaceAll("I", "18");
    	str = str.replaceAll("J", "19");
    	str = str.replaceAll("K", "20");
    	str = str.replaceAll("L", "21");
    	str = str.replaceAll("M", "22");
    	str = str.replaceAll("N", "23");
    	str = str.replaceAll("O", "24");
    	str = str.replaceAll("P", "25");
    	str = str.replaceAll("Q", "26");
    	str = str.replaceAll("R", "27");
    	str = str.replaceAll("S", "28");
    	str = str.replaceAll("T", "29");
    	str = str.replaceAll("U", "30");
    	str = str.replaceAll("V", "31");
    	str = str.replaceAll("W", "32");
    	str = str.replaceAll("X", "33");
    	str = str.replaceAll("Y", "34");
    	str = str.replaceAll("Z", "35");
    	 
    	final BigInteger iban = new BigInteger(str);    
    	/* PMD
    	if(iban.mod(new BigInteger("97")).intValue()==1){
    		return true;
    	} else {
    		return false;
    	}
    	*/
    	
    	return (iban.mod(new BigInteger("97")).intValue()==1);
    	
     }
     
     /**
      * Fnc validar importe decimales.
      * 
      * @param strPfImporteP the str pf importe p
      * 
      * @return true, if successful
      */
     public static boolean fncValidarImporteDecimales(String strPfImporteP){
    	 
    	 String strPfImporte = strPfImporteP;
    	 
    	 if (strPfImporte != null && !strPfImporte.equals("")){
    		 strPfImporte=strPfImporte.replaceAll("\\.","");
    		 strPfImporte=strPfImporte.replaceAll(",","\\.");
	    		Pattern pat=Pattern.compile("^[0-9]{1,10}(\\.[0-9]{1,2})?$");
		    	return pat.matcher(strPfImporte).find(); // true;
	    	} else {
			return true;
		}
     }
     
     /**
      * Fnc generar msg error pagos.
      * 
      * @param listPfErrorres the list pf errorres
      * 
      * @return the string
      */
     public static String fncGenerarMsgErrorPagos(List listPfErrorres){
    	 
		StringBuffer sbError=new StringBuffer();
		for(int i=0;i<listPfErrorres.size();i++){
			sbError.append("<li>");
			sbError.append(listPfErrorres.get(i));
			sbError.append("</li>");
		}
		return sbError.toString();
     }
     
     /**
      * Fnc formatear importe gen pago.
      * 
      * @param strPfImporteP the str pf importe p
      * 
      * @return the string
      * 
      * @throws Exception the exception
      */
     public static String fncFormatearImporteGenPago(String strPfImporteP)throws Exception{
    	
    	String strPfImporte = strPfImporteP;
    	 
    	List arrImporte=V50bClsFunciones.fncSplit(strPfImporte, ".");
 		if(arrImporte!=null && arrImporte.size()>1){
 			if(arrImporte.get(1).toString().length()==1){
 				arrImporte.set(1,arrImporte.get(1).toString()+"0");
 			}
 			strPfImporte=arrImporte.get(0)+"."+arrImporte.get(1);
 		}
 		return strPfImporte;
     }
     
     /**
      * Fnc validar irpf decimales.
      * 
      * @param strIRPFP the str irpfp
      * 
      * @return true, if successful
      */
     public static boolean fncValidarIRPFDecimales(String strIRPFP){
    	 
    	 String strIRPF = strIRPFP;
    	 
    	 if (strIRPF != null && !strIRPF.equals("")){
    		 strIRPF=strIRPF.replaceAll("\\.","");
    		 strIRPF=strIRPF.replaceAll(",","\\.");
	    		Pattern pat=Pattern.compile("^[0-9]{1,3}(\\.[0-9]{1,2})?$");
		    	return pat.matcher(strIRPF).find(); // true;
	    	}
	    	else{
	    		return true;
	    	}
     }
     
     /**
      * Crea una nueva instancia pasandole el nombre completo del objeto por parameto.
      * 
      * @param name String 
      * 
      * @return Object El objeto creado
      * 
      * @throws Exception Se eleva la excepcin
      * 
      */
     public static Object fncNewInstance(String name) throws Exception {
    	 return Class.forName(name).newInstance();
	    	
     }
     
     /**
      * Rellena con 0s por la izquierda un string hasta un tamao dado.
      *
      * @param strPfCadenaInicial String: String original
      * @param intTamanyoFinal int: Tamao hasta el que meter blancos
      * @return String: resultado.
      */
     public static String fncRellenaConCeros(String strPfCadenaInicial,
   		  int intTamanyoFinal){
   	  StringBuffer tratamiento = new StringBuffer();
   	  tratamiento.append(strPfCadenaInicial);
   	  int intTamanyoInicial = tratamiento.length();
   	  String temp ="";
   	  for (int i = intTamanyoInicial; i < intTamanyoFinal; ++i) {
   		  // tratamiento = "0"+tratamiento;
   		  temp = tratamiento.toString();
   		  tratamiento.delete(0,tratamiento.length());
   		  tratamiento.append("0").append(temp);
   	  }
   	  
   	  return tratamiento.toString();
   	  
     } //Fin fncRellenaConBlancos
     
     
     /**
	   * Calcula la fecha juliana valida para la aplicacion K81
	   *
	   ** @author    Iaki Cantalapiedra Bernal
	   *  @version 	1.0
	   *  @fecha	  
	   *  @param dia a
	   *  @param mes a
	   *  @param anno a
	   *  @return String
	   *  @throws Exception
	   */
	public static String fncCalculaFechaJulianaK81(int dia, int mes, int anno) 
	{
		int JGREG= V50bClsConstantes.QUINCE + V50bClsConstantes.TREINTAYUNO*
				(V50bClsConstantes.DIEZ+V50bClsConstantes.DOCE*V50bClsConstantes.MIL_QUIENIENTOS_OCHENTAYDOS);
		
		int julianYear = anno;
		if (anno < 0){
			julianYear++;
		}
		int julianMonth = mes;
		if (mes > 2) {
			julianMonth++;
		}
		else {
			julianYear--;
			julianMonth += V50bClsConstantes.TRECE;
		}

		double julian = (java.lang.Math.floor(V50bClsConstantes.TREINTAYSEISMIL_QUINIENTOS_VEINTICINCO * julianYear)+ java.lang.Math.floor(V50bClsConstantes.TRESCIENTOSSEISMIL_UNO*julianMonth) + dia + V50bClsConstantes.DIECISIETE_MILLONES_DOCCIENTOSNUEVEMIL_NOVECIENTOSCINCUENTA);

		if (dia + V50bClsConstantes.TREINTAYUNO * (mes + V50bClsConstantes.DOCE * anno) >= JGREG) {		       
			int ja = (int)(V50bClsConstantes.CERO_CERO_UNO* julianYear);
			julian += 2 - ja + (V50bClsConstantes.CERO_VEINTICINCO * ja);
		}
		double julianD = java.lang.Math.floor(julian);
		Double JD = new Double(julianD);
		JD.intValue();
		return String.valueOf(JD.intValue()-V50bClsConstantes.SESGO_JULIANO);

	}
	
	/**
  	 * Genera una clave de acceso.
  	 * 
  	 * @param intPfNumCaracteres Nmero de caracteres de la clave
  	 * 
  	 * @return Un String con la clave de acceso
  	 * 
  	 * @throws NoSuchAlgorithmException Si no se ha podido generar
  	 */
	  public static String fncGenerarClave(int intPfNumCaracteres) throws NoSuchAlgorithmException {
	  	String strAlgoritmo = "SHA1PRNG";
	  	String strCaracteresClave="0123456789";
	    StringBuffer sbClave = new StringBuffer();
	    SecureRandom random = SecureRandom.getInstance(strAlgoritmo);

	    for (int i = 0; i < intPfNumCaracteres; i++) {
	      sbClave.append(strCaracteresClave.charAt(random.nextInt(strCaracteresClave.length())));
	    }

	    return sbClave.toString();
	  }
	  
	/**
	 * Rellena el Idioma y el 'subOpFlag' a los Beans del recorriendo el contexto de la OP.
	 * 
	 * @param contexto the contexto
	 * 
	 * @throws Exception the exception
	 * 
	 * @author brey
	 * @version 1.0
	 */
	 public static void fncRellenarIdiomaYSubOpFlag(Q70ContextoEJIE contexto) throws Exception{
	 		
		 final DynaProperty[] prop = contexto.getDynaClass().getDynaProperties();
	 		
	     //Miramos si la OP tiene subOpFlag o no.
	 	 boolean existeSubOpFlag = false;
	 	 	for(int s=0;s<prop.length;s++){
				if("subOpFlag".equals(prop[s].getName())){
					existeSubOpFlag = true;
					break;
				}
			}
	 		
	 	 //Introducidos el Idioma, y el subOpFlag si procede.
		 for(int i=0;i<prop.length;i++){
			final Object obj = contexto.get(prop[i].getName());
				if(obj instanceof V50bGenericoBean){
					final V50bGenericoBean gen = (V50bGenericoBean) obj;
					gen.setIdioma((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
					if(existeSubOpFlag){
						gen.setSubOpFlag((String)contexto.get("subOpFlag"));
					}
					contexto.set(prop[i].getName(), gen);
				}
			}

	 	 }
    
	/**
	 * 
	 * <p>Ttulo: fncTextoClob</p>
	 * <p>Descripcin: Obtiene el texto de un clob</p>
	 * <p>Copyright: Copyright (c) Jan 23, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param clob El CLOB
	 * @return String con el texto del clob
	 * @throws Exception Cualquier excepcin
	 */ 
	public static String fncTextoClob(Clob clob) throws Exception {
		StringBuffer strOut = new StringBuffer();
		String buff;
		// Accedemos al stream, en este punto no usar CLOB.length() con un for xq es ms lento...
		BufferedReader br = new BufferedReader(clob.getCharacterStream());
		try{  
		  while ((buff=br.readLine())!= null) {
		         strOut.append(buff);
		  }
		} catch (Exception e) {
			strOut.append("");
		}
		return strOut.toString();
	 }
	
	
	/**
	 * 
	 * <p>Ttulo: fncConversionInformeCalendarioAnual</p>
	 * <p>Descripcin: Funcin de J81 para sacar la lista para imprimir un calendario</p>
	 * <p>Copyright: Copyright (c) Feb 16, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param festivos Mapa con los festivos
	 * @param th Territorio histrico actual
	 * @param mes Mes
	 * @param anno Ao
	 * @return Lista para generar el fop del calendario
	 */
	public static List fncConversionInformeCalendarioAnual(Map festivos, String th, int mes, int anno){
		V50bClsTrazas.depura("V50bClsFunciones.fncConversionInformeCalendarioAnual() ");
		List convertido = new ArrayList();
		List retorno;// = new ArrayList(137*2+1); //7*3+2*6=138 (diassem*nummeses+celdasblanca*numsems)=totalcapacidad
		List retornoFinal = new ArrayList();
		int me=1;
		int mesAux = mes;
		int annoAux = anno;
		
		for (int m = 0;m<V50bClsConstantes.CUATRO;m++) {
			retorno = V50bClsFunciones.fncNewArrayList(V50bClsConstantes.CIENTOTREINTAISIETE*2+1);
			
			for(int a=0;a<(V50bClsConstantes.CIENTOTREINTAISIETE*2)+2;a++){
				retorno.add("");
			}
			
			int indice=0;
			
			for(int nm=0;nm<V50bClsConstantes.TRES;nm++){
				mesAux=me;
				me++;
				indice=nm*(V50bClsConstantes.OCHO*2);
				
				GregorianCalendar gregoriancalendar = V50bClsFunciones.fncNewGregorianCalendar(annoAux, mesAux - 1, 1);
		        int i = mesAux - 1;
		        int j = 0;
	
		        int i1 = 0;
		        j = 0;
		        if(((gregoriancalendar.get(V50bClsConstantes.SIETE) + V50bClsConstantes.CINCO) % V50bClsConstantes.SIETE) > 0) {
		            for(; i1 < ((gregoriancalendar.get(V50bClsConstantes.SIETE) + V50bClsConstantes.CINCO) % V50bClsConstantes.SIETE); i1++) {
		            	retorno.set(indice,"NORMAL");
		            	retorno.set(indice+1,"");
		            	indice=indice+2;;
		                j++;
		            }
		        }
		        for(; gregoriancalendar.get(2) == i; gregoriancalendar.add(V50bClsConstantes.CINCO, 1)) {
		            int j1 = gregoriancalendar.get(V50bClsConstantes.CINCO);
		            int k1 = (i1 + j1) % V50bClsConstantes.SIETE;
	
		            j++;
		            String dia = ((String.valueOf(j1).length())==1)?"0"+j1:String.valueOf(j1);
		            String mess = ((String.valueOf(mesAux).length())==1)?"0"+mesAux:String.valueOf(mesAux);
		            if(festivos.containsKey(annoAux+mess+dia+"/"+V50bClsConstantes.CONSTANTE_FESTIVOS_GENERALES) || festivos.containsKey(annoAux+mess+dia+"/"+th)){
		            	retorno.set(indice,"FESTIVO");
		            	retorno.set(indice+1,String.valueOf(j1));
		            } else {
		            	if (festivos.containsKey(annoAux+mess+dia)){
			            	retorno.set(indice,"CURSO");
			            	retorno.set(indice+1,String.valueOf(j1));
			            } else {
			            	retorno.set(indice,"NORMAL");
			            	retorno.set(indice+1,String.valueOf(j1));
			            }
			        }
		            if(k1 == 0){
		                indice=indice+(V50bClsConstantes.DIECISIETE*2);
		                j=0;
		            } else {
		            	indice=indice+2;;        
		            }
		        }
		        if(j < V50bClsConstantes.SIETE) {
		            for(; j < V50bClsConstantes.SIETE; j++) {	
		            	retorno.set(indice,"NORMAL");
		            	retorno.set(indice+1,"");
		            	indice=indice+2;
		            }
		        }    
		        
		        if(mesAux==V50bClsConstantes.DOCE){
		        	mesAux=1;
		        	annoAux++;;
		        } else {
		        	mesAux++; 
		        }
			}
			convertido = V50bClsFunciones.fncNewArrayList();
			List temp = V50bClsFunciones.fncNewArrayList();
			for(int c=0;c<(V50bClsConstantes.CIENTOTREINTAISIETE*2)+2;c++){
				if(c%(V50bClsConstantes.VEINTITRES*2)==0 && c!=0){
					convertido.add(temp);
					temp = V50bClsFunciones.fncNewArrayList();
				}
				temp.add(retorno.get(c));
			}
			convertido.add(temp);
			retornoFinal.add(convertido);
		}
		
		return retornoFinal;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNewArrayList</p>
	 * <p>Descripcin: Devuelve un nuevo ArrayList, fnc util para instanciar nuevos arraylists en bucles</p>
	 * <p>Copyright: Copyright (c) Feb 16, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param tam tamao inicial del array
	 * @return el arraylist
	 */
	public static List fncNewArrayList(int tam){
		return new ArrayList(tam);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNewArrayList</p>
	 * <p>Descripcin: Devuelve un nuevo ArrayList, fnc util para instanciar nuevos arraylists en bucles</p>
	 * <p>Copyright: Copyright (c) Feb 16, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @return el arraylist
	 */
	public static List fncNewArrayList(){
		return new ArrayList();
	}
	
	/**
	 * 
	 * <p>Ttulo: GregorianCalendar</p>
	 * <p>Descripcin: Devuelve un nuevo GregorianCalendar, fnc util para instanciar nuevos gregoriancalendars en bucles</p>
	 * <p>Copyright: Copyright (c) Feb 16, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param year Ao
	 * @param month Mes
	 * @param date Semana
	 * @return El gregoriancalendar
	 */
	public static GregorianCalendar fncNewGregorianCalendar(int year, int month, int date){
		return new GregorianCalendar(year, month, date);
	}
	
	/**
	 * fncNormalizarCadena
	 * @param consulta cadena a limpiar
	 * @return String cadena limpia
	 * @throws Exception ex
	 */
	public static String fncNormalizarCadena(String consulta)throws Exception{
		
		return V50bClsFunciones.replaceGenerales(consulta);
	}
	
	/**
	 * Replace generales.
	 * @param sTexto the s text
	 * @return String the string
	 * @throws Exception the exception
	 */
	public static String replaceGenerales(String sTexto) throws Exception{
		
		//V50bClsTrazas.depura("V50bClsFunciones.replaceGenerales()");
		
		String strTextoNuevo = sTexto.trim().replaceAll("","a")
		.replaceAll("","a")
		.replaceAll("","a")
		.replaceAll("","a")
		.replaceAll("","a")
		.replaceAll("","a")
		.replaceAll("","a")
		.replaceAll("","e")
		.replaceAll("","e")
		.replaceAll("","e")
		.replaceAll("","e")
		.replaceAll("","e")
		.replaceAll("","i")
		.replaceAll("","i")
		.replaceAll("","i")
		.replaceAll("","i")
		.replaceAll("","i")
		.replaceAll("","o")
		.replaceAll("","o")
		.replaceAll("","o")
		.replaceAll("","o")
		.replaceAll("","o")
		.replaceAll("","o")
		.replaceAll("","u")
		.replaceAll("","u")
		.replaceAll("","u")
		.replaceAll("","u")
		.replaceAll("","u")
		.replaceAll("","n")
		.replaceAll("","A")
		.replaceAll("","A")
		.replaceAll("","A") 
		.replaceAll("","A")
		.replaceAll("","A")
		.replaceAll("","A")
		.replaceAll("","A")
		.replaceAll("","A")
		.replaceAll("","E")
		.replaceAll("","E")
		.replaceAll("","E")
		.replaceAll("","E")
		.replaceAll("","E")
		.replaceAll("","I")
		.replaceAll("","I")
		.replaceAll("","I")
		.replaceAll("","I")
		.replaceAll("","I")
		.replaceAll("","O")
		.replaceAll("","O")
		.replaceAll("","O")
		.replaceAll("","O")
		.replaceAll("","O")
		.replaceAll("","O")
		.replaceAll("","0")
		.replaceAll("","U")
		.replaceAll("","U")
		.replaceAll("","U")
		.replaceAll("","U")
		.replaceAll("","U")
		.replaceAll("","U")
		.replaceAll("","N")
		.replaceAll("","")
		.replaceAll("!","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("/","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")		
		.replaceAll("&","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("","")
		.replaceAll("`","")
		.replaceAll("'","")
		.replaceAll("\r\n"," ")
		.replaceAll("^","")
		.replaceAll("acute;","");
		
		
		return strTextoNuevo;
	}
}