package v50b.v50bClasesComunes;


import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


/**
 * The Class V50bClsFecha.
 * 
 * @author Iaki Cantalapiedra Bernal
 */
public class V50bClsFecha {

	/**
	 * Instantiates a new v50b cls fecha.
	 */
	private V50bClsFecha(){}
	
  /**
   * Constantes para seleccionar el campo que queremos que se devuelva
   */
  public static final int DIA = 1;
  public static final int MES = 2;
  public static final int ANYO = 3;
  public static final int HORA = 4;
  public static final int MINUTOS = 5;
  public static final long HORAS_DIA= 24;

  /**
   * Indica el ao a partir del cual se considera 1900 o 2000.
   * 
   * @return the string
   * 
   * @throws Exception the exception
   */
 // private static final int LIMITE_ANNO = 90;



 /**
 * Devuelve un string con la fecha del sistema en formato corto.
 *
 * @return String: string con la fecha en formato AAAAMMDD.
 * @throws Exception Se eleva
 */
  public static String fncObtenerFechaSistemaCorta() throws Exception
  {
    Calendar calendario = Calendar.getInstance();

    String strAnyo = String.valueOf(calendario.get(Calendar.YEAR));
    StringBuffer strMes = new StringBuffer(String.valueOf(calendario.get(Calendar.MONTH)+1));
    if (strMes.length() == 1){
      strMes.insert(0, "0");
    }
    StringBuffer strDia = new StringBuffer(String.valueOf(calendario.get(Calendar.DAY_OF_MONTH)));
    if (strDia.length() == 1){
      strDia.insert(0, "0");
    }

    return strAnyo + strMes.toString() + strDia.toString();
  }//Fin fncObtenerFechaSistemaCorta
  
  
  /**
   * Devuelve un string con la fecha del sistema en formato corto.
   * 
   * @return String: string con la fecha en formato AAMMDD.
   * 
   * @throws Exception the exception
   */
    public static String fncObtenerFechaSistemaCortaAAMMDD() throws Exception
    {
      Calendar calendario = Calendar.getInstance();

      String strAnyo = String.valueOf(calendario.get(Calendar.YEAR));
      strAnyo=strAnyo.substring(2);
      StringBuffer strMes = new StringBuffer(String.valueOf(calendario.get(Calendar.MONTH)+1));
      if (strMes.length()==1){
    	  strMes.insert(0, "0");
      }
      StringBuffer strDia = new StringBuffer(String.valueOf(calendario.get(Calendar.DAY_OF_MONTH)));
      if (strDia.length()==1){
        strDia.insert(0, "0");
      }

      return strAnyo + strMes + strDia;
    }//Fin fncObtenerFechaSistemaCorta


  /**
   * Arregla una fecha valida para que tenga siempre el mismo tamao
   * y las posiciones de dia mes y ao sean siempre las mismas.
   * (1/1/1999 --> 01/01/1999)
   * 
   * @param fecha the fecha
   * @param idioma the idioma
   * 
   * @return 	String: string con la fecha.
   * 
   * @throws  Exception
   * @throws Exception the exception
   * 
   * @author    Iaki Cantalapiedra Bernal
   * @version 	1.0
   * @fecha	  	19/12/2005
   */
    /*
   public static String fncFormateaFecha (String fecha, String idioma) throws Exception
   {
	   StringTokenizer barras = new StringTokenizer(fecha,"/");
	   String fechaValida="";
	   try{
	   String campo1=barras.nextToken();
	   String campo2=barras.nextToken();
	   String campo3=barras.nextToken();
	   
	   if(campo2.length()==1)campo2 = "0" + campo2;
	   
	   if(idioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)){
		   if(campo1.length()==1)campo1="0"+campo1;
		   if(campo3.length()==1)campo3="000"+campo3;
		   if(campo3.length()==2)campo3="00"+campo3;
		   if(campo3.length()==3)campo3="0"+campo3;
		   fechaValida=campo1+"/"+campo2+"/"+campo3;
	   }
	   else{
		   if(campo3.length()==1)campo3="0"+campo3;
		   if(campo1.length()==1)campo1="000"+campo1;
		   if(campo1.length()==2)campo1="00"+campo1;
		   if(campo1.length()==3)campo1="0"+campo1;
		   fechaValida=campo3+"/"+campo2+"/"+campo1;
	   }
	   }catch(Exception e){}
	   
	   return fechaValida;   
   }
  */
    
    /**
     * 
     * @param fecha the str pf fecha
     * @param idioma the str pf idioma
     * 
     * @return String: string con la fecha.
     * 
     * @throws Exception the exception
     */
   public static String fncFormateaFecha (String fecha, String idioma) throws Exception
    {
 	   StringTokenizer barras = new StringTokenizer(fecha, "/");
 	   StringBuffer fechaValida = new StringBuffer();
 	   try{
 	   StringBuffer campo1 = new StringBuffer(barras.nextToken());
 	   StringBuffer campo2 = new StringBuffer(barras.nextToken());
 	   StringBuffer campo3 = new StringBuffer(barras.nextToken());
 	   
 	   if(campo2.length()==1) {
		campo2.insert(0, "0");
	}
 	   
 	   if(idioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)){
 		   if(campo1.length()==1) {
			campo1.insert(0, "0");
		}
 		   if(campo3.length()==1) {
			campo3.insert(0, "000");
		}
 		   if(campo3.length()==2) {
			campo3.insert(0, "00");
		}
 		   if(campo3.length()==V50bClsConstantes.TRES) {
			campo3.insert(0, "0");
		}
 		   fechaValida.append(campo1).append("/").append(campo2).append("/").append(campo3);
 	   }
 	   else{
 		   if(campo3.length()==1) {
			campo3.insert(0, "0");
		}
 		   if(campo1.length()==1) {
			campo1.insert(0, "000");
		}
 		   if(campo1.length()==2) {
			campo1.insert(0, "00");
		}
 		   if(campo1.length()==V50bClsConstantes.TRES) {
			campo1.insert(0, "000");
		}
 		   fechaValida.append(campo3).append("/").append(campo2).append("/").append(campo1);
 	   }
 	   }catch(Exception e){}
 	   
 	   return fechaValida.toString();   
    }
    
  
  /**
   * Devuelve un string con la fecha formateada para presentarla en pantalla
   * como DD/MM/AAAA o AAAA/MM/DD dependiendo del idioma que le pasemos.
   * 
   * @param strPfFecha the str pf fecha
   * @param strPfIdioma the str pf idioma
   * 
   * @return String: string con la fecha.
   * 
   * @throws Exception the exception
   */
  public static String fncPresentarFechaCorta (String strPfFecha, String strPfIdioma) throws Exception
  {
    StringBuffer strFechaPresentacion = new StringBuffer();
    String strDia = "";
    String strMes = "";
    String strAnno = "";
    String strCaracterSeparador = "/";

    //AAAAAMMDD
    strAnno = strPfFecha.substring(0, V50bClsConstantes.CUATRO);
    strMes = strPfFecha.substring(V50bClsConstantes.CUATRO, V50bClsConstantes.SEIS);
    strDia = strPfFecha.substring(V50bClsConstantes.SEIS, strPfFecha.length());

    if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO))
    {
      /*
      strFechaPresentacion = strDia + strCaracterSeparador;
      strFechaPresentacion += strMes + strCaracterSeparador;
      strFechaPresentacion += strAnno;
      */
      strFechaPresentacion.append(strDia);
      strFechaPresentacion.append(strCaracterSeparador);
      strFechaPresentacion.append(strMes);
      strFechaPresentacion.append(strCaracterSeparador);
      strFechaPresentacion.append(strAnno);
    }
    else
    {
      /*
      strFechaPresentacion = strAnno + strCaracterSeparador;
      strFechaPresentacion += strMes + strCaracterSeparador;
      strFechaPresentacion += strDia;
      */
    
      strFechaPresentacion.append(strAnno);
      strFechaPresentacion.append(strCaracterSeparador);
      strFechaPresentacion.append(strMes);
      strFechaPresentacion.append(strCaracterSeparador);
      strFechaPresentacion.append(strDia);
    }

      return strFechaPresentacion.toString();
  }//Fin fncPresentarFechaCorta
  
  
  /**
   * Suma un dia a una fecha.
   * 
   * @param strPfFecha the str pf fecha
   * @param strPfIdioma the str pf idioma
   * 
   * @return String: string con la fecha inicial ms uno.
   * 
   * @throws Exception the exception
   */
   public static String fncSumarDiaAFecha (String strPfFecha, String strPfIdioma) throws Exception
   {
     StringBuffer strFechaPresentacion = new StringBuffer();
     		
     GregorianCalendar fecha = new GregorianCalendar();
     
     String strCaracterSeparador = "/";
     
     try{
 		SimpleDateFormat sdf;
 		if(strPfIdioma!=null && strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)){
 			sdf = new SimpleDateFormat("dd/MM/yyyy");
 		}
 		
 		else {
 			sdf = new SimpleDateFormat("yyyy/MM/dd");
 		}
 	
 		fecha.setTime(sdf.parse(strPfFecha));
 		fecha.add(Calendar.DATE,1);
 		
 		String mes = "";
 		if ((fecha.get(Calendar.MONTH)+1) < V50bClsConstantes.DIEZ){
 			mes = "0";
 		}
 		mes = mes.concat(String.valueOf((fecha.get(Calendar.MONTH)+1)));
 		if(strPfIdioma!=null && strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO))
 		{
 			/*
	 		strFechaPresentacion= ((fecha.get(Calendar.DAY_OF_MONTH)<10)?"0"+fecha.get(Calendar.DAY_OF_MONTH):""+fecha.get(Calendar.DAY_OF_MONTH))+ strCaracterSeparador;
	 		strFechaPresentacion= strFechaPresentacion+mes+strCaracterSeparador;
	 		strFechaPresentacion=strFechaPresentacion+fecha.get(Calendar.YEAR);
	 		*/
 			
	 		strFechaPresentacion.append(((fecha.get(Calendar.DAY_OF_MONTH)<V50bClsConstantes.DIEZ)?"0"+fecha.get(Calendar.DAY_OF_MONTH):""+fecha.get(Calendar.DAY_OF_MONTH)));
	 		strFechaPresentacion.append(strCaracterSeparador);
	 		strFechaPresentacion.append(mes);
	 		strFechaPresentacion.append(strCaracterSeparador);
	 		strFechaPresentacion.append(fecha.get(Calendar.YEAR));
 		}
 		else
 		{
 			/*
 			strFechaPresentacion= fecha.get(Calendar.YEAR)+strCaracterSeparador;
 			strFechaPresentacion= strFechaPresentacion+mes+strCaracterSeparador;
	 		strFechaPresentacion= strFechaPresentacion+((fecha.get(Calendar.DAY_OF_MONTH)<10)?"0"+fecha.get(Calendar.DAY_OF_MONTH):""+fecha.get(Calendar.DAY_OF_MONTH));
	 		*/
	 		
	 		strFechaPresentacion.append(fecha.get(Calendar.YEAR));
	 		strFechaPresentacion.append(strCaracterSeparador);
	 		strFechaPresentacion.append(mes);
	 		strFechaPresentacion.append(strCaracterSeparador);
	 		strFechaPresentacion.append(((fecha.get(Calendar.DAY_OF_MONTH)<V50bClsConstantes.DIEZ)?"0"+fecha.get(Calendar.DAY_OF_MONTH):""+fecha.get(Calendar.DAY_OF_MONTH)));
 		}
 	}
 	catch(ParseException pe){
 		V50bClsTrazas.depura("fncSumarDiaAFecha", pe.getMessage());
 		throw pe;
 	}
       return strFechaPresentacion.toString();
   }//Fin fncPresentarFechaCorta
   
  
  /**
   * Devuelve un string con la fecha formateada para presentarla en pantalla
   * como DD/MM/AAAA o AAAA/MM/DD dependiendo del idioma que le pasemos.
   * 
   * @param strPfFecha the str pf fecha
   * @param strPfIdioma the str pf idioma
   * 
   * @return String: string con la fecha.
   * 
   * @throws Exception  	 Se eleva Exception.
   */
  public static List fncPresentarFechaCortaSeparacion (String strPfFecha, String strPfIdioma) throws Exception
  {
    ArrayList arrFechaPresentacion = new ArrayList();
    
    GregorianCalendar fecha = new GregorianCalendar();
    try{
		SimpleDateFormat sdf;
		if(strPfIdioma!=null && strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)){
			sdf = new SimpleDateFormat("dd/MM/yyyy");
		}
		
		else {
			sdf = new SimpleDateFormat("yyyy/MM/dd");
		}
	
		fecha.setTime(sdf.parse(strPfFecha));
		
		arrFechaPresentacion.add(new Integer(fecha.get(Calendar.DAY_OF_MONTH)));
		arrFechaPresentacion.add(new Integer(fecha.get(Calendar.MONTH)+1));
		arrFechaPresentacion.add(new Integer(fecha.get(Calendar.YEAR)));
	}
	catch(ParseException pe){
		V50bClsTrazas.depura("fncPresentarFechaCortaSeparacion", pe.getMessage());
 		throw pe;
	}
      return arrFechaPresentacion;
  }//Fin fncPresentarFechaCortaSeparacion




  /**
   * Devuelve un java.sql.date listo para insertar en BD a partir de un string
   * 
   * @param strPfFecha     String con el formato de fecha que viene formateada
   * de pantalla segn el idioma.
   * @param strPfIdioma the str pf idioma
   * 
   * @return java.sql.Date    Fecha formateada devuelta
   * 
   * @throws Exception the exception
   */
  public static java.sql.Date fncFormatearFecha (String strPfFecha, String strPfIdioma) throws Exception
  {        
      String strFormato=null;
      if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO))
      {
          strFormato="dd/MM/yyyy";        
      }
      else
      {        
        strFormato="yyyy/MM/dd";
      }
      java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(strFormato);
      java.util.Date dateU = sdf.parse(strPfFecha);
      return new java.sql.Date(dateU.getTime()); 
  }//Fin fncFormatearFecha
  
  /**
   * Devuelve un java.sql.date listo para insertar en BD a partir de un string
   * 
   * @param strPfFecha     String con el formato de fecha y hora que viene formateada
   * de pantalla segn el idioma.
   * @param strPfIdioma the str pf idioma
   * 
   * @return java.sql.Date    Fecha formateada devuelta
   * 
   * @throws Exception the exception
   */

  public static Timestamp fncFormatearFechaHora (String strPfFecha, String strPfIdioma) throws Exception{
      
      String strFormato=null;
      if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO))
      {
          strFormato="dd/MM/yyyy HH:mm:ss";        
      }
      else
      {        
        strFormato="yyyy/MM/dd HH:mm:ss";
      }
      java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(strFormato);
      java.util.Date dateU = sdf.parse(strPfFecha);     

      return new Timestamp(dateU.getTime());
  }
  


  /**
   * Devuelve un string con la fecha del sistema en formato largo DD/MM/AAAA HH:MI:SS
   * si el idioma que le pasamos es el castellano, o AAAA/MM/DD HH:MI:SS si se trata
   * de Euskera.
   * 
   * @param strPfIdioma the str pf idioma
   * 
   * @return String
   * 
   * @throws Exception the exception
   */
  public static String fncPresentarFechaSistemaLarga(String strPfIdioma) throws Exception
  {
    Calendar calendario = Calendar.getInstance();
    String strCaracterSeparadorDia = "/";
    String strCaracterSeparadorHora=":";
    StringBuffer strFechaPresentacion = new StringBuffer();

    String strAnyo = String.valueOf(calendario.get(Calendar.YEAR));
    StringBuffer strMes = new StringBuffer(String.valueOf(calendario.get(Calendar.MONTH)+1));
    
    if (strMes.length()==1){
    	strMes.insert(0, "0");
    }
    StringBuffer strDia = new StringBuffer(String.valueOf(calendario.get(Calendar.DAY_OF_MONTH)));
    if (strDia.length()==1){
    	strDia.insert(0, "0");
    }
    StringBuffer strHora = new StringBuffer(String.valueOf(calendario.get(Calendar.HOUR_OF_DAY)));
    if (strHora.length()==1){
    	strHora.insert(0, "0");
    }
    StringBuffer strMinute = new StringBuffer(String.valueOf(calendario.get(Calendar.MINUTE)));
    if (strMinute.length()==1){
    	strMinute.insert(0, "0");
    }
    StringBuffer strSegundos = new StringBuffer(String.valueOf(calendario.get(Calendar.SECOND)));
    if (strSegundos.length()==1){
    	strSegundos.insert(0, "0");
    }

    String strFechaSistema = strAnyo + strMes.toString() + strDia.toString() + strHora.toString() + strMinute.toString() + strSegundos.toString();

    //AAAAAMMDD
    strAnyo = strFechaSistema.substring(0, V50bClsConstantes.CUATRO);
    String strMes2 = strFechaSistema.substring(V50bClsConstantes.CUATRO, V50bClsConstantes.SEIS);
    String strDia2 = strFechaSistema.substring(V50bClsConstantes.SEIS, V50bClsConstantes.OCHO);

    String strHora2 = strFechaSistema.substring(V50bClsConstantes.OCHO, V50bClsConstantes.DIEZ);
    String strMinute2 = strFechaSistema.substring(V50bClsConstantes.DIEZ, V50bClsConstantes.DOCE);
    String strSegundos2 = strFechaSistema.substring(V50bClsConstantes.DOCE, V50bClsConstantes.CATORCE);

    if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO))
    {
      strFechaPresentacion.append(strDia2);
      strFechaPresentacion.append(strCaracterSeparadorDia);
      strFechaPresentacion.append(strMes2);
      strFechaPresentacion.append(strCaracterSeparadorDia);
      strFechaPresentacion.append(strAnyo);
    }
    else
    {
      strFechaPresentacion.append(strAnyo);
      strFechaPresentacion.append(strCaracterSeparadorDia);
      strFechaPresentacion.append(strMes2);
      strFechaPresentacion.append(strCaracterSeparadorDia);
      strFechaPresentacion.append(strDia2);
      
    }

    strFechaPresentacion.append(" ");
    strFechaPresentacion.append(strHora2);
    strFechaPresentacion.append(strCaracterSeparadorHora);
    strFechaPresentacion.append(strMinute2);
    strFechaPresentacion.append(strCaracterSeparadorHora);
    strFechaPresentacion.append(strSegundos2);
    

    return strFechaPresentacion.toString();

  }//Fin fncPresentarFechaSistemaLarga



  /**
   * Devuelve un string con la fecha del sistema en formato corto
   * DD/MM/AAAA si el idioma que le pasamos es el castellano, o AAAA/MM/DD
   * si se trata de Euskera.
   * 
   * @param strPfIdioma the str pf idioma
   * 
   * @return String
   * 
   * @throws Exception the exception
   */
  public static String fncPresentarFechaSistemaCorta(String strPfIdioma) throws Exception
  {
    Calendar calendario = Calendar.getInstance();
    String strCaracterSeparadorDia = "/";
    StringBuffer strFechaPresentacion = new StringBuffer();

    String strAnyo = String.valueOf(calendario.get(Calendar.YEAR));
    StringBuffer strMes = new StringBuffer(String.valueOf(calendario.get(Calendar.MONTH)+1));
    if (strMes.length()==1){
    	strMes.insert(0, "0");
    }
    StringBuffer strDia = new StringBuffer(String.valueOf(calendario.get(Calendar.DAY_OF_MONTH)));
    if (strDia.length()==1){
    	strDia.insert(0, "0");
    }

    String strFechaSistema = strAnyo + strMes.toString() + strDia.toString();

    strAnyo = strFechaSistema.substring(0, V50bClsConstantes.CUATRO);
    String strMes2 = strFechaSistema.substring(V50bClsConstantes.CUATRO, V50bClsConstantes.SEIS);
    String strDia2 = strFechaSistema.substring(V50bClsConstantes.SEIS, V50bClsConstantes.OCHO);

    if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO))
    {
      strFechaPresentacion.append(strDia2);
      strFechaPresentacion.append(strCaracterSeparadorDia);
      strFechaPresentacion.append(strMes2);
      strFechaPresentacion.append(strCaracterSeparadorDia);
      strFechaPresentacion.append(strAnyo);
    }
    else
    {
      strFechaPresentacion.append(strAnyo);
      strFechaPresentacion.append(strCaracterSeparadorDia);
      strFechaPresentacion.append(strMes2);
      strFechaPresentacion.append(strCaracterSeparadorDia);
      strFechaPresentacion.append(strDia2);
    }
    return strFechaPresentacion.toString();

  }//Fin fncPresentarFechaSistemaLarga


  /**
   * Crea un objeto Calendar a partir de la fecha pasada como parmetro.
   * 
   * @param strPfFecha the str pf fecha
   * 
   * @return Calendar           objeto tipo Calendar segn la fecha facilitada
   * 
   * @throws Exception the exception
   */
  private static Calendar fncCrearCalendar (String strPfFecha) throws Exception
  {
       Calendar calendario = Calendar.getInstance();

       String strDia = V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.DIA);
       String strMes = V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.MES);
       int intMes = Integer.parseInt(strMes, V50bClsConstantes.DIEZ) - 1;
       strMes = String.valueOf(intMes);
       String strAnno = V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.ANYO);

       calendario.set(Integer.parseInt (strAnno, V50bClsConstantes.DIEZ), Integer.parseInt (strMes, V50bClsConstantes.DIEZ),
                            Integer.parseInt (strDia, V50bClsConstantes.DIEZ));
       calendario.setFirstDayOfWeek(Calendar.MONDAY);

       return calendario;
  }//Fin fncCrearCalendar





  /**
   * Devuelve un string con el da, el mes o el ao.
   * 
   * @param strPfFecha     String fecha con el formato AAAAMMDD
   * @param intPfOpcion    Indica si lo que se quiere obtener es el da,
   * el mes o el ao.
   * 
   * @return String: string con el valor.
   * 
   * @throws Exception the exception
   */
  public static String fncObtenerDiaMesAnno (String strPfFecha, int intPfOpcion) throws Exception
  {

      if (intPfOpcion == V50bClsFecha.ANYO){
         return strPfFecha.substring(0, V50bClsConstantes.CUATRO);
         }

      if (intPfOpcion == V50bClsFecha.MES){
         return strPfFecha.substring(V50bClsConstantes.CUATRO, V50bClsConstantes.SEIS);
      }

      if (intPfOpcion == V50bClsFecha.DIA){
         return strPfFecha.substring(V50bClsConstantes.SEIS, strPfFecha.length());
      }

     return "";
  }//Fin fncObtenerDiaMesAnno





  /**
   * Devuelve el nombre del mes segn el idioma que se elija.
   * 
   * @param strPfFecha the str pf fecha
   * @param strPfIdioma the str pf idioma
   * 
   * @return string: string con el nombre del mes
   * 
   * @throws Exception the exception
   */
  public static String fncObtenerNombreMes (String strPfFecha, String strPfIdioma) throws Exception
  {
      Calendar calendario = V50bClsFecha.fncCrearCalendar(strPfFecha);

      int intMes = calendario.get(Calendar.MONTH);

      String strMes = "";

      switch (intMes)
      {
          case Calendar.JANUARY:
                  strMes = "Enero";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Urtarrila";
                  }
                  break;
          case Calendar.FEBRUARY:
                  strMes = "Febrero";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Otsaila";
                  }
                  break;
          case Calendar.MARCH:
                  strMes = "Marzo";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Martxoa";
                  }
                  break;
          case Calendar.APRIL:
                  strMes = "Abril";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Apirila";
                  }
                  break;
          case Calendar.MAY:
                  strMes = "Mayo";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Maiatza";
                  }
                  break;
          case Calendar.JUNE:
                  strMes = "Junio";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Ekaina";
                  }
                  break;
          case Calendar.JULY:
                  strMes = "Julio";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Uztaila";
                  }
                  break;
          case Calendar.AUGUST:
                  strMes = "Agosto";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Abuztua";
                  }
                  break;
          case Calendar.SEPTEMBER:
                  strMes = "Septiembre";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Iraila";
                  }
                  break;
          case Calendar.OCTOBER:
                  strMes ="Octubre";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Urria";
                  }
                  break;
          case Calendar.NOVEMBER:
                  strMes = "Noviembre";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Azaroa";
                  }
                  break;
          case Calendar.DECEMBER:
                  strMes = "Diciembre";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strMes = "Abendua";
                  }
                  break;
          default:
      }

      return strMes;

  }//Fin fncObtenerNombreMes

  /**
   * obtiene el nombre del mes a traves de un codigo
   * @param mes codigo de mes
   * @param idioma idioma
   * @return string nombre
   * @throws Exception ex
   */
  public static String fncObtenerNombreCodigoMes(String mes, String idioma)throws Exception{
	  
	  String key="";
	  
	  if (V50bClsConstantes.MES_ENERO.equals(mes)) {
		  	key="comun.enero";
		} else if (V50bClsConstantes.MES_FEBRERO.equals(mes)) {
			key="comun.febrero";
		} else if (V50bClsConstantes.MES_MARZO.equals(mes)) {
			key="comun.marzo";
		} else if (V50bClsConstantes.MES_ABRIL.equals(mes)) {
			key="comun.abril";
		} else if (V50bClsConstantes.MES_MAYO.equals(mes)) {
			key="comun.mayo";
		} else if (V50bClsConstantes.MES_JUNIO.equals(mes)) {
			key= "comun.junio";
		} else if (V50bClsConstantes.MES_JULIO.equals(mes)) {
			key="comun.julio";
		} else if (V50bClsConstantes.MES_AGOSTO.equals(mes)) {
			key="comun.agosto";
		} else if (V50bClsConstantes.MES_SEPTIEMBRE.equals(mes)) {
			key="comun.septiembre";
		} else if (V50bClsConstantes.MES_OCTUBRE.equals(mes)) {
			key="comun.octubre";
		} else if (V50bClsConstantes.MES_NOVIEMBRE.equals(mes)) {
			key="comun.noviembre";
		} else if (V50bClsConstantes.MES_DICIEMBRE.equals(mes)) {
			key="comun.diciembre";
		}
	  return Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun", key, idioma);
  }


  /**
   * Devuelve un string con la fecha corta en letras segn si el idioma es el
   * castellano o el Euskera.
   * 
   * @param strPfFecha String con el formato AAAAMMDD
   * @param strPfIdioma the str pf idioma
   * 
   * @return String: string con la fecha.
   * 
   * @throws Exception the exception
   */
  public static String fncPresentarFechaLetras (String strPfFecha, String strPfIdioma) throws Exception
  {
    StringBuffer strFechaFinal = new StringBuffer();

    if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO))
    {
      strFechaFinal.append(V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.DIA));
      strFechaFinal.append(" de ");
      strFechaFinal.append(V50bClsFecha.fncObtenerNombreMes(strPfFecha, strPfIdioma));
      strFechaFinal.append(" de ");
      strFechaFinal.append(V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.ANYO));
    }
    else
    {
      strFechaFinal.append(V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.ANYO));
      strFechaFinal.append("ko ");
      strFechaFinal.append(V50bClsFecha.fncObtenerNombreMes(strPfFecha, strPfIdioma));
      strFechaFinal.append("k ");
      strFechaFinal.append(V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.DIA));
    }
    return strFechaFinal.toString();
  }//Fin fncPresentarFechaLetras

  /**
   * Devuelve un string con la fecha corta con el dia de la semana en letras segn
   * si el idioma es el castellano o el Euskera.
   * 
   * @param strPfFecha String con el formato AAAAMMDD
   * @param strPfIdioma the str pf idioma
   * 
   * @return String: string con la fecha.
   * 
   * @throws Exception the exception
   */

  public static String fncPresentarFechaLetrasConDia (String strPfFecha, String strPfIdioma) throws Exception
  {
   StringBuffer strFechaFinal = new StringBuffer();

   if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO))
   {
     strFechaFinal.append(V50bClsFecha.fncObtenerNombreDia(strPfFecha, strPfIdioma));
     strFechaFinal.append(",");
     strFechaFinal.append(V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.DIA));
     strFechaFinal.append(" de ");
     strFechaFinal.append(V50bClsFecha.fncObtenerNombreMes(strPfFecha, strPfIdioma));
     strFechaFinal.append(" de ");
     strFechaFinal.append(V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.ANYO));
   }
   else
   {
     strFechaFinal.append(V50bClsFecha.fncObtenerNombreDia(strPfFecha, strPfIdioma));
     strFechaFinal.append(",");
     strFechaFinal.append(V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.ANYO));
     strFechaFinal.append("ko ");
     strFechaFinal.append(V50bClsFecha.fncObtenerNombreMes(strPfFecha, strPfIdioma));
     strFechaFinal.append("k ");
     strFechaFinal.append(V50bClsFecha.fncObtenerDiaMesAnno(strPfFecha, V50bClsFecha.DIA));
   }
   return strFechaFinal.toString();
  }//Fin fncPresentarFechaLetras

  /**
   * Devuelve un string con la fecha desde/hasta segn el idioma que le pasa por parametro.
   * 
   * @param fechaInicioSF String con el formato AAAAMMDD (fecha desde)
   * @param fechaFinSF the fecha fin sf
   * @param idioma the idioma
   * 
   * @return String: string con la fecha.
   * 
   * @throws Exception the exception
   */
  public static String fncFormatearFechaEntre(String fechaInicioSF, String fechaFinSF, String idioma) throws Exception{
	   
	   String fechaEntre="";
	   String fechaInicio="";
	   String fechaFin="";
	   if(idioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA)){
		   
		  try{
			   fechaInicio=V50bClsFecha.fncPresentarFechaLetras (fechaInicioSF,V50bClsConstantes.CONSTANTE_EUSKARA);
			   fechaFin=V50bClsFecha.fncPresentarFechaLetras (fechaFinSF,V50bClsConstantes.CONSTANTE_EUSKARA);
			   
			   String digitoUltimoFin=fechaFin.substring(fechaFin.length()-1);
			   String digitoPenultimoFin=fechaFin.substring(fechaFin.length()-2);
			   
			   String digitoUltimoInicio=fechaInicio.substring(fechaInicio.length()-1);
			   String digitoPenultimoInicio=fechaInicio.substring(fechaInicio.length()-2);			   
			   
			   String fechaDesde="";
			   String fechaHasta="";
			   
			   
			   if(("1".equals(digitoUltimoInicio) && !"1".equals(digitoPenultimoInicio) 
					   && !"3".equals(digitoPenultimoInicio)) || "5".equals(digitoUltimoInicio) 
					   || ("0".equals(digitoUltimoInicio) && !"2".equals(digitoPenultimoInicio)))
					   {
				   			fechaDesde=fechaInicio+ "etik";
					   }
				else {
					fechaDesde=fechaInicio+ "tik";
				}
			   
			   
			   if(("1".equals(digitoUltimoFin) && !"1".equals(digitoPenultimoFin) 
					   && !"3".equals(digitoPenultimoFin)) || "5".equals(digitoUltimoFin) 
					   || ("0".equals(digitoUltimoFin) && !"2".equals(digitoPenultimoFin)))
			   {
				   fechaHasta=fechaFin+ "era";
			   }
			   else {
				   fechaHasta=fechaFin+ "ra";			
			   }
			   
			   fechaEntre=fechaDesde + " " + fechaHasta;
			   
		  }catch (Exception e){
			  V50bClsTrazas.depura("fncFormatearFechaEntre", e.getMessage());
		 	  throw e;
		  }
	   }else{
		   
		   try{
			   fechaInicio=V50bClsFecha.fncPresentarFechaLetras (fechaInicioSF,V50bClsConstantes.CONSTANTE_CASTELLANO);
			   fechaFin=V50bClsFecha.fncPresentarFechaLetras (fechaFinSF,V50bClsConstantes.CONSTANTE_CASTELLANO);
			   fechaEntre="el " +fechaInicio + " y el " + fechaFin;
			   
		   }catch (Exception e){
			      V50bClsTrazas.depura("fncFormatearFechaEntre", e.getMessage());
			 	  throw e;
			  }
		   
	   }   
		return fechaEntre;
	}// Fin fncFormatearFechaEntre
  
  /**
   * Devuelve el nombre del dia de la semana segn el idioma que se elija.
   * 
   * @param strPfFecha the str pf fecha
   * @param strPfIdioma the str pf idioma
   * 
   * @return string: string con el nombre del dia de la semana
   * 
   * @throws Exception the exception
   */
  public static String fncObtenerNombreDia (String strPfFecha, String strPfIdioma) throws Exception
  {
      Calendar calendario = V50bClsFecha.fncCrearCalendar(strPfFecha);

      int intDia = calendario.get(Calendar.DAY_OF_WEEK);

      String strDia = "";

      switch (intDia)
      {
          case Calendar.MONDAY:
                  strDia = "Lunes";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strDia = "Astelehena";
                  }
                  break;
          case Calendar.TUESDAY:
                  strDia = "Martes";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strDia = "Asteartea";
                  }
                  break;

          case Calendar.WEDNESDAY:
                  strDia = "Mircoles";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strDia = "Asteazkena";
                  }
                  break;
          case Calendar.THURSDAY:
                  strDia = "Jueves";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strDia = "Osteguna";
                  }
                  break;
          case Calendar.FRIDAY:
                  strDia = "Viernes";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strDia = "Ostirala";
                  }
                  break;
          case Calendar.SATURDAY:
                  strDia = "Sbado";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strDia = "Larunbata";
                  }
                  break;
          case Calendar.SUNDAY:
                  strDia = "Domingo";
          if (strPfIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
                  {
                    strDia = "Igandea";
                  }
                  break;
                  
           default:
      }

      return strDia;

  }//Fin fncObtenerNombreDia

  /**
   * Devuelve un string con la fecha del sistema en formato LOPD AAAAMMDDHHMMSSLLL.
   * 
   * @return String
   * 
   * @throws Exception the exception
   */
  public static String fncPresentarFechaSistemaLOPD() throws Exception
  {
    Calendar calendario = Calendar.getInstance();
    StringBuffer strResultado = new StringBuffer();
    
    strResultado.append(calendario.get(Calendar.YEAR));
    strResultado.append(calendario.get(Calendar.MONTH+1));
    strResultado.append(calendario.get(Calendar.DAY_OF_MONTH));
    strResultado.append(calendario.get(Calendar.HOUR_OF_DAY));
    strResultado.append(calendario.get(Calendar.MINUTE));
    strResultado.append(calendario.get(Calendar.SECOND));
    strResultado.append(calendario.get(Calendar.MILLISECOND));
    
    return strResultado.toString();
  }//Fin fncPresentarFechaSistemaLOPD

  /**
   * Devuelve el numero de dias de Febrero en cierto anyo.
   * 
   * @param intPfAnyo Anyo
   * 
   * @return Un int con los dias de Febrero ese anyo
   * 
   * @throws Exception the exception
   */
  public static int getDiasFebrero (int intPfAnyo) throws Exception{
    return (((intPfAnyo % V50bClsConstantes.CUATRO == 0) && ( (!(intPfAnyo % V50bClsConstantes.CIEN == 0)) || (intPfAnyo % V50bClsConstantes.CUATROCIENTOS == 0))) ? V50bClsConstantes.VEINTINUEVE : V50bClsConstantes.VEINTIOCHO );
 }//Fin getDiasFebrero

/**
 * Devuelve un array con el nmero de dias de cada mes, en cierto ao.
 * 
 * @param intPfAnyo Un entero con el ao del que queremos conocer el numero de dias de cada mes.
 * 
 * @return Un array con el numero de dias de cada mes {1..12}
 * 
 * @throws Exception the exception
 */
  public static List getArrayDias (int intPfAnyo) throws Exception{
    ArrayList arrDias = new ArrayList();
        for (int i = 1; i <= V50bClsConstantes.DOCE; i++) {
                arrDias.add(i-1,"31");
                if (i==V50bClsConstantes.CUATRO || i==V50bClsConstantes.SEIS || i==V50bClsConstantes.NUEVE || i==V50bClsConstantes.ONCE) {arrDias.add(i-1,"30");}
                int intDiasFeb=V50bClsFecha.getDiasFebrero(intPfAnyo);
                String strDiasFeb = String.valueOf(intDiasFeb);
                if (i==2) {arrDias.add(i-1,strDiasFeb);}
        }
   return arrDias;
}//Fin getArrayDias

 /**
  * Valida que el valor (no el formato) de una fecha sea correcto.
  * 
  * @param strPfFecha String con la fecha
  * 
  * @return true si esta bien, false si no
  * 
  * @throws Exception the exception
  * @throws NumberFormatException the number format exception
  */
  public static boolean fncValidarValorFecha (String strPfFecha) throws NumberFormatException, Exception {

     // Extraemos los valores del formato
	 StringBuffer strDia = new StringBuffer();
     String strMes, strAnyo;
     /* Por defecto el formato de la fecha es dd/mm/aaaa. Lo separamos por "/" porque una
     fecha correcta puede tener longitud 8,9 o 10. Los meses y los dias pueden ser correctos
     con 1 o 2 digitos sin embargo, se obligara a que las fechas tengan 4 digitos*/
    try{
      List arrFecha = V50bClsFunciones.fncSplit(strPfFecha, "/");
      strAnyo = arrFecha.get(2).toString();
      strMes = arrFecha.get(1).toString();
      if (strMes.length() == 1){
        strDia.append("0");
        strDia.append(strMes);
      }
      strDia = new StringBuffer(arrFecha.get(0).toString());
      if (strDia.length() == 1){
        strDia.insert(0, "0");
      }

        // Convertimos strDia, strMes, strAnyo en enteros
      int intMes = Integer.parseInt(strMes, V50bClsConstantes.DIEZ);
      int intDia = Integer.parseInt(strDia.toString(), V50bClsConstantes.DIEZ);
      int intAnyo = Integer.parseInt(strAnyo, V50bClsConstantes.DIEZ);
      List arrDiasMes = V50bClsFecha.getArrayDias(intAnyo);

      if (intMes < 1 || intMes > V50bClsConstantes.DOCE) {
        // Comprobamos que el mes sea correcto
        return false;
      }
      else if (! (intMes < 1 || intMes > V50bClsConstantes.DOCE)) {
        String strDiasMes = arrDiasMes.get(intMes - 1).toString();
        int intDiasMes = Integer.parseInt(strDiasMes);
        if (intDia < 1 || intDia > V50bClsConstantes.TREINTAYUNO || intDia > intDiasMes) {
          // Comprobamos que el numero de dias en el mes sea correcto
          return false;
        }
        else if (strAnyo.length() != V50bClsConstantes.CUATRO || intAnyo == 0) {
          // Comprobamos que el ao sea correcto
          return false;
        }
      }
    }catch(NumberFormatException e){
      return false;
    }

     // Si llegamos aqui, todo ha ido OK
     return true;
}//Fin fncValidarValorFecha



	/**
	 * Devuelve un string con la fecha formateada para presentarla en pantalla
	 * como 'AAAA(e)ko mes DD(e)an' o 'DD de mes de AAAA' dependiendo del idioma que le pasemos.
	 * 
	 * @param fecha the fecha
	 * @param idioma the idioma
	 * @param parametro the parametro
	 * 
	 * @return String: string con la fecha.
	 * 
	 * @throws Exception the exception
	 */
	public static String fncFechaTexto(String fecha, String idioma, String parametro) throws Exception
	{
		  String strDev="";
		  
		  try
	      {
			  String strAnyo = fecha.substring(0,V50bClsConstantes.CUATRO); 
	    	  String nombreMes = (V50bClsFecha.fncObtenerNombreMes (fecha, idioma)).toLowerCase();
	    	  String strDia = fecha.substring(V50bClsConstantes.SEIS,V50bClsConstantes.OCHO);
	    	  int iDia=Integer.parseInt(strDia);
			  if (idioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
			  {
				   String strBukaera="";
				   int iUrtea=Integer.parseInt(strAnyo,V50bClsConstantes.DIEZ);
				   int iEguna=Integer.parseInt(strDia,V50bClsConstantes.DIEZ);
				   int iZifra1=iUrtea % V50bClsConstantes.DIEZ;
				   int iZifra2=iUrtea % V50bClsConstantes.CIEN;
				   if ((iUrtea % V50bClsConstantes.MIL != 0 && iZifra2==0) ||  iZifra2==1 || iZifra2==V50bClsConstantes.DIEZ || iZifra2==V50bClsConstantes.VEINTIUNO || iZifra2==V50bClsConstantes.TREINTA || iZifra2==V50bClsConstantes.CUARENTAYUNO || iZifra2==V50bClsConstantes.CINCUENTA || iZifra2==V50bClsConstantes.SESENTAYUNO || iZifra2==V50bClsConstantes.SETENTA || iZifra2==V50bClsConstantes.OCHENTAYUNO || iZifra2==V50bClsConstantes.NOVENTA || iZifra1==V50bClsConstantes.CINCO) {
					strBukaera="e";
				}
		          
				   if (parametro!=null && parametro.equals(V50bClsConstantes.CONSTANTE_EN_DIA))
				   {
					  Map map = new HashMap();
					  map.put("1", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "ean");
					  map.put("5", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "ean");
					  map.put("10", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "ean");
					  map.put("15", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "ean");
					  map.put("21", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "ean");
					  map.put("25", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "ean");
					  map.put("30", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "ean");
					  map.put("11", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "n");
					  map.put("31", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "n");
					  
					  strDev = (String)map.get(String.valueOf(iEguna));
					  if(null==strDev) {
						strDev=strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "an";
					}
				   }
				   else
				   {
					   Map map = new HashMap();
					   map.put("11", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna);
					   map.put("31", strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna);
					   
					   strDev = (String)map.get(String.valueOf(iEguna));
					   if(null==strDev) {
						strDev=strAnyo + strBukaera + "ko " + nombreMes + "ren " + iEguna + "a";
					}
				   }
			  }
			  else
			  {
				  strDev = iDia + " de " + nombreMes + " de " + strAnyo;
			  }
	      }
          catch (Exception e)
          {
        	  V50bClsTrazas.depura("fncFechaTexto", e.getMessage());
		 	  throw e;
          }
          return strDev;
	}
	
	/**
	 * Devuelve un string con la fecha formateada AAAAMMDD, para ser empleada
	 * por otros mtodos de esta clase.
	 * 
	 * @param fecha the fecha
	 * @param idioma the idioma
	 * 
	 * @return String: string con la fecha.
	 * 
	 * @throws Exception the exception
	 */
	public static String fncObtenerFechaSinMascara(String fecha,String idioma) throws Exception
	{
		List componentes= V50bClsFunciones.fncSplit(fecha,"/");
		StringBuffer retorno=new StringBuffer();
		if (V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma))
		{
			retorno.append((String)componentes.get(2));
			retorno.append((String)componentes.get(1));
			retorno.append((String)componentes.get(0));
		}
		else if(V50bClsConstantes.CONSTANTE_EUSKARA.equals(idioma))
		{
			retorno.append((String)componentes.get(0));
			retorno.append((String)componentes.get(1));
			retorno.append((String)componentes.get(2));
		}
		return retorno.toString();
	}
	
	/**
	 * Devuelve un string con la fecha formateada para presentarla en pantalla
	 * como 'AAAA(e)ko mes' o 'mes de AAAA' dependiendo del idioma que le pasemos.
	 * 
	 * @param fechaP the fecha p
	 * @param idioma the idioma
	 * 
	 * @return String: string con la fecha.
	 * 
	 * @throws Exception the exception
	 */
	public static String fncFechaTextoMesDia(String fechaP, String idioma) throws Exception
	{
		
		  String fecha = fechaP;
		
		  String strDev="";
		  
		  try
	      {
			  String strAnyo = fecha.substring(0,V50bClsConstantes.CUATRO);
			  //Le aadimos el dia para obtener el nombre del mes aunque no lo vayamos a utilizar
			  fecha.concat("01");
	    	  String nombreMes = (V50bClsFecha.fncObtenerNombreMes (fecha, idioma)).toLowerCase();

			  if (idioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA))
			  {
				   String strBukaera="";
				   int iUrtea=Integer.parseInt(strAnyo,V50bClsConstantes.DIEZ);
				   int iZifra1=iUrtea % V50bClsConstantes.DIEZ;
				   int iZifra2=iUrtea % V50bClsConstantes.CIEN;
				   if ((iUrtea % V50bClsConstantes.MIL != 0 && iZifra2==0) ||  iZifra2==1 || iZifra2==V50bClsConstantes.DIEZ || iZifra2==V50bClsConstantes.VEINTIUNO || iZifra2==V50bClsConstantes.TREINTA || iZifra2==V50bClsConstantes.CUARENTAYUNO || iZifra2==V50bClsConstantes.CINCUENTA || iZifra2==V50bClsConstantes.SESENTAYUNO || iZifra2==V50bClsConstantes.SESENTA || iZifra2==V50bClsConstantes.OCHENTAYUNO || iZifra2==V50bClsConstantes.NOVENTA || iZifra1==V50bClsConstantes.CINCO) {
					strBukaera="e";
				}

				   strDev=strAnyo + strBukaera + "ko " + nombreMes;
				   
			  }
			  else
			  {
				  strDev = nombreMes + " de " + strAnyo;
			  }
	      }
          catch (Exception e)
          {
        	  V50bClsTrazas.depura("fncFechaTextoMesDia", e.getMessage());
		 	  throw e;
          }
          return strDev;
	}
	
	/**
	 * Obtiene el anyo del sistema
	 * @author iurkidi
	 * @return int. anyo del sistema
	 */
	public static int fncObtenerAnyoSistema(){
		Calendar calendario = Calendar.getInstance();
		return calendario.get(Calendar.YEAR);
		
	}
	
	/**
	 * Obtiene el anyo del sistema
	 * @author iurkidi
	 * @return int. anyo del sistema
	 */
	public static int fncObtenerMesSistema(){
		Calendar calendario = Calendar.getInstance();
		return calendario.get(Calendar.MONTH);
		
	}
	

}
